/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group;

import com.querydsl.core.FetchableQuery;
import com.querydsl.core.group.AbstractGroupByTransformer;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupByMap;
import com.querydsl.core.types.Expression;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GroupByList<K, V>
extends AbstractGroupByTransformer<K, List<V>> {
    private final GroupByMap<K, V> mapTransformer;

    GroupByList(Expression<K> key, Expression<?> ... expressions) {
        super(key, expressions);
        this.mapTransformer = new GroupByMap<K, V>(key, (Expression[])expressions){

            @Override
            protected Map<K, V> transform(Map<K, Group> groups) {
                LinkedHashMap results = new LinkedHashMap((int)Math.ceil((double)groups.size() / 0.75), 0.75f);
                for (Map.Entry entry : groups.entrySet()) {
                    results.put(entry.getKey(), GroupByList.this.transform(entry.getValue()));
                }
                return results;
            }
        };
    }

    @Override
    public List<V> transform(FetchableQuery<?, ?> query) {
        Object result = this.mapTransformer.transform((FetchableQuery)query);
        return new ArrayList(result.values());
    }

    protected V transform(Group group) {
        return (V)group;
    }
}

