/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.persistence.annotations.Index;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.enums.Language;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.enums.Nationality;
import xxx.scenerixx.scenerixxlib.model.medium.Dvd;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;

@Entity
public class Movie
extends AbstractEntity
implements INode,
IPlayable,
Serializable,
IPlayablePlaylistItems {
    private static transient DB db = null;
    @Index
    @Column(length=2048)
    private String title;
    @Column(length=2048)
    private String alternativeTitle;
    @Column(length=2048)
    private String officialUrl;
    @Column(length=2048)
    private String iafdUrl;
    @Column(length=2048)
    private String tubeUrl;
    @Lob
    private String tubeTitle;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Studio studio;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH, CascadeType.DETACH}, mappedBy="movie")
    @OrderBy(value="pos")
    private List<Scene> scenes = new ArrayList<Scene>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH, CascadeType.DETACH}, mappedBy="movie")
    @OrderBy(value="position")
    private List<Bookmark> bookmarks = new ArrayList<Bookmark>();
    private Integer releaseYear;
    private Integer releaseMonth;
    private Integer releaseDay;
    @Enumerated(value=EnumType.STRING)
    private MovieType type;
    @Enumerated(value=EnumType.STRING)
    private MovieType type2;
    @Enumerated(value=EnumType.STRING)
    private MovieType type3;
    @Enumerated(value=EnumType.STRING)
    private MovieType type4;
    @Enumerated(value=EnumType.STRING)
    private MovieType type5;
    @Enumerated(value=EnumType.STRING)
    private MovieType type6;
    @ElementCollection(fetch=FetchType.EAGER)
    @Enumerated(value=EnumType.STRING)
    private Collection<MovieType> movietypes;
    @Lob
    private String publicDescription;
    @Lob
    private String privateDescription;
    private boolean favorite;
    private boolean regrettablyAwesome;
    private boolean secret;
    private boolean synchronizedAudio;
    private boolean censored;
    private boolean counter;
    @Enumerated(value=EnumType.STRING)
    private Language languageSpoken;
    @Enumerated(value=EnumType.STRING)
    private Language languageSubtitles;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH, CascadeType.DETACH})
    @OrderBy(value="part")
    private List<MediumFile> pictures = new ArrayList<MediumFile>();
    private int movieRuntimeCache = 0;
    private boolean snippet;
    private boolean interactive;
    private boolean threeD;
    private boolean vr;
    private boolean decensored;
    private boolean mirrored;
    private boolean vertical;
    private String minutesOfSilence;
    private boolean wizardGenerated;
    @Enumerated(value=EnumType.STRING)
    private Nationality shotInCountry;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTubeUrl() {
        return this.tubeUrl;
    }

    public void setTubeUrl(String tubeUrl) {
        this.tubeUrl = tubeUrl;
    }

    public String getTubeTitle() {
        return this.tubeTitle;
    }

    public String getAlternativeTitle() {
        return this.alternativeTitle;
    }

    public void setAlternativeTitle(String alternativeTitle) {
        this.alternativeTitle = alternativeTitle;
    }

    public String getOfficialUrl() {
        return this.officialUrl;
    }

    public void setOfficialUrl(String officialUrl) {
        this.officialUrl = officialUrl;
    }

    public String getIafdUrl() {
        return this.iafdUrl;
    }

    public void setIafdUrl(String iafdUrl) {
        this.iafdUrl = iafdUrl;
    }

    public void setTubeTitle(String tubeTitle) {
        this.tubeTitle = tubeTitle;
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
    }

    public List<Scene> getScenes() {
        return this.scenes;
    }

    public List<INode> getScenesAsINode() {
        ArrayList<INode> result = new ArrayList<INode>();
        for (Scene s : this.scenes) {
            result.add(s);
        }
        return result;
    }

    public void setScenes(List<Scene> scenes) {
        this.scenes = scenes;
    }

    public List<Bookmark> getBookmarks(boolean showSecret) {
        if (showSecret) {
            return this.bookmarks;
        }
        ArrayList<Bookmark> result = new ArrayList<Bookmark>(this.bookmarks);
        for (Bookmark b : this.bookmarks) {
            if (!b.isSecret() || showSecret) continue;
            result.remove(b);
        }
        return result;
    }

    public List<INode> getBookmarksAsINode(boolean showSecret) {
        ArrayList<INode> result = new ArrayList<INode>();
        this.getBookmarks(showSecret).forEach(b -> result.add((INode)b));
        return result;
    }

    public void setBookmarks(List<Bookmark> bookmarks) {
        this.bookmarks = bookmarks;
    }

    public Integer getReleaseYear() {
        return this.releaseYear;
    }

    public void setReleaseYear(Integer releaseYear) {
        this.releaseYear = releaseYear;
    }

    public Integer getReleaseMonth() {
        return this.releaseMonth;
    }

    public void setReleaseMonth(Integer releaseMonth) {
        this.releaseMonth = releaseMonth;
    }

    public Integer getReleaseDay() {
        return this.releaseDay;
    }

    public void setReleaseDay(Integer releaseDay) {
        this.releaseDay = releaseDay;
    }

    public MovieType getType() {
        return this.type;
    }

    public void setType(MovieType type) {
        this.type = type;
    }

    public MovieType getType2() {
        return this.type2;
    }

    public void setType2(MovieType type2) {
        this.type2 = type2;
    }

    public MovieType getType3() {
        return this.type3;
    }

    public void setType3(MovieType type3) {
        this.type3 = type3;
    }

    public MovieType getType4() {
        return this.type4;
    }

    public void setType4(MovieType type4) {
        this.type4 = type4;
    }

    public MovieType getType5() {
        return this.type5;
    }

    public void setType5(MovieType type5) {
        this.type5 = type5;
    }

    public MovieType getType6() {
        return this.type6;
    }

    public void setType6(MovieType type6) {
        this.type6 = type6;
    }

    public Collection<MovieType> getMovietypes() {
        if (this.movietypes == null) {
            this.movietypes = new ArrayList<MovieType>();
        }
        return this.movietypes;
    }

    public void setMovietypes(Collection<MovieType> movietypes) {
        this.movietypes = movietypes;
    }

    public String getPublicDescription() {
        return this.publicDescription;
    }

    public void setPublicDescription(String publicDescription) {
        this.publicDescription = publicDescription;
    }

    public String getPrivateDescription() {
        return this.privateDescription;
    }

    public void setPrivateDescription(String privateDescription) {
        this.privateDescription = privateDescription;
    }

    @Override
    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public boolean isRegrettablyAwesome() {
        return this.regrettablyAwesome;
    }

    public void setRegrettablyAwesome(boolean regrettablyAwesome) {
        this.regrettablyAwesome = regrettablyAwesome;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public void setSecret(boolean secret) {
        this.secret = secret;
    }

    public boolean isCensored() {
        return this.censored;
    }

    public void setCensored(boolean censored) {
        this.censored = censored;
    }

    public boolean isCounter() {
        return this.counter;
    }

    public void setCounter(boolean counter) {
        this.counter = counter;
    }

    public boolean isSynchronizedAudio() {
        return this.synchronizedAudio;
    }

    public void setSynchronizedAudio(boolean synchronizedAudio) {
        this.synchronizedAudio = synchronizedAudio;
    }

    public Language getLanguageSpoken() {
        return this.languageSpoken;
    }

    public void setLanguageSpoken(Language languageSpoken) {
        this.languageSpoken = languageSpoken;
    }

    public Language getLanguageSubtitles() {
        return this.languageSubtitles;
    }

    public void setLanguageSubtitles(Language languageSubtitles) {
        this.languageSubtitles = languageSubtitles;
    }

    public boolean isSnippet() {
        return this.snippet;
    }

    public void setSnippet(boolean snippet) {
        this.snippet = snippet;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isThreeD() {
        return this.threeD;
    }

    public void setThreeD(boolean threeD) {
        this.threeD = threeD;
    }

    public boolean isVr() {
        return this.vr;
    }

    public void setVr(boolean vr) {
        this.vr = vr;
    }

    public boolean isDecensored() {
        return this.decensored;
    }

    public void setDecensored(boolean decensored) {
        this.decensored = decensored;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public void setMirrored(boolean mirrored) {
        this.mirrored = mirrored;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public String getMinutesOfSilence() {
        return this.minutesOfSilence;
    }

    public void setMinutesOfSilence(String minutesOfSilence) {
        this.minutesOfSilence = minutesOfSilence;
    }

    public boolean isWizardGenerated() {
        return this.wizardGenerated;
    }

    public void setWizardGenerated(boolean wizardGenerated) {
        this.wizardGenerated = wizardGenerated;
    }

    public Nationality getShotInCountry() {
        return this.shotInCountry;
    }

    public void setShotInCountry(Nationality shotInCountry) {
        this.shotInCountry = shotInCountry;
    }

    @Override
    public List<MediumFile> getPictures() {
        if (this.pictures == null) {
            return new ArrayList<MediumFile>();
        }
        return this.pictures;
    }

    public void setPictures(List<MediumFile> pictures) {
        this.pictures = pictures;
    }

    public void addPicture(MediumFile picture) {
        int highestPart = -1;
        for (MediumFile mf : this.getPictures()) {
            if (highestPart >= mf.getPart()) continue;
            highestPart = mf.getPart();
        }
        picture.setPart(++highestPart);
        this.getPictures().add(picture);
    }

    @Override
    public Medium getStartMedium() {
        List<MediumFile> mediumFiles = this.getDB().getMediumFiles(this, true);
        MediumFile result = null;
        if (!mediumFiles.isEmpty()) {
            result = mediumFiles.get(0);
        }
        return result;
    }

    @Override
    public Medium getEndMedium() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNameOfPlayable() {
        return this.title;
    }

    public void recalculateTotalRuntime() {
        this.movieRuntimeCache = 0;
        this.getTotalRuntime();
    }

    @Override
    public int getTotalRuntime() {
        if (this.movieRuntimeCache <= 0) {
            int result = 0;
            List<MediumFile> mediumFiles = this.getDB().getMediumFiles(this, true);
            if (mediumFiles.isEmpty()) {
                result = -1;
                Dvd dvd = db.getDvd(this, true);
                if (dvd != null && dvd.getDuration() != null) {
                    result += dvd.getDuration() / 1000;
                }
            } else {
                for (MediumFile mf : mediumFiles) {
                    Integer duration = mf.getDuration();
                    if (duration != null) {
                        result += duration / 1000;
                        continue;
                    }
                    if (mf.getFileExtension() == null || mf.getFileExtension().equalsIgnoreCase("iso")) continue;
                    Logger.getLogger(Movie.class.getName()).log(Level.WARNING, "Duration for " + mf.getFileCompletePath() + " is not known.");
                }
            }
            this.movieRuntimeCache = result;
        }
        return this.movieRuntimeCache;
    }

    @Override
    public Movie getMovieAssociated() {
        return this;
    }

    public String getTypesAsString() {
        ArrayList<String> typesList = new ArrayList<String>();
        if (this.type != null) {
            typesList.add(this.type.getTitle());
        }
        if (this.type2 != null) {
            typesList.add(this.type2.getTitle());
        }
        if (this.type3 != null) {
            typesList.add(this.type3.getTitle());
        }
        if (this.type4 != null) {
            typesList.add(this.type4.getTitle());
        }
        if (this.type5 != null) {
            typesList.add(this.type5.getTitle());
        }
        if (this.type6 != null) {
            typesList.add(this.type6.getTitle());
        }
        this.movietypes.stream().forEach(f -> typesList.add(f.toString()));
        return typesList.stream().collect(Collectors.joining(", "));
    }

    private DB getDB() {
        if (db == null) {
            db = DB.getInstance();
        }
        return db;
    }
}

