/*
 * Decompiled with CFR 0.152.
 */
package api.invoker.auth;

import api.invoker.auth.Authentication;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;

public class HttpBearerAuth
implements Authentication {
    private final String scheme;
    private Supplier<String> tokenSupplier;

    public HttpBearerAuth(String scheme) {
        this.scheme = scheme;
    }

    public String getBearerToken() {
        return this.tokenSupplier.get();
    }

    public void setBearerToken(String bearerToken) {
        this.tokenSupplier = () -> bearerToken;
    }

    public void setBearerToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    public void applyToParams(MultiValueMap<String, String> queryParams, HttpHeaders headerParams, MultiValueMap<String, String> cookieParams) {
        String bearerToken = Optional.ofNullable(this.tokenSupplier).map(Supplier::get).orElse(null);
        if (bearerToken == null) {
            return;
        }
        headerParams.add("Authorization", (String)(this.scheme != null ? HttpBearerAuth.upperCaseBearer(this.scheme) + " " : "") + bearerToken);
    }

    private static String upperCaseBearer(String scheme) {
        return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
    }
}

