/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.Styler;

public class InfoPanel<ST extends Styler, S extends Series>
implements ChartPart {
    private static final int INFO_PANEL_MARGIN = 6;
    private static final int MULTI_LINE_SPACE = 3;
    private final Chart<ST, S> chart;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private Rectangle2D bounds;

    public InfoPanel(Chart<ST, S> chart) {
        this.chart = chart;
    }

    public void doPaint(Graphics2D g) {
        double startx = this.xOffset + (double)((Styler)this.chart.getStyler()).getInfoPanelPadding();
        double starty = this.yOffset + (double)((Styler)this.chart.getStyler()).getInfoPanelPadding();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        List<String> infoContent = this.chart.getInfoContent();
        Map<String, Rectangle2D> textBounds = this.getTextBounds(infoContent);
        this.paintInfoContent(g, textBounds, startx, starty);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    @Override
    public void paint(Graphics2D g) {
        if (!((Styler)this.chart.getStyler()).isInfoPanelVisible()) {
            return;
        }
        if (this.chart.getPlot().getBounds().getWidth() < 30.0) {
            return;
        }
        if (this.chart.getInfoContent().isEmpty()) {
            return;
        }
        this.bounds = this.getBoundsHintVertical();
        double height = this.bounds.getHeight();
        switch (((Styler)this.chart.getStyler()).getInfoPanelPosition()) {
            case OutsideS: {
                this.xOffset = this.chart.getPlot().getBounds().getX();
                this.yOffset = (double)this.chart.getHeight() - this.bounds.getHeight() - 6.0;
                break;
            }
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(this.xOffset, this.yOffset, this.bounds.getWidth(), height);
        g.setColor(((Styler)this.chart.getStyler()).getInfoPanelBackgroundColor());
        g.fill(rect);
        g.setStroke(SOLID_STROKE);
        g.setColor(((Styler)this.chart.getStyler()).getInfoPanelBorderColor());
        g.draw(rect);
        this.doPaint(g);
    }

    float getEntryHeight(Map<String, Rectangle2D> seriesTextBounds, int markerSize) {
        float legendEntryHeight = 0.0f;
        for (Map.Entry<String, Rectangle2D> entry : seriesTextBounds.entrySet()) {
            legendEntryHeight = (float)((double)legendEntryHeight + (entry.getValue().getHeight() + 3.0));
        }
        legendEntryHeight -= 3.0f;
        legendEntryHeight = Math.max(legendEntryHeight, (float)markerSize);
        return legendEntryHeight;
    }

    float getLegendEntryWidth(Map<String, Rectangle2D> seriesTextBounds, int markerSize) {
        float legendEntryWidth = 0.0f;
        for (Map.Entry<String, Rectangle2D> entry : seriesTextBounds.entrySet()) {
            legendEntryWidth = Math.max(legendEntryWidth, (float)entry.getValue().getWidth());
        }
        return legendEntryWidth + (float)markerSize + (float)((Styler)this.chart.getStyler()).getInfoPanelPadding();
    }

    void paintInfoContent(Graphics2D g, Map<String, Rectangle2D> seriesTextBounds, double x, double starty) {
        g.setColor(((Styler)this.chart.getStyler()).getChartFontColor());
        g.setFont(((Styler)this.chart.getStyler()).getInfoPanelFont());
        double multiLineOffset = 0.0;
        for (Map.Entry<String, Rectangle2D> entry : seriesTextBounds.entrySet()) {
            double height = entry.getValue().getHeight();
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout tl = new TextLayout(entry.getKey(), ((Styler)this.chart.getStyler()).getInfoPanelFont(), frc);
            Shape shape = tl.getOutline(null);
            AffineTransform orig = g.getTransform();
            AffineTransform at = new AffineTransform();
            at.translate(x, starty + height + multiLineOffset);
            g.transform(at);
            g.fill(shape);
            g.setTransform(orig);
            multiLineOffset += height + 3.0;
        }
    }

    private Rectangle2D getBoundsHintVertical() {
        if (!((Styler)this.chart.getStyler()).isInfoPanelVisible()) {
            return new Rectangle2D.Double();
        }
        double contentMaxWidth = 0.0;
        double contentHeight = 0.0;
        List<String> infoContent = this.chart.getInfoContent();
        Map<String, Rectangle2D> textBounds = this.getTextBounds(infoContent);
        double entryHeight = 0.0;
        for (Map.Entry<String, Rectangle2D> entry : textBounds.entrySet()) {
            entryHeight += entry.getValue().getHeight() + 3.0;
            contentMaxWidth = Math.max(contentMaxWidth, entry.getValue().getWidth());
        }
        double contentWidth = (double)((Styler)this.chart.getStyler()).getInfoPanelPadding() + contentMaxWidth;
        double width = contentWidth + (double)(2 * ((Styler)this.chart.getStyler()).getInfoPanelPadding());
        double height = (contentHeight += (entryHeight -= 3.0) + (double)((Styler)this.chart.getStyler()).getInfoPanelPadding()) + (double)((Styler)this.chart.getStyler()).getInfoPanelPadding();
        return new Rectangle2D.Double(0.0, 0.0, width, height);
    }

    Map<String, Rectangle2D> getTextBounds(List<String> lines) {
        Font infoPanelFont = ((Styler)this.chart.getStyler()).getInfoPanelFont();
        LinkedHashMap<String, Rectangle2D> textBounds = new LinkedHashMap<String, Rectangle2D>(lines.size());
        for (String line : lines) {
            TextLayout textLayout = new TextLayout(line, infoPanelFont, new FontRenderContext(null, true, false));
            Shape shape = textLayout.getOutline(null);
            Rectangle2D bounds = shape.getBounds2D();
            textBounds.put(line, bounds);
        }
        return textBounds;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getBoundsHintVertical();
    }
}

