/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.tree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class TreeEntry
implements Comparable<TreeEntry> {
    static final byte[] DIR = "DIRECTORY".getBytes(StandardCharsets.UTF_8);
    private final LookupListener ll = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            Object source = ev.getSource();
            if (source instanceof Lookup.Result) {
                Lookup.Result result = (Lookup.Result)source;
                boolean saveCookiesPresent = !result.allInstances().isEmpty();
                SwingUtilities.invokeLater(() -> {
                    boolean old = TreeEntry.this.modified;
                    TreeEntry.this.modified = saveCookiesPresent;
                    TreeEntry.this.pcs.firePropertyChange("modified", old, TreeEntry.this.modified);
                });
            }
        }
    };
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private TreeEntry parent;
    private final FileObject file1;
    private final FileObject file2;
    private final FileObject basePath1;
    private final FileObject basePath2;
    private final byte[] checksum1;
    private final byte[] checksum2;
    private final List<TreeEntry> children;
    private boolean modified;

    public TreeEntry(FileObject file1, FileObject file2, FileObject basePath1, FileObject basePath2, byte[] checksum1, byte[] checksum2, List<TreeEntry> children) {
        this.file1 = file1;
        this.file2 = file2;
        this.basePath1 = basePath1;
        this.basePath2 = basePath2;
        this.checksum1 = checksum1;
        this.checksum2 = checksum2;
        this.children = new ArrayList<TreeEntry>(children);
        if (this.file2 != null) {
            Lookup.Result saveCookieResult = this.file2.getLookup().lookupResult(SaveCookie.class);
            saveCookieResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.ll, (Object)saveCookieResult));
            this.modified = !saveCookieResult.allInstances().isEmpty();
        }
        for (TreeEntry cte : children) {
            cte.parent = this;
        }
    }

    public TreeEntry getParent() {
        return this.parent;
    }

    public FileObject getFile1() {
        return this.file1;
    }

    public FileObject getFile2() {
        return this.file2;
    }

    public FileObject getBasePath1() {
        return this.basePath1;
    }

    public FileObject getBasePath2() {
        return this.basePath2;
    }

    public byte[] getChecksum1() {
        return this.checksum1;
    }

    public byte[] getChecksum2() {
        return this.checksum2;
    }

    public boolean isFilesIdentical() {
        return Arrays.equals(this.checksum1, this.checksum2);
    }

    public String getRelativePath() {
        String basePath;
        String filePath;
        if (this.file1 != null) {
            filePath = this.file1.getPath();
            basePath = this.basePath1.getPath();
        } else {
            filePath = this.file2.getPath();
            basePath = this.basePath2.getPath();
        }
        return filePath.substring(Math.min(filePath.length(), basePath.length() + 1));
    }

    public String getRelativeParent() {
        String basePath;
        String filePath;
        if (this.file1 != null) {
            filePath = this.file1.getParent().getPath();
            basePath = this.basePath1.getPath();
        } else {
            filePath = this.file2.getParent().getPath();
            basePath = this.basePath2.getPath();
        }
        return filePath.substring(Math.min(filePath.length(), basePath.length() + 1));
    }

    public String getName() {
        if (this.file1 != null) {
            return this.file1.getNameExt();
        }
        return this.file2.getNameExt();
    }

    public List<TreeEntry> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void removeChild(TreeEntry treeEntry) {
        this.children.remove(treeEntry);
    }

    @Override
    public int compareTo(TreeEntry t) {
        return this.getRelativePath().compareToIgnoreCase(t.getRelativePath());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.file1);
        hash = 29 * hash + Objects.hashCode(this.file2);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeEntry other = (TreeEntry)obj;
        if (!Objects.equals(this.file1, other.file1)) {
            return false;
        }
        if (!Objects.equals(this.file2, other.file2)) {
            return false;
        }
        if (!Arrays.equals(this.checksum1, other.checksum1)) {
            return false;
        }
        if (!Arrays.equals(this.checksum2, other.checksum2)) {
            return false;
        }
        return Objects.equals(this.children, other.children);
    }
}

