/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.tree;

import java.util.regex.Pattern;

public class ExclusionPattern {
    private ExclusionType type = ExclusionType.WILDCARD;
    private String pattern;
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(/|\\\\|[*]{1,2})");

    public ExclusionType getType() {
        return this.type;
    }

    public void setType(ExclusionType type) {
        this.type = type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Pattern asPattern() {
        if (this.type == ExclusionType.WILDCARD) {
            String convertedPattern = "\\Q" + WILDCARD_PATTERN.matcher(this.pattern).replaceAll(mr -> {
                String matchedText;
                return switch (matchedText = mr.group()) {
                    case "/", "\\" -> "\\E[/\\\\]\\Q".replace("\\", "\\\\");
                    case "*" -> "\\E[^/\\\\]+\\Q".replace("\\", "\\\\");
                    case "**" -> "\\\\E.+\\\\Q";
                    default -> matchedText;
                };
            }) + "\\E";
            return Pattern.compile(convertedPattern);
        }
        throw new IllegalStateException("Type: " + this.type + " is not known");
    }

    public static enum ExclusionType {
        WILDCARD;

    }
}

