/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxhub.web;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxhub.web.ScenerixxHubSession;
import xxx.scenerixx.scenerixxhub.web.VideoCard;
import xxx.scenerixx.scenerixxhub.web.VideoDescription;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;

public class SearchResultRowPanel
extends Panel {
    private final Logger LOGGER = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private transient IModel<List<Long>> movies;
    protected transient DB db = DB.getInstance();

    public SearchResultRowPanel(String id) {
        super(id);
    }

    public SearchResultRowPanel(String id, IModel<List<Long>> movieIds) {
        super(id);
        this.movies = movieIds;
    }

    protected void onInitialize() {
        super.onInitialize();
        RepeatingView movieCards = new RepeatingView("movieCards");
        RepeatingView movieDescriptions = new RepeatingView("movieDescriptions");
        for (final Long movId : (List)this.movies.getObject()) {
            LoadableDetachableModel<Movie> model = new LoadableDetachableModel<Movie>(){

                protected Movie load() {
                    return (Movie)SearchResultRowPanel.this.getDb().getEntityService().load(Movie.class, movId.longValue());
                }
            };
            List mediumFiles = this.db.getMediumFiles((Movie)model.getObject(), ScenerixxHubSession.get().isUnlocked());
            ArrayList tmpMfs = new ArrayList(mediumFiles);
            for (MediumFile mf : mediumFiles) {
                if (Files.exists(Paths.get(mf.getFileCompletePath(), new String[0]), LinkOption.NOFOLLOW_LINKS)) continue;
                tmpMfs.remove(mf);
                this.LOGGER.info(mf.getFileCompletePath() + " does not exists or is online");
            }
            if (tmpMfs.isEmpty()) continue;
            movieCards.add(new Component[]{new VideoCard(movieCards.newChildId(), model)});
            movieDescriptions.add(new Component[]{new VideoDescription(movieDescriptions.newChildId(), (Movie)model.getObject())});
        }
        this.add(new Component[]{movieCards});
        this.add(new Component[]{movieDescriptions});
    }

    public DB getDb() {
        if (this.db == null) {
            this.db = DB.getInstance();
        }
        return this.db;
    }
}

