/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.studio.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.Importer;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.studio.StudioListTopComponent;

public class ImportStudioAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(ImportStudioAction.class.getName());
    private DB db = DB.getInstance();

    public ImportStudioAction() {
        Image image = ImageUtilities.loadImage((String)"icons/Download.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        block8: {
            Importer imp = new Importer();
            JFileChooser jFileChooser1 = new JFileChooser();
            jFileChooser1.setCurrentDirectory(new File(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirStudio).getAbsoluteFile());
            int ret = jFileChooser1.showOpenDialog(null);
            if (ret == 0) {
                LOG.info("User selected a file to import: " + String.valueOf(jFileChooser1.getSelectedFile()));
                try {
                    Studio s = imp.importStudioFile(jFileChooser1.getSelectedFile().getAbsolutePath());
                    if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)s.getName())).count() > 0L) {
                        JOptionPane.showMessageDialog(null, " There is already a studio with the name " + s.getName() + ". I cannot handle this. Either delete the existing studio or rename the studio to import.", "", 0);
                        break block8;
                    }
                    if (s.getParent() != null) {
                        Studio parent = (Studio)this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.equalsIgnoreCase(s.getParent().getName())).findFirst();
                        if (parent == null) {
                            parent = (Studio)this.db.getEntityService().save((AbstractEntity)s.getParent());
                        }
                        s.setParent(parent);
                    }
                    this.db.getEntityService().save((AbstractEntity)s);
                    TopComponent studioList = WindowManager.getDefault().findTopComponent("StudioListTopComponent");
                    if (studioList != null) {
                        ((StudioListTopComponent)studioList).reloadList();
                    }
                    AbstractTopComponent.notifyInfo("Imported " + s.getName());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("Could not import studio file. An error occured: " + ex.getMessage());
                }
            } else {
                LOG.fine("User cancelled import.");
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Import Studio";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

