/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.search.action;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class OpenInMoviesWindowAction
extends NodeAction
implements Presenter.Popup {
    List<INode> nodes = new ArrayList<INode>();

    public OpenInMoviesWindowAction(List<INode> nodes) {
        this();
        this.nodes = nodes;
    }

    public OpenInMoviesWindowAction() {
        Image image = ImageUtilities.loadImage((String)"icons/movie.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] selectedNodes) {
        Playlist playlist = new Playlist();
        playlist.setName("[TEMPORARY PLAYLIST]");
        ArrayList<PlaylistEntry> entries = new ArrayList<PlaylistEntry>();
        for (INode node : this.nodes) {
            PlaylistEntry pe = new PlaylistEntry();
            if (node instanceof Scene) {
                Scene scene = (Scene)node;
                pe.setMovie(scene.getMovieAssociated());
            }
            if (node instanceof Movie) {
                Movie movie = (Movie)node;
                pe.setMovie(movie);
            }
            if (node instanceof Bookmark) {
                Bookmark bookmark = (Bookmark)node;
                pe.setMovie(bookmark.getMovieAssociated());
            }
            entries.add(pe);
        }
        playlist.setEntries(entries);
        TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
        if (movieList != null) {
            ((MovieListTopComponent)movieList).clearFilter();
            ((MovieListTopComponent)movieList).openPlaylist(playlist);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Open in 'Movies' window";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    protected boolean asynchronous() {
        return false;
    }

    public void execute(List<INode> nodes) {
        this.performAction(null);
    }

    public void setNodes(List<INode> nodes) {
        this.nodes = nodes;
    }
}

