/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.search.action;

import java.awt.Image;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;

public class CreatePlaylistAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(CreatePlaylistAction.class.getName());
    private DB db = DB.getInstance();
    private List<INode> scenes;
    protected PlaylistService ps = new PlaylistService();

    public CreatePlaylistAction() {
        Image image = ImageUtilities.loadImage((String)"icons/notes.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/badgeAdd.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        ArrayList<INode> list = new ArrayList<INode>();
        Scene tmpScene = null;
        for (INode s : this.scenes) {
            list.add(s);
            if (!(s instanceof Scene) || (tmpScene = (Scene)s) == null) continue;
            list.addAll(tmpScene.getMovie().getBookmarksAsINode(Scenerixx.unlocked));
        }
        Playlist playlist = new Playlist();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        playlist.setName("[New Search " + df.format(LocalDateTime.now()) + "]");
        int dvds = 0;
        for (INode n : list) {
            PlaylistEntry pe = new PlaylistEntry();
            pe.setPlaylist(playlist);
            pe.setDateOfCreation(LocalDateTime.now());
            if (n instanceof Scene) {
                Scene scene = (Scene)n;
                if (this.db.getDvd(scene.getMovie(), Scenerixx.unlocked) == null) {
                    pe.setScene(scene);
                    playlist = this.ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                } else {
                    ++dvds;
                }
            }
            if (!(n instanceof Bookmark)) continue;
            Bookmark bookmark = (Bookmark)n;
            if (this.db.getDvd(bookmark.getMovieAssociated(), Scenerixx.unlocked) == null) {
                pe.setBookmark(bookmark);
                playlist = this.ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                continue;
            }
            ++dvds;
        }
        TopComponent playlistList = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
        if (playlistList != null) {
            ((PlaylistTopComponent)playlistList).reloadList(playlist.getName());
        }
        String message = "Created new playlist '" + playlist.getName() + "'";
        if (dvds > 0) {
            message = message + " (" + dvds + " DVDs have not been added)";
        }
        AbstractTopComponent.notifyInfo(message);
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Create Playlist";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    public void setScenes(List<INode> scenes) {
        this.scenes = scenes;
    }
}

