/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.person;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.text.diff.CommandVisitor;
import org.apache.commons.text.diff.StringsComparator;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxmodule.util.sync.WebServiceHelper;
import xxx.scenerixx.scenerixxmodule.windows.indexing.IndexingTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonDetailsPanel;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;

public class PersonDiffPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(PersonDiffPanel.class.getName());
    private PersonDetailsPanel panel;
    private List<Person> personServer;
    private Person currentPerson;
    private String fromWhere;
    private int currentIndex = 0;
    private FileCommandsVisitor fileCommandsVisitor;
    private boolean showWhenNoDiff = true;
    private DiffView diffView;
    private JButton btnAbort;
    private JButton btnKeepCurrentAndDoNothing;
    private JButton btnKeepCurrentAndUpload;
    private JButton btnNext;
    private JButton btnPrev;
    private JButton btnUseVersionFromServer;
    private JPanel diffPanel;
    private JScrollPane jScrollPane1;
    private JLabel lbExplanation;

    public PersonDiffPanel() {
        this.initComponents();
    }

    public PersonDiffPanel(PersonDetailsPanel panel, Person currentPerson, List<Person> personOnServer, String fromWhere, boolean showWhenNoDiff) {
        this();
        this.panel = panel;
        this.personServer = personOnServer;
        this.currentPerson = currentPerson;
        this.showWhenNoDiff = showWhenNoDiff;
        this.fromWhere = fromWhere;
        this.loadDiff(currentPerson);
        this.toggleButtonsEnabled();
    }

    public boolean isDiff() {
        return this.fileCommandsVisitor.isChanges();
    }

    private void loadDiff(Person currentPerson) {
        this.loadDiffOld(currentPerson);
        this.loadDiffNew(currentPerson);
    }

    private boolean loadDiffNew(Person currentPerson) {
        String orgFileName = "";
        String newFileName = "";
        try {
            Exporter exp = new Exporter();
            orgFileName = exp.exportPersonToFile(currentPerson, System.getProperty("java.io.tmpdir"), false);
            File f = new File(orgFileName);
            orgFileName = orgFileName.replace(".scenerixx", ".scenerixx.old");
            f.renameTo(new File(orgFileName));
            f = new File(orgFileName);
            newFileName = exp.exportPersonToFile(this.personServer.get(this.currentIndex), System.getProperty("java.io.tmpdir"), false);
            File f2 = new File(newFileName);
            newFileName = newFileName.replace(".scenerixx", ".scenerixx.new");
            f2.renameTo(new File(newFileName));
            f2 = new File(newFileName);
            File tmpf1 = new File(orgFileName);
            File tmpf2 = new File(newFileName);
            SwingUtilities.invokeLater(() -> {
                try {
                    LOG.info("starting new diff");
                    this.diffView = Diff.getDefault().createDiff(StreamSource.createSource((String)"name1", (String)("current version for " + currentPerson.getName()), (String)"text/html", (File)tmpf1), StreamSource.createSource((String)"name2", (String)("version " + (this.currentIndex + 1) + " of " + this.personServer.size() + " " + this.fromWhere), (String)"text/html", (File)tmpf2));
                    LOG.fine("diff count: " + this.diffView.getDifferenceCount() + " for " + currentPerson.getName());
                    this.toggleButtonsEnabled();
                    Component component1 = this.diffView.getComponent();
                    LOG.info("component: " + String.valueOf(this.diffView.getComponent()));
                    component1.setSize(1150, 650);
                    this.diffPanel.removeAll();
                    this.diffPanel.add(component1);
                    this.revalidate();
                    LOG.fine(" new diff done... count: " + this.diffView.getDifferenceCount());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return this.isDiff();
    }

    private boolean loadDiffOld(Person currentPerson) {
        String orgFileName = "";
        String newFileName = "";
        try {
            Exporter exp = new Exporter();
            orgFileName = exp.exportPersonToFile(currentPerson, System.getProperty("java.io.tmpdir"), false);
            File f = new File(orgFileName);
            orgFileName = orgFileName.replace(".scenerixx", ".scenerixx.old");
            f.renameTo(new File(orgFileName));
            f = new File(orgFileName);
            newFileName = exp.exportPersonToFile(this.personServer.get(this.currentIndex), System.getProperty("java.io.tmpdir"), false);
            File f2 = new File(newFileName);
            newFileName = newFileName.replace(".scenerixx", ".scenerixx.new");
            f2.renameTo(new File(newFileName));
            f2 = new File(newFileName);
            File tmpf1 = new File(orgFileName);
            File tmpf2 = new File(newFileName);
            LineIterator file1 = FileUtils.lineIterator((File)f, (String)"utf-8");
            LineIterator file2 = FileUtils.lineIterator((File)f2, (String)"utf-8");
            this.fileCommandsVisitor = new FileCommandsVisitor();
            while (file1.hasNext() || file2.hasNext()) {
                String right;
                String left = (file1.hasNext() ? file1.nextLine() : "") + "\n";
                StringsComparator comparator = new StringsComparator(left, right = (file2.hasNext() ? file2.nextLine() : "") + "\n");
                if ((double)comparator.getScript().getLCSLength() > (double)Integer.max(left.length(), right.length()) * 0.4) {
                    comparator.getScript().visit((CommandVisitor)this.fileCommandsVisitor);
                    continue;
                }
                StringsComparator leftComparator = new StringsComparator(left, "\n");
                leftComparator.getScript().visit((CommandVisitor)this.fileCommandsVisitor);
                StringsComparator rightComparator = new StringsComparator("\n", right);
                rightComparator.getScript().visit((CommandVisitor)this.fileCommandsVisitor);
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return this.fileCommandsVisitor.isChanges();
    }

    private void initComponents() {
        this.btnKeepCurrentAndUpload = new JButton();
        this.btnUseVersionFromServer = new JButton();
        this.btnNext = new JButton();
        this.btnPrev = new JButton();
        this.btnKeepCurrentAndDoNothing = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.diffPanel = new JPanel();
        this.btnAbort = new JButton();
        this.lbExplanation = new JLabel();
        this.btnKeepCurrentAndUpload.setIcon(new ImageIcon(this.getClass().getResource("/icons/Raise.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnKeepCurrentAndUpload, (String)NbBundle.getMessage(PersonDiffPanel.class, (String)"PersonDiffPanel.btnKeepCurrentAndUpload.text"));
        this.btnKeepCurrentAndUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonDiffPanel.this.btnKeepCurrentAndUploadActionPerformed(evt);
            }
        });
        this.btnUseVersionFromServer.setIcon(new ImageIcon(this.getClass().getResource("/icons/Fall.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUseVersionFromServer, (String)NbBundle.getMessage(PersonDiffPanel.class, (String)"PersonDiffPanel.btnUseVersionFromServer.text"));
        this.btnUseVersionFromServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonDiffPanel.this.btnUseVersionFromServerActionPerformed(evt);
            }
        });
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/icons/Forward.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNext, (String)NbBundle.getMessage(PersonDiffPanel.class, (String)"PersonDiffPanel.btnNext.text"));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonDiffPanel.this.btnNextActionPerformed(evt);
            }
        });
        this.btnPrev.setIcon(new ImageIcon(this.getClass().getResource("/icons/Back.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPrev, (String)NbBundle.getMessage(PersonDiffPanel.class, (String)"PersonDiffPanel.btnPrev.text"));
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonDiffPanel.this.btnPrevActionPerformed(evt);
            }
        });
        this.btnKeepCurrentAndDoNothing.setIcon(new ImageIcon(this.getClass().getResource("/icons/No.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnKeepCurrentAndDoNothing, (String)NbBundle.getMessage(PersonDiffPanel.class, (String)"PersonDiffPanel.btnKeepCurrentAndDoNothing.text"));
        this.btnKeepCurrentAndDoNothing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonDiffPanel.this.btnKeepCurrentAndDoNothingActionPerformed(evt);
            }
        });
        GroupLayout diffPanelLayout = new GroupLayout(this.diffPanel);
        this.diffPanel.setLayout(diffPanelLayout);
        diffPanelLayout.setHorizontalGroup(diffPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        diffPanelLayout.setVerticalGroup(diffPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 559, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.diffPanel);
        this.btnAbort.setIcon(new ImageIcon(this.getClass().getResource("/icons/Cancel.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAbort, (String)NbBundle.getMessage(PersonDiffPanel.class, (String)"PersonDiffPanel.btnAbort.text"));
        this.btnAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonDiffPanel.this.btnAbortActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbExplanation, (String)NbBundle.getMessage(PersonDiffPanel.class, (String)"PersonDiffPanel.lbExplanation.text"));
        this.lbExplanation.setVerticalAlignment(1);
        this.lbExplanation.setVerticalTextPosition(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnUseVersionFromServer, -1, -1, Short.MAX_VALUE).addComponent(this.btnKeepCurrentAndUpload, -1, -1, Short.MAX_VALUE).addComponent(this.btnKeepCurrentAndDoNothing, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnPrev).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAbort))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbExplanation)).addComponent(this.jScrollPane1, -2, 1200, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 561, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnKeepCurrentAndDoNothing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnKeepCurrentAndUpload).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUseVersionFromServer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnPrev, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNext).addComponent(this.btnAbort))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.lbExplanation))).addContainerGap()));
    }

    private void btnKeepCurrentAndUploadActionPerformed(ActionEvent evt) {
        WebServiceHelper.uploadPerson(this.currentPerson);
        this.reloadPersonList();
        this.closePanel();
    }

    private void closePanel() {
        JDialog parent = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
        if (parent != null) {
            LOG.finer("dispose person diff");
            parent.dispose();
        } else {
            LOG.finer("parent is null");
        }
    }

    private void btnUseVersionFromServerActionPerformed(ActionEvent evt) {
        this.saveVersionFromServer();
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.showNextVersion();
    }

    private void btnPrevActionPerformed(ActionEvent evt) {
        this.showPrevVersion();
    }

    private void btnKeepCurrentAndDoNothingActionPerformed(ActionEvent evt) {
        this.closePanel();
    }

    private void btnAbortActionPerformed(ActionEvent evt) {
        this.abort();
    }

    private void abort() {
        IndexingTopComponent.abortIndexing = true;
        this.closePanel();
    }

    private void showNextVersion() {
        if (this.currentIndex < this.personServer.size() - 1) {
            ++this.currentIndex;
            this.toggleButtonsEnabled();
            this.loadDiff(this.currentPerson);
        }
    }

    private void showPrevVersion() {
        if (this.currentIndex > 0) {
            --this.currentIndex;
            this.toggleButtonsEnabled();
            this.loadDiff(this.currentPerson);
        }
    }

    private void toggleButtonsEnabled() {
        LOG.finer("cur index " + this.currentIndex);
        if (this.currentIndex < this.personServer.size() - 1) {
            this.btnNext.setEnabled(true);
        } else {
            this.btnNext.setEnabled(false);
        }
        if (this.currentIndex == 0) {
            this.btnPrev.setEnabled(false);
        } else {
            this.btnPrev.setEnabled(true);
        }
        if (!this.isDiff()) {
            this.btnKeepCurrentAndUpload.setEnabled(false);
            this.btnUseVersionFromServer.setEnabled(false);
            this.btnKeepCurrentAndUpload.setToolTipText("There are no differences.");
            this.btnUseVersionFromServer.setToolTipText("There are no differences.");
            if (!(this.showWhenNoDiff || this.btnPrev.isEnabled() || this.btnNext.isEnabled())) {
                LOG.info("trying to close");
                this.closePanel();
            }
        } else {
            this.btnKeepCurrentAndUpload.setEnabled(true);
            this.btnUseVersionFromServer.setEnabled(true);
            this.btnKeepCurrentAndUpload.setToolTipText("");
            this.btnUseVersionFromServer.setToolTipText("");
        }
    }

    public void saveVersionFromServer() {
        Person personToSave = this.personServer.get(this.currentIndex);
        personToSave.setId(this.currentPerson.getId());
        this.panel.loadForm(personToSave, null, false);
        this.panel.savePerson();
        this.reloadPersonList();
        this.closePanel();
    }

    private void reloadPersonList() {
        SwingUtilities.invokeLater(() -> {
            TopComponent personList = WindowManager.getDefault().findTopComponent("PersonListTopComponent");
            if (personList != null) {
                ((PersonListTopComponent)personList).appendSearchText(this.currentPerson.getName());
                ((PersonListTopComponent)personList).reloadList(this.currentPerson.getName());
            }
        });
    }

    class FileCommandsVisitor
    implements CommandVisitor<Character> {
        private static final String DELETION = "<span style=\"background-color: #FB504B\">${text}</span>";
        private static final String INSERTION = "<span style=\"background-color: #45EA85\">${text}</span>";
        private String left = "";
        private String right = "";
        private boolean changes = false;

        FileCommandsVisitor() {
        }

        public boolean isChanges() {
            return this.changes;
        }

        public void visitKeepCommand(Character c) {
            Object toAppend = "\n".equals("" + c) ? "<br/>" : "" + c;
            this.left = this.left + (String)toAppend;
            this.right = this.right + (String)toAppend;
        }

        public void visitInsertCommand(Character c) {
            Object toAppend = "\n".equals("" + c) ? "<br/>" : "" + c;
            this.right = this.right + INSERTION.replace("${text}", (String)toAppend);
            this.changes = true;
        }

        public void visitDeleteCommand(Character c) {
            Object toAppend = "\n".equals("" + c) ? "<br/>" : "" + c;
            this.left = this.left + DELETION.replace("${text}", (String)toAppend);
            this.changes = true;
        }

        public String generateHTML() throws IOException {
            this.left = this.left.replaceAll("<", "&lt;");
            this.left = this.left.replaceAll(">", "&gt;");
            this.left = this.left.replaceAll("&lt;br/&gt;", "<br>");
            this.left = this.left.replaceAll("&lt;/span&gt;", "</span>");
            this.left = this.left.replaceAll("&lt;span", "<span");
            this.left = this.left.replaceAll("\"&gt;", "\">");
            this.right = this.right.replaceAll("<", "&lt;");
            this.right = this.right.replaceAll(">", "&gt;");
            this.right = this.right.replaceAll("&lt;br/&gt;", "<br>");
            this.right = this.right.replaceAll("&lt;/span&gt;", "</span>");
            this.right = this.right.replaceAll("&lt;span", "<span");
            this.right = this.right.replaceAll("\"&gt;", "\">");
            return "<html><table><tr><tr><td><b>Current person</b></td><td><b>Person " + PersonDiffPanel.this.fromWhere + " (" + (PersonDiffPanel.this.currentIndex + 1) + " of " + PersonDiffPanel.this.personServer.size() + ")</b></td></tr><td><pre>" + this.left + "</pre></td><td><pre>" + this.right + "</pre></td></tr></table></html>";
        }
    }
}

