/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.dashboard;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Color;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.medium.QMedium;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.actions.ChangelogAction;
import xxx.scenerixx.scenerixxmodule.actions.LoadLastSessionAction;
import xxx.scenerixx.scenerixxmodule.options.TipOfTheDayPanel;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.dashboard.Bundle;
import xxx.scenerixx.scenerixxmodule.windows.indexing.IndexingTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.indexing.ScenerixxWizardTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.PlaceholderPanel;
import xxx.scenerixx.scenerixxmodule.windows.statistic.StatisticService;
import xxx.scenerixx.scenerixxmodule.windows.statistic.StatisticTopComponent;

@TopComponent.Description(preferredID="DashboardTopComponent", iconBase="icons2/favicon.png", persistenceType=0)
public final class DashboardTopComponent
extends AbstractTopComponent {
    private static final Logger LOG = Logger.getLogger(DashboardTopComponent.class.getName());
    private DB db = DB.getInstance();
    private StatisticService statService = new StatisticService();
    private JButton btnChangelog;
    private ButtonGroup btnGrpOrderBy;
    private JButton btnIndexing;
    private JButton btnStatistic;
    private JButton btnWizard;
    private JButton btnWizard1;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JLabel lbBirhtdayIcon;
    private JLabel lbBirthdays;
    private JLabel lbStats;
    private JLabel lbUnhashed;
    private JLabel lbUpgradedToNewVersion;
    private PlaceholderPanel panelPlaceholder;
    private TipOfTheDayPanel tipOfTheDayPanel1;

    public DashboardTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_DashboardTopComponent());
        this.setToolTipText(Bundle.HINT_DashboardTopComponent());
        this.lbStats.setText(this.statService.loadStatistics(false));
        this.checkUnhashedFiles();
        this.upgradedToNewVersion();
        this.showBirthdays();
    }

    public void setStatus(String text) {
        if (!text.isBlank()) {
            this.requestActive();
        }
        this.panelPlaceholder.setStatus(text);
    }

    private void upgradedToNewVersion() throws HeadlessException {
        if (Scenerixx.upgradedToNewVersion) {
            this.lbUpgradedToNewVersion.setText("<html><b>Welcome back</b><br>You updated to version " + Scenerixx.VERSION + ". <br>Have a look at the changelog in the help to see what's new.</html>");
            this.lbUpgradedToNewVersion.setVisible(true);
            this.btnChangelog.setVisible(true);
        } else {
            this.lbUpgradedToNewVersion.setVisible(false);
            this.btnChangelog.setVisible(false);
        }
    }

    private void checkUnhashedFiles() throws HeadlessException {
        long notHashedFiles = this.db.getEntityService().find((EntityPathBase)QMedium.medium).filter(f -> f.hashValue.isNull()).count();
        if (notHashedFiles > 0L) {
            this.lbUnhashed.setText("<html><b>Just a small reminder:</b> <br>there are still " + notHashedFiles + " unhashed files. You will not be able to associate an unhashed file to a movie.<br>You can hash them in the 'Indexing, Hashing, Purging' window. Or use the wizard.</html>");
            this.btnIndexing.setVisible(true);
            this.lbUnhashed.setVisible(true);
        } else {
            this.btnIndexing.setVisible(false);
            this.lbUnhashed.setVisible(false);
        }
    }

    private void showBirthdays() {
        List personsByBirthdateMales = this.db.getPersonsByBirthdate(Gender.MALE, Scenerixx.unlocked);
        List personsByBirthdateFemales = this.db.getPersonsByBirthdate(Gender.FEMALE, Scenerixx.unlocked);
        List personsByBirthdateTs = this.db.getPersonsByBirthdate(Gender.TS, Scenerixx.unlocked);
        Object females = "";
        Object males = "";
        Object ts = "";
        for (Person p : personsByBirthdateFemales) {
            if (!p.hasBirthday()) continue;
            females = (String)females + "<tr><td>" + p.getNameWithBirthtoday(true) + "</td></tr>";
        }
        for (Person p : personsByBirthdateTs) {
            if (!p.hasBirthday()) continue;
            ts = (String)ts + "<tr><td>" + p.getNameWithBirthtoday(true) + "</td></tr>";
        }
        for (Person p : personsByBirthdateMales) {
            if (!p.hasBirthday()) continue;
            males = (String)males + "<tr><td>" + p.getNameWithBirthtoday(true) + "</td></tr>";
        }
        if (((String)males).length() == 0 && ((String)females).length() == 0 && ((String)ts).length() == 0) {
            this.lbBirhtdayIcon.setIcon(null);
            this.lbBirthdays.setText("");
        } else {
            String s = "<html><table>" + (String)females + (String)ts + (String)males + "</table></html>";
            this.lbBirthdays.setText(s);
        }
    }

    private void initComponents() {
        this.btnGrpOrderBy = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jSeparator6 = new JSeparator();
        this.jSeparator1 = new JSeparator();
        this.btnWizard = new JButton();
        this.jSeparator4 = new JSeparator();
        this.lbStats = new JLabel();
        this.btnStatistic = new JButton();
        this.jSeparator3 = new JSeparator();
        this.panelPlaceholder = new PlaceholderPanel();
        this.btnIndexing = new JButton();
        this.jSeparator2 = new JSeparator();
        this.tipOfTheDayPanel1 = new TipOfTheDayPanel();
        this.lbUnhashed = new JLabel();
        this.jSeparator5 = new JSeparator();
        this.btnChangelog = new JButton();
        this.lbUpgradedToNewVersion = new JLabel();
        this.jSeparator8 = new JSeparator();
        this.lbBirthdays = new JLabel();
        this.lbBirhtdayIcon = new JLabel();
        this.jSeparator11 = new JSeparator();
        this.btnWizard1 = new JButton();
        this.jSeparator12 = new JSeparator();
        this.jSeparator7 = new JSeparator();
        this.jSeparator9 = new JSeparator();
        this.jSeparator10 = new JSeparator();
        this.jSeparator6.setForeground(new Color(0, 153, 153));
        this.jSeparator1.setForeground(new Color(0, 153, 153));
        this.jSeparator1.setOrientation(1);
        this.btnWizard.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.silk/wand.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnWizard, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.btnWizard.text"));
        this.btnWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardTopComponent.this.btnWizardActionPerformed(evt);
            }
        });
        this.jSeparator4.setBackground(new Color(0, 153, 153));
        this.jSeparator4.setForeground(new Color(0, 153, 153));
        Mnemonics.setLocalizedText((JLabel)this.lbStats, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.lbStats.text"));
        this.btnStatistic.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Piechart.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnStatistic, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.btnStatistic.text"));
        this.btnStatistic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardTopComponent.this.btnStatisticActionPerformed(evt);
            }
        });
        this.jSeparator3.setForeground(new Color(0, 153, 153));
        this.btnIndexing.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Database.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnIndexing, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.btnIndexing.text"));
        this.btnIndexing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardTopComponent.this.btnIndexingActionPerformed(evt);
            }
        });
        this.jSeparator2.setForeground(new Color(0, 153, 153));
        Mnemonics.setLocalizedText((JLabel)this.lbUnhashed, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.lbUnhashed.text"));
        this.jSeparator5.setForeground(new Color(0, 153, 153));
        this.btnChangelog.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/About.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnChangelog, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.btnChangelog.text"));
        this.btnChangelog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardTopComponent.this.btnChangelogActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbUpgradedToNewVersion, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.lbUpgradedToNewVersion.text"));
        this.jSeparator8.setForeground(new Color(0, 153, 153));
        this.jSeparator8.setOrientation(1);
        Mnemonics.setLocalizedText((JLabel)this.lbBirthdays, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.lbBirthdays.text"));
        this.lbBirhtdayIcon.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Gift.png")));
        Mnemonics.setLocalizedText((JLabel)this.lbBirhtdayIcon, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.lbBirhtdayIcon.text"));
        this.lbBirhtdayIcon.setToolTipText(NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.lbBirhtdayIcon.toolTipText"));
        this.jSeparator11.setForeground(new Color(0, 153, 153));
        this.jSeparator11.setOrientation(1);
        this.btnWizard1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/time.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnWizard1, (String)NbBundle.getMessage(DashboardTopComponent.class, (String)"DashboardTopComponent.btnWizard1.text"));
        this.btnWizard1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardTopComponent.this.btnWizard1ActionPerformed(evt);
            }
        });
        this.jSeparator12.setBackground(new Color(0, 153, 153));
        this.jSeparator12.setForeground(new Color(0, 153, 153));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.tipOfTheDayPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator6, GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panelPlaceholder, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnWizard, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator4)).addGap(9, 9, 9)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator12).addComponent(this.btnWizard1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.jSeparator1, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnStatistic, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2).addComponent(this.btnIndexing, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator5).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.lbStats)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lbUpgradedToNewVersion).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.btnChangelog, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.lbUnhashed, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.lbBirhtdayIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbBirthdays).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator11, -2, 3, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator3)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator8, -2, 0, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator8).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lbUpgradedToNewVersion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChangelog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbUnhashed, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnIndexing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator5, -2, 10, -2).addGap(3, 3, 3).addComponent(this.lbStats).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnStatistic)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.panelPlaceholder, -2, -1, -2).addGap(4, 4, 4).addComponent(this.jSeparator12, -2, 10, -2).addGap(4, 4, 4).addComponent(this.btnWizard1, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnWizard, -2, 43, -2)).addComponent(this.jSeparator1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator6, -2, 13, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tipOfTheDayPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbBirhtdayIcon).addComponent(this.lbBirthdays).addComponent(this.jSeparator11, -2, 62, -2)).addContainerGap()))));
        this.jSeparator7.setForeground(new Color(0, 153, 153));
        this.jSeparator9.setForeground(new Color(0, 153, 153));
        this.jSeparator9.setOrientation(1);
        this.jSeparator10.setForeground(new Color(0, 153, 153));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator7).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator10, -1, 94, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator9, -2, 15, -2).addGap(0, 0, Short.MAX_VALUE)))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator10, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator9))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator7, -2, 10, -2)));
    }

    private void btnWizardActionPerformed(ActionEvent evt) {
        this.openWizard();
    }

    public void openWizard() {
        TopComponent wizardTC = WindowManager.getDefault().findTopComponent("ScenerixxWizardTopComponent");
        if (wizardTC != null) {
            ((ScenerixxWizardTopComponent)wizardTC).open();
            ((ScenerixxWizardTopComponent)wizardTC).requestActive();
        }
    }

    private void btnStatisticActionPerformed(ActionEvent evt) {
        this.openStatistic();
    }

    private void btnIndexingActionPerformed(ActionEvent evt) {
        this.openIndexing();
    }

    private void btnChangelogActionPerformed(ActionEvent evt) {
        new ChangelogAction().actionPerformed(null);
    }

    private void btnWizard1ActionPerformed(ActionEvent evt) {
        new LoadLastSessionAction().actionPerformed(null);
    }

    public void openStatistic() {
        StatisticTopComponent statTC = (StatisticTopComponent)WindowManager.getDefault().findTopComponent("StatisticTopComponent");
        if (statTC != null) {
            statTC.open();
            statTC.requestActive();
        }
    }

    public void openIndexing() {
        IndexingTopComponent indexingTC = (IndexingTopComponent)WindowManager.getDefault().findTopComponent("IndexingTopComponent");
        indexingTC.open();
        indexingTC.requestActive();
    }

    @Override
    public void componentOpened() {
    }

    @Override
    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

