/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util.gui.memory;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;

public class MemPanel
extends JPanel {
    private final ScheduledExecutorService executorService;
    private static final int REFRESH_INTERVAL_IN_SECONDS = 2;
    private final ThreadFactory threadFactory = r -> {
        Thread thread = new Thread(r);
        thread.setName("Memory Usage Status Line Panel");
        return thread;
    };
    private final Runnable updater = new Runnable(){

        @Override
        public void run() {
            this.updateMemoryUsageInfo();
        }

        private void updateMemoryUsageInfo() {
            Runtime runtime = Runtime.getRuntime();
            long totalMemoryInBytes = runtime.totalMemory();
            long freeMemoryInBytes = runtime.freeMemory();
            long maxMemoryInBytes = runtime.maxMemory();
            long usedMemoryInBytes = totalMemoryInBytes - freeMemoryInBytes;
            MemPanel.this.lbMemory.setText(ScenerixxCommon.readableFileSize(usedMemoryInBytes));
            MemPanel.this.lbMemory.setToolTipText("<html>Free memory: " + ScenerixxCommon.readableFileSize(freeMemoryInBytes) + "<br/>Max. memory: " + ScenerixxCommon.readableFileSize(maxMemoryInBytes) + "<br/>Used memory: " + ScenerixxCommon.readableFileSize(usedMemoryInBytes) + "<br/>Total memory: " + ScenerixxCommon.readableFileSize(totalMemoryInBytes) + "</html>");
        }
    };
    private JLabel lbMemory;

    public MemPanel() {
        this.initComponents();
        this.executorService = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        this.executorService.scheduleAtFixedRate(this.updater, 0L, 2L, TimeUnit.SECONDS);
    }

    private void initComponents() {
        this.lbMemory = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lbMemory, (String)NbBundle.getMessage(MemPanel.class, (String)"MemPanel.lbMemory.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lbMemory).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbMemory));
    }
}

