/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        Instant instant = Instant.ofEpochMilli(record.getMillis());
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        String logMsg = timestamp.toLocalTime().toString() + " - " + String.format("%-7s", record.getLevel()) + " - [" + this.shortenName(record.getLoggerName()) + "]: " + record.getMessage() + "\n";
        if (logMsg.length() > 150 && !logMsg.endsWith("\n\n")) {
            logMsg = logMsg + "\n";
        }
        return logMsg;
    }

    private String shortenName(String s) {
        Object ret = "";
        try {
            String[] split = s.split("\\.");
            if (split.length == 0) {
                ret = s;
            } else {
                for (int i = 0; i < split.length - 1; ++i) {
                    ret = (String)ret + split[i].substring(0, 1) + ".";
                }
                ret = (String)ret + split[split.length - 1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format("%-40s", ret);
    }
}

