/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.FocusManager;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AutoCompleteBehaviour<T> {
    private Window popup;
    private JTextComponent editor;
    private final JList<T> list = new JList();
    private ListCellRenderer<? super T> listCellRenderer;
    private JScrollPane scrollPane;
    private final AutoCompleteBuffer buffer = new AutoCompleteBuffer();
    private int visibleRowCount = 3;
    private boolean autoCompleteActive;
    private long activationTimestamp;
    private Dimension initialPopupSize = new Dimension(100, 300);
    private final MyKeyDispatcher keyInterceptor = new MyKeyDispatcher();
    private final MyListModel listModel = new MyListModel();
    private final ChangeListener viewportListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (AutoCompleteBehaviour.this.autoCompleteActive) {
                AutoCompleteBehaviour.this.hidePopup(null);
            }
        }
    };
    private final CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent e) {
            if (AutoCompleteBehaviour.this.autoCompleteActive && !AutoCompleteBehaviour.this.buffer.isValidOffset(e.getDot())) {
                AutoCompleteBehaviour.this.hidePopup(null);
            }
        }
    };
    private final PropertyChangeListener focusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            Object newValue;
            if (AutoCompleteBehaviour.this.autoCompleteActive && (newValue = ev.getNewValue()) instanceof Component && "focusOwner".equals(ev.getPropertyName()) && !AutoCompleteBehaviour.isChildOf(AutoCompleteBehaviour.this.editor, (Component)newValue) && !AutoCompleteBehaviour.isChildOf(AutoCompleteBehaviour.this.popup, (Component)newValue)) {
                AutoCompleteBehaviour.this.hidePopup(null);
            }
        }
    };
    private IAutoCompleteCallback<T> callback = new DefaultAutoCompleteCallback<T>(this){

        @Override
        public List<T> getProposals(String input) {
            return Collections.emptyList();
        }

        @Override
        public String getStringToInsert(T item) {
            return item == null ? "" : item.toString();
        }
    };
    boolean showAlways = false;
    private final KeyAdapter keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (AutoCompleteBehaviour.this.showAlways || e.getKeyCode() == 32 && AutoCompleteBehaviour.isCtrlDown(e) || !AutoCompleteBehaviour.this.autoCompleteActive && e.getKeyCode() == 40) {
                try {
                    InitialUserInput p = AutoCompleteBehaviour.this.callback.getInitialUserInput(AutoCompleteBehaviour.this.editor, AutoCompleteBehaviour.this.editor.getCaretPosition());
                    Rectangle2D rect = AutoCompleteBehaviour.this.editor.modelToView2D(p.caretPosition);
                    System.out.println("rect: " + String.valueOf(rect));
                    AutoCompleteBehaviour.this.showPopup(rect, e.getWhen(), p.userInput, p.caretPosition);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }
    };
    private DocumentListener documentListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (AutoCompleteBehaviour.this.autoCompleteActive) {
                AutoCompleteBehaviour.this.buffer.remove(e.getLength(), e.getOffset());
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (AutoCompleteBehaviour.this.autoCompleteActive) {
                int len = e.getLength();
                int offset = e.getOffset();
                String text = AutoCompleteBehaviour.this.editor.getText().substring(offset, offset + len);
                AutoCompleteBehaviour.this.buffer.insert(text, offset);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    };

    public boolean isShowAlways() {
        return this.showAlways;
    }

    public void setShowAlways(boolean showAlways) {
        this.showAlways = showAlways;
    }

    public AutoCompleteBehaviour() {
        this.list.setModel(this.listModel);
    }

    protected void showPopup(Rectangle2D rect, long activationTimestamp, String initialContent, int autoCompleteStartCaretPosition) {
        if (!this.autoCompleteActive) {
            this.buffer.setInitialContent(initialContent, autoCompleteStartCaretPosition);
            List<T> choices = this.createProposals();
            if (choices.isEmpty()) {
                return;
            }
            this.autoCompleteActive = true;
            this.activationTimestamp = activationTimestamp;
            Window parentContainer = (Window)this.editor.getTopLevelAncestor();
            if (parentContainer == null) {
                throw new IllegalStateException("Editor has not been added to a container ?");
            }
            this.popup = this.createPopupWindow(parentContainer);
            if (this.listCellRenderer != null) {
                this.list.setCellRenderer(this.listCellRenderer);
            }
            this.list.setVisibleRowCount(this.visibleRowCount);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int idx;
                    if (e.getClickCount() == 2 && e.getButton() == 1 && (idx = AutoCompleteBehaviour.this.list.locationToIndex(e.getPoint())) >= 0 && idx < AutoCompleteBehaviour.this.listModel.getSize()) {
                        AutoCompleteBehaviour.this.hidePopup(AutoCompleteBehaviour.this.listModel.data.get(idx));
                    }
                }
            });
            this.scrollPane = new JScrollPane(this.list);
            this.popup.add(this.scrollPane);
            Point loc = this.editor.getLocationOnScreen();
            loc.x = (int)((double)loc.x + rect.getX());
            loc.y = (int)((double)loc.y + (rect.getY() + (double)this.editor.getFontMetrics(this.editor.getFont()).getHeight()));
            this.popup.setLocation(loc);
            this.popup.pack();
            this.popup.setVisible(true);
            this.setProposals(choices);
        }
    }

    protected Window createPopupWindow(Window parentContainer) {
        Window popup = new Window(parentContainer);
        popup.setFocusable(false);
        popup.setAutoRequestFocus(false);
        popup.setSize(this.initialPopupSize);
        return popup;
    }

    protected void hidePopup(T selection) {
        if (this.autoCompleteActive) {
            String userChoice;
            this.autoCompleteActive = false;
            this.popup.setVisible(false);
            this.popup.dispose();
            if (selection != null && (userChoice = this.callback.getStringToInsert(selection)) != null && userChoice.length() > 0) {
                Document doc = this.editor.getDocument();
                try {
                    doc.remove(this.buffer.autoCompleteCaretStartPosition, this.buffer.length());
                    doc.insertString(this.buffer.autoCompleteCaretStartPosition, userChoice, null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void attachTo(JTextComponent editor) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called from the EDT");
        }
        if (this.isAttached()) {
            throw new IllegalStateException("Already attached to " + String.valueOf(this.editor));
        }
        this.editor = editor;
        if (editor.getParent() instanceof JViewport) {
            ((JViewport)editor.getParent()).addChangeListener(this.viewportListener);
        }
        FocusManager focusManager = FocusManager.getCurrentManager();
        focusManager.addPropertyChangeListener(this.focusListener);
        editor.getDocument().addDocumentListener(this.documentListener);
        editor.addKeyListener(this.keyListener);
        editor.addCaretListener(this.caretListener);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyInterceptor);
    }

    public void detach() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called from the EDT");
        }
        if (this.isAttached()) {
            this.hidePopup(null);
            if (this.editor.getParent() instanceof JViewport) {
                ((JViewport)this.editor.getParent()).removeChangeListener(this.viewportListener);
            }
            this.editor.getDocument().removeDocumentListener(this.documentListener);
            this.editor.removeKeyListener(this.keyListener);
            this.editor.removeCaretListener(this.caretListener);
            FocusManager focusManager = FocusManager.getCurrentManager();
            focusManager.removePropertyChangeListener(this.focusListener);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyInterceptor);
            this.editor = null;
        }
    }

    public boolean isAttached() {
        return this.editor != null;
    }

    public void setCallback(IAutoCompleteCallback<T> callback) {
        this.callback = callback;
    }

    protected void updateProposals() {
        this.setProposals(this.createProposals());
    }

    protected List<T> createProposals() {
        return this.callback.getProposals(this.buffer.getValue());
    }

    protected void setProposals(List<T> choicesArray) {
        this.listModel.setData(choicesArray);
        if (!choicesArray.isEmpty()) {
            this.list.setSelectedIndex(0);
        }
    }

    public void setVisibleRowCount(int elementsToShow) {
        if (elementsToShow < 1) {
            throw new IllegalArgumentException("elementsToShow needs to be >= 1");
        }
        this.visibleRowCount = elementsToShow;
    }

    protected void setSelectedIndex(int selectedIndex) {
        if (selectedIndex >= 0 && selectedIndex < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        } else if (selectedIndex < 0) {
            this.list.setSelectedIndex(0);
            this.list.ensureIndexIsVisible(0);
        } else if (selectedIndex >= this.list.getModel().getSize()) {
            this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
            this.list.ensureIndexIsVisible(this.list.getModel().getSize() - 1);
        }
    }

    public void setInitialPopupSize(Dimension initialPopupSize) {
        if (initialPopupSize == null) {
            throw new IllegalArgumentException("Popup size cannot be NULL");
        }
        this.initialPopupSize = new Dimension(initialPopupSize);
    }

    public void setListCellRenderer(ListCellRenderer<? super T> listRenderer) {
        this.listCellRenderer = listRenderer;
    }

    protected T getCurrentSelection() {
        int idx = this.list.getSelectedIndex();
        T selectedValue = idx >= this.listModel.getSize() ? null : (T)this.list.getSelectedValue();
        return selectedValue;
    }

    protected static boolean isKeyPress(KeyEvent e) {
        return e.getID() == 401;
    }

    protected static boolean isKeyRelease(KeyEvent e) {
        return e.getID() == 402;
    }

    protected static boolean isKeyTyped(KeyEvent e) {
        return e.getID() == 400;
    }

    protected static boolean isCtrlDown(KeyEvent e) {
        return (e.getModifiersEx() & 0x80) != 0;
    }

    protected long timeSinceActivationMillis(KeyEvent e) {
        return e.getWhen() - this.activationTimestamp;
    }

    private static boolean isChildOf(Component parent, Component potentialChild) {
        Component current;
        for (current = potentialChild; current != null && current != parent; current = current.getParent()) {
        }
        return current == parent;
    }

    private final class AutoCompleteBuffer {
        private final StringBuilder buffer = new StringBuilder();
        private int autoCompleteCaretStartPosition;

        private AutoCompleteBuffer() {
        }

        public void setInitialContent(String initialInput, int autoCompleteCaretStartPosition) {
            this.autoCompleteCaretStartPosition = autoCompleteCaretStartPosition;
            this.buffer.setLength(0);
            this.buffer.insert(this.localOffset(autoCompleteCaretStartPosition), initialInput);
        }

        private int localOffset(int input) {
            return input - this.autoCompleteCaretStartPosition;
        }

        public void insert(String s, int editorCaretPosition) {
            if (this.isValidOffset(editorCaretPosition)) {
                this.buffer.insert(this.localOffset(editorCaretPosition), s);
                AutoCompleteBehaviour.this.updateProposals();
            } else {
                AutoCompleteBehaviour.this.hidePopup(null);
            }
        }

        public boolean isValidOffset(int offset) {
            return offset >= this.autoCompleteCaretStartPosition && offset <= this.autoCompleteCaretStartPosition + this.buffer.length();
        }

        public void remove(int len, int offset) {
            if (this.isValidOffset(offset)) {
                int start = this.localOffset(offset);
                int end = start + len;
                this.buffer.delete(start, end);
                AutoCompleteBehaviour.this.updateProposals();
            } else {
                AutoCompleteBehaviour.this.hidePopup(null);
            }
        }

        public int length() {
            return this.buffer.length();
        }

        public String getValue() {
            return this.buffer.toString();
        }
    }

    private final class MyKeyDispatcher
    implements KeyEventDispatcher {
        private MyKeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (!AutoCompleteBehaviour.this.autoCompleteActive) {
                return false;
            }
            boolean eventHandled = false;
            if (AutoCompleteBehaviour.isKeyTyped(e)) {
                switch (e.getKeyChar()) {
                    case '\n': 
                    case '\u0010': 
                    case '\u001b': 
                    case ' ': {
                        e.consume();
                        eventHandled = true;
                        break;
                    }
                }
            } else if (AutoCompleteBehaviour.isKeyPress(e)) {
                switch (e.getKeyCode()) {
                    case 9: 
                    case 10: 
                    case 27: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 38: 
                    case 40: {
                        e.consume();
                        eventHandled = true;
                        break;
                    }
                }
            } else if (AutoCompleteBehaviour.isKeyRelease(e)) {
                int selectedIndex = AutoCompleteBehaviour.this.list.getSelectedIndex();
                if (e.getKeyCode() == 27) {
                    e.consume();
                    eventHandled = true;
                    AutoCompleteBehaviour.this.hidePopup(null);
                } else if (e.getKeyCode() == 40) {
                    e.consume();
                    eventHandled = true;
                    AutoCompleteBehaviour.this.setSelectedIndex(selectedIndex + 1);
                } else if (e.getKeyCode() == 38) {
                    e.consume();
                    eventHandled = true;
                    AutoCompleteBehaviour.this.setSelectedIndex(selectedIndex - 1);
                } else if (e.getKeyCode() == 34) {
                    e.consume();
                    eventHandled = true;
                    AutoCompleteBehaviour.this.setSelectedIndex(selectedIndex + 25);
                } else if (e.getKeyCode() == 33) {
                    e.consume();
                    eventHandled = true;
                    AutoCompleteBehaviour.this.setSelectedIndex(selectedIndex - 25);
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 9) {
                    boolean spaceTrigger;
                    e.consume();
                    eventHandled = true;
                    boolean isSpace = e.getKeyCode() == 32;
                    boolean ctrlDown = AutoCompleteBehaviour.isCtrlDown(e);
                    long timeSinceActivationMillis = AutoCompleteBehaviour.this.timeSinceActivationMillis(e);
                    boolean bl = spaceTrigger = !ctrlDown && isSpace && timeSinceActivationMillis > 200L;
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 9 || spaceTrigger) {
                        int idx = AutoCompleteBehaviour.this.list.getSelectedIndex();
                        Object selectedValue = idx >= AutoCompleteBehaviour.this.listModel.getSize() ? null : (Object)AutoCompleteBehaviour.this.list.getSelectedValue();
                        AutoCompleteBehaviour.this.hidePopup(selectedValue);
                    }
                }
            }
            return eventHandled;
        }
    }

    protected final class MyListModel
    extends AbstractListModel<T> {
        private final List<T> data = new ArrayList();

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public void setData(List<T> newData) {
            this.data.clear();
            this.data.addAll(newData);
            this.fireContentsChanged(this, 0, this.data.size());
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public T getElementAt(int index) {
            return this.data.get(index);
        }
    }

    public static interface IAutoCompleteCallback<X> {
        public List<X> getProposals(String var1);

        public String getStringToInsert(X var1);

        public InitialUserInput getInitialUserInput(JTextComponent var1, int var2);
    }

    public static final class InitialUserInput {
        public final int caretPosition;
        public final String userInput;

        public InitialUserInput(int caretPosition, String userInput) {
            this.caretPosition = caretPosition;
            this.userInput = userInput;
        }
    }

    public static abstract class DefaultAutoCompleteCallback<T>
    implements IAutoCompleteCallback<T> {
        @Override
        public InitialUserInput getInitialUserInput(JTextComponent editor, int caretPosition) {
            String text = editor.getText();
            StringBuilder buffer = new StringBuilder();
            int start = caretPosition;
            while (start - 1 >= 0 && !this.isSeparatorChar(text.charAt(start - 1))) {
                buffer.insert(0, text.charAt(start - 1));
                --start;
            }
            for (int end = editor.getCaretPosition(); end < text.length() && !this.isSeparatorChar(text.charAt(end)); ++end) {
                buffer.append(text.charAt(end));
            }
            return new InitialUserInput(start, buffer.toString());
        }

        protected boolean isSeparatorChar(char c) {
            return Character.isWhitespace(c);
        }
    }
}

