/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.special;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.MovieChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.studio.StudioChildFactory;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.MovieTypeComboRenderer;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class MovieTypeChildFactory
extends ChildFactory<INode> {
    public static final Logger LOG = Logger.getLogger(MovieTypeChildFactory.class.getName());
    private List<MovieType> movieTypeList;
    private DB db = DB.getInstance();
    private boolean showCounter = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showSecret = false;
    private boolean showRating = false;
    private boolean showPosition = false;
    private boolean prefixMetadata;

    public MovieTypeChildFactory(boolean showCounter, boolean showLikeCounter, boolean showRuntime, boolean showSecret, boolean showRating, boolean showPosition, boolean prefixMetadata) {
        this.movieTypeList = new ArrayList<MovieType>(Arrays.asList(MovieType.values()));
        this.movieTypeList.sort((one, other) -> one.getTitle().compareTo(other.getTitle()));
        this.showCounter = showCounter;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showSecret = showSecret;
        this.showRating = showRating;
        this.showPosition = showPosition;
        this.prefixMetadata = prefixMetadata;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in MovieTypeChildFactory");
    }

    protected boolean createKeys(List<INode> list) {
        for (MovieType mt : this.movieTypeList) {
            list.add((INode)mt);
        }
        return true;
    }

    protected Node createNodeForKey(INode movieType) {
        LOG.fine("create new node for movietype: " + movieType.toString());
        Object result = null;
        if (movieType instanceof MovieType) {
            final MovieType mt = (MovieType)movieType;
            List moviesList = this.db.getMovies(mt, this.showSecret);
            ArrayList<INode> tmpList = new ArrayList<INode>();
            tmpList.addAll(moviesList);
            LOG.fine("found " + tmpList.size() + " movies");
            List studios = this.db.getStudios(mt);
            if (!studios.isEmpty()) {
                tmpList.addAll(studios);
                LOG.info("Added " + studios.size() + " studios for movie type " + mt.getTitle());
            } else {
                LOG.info("No studio for movie type " + mt.getTitle());
            }
            LOG.fine("found " + tmpList.size() + " with studios");
            result = new AbstractNode(Children.create((ChildFactory)new MovieChildFactory(tmpList, this.showCounter, this.showLikeCounter, this.showRuntime, this.showRating, this.showPosition, true, false, this.prefixMetadata), (boolean)true)){

                public Image getOpenedIcon(int type) {
                    return ImageUtilities.loadImage((String)MovieTypeComboRenderer.getIconImagePath(mt));
                }

                public Image getIcon(int type) {
                    return this.getOpenedIcon(type);
                }

                public Action[] getActions(boolean context) {
                    return new Action[]{new CreatePlaylistAction()};
                }

                class CreatePlaylistAction
                extends AbstractAction {
                    public CreatePlaylistAction() {
                        this.putValue("Name", "Create Playlist");
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PlaylistService ps = new PlaylistService();
                        Playlist playlist = new Playlist();
                        playlist.setName(mt.getTitle());
                        int dvds = 0;
                        for (Movie movie : MovieTypeChildFactory.this.db.getMovies(mt, Scenerixx.unlocked)) {
                            for (Scene s : movie.getScenes()) {
                                if (MovieTypeChildFactory.this.db.getDvd(s.getMovie(), Scenerixx.unlocked) == null) {
                                    PlaylistEntry pe = new PlaylistEntry();
                                    pe.setDateOfCreation(LocalDateTime.now());
                                    pe.setScene(s);
                                    ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                                    continue;
                                }
                                ++dvds;
                            }
                        }
                        AbstractTopComponent.reloadPlaylist();
                        String message = "Created new playlist '" + playlist.getName() + "'";
                        if (dvds > 0) {
                            message = message + " (" + dvds + " DVDs have not been added)";
                        }
                        AbstractTopComponent.notifyInfo(message);
                    }
                }
            };
            int studiosSize = studios.size();
            String app = studiosSize > 0 ? " [" + this.db.countMovies(mt, this.showSecret) + " + " + studiosSize + " studios]" : " [" + this.db.countMovies(mt, this.showSecret) + "]";
            if (this.showRuntime) {
                List movies = this.db.getMovies(mt, this.showSecret);
                Long runtime = 0L;
                for (Movie m : movies) {
                    if (m.getTotalRuntime() <= 0) continue;
                    runtime = runtime + (long)m.getTotalRuntime();
                }
                Object sRuntime = "";
                if (runtime / 86400L > 0L) {
                    sRuntime = String.format("%02d", runtime / 86400L) + "d:";
                }
                sRuntime = (String)sRuntime + String.format("%02d", runtime / 3600L % 24L) + ":" + String.format("%02d", runtime / 60L % 60L) + ":" + String.format("%02d", runtime % 60L);
                app = app + " [" + (String)sRuntime + "]";
            }
            result.setDisplayName(mt.getTitle() + app);
            result.setValue("movieType", (Object)mt);
            result.setName(mt.getTitle());
        } else if (movieType instanceof Studio) {
            Studio studio = (Studio)movieType;
            StudioChildFactory scf = new StudioChildFactory(new ArrayList<INode>());
            result = scf.createNode((INode)studio);
        }
        return result;
    }
}

