/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.person.action;

import java.awt.Image;
import java.io.File;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class ExportPersonAction
extends NodeAction
implements Presenter.Popup {
    public ExportPersonAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/text_exports.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            if (n.getValue("person") == null || !(n.getValue("person") instanceof Person)) continue;
            Person tmpPerson = (Person)n.getValue("person");
            Exporter exp = new Exporter();
            boolean overwriteOption = false;
            String destinationFileName = exp.getDestinationFileName(tmpPerson, Scenerixx.getPathToPersonExport(tmpPerson));
            if (new File(destinationFileName).exists()) {
                int overwrite = JOptionPane.showConfirmDialog(null, "A file with the name '" + destinationFileName + "' already exists. Do you want to overwrite it?\n'Yes' overwrites the file, 'No' uses a new filename, 'Cancel' aborts", "File exists already", 1, 2);
                if (overwrite == 0) {
                    overwriteOption = true;
                } else if (overwrite == 1) {
                    overwriteOption = false;
                } else if (overwrite == 2) {
                    AbstractTopComponent.notifyInfo("Aborted export. Existing file was not changed.");
                    return;
                }
            }
            try {
                String exportFile = exp.exportPersonToFile(tmpPerson, Scenerixx.getPathToPersonExport(tmpPerson), overwriteOption);
                AbstractTopComponent.notifyInfo(tmpPerson.getName() + " exported to " + exportFile);
            }
            catch (TransformerException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("Could not export person to public file. An error occured: " + ex.getMessage());
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Export Person to public file";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

