/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.panel.MovieTypeSelectionPanel;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;

public class RemoveMovieTypeAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(RemoveMovieTypeAction.class.getName());
    private final DB db = DB.getInstance();
    private final ScenerixxCommon common = new ScenerixxCommon();
    private Movie m = null;

    public RemoveMovieTypeAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/tag_blue_delete.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        final MovieTypeSelectionPanel panel = new MovieTypeSelectionPanel();
        JOptionPane op = new JOptionPane(panel, 3, 2){

            @Override
            public void selectInitialValue() {
                panel.getComboMovieType1();
            }
        };
        int selectedMovies = 0;
        for (Node n : activatedNodes) {
            if ((n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) && (n.getValue("scene") == null || !(n.getValue("scene") instanceof Scene))) continue;
            ++selectedMovies;
        }
        JDialog dlg = op.createDialog("Remove movie type(s) for " + ScenerixxCommon.singularPlural(selectedMovies, "movie", "movies", true));
        dlg.setVisible(true);
        dlg.addWindowFocusListener(new WindowAdapter(this){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                panel.gainedFocus();
            }
        });
        if (op.getValue() != null && op.getValue().equals(0)) {
            Movie firstMovie = null;
            for (Node n : activatedNodes) {
                int cnt = 0;
                if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
                this.m = (Movie)n.getValue("movie");
                if (firstMovie == null) {
                    firstMovie = this.m;
                }
                ArrayList<MovieType> tmpList = new ArrayList<MovieType>();
                if (panel.getComboMovieType1().getSelectedItem() != null) {
                    tmpList.add((MovieType)panel.getComboMovieType1().getSelectedItem());
                }
                if (panel.getComboMovieType2().getSelectedItem() != null) {
                    tmpList.add((MovieType)panel.getComboMovieType2().getSelectedItem());
                }
                if (panel.getComboMovieType3().getSelectedItem() != null) {
                    tmpList.add((MovieType)panel.getComboMovieType3().getSelectedItem());
                }
                if (panel.getComboMovieType4().getSelectedItem() != null) {
                    tmpList.add((MovieType)panel.getComboMovieType4().getSelectedItem());
                }
                if (panel.getComboMovieType5().getSelectedItem() != null) {
                    tmpList.add((MovieType)panel.getComboMovieType5().getSelectedItem());
                }
                if (panel.getComboMovieType6().getSelectedItem() != null) {
                    tmpList.add((MovieType)panel.getComboMovieType6().getSelectedItem());
                }
                for (MovieType mt : tmpList) {
                    if (mt.equals((Object)this.m.getType())) {
                        this.m.setType(null);
                        ++cnt;
                        continue;
                    }
                    if (mt.equals((Object)this.m.getType2())) {
                        this.m.setType2(null);
                        ++cnt;
                        continue;
                    }
                    if (mt.equals((Object)this.m.getType3())) {
                        this.m.setType3(null);
                        ++cnt;
                        continue;
                    }
                    if (mt.equals((Object)this.m.getType4())) {
                        this.m.setType4(null);
                        ++cnt;
                        continue;
                    }
                    if (mt.equals((Object)this.m.getType5())) {
                        this.m.setType5(null);
                        ++cnt;
                        continue;
                    }
                    if (mt.equals((Object)this.m.getType6())) {
                        this.m.setType6(null);
                        ++cnt;
                        continue;
                    }
                    if (!this.m.getMovietypes().contains(mt)) continue;
                    this.m.getMovietypes().remove(mt);
                    ++cnt;
                }
                for (int i = 1; i <= 6; ++i) {
                    if ((MovieType.UNDEFINED.equals((Object)this.m.getType()) || this.m.getType() == null) && !MovieType.UNDEFINED.equals((Object)this.m.getType2())) {
                        this.m.setType(this.m.getType2());
                        this.m.setType2(null);
                    }
                    if ((MovieType.UNDEFINED.equals((Object)this.m.getType2()) || this.m.getType2() == null) && !MovieType.UNDEFINED.equals((Object)this.m.getType3())) {
                        this.m.setType2(this.m.getType3());
                        this.m.setType3(null);
                    }
                    if ((MovieType.UNDEFINED.equals((Object)this.m.getType3()) || this.m.getType3() == null) && !MovieType.UNDEFINED.equals((Object)this.m.getType4())) {
                        this.m.setType3(this.m.getType4());
                        this.m.setType4(null);
                    }
                    if ((MovieType.UNDEFINED.equals((Object)this.m.getType4()) || this.m.getType4() == null) && !MovieType.UNDEFINED.equals((Object)this.m.getType5())) {
                        this.m.setType4(this.m.getType5());
                        this.m.setType5(null);
                    }
                    if (!MovieType.UNDEFINED.equals((Object)this.m.getType5()) && this.m.getType5() != null || MovieType.UNDEFINED.equals((Object)this.m.getType6())) continue;
                    this.m.setType5(this.m.getType6());
                    this.m.setType6(null);
                }
                for (MovieType mt : tmpList) {
                    for (Scene s : this.m.getScenes()) {
                        if (mt.equals((Object)s.getType())) {
                            s.setType(null);
                            ++cnt;
                            continue;
                        }
                        if (mt.equals((Object)s.getType2())) {
                            s.setType2(null);
                            ++cnt;
                            continue;
                        }
                        if (mt.equals((Object)s.getType3())) {
                            s.setType3(null);
                            ++cnt;
                            continue;
                        }
                        if (mt.equals((Object)s.getType4())) {
                            s.setType4(null);
                            ++cnt;
                            continue;
                        }
                        if (mt.equals((Object)s.getType5())) {
                            s.setType5(null);
                            ++cnt;
                            continue;
                        }
                        if (mt.equals((Object)s.getType6())) {
                            s.setType6(null);
                            ++cnt;
                            continue;
                        }
                        if (!this.m.getMovietypes().contains(mt)) continue;
                        this.m.getMovietypes().remove(mt);
                        ++cnt;
                    }
                }
                for (Scene currentScene : this.m.getScenes()) {
                    for (int i = 1; i <= 6; ++i) {
                        if ((MovieType.UNDEFINED.equals((Object)currentScene.getType()) || currentScene.getType() == null) && !MovieType.UNDEFINED.equals((Object)currentScene.getType2())) {
                            currentScene.setType(currentScene.getType2());
                            currentScene.setType2(null);
                        }
                        if ((MovieType.UNDEFINED.equals((Object)currentScene.getType2()) || currentScene.getType2() == null) && !MovieType.UNDEFINED.equals((Object)currentScene.getType3())) {
                            currentScene.setType2(currentScene.getType3());
                            currentScene.setType3(null);
                        }
                        if ((MovieType.UNDEFINED.equals((Object)currentScene.getType3()) || currentScene.getType3() == null) && !MovieType.UNDEFINED.equals((Object)currentScene.getType4())) {
                            currentScene.setType3(currentScene.getType4());
                            currentScene.setType4(null);
                        }
                        if ((MovieType.UNDEFINED.equals((Object)currentScene.getType4()) || currentScene.getType4() == null) && !MovieType.UNDEFINED.equals((Object)currentScene.getType5())) {
                            currentScene.setType4(currentScene.getType5());
                            currentScene.setType5(null);
                        }
                        if (!MovieType.UNDEFINED.equals((Object)currentScene.getType5()) && currentScene.getType5() != null || MovieType.UNDEFINED.equals((Object)currentScene.getType6())) continue;
                        currentScene.setType5(currentScene.getType6());
                        currentScene.setType6(null);
                    }
                }
                this.m = (Movie)this.db.getEntityService().save((AbstractEntity)this.m);
            }
            AbstractTopComponent.notifyInfo("We have removed the specified movie types for " + activatedNodes.length + " movies.");
            Movie tmpFirstMovie = firstMovie;
            SwingUtilities.invokeLater(() -> {
                TopComponent detailTopComponent = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                if (detailTopComponent != null && tmpFirstMovie != null) {
                    LOG.info("Reload movie details " + tmpFirstMovie.getNameOfPlayable());
                    ((DetailsTopComponent)detailTopComponent).resetForm();
                    ((DetailsTopComponent)detailTopComponent).loadMovie(tmpFirstMovie);
                }
            });
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        LOG.finer("Check if RemoveMovieTypeAction is enabled");
        boolean enable = false;
        for (Node n : activatedNodes) {
            if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) {
                enable = false;
                break;
            }
            LOG.finer("it's a movie");
            enable = true;
        }
        return enable;
    }

    public String getName() {
        return "Remove Movie Type(s)";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

