/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.StringUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.medium.QDvd;
import xxx.scenerixx.scenerixxlib.model.medium.QMediumFile;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.actions.ShowPicturesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.actions.ResetCounterAction;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.MediumFileChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddBookmarkAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddMovieTypeAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddPersonsAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddSceneAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddSeveralScenesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToDefaultPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.CompareMoviesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.ConfirmWizardDataAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.CopyScreencapsAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.DeleteMovieFromDiscAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.DeletePlayableFromDatabaseAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.DeleteScreencapAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.ExportMovieToPublicFileAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.MarkAsFavoriteAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.MarkAsNoDuplicateAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.OpenDirectoryAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.OpenMovieAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.OpenMovieInternalPlayerAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.OpenMoviesOwnInstanceAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.PrefixTitleAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.RecreateScreencapAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.RemoveAllPersonsAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.RemoveMovieTypeAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.SetOffsetStarttimeAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.SetSecretAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.SetStudioAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.SwapMediumFilesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.UnsetSecretAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.CallableSceneChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.studio.StudioChildFactory;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class MovieChildFactory
extends ChildFactory.Detachable<INode>
implements LookupListener {
    public static final Logger LOG = Logger.getLogger(MovieChildFactory.class.getName());
    private final List<String> filePaths = new ArrayList<String>();
    private final List<INode> resultList;
    private final DB db = DB.getInstance();
    private boolean showCounter = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showRating = false;
    private boolean showPosition = false;
    private boolean showYear = false;
    private boolean showResolution = false;
    private boolean prefixMetadata = false;
    private String searchTerms = "";
    private boolean useDifferentColorCensored = false;
    private DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private Lookup.Result<Movie> results;

    public MovieChildFactory(List<INode> resultList, boolean showCounter, boolean showLikeCounter, boolean showRuntime, boolean showRating, boolean showPosition, boolean showYear, boolean showResolution, boolean prefixMetadata) {
        this.resultList = resultList;
        this.showCounter = showCounter;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showRating = showRating;
        this.showPosition = showPosition;
        this.showYear = showYear;
        this.showResolution = showResolution;
        this.prefixMetadata = prefixMetadata;
        this.useDifferentColorCensored = this.db.getScenerixxSettings().isUseDifferentColorCensored();
        LOG.finer("Prefix metadata: " + prefixMetadata);
        if (showPosition) {
            int i = 1;
            for (INode n : resultList) {
                if (!(n instanceof AbstractEntity)) continue;
                AbstractEntity entity = (AbstractEntity)n;
                entity.setPositionInList(i++);
            }
        }
    }

    public List<INode> getResultList() {
        return this.resultList;
    }

    public boolean isShowCounter() {
        return this.showCounter;
    }

    public void setShowCounter(boolean showCounter) {
        this.showCounter = showCounter;
    }

    public boolean isShowLikeCounter() {
        return this.showLikeCounter;
    }

    public void setShowLikeCounter(boolean showLikeCounter) {
        this.showLikeCounter = showLikeCounter;
    }

    public boolean isShowRuntime() {
        return this.showRuntime;
    }

    public void setShowRuntime(boolean showRuntime) {
        this.showRuntime = showRuntime;
    }

    public boolean isShowRating() {
        return this.showRating;
    }

    public void setShowRating(boolean showRating) {
        this.showRating = showRating;
    }

    public boolean isShowPosition() {
        return this.showPosition;
    }

    public void setShowPosition(boolean showPosition) {
        this.showPosition = showPosition;
    }

    public boolean isShowYear() {
        return this.showYear;
    }

    public void setShowYear(boolean showYear) {
        this.showYear = showYear;
    }

    public boolean isShowResolution() {
        return this.showResolution;
    }

    public void setShowResolution(boolean showResolution) {
        this.showResolution = showResolution;
    }

    public boolean isPrefixMetadata() {
        return this.prefixMetadata;
    }

    public void setPrefixMetadata(boolean prefixMetadata) {
        this.prefixMetadata = prefixMetadata;
    }

    public String getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(String searchTerms) {
        this.searchTerms = searchTerms;
    }

    public void refresh() {
        LOG.info("Refresh (manually)");
        this.refresh(true);
    }

    protected void addNotify() {
        super.addNotify();
        LOG.fine("MovieChildFactory ADD NOTIFY");
        this.results = Utilities.actionsGlobalContext().lookupResult(Movie.class);
        this.results.addLookupListener((LookupListener)this);
    }

    protected void removeNotify() {
        super.removeNotify();
        LOG.info("MovieChildFactory REMOVE NOTIFY " + this.results.allItems().size());
        this.results.removeLookupListener((LookupListener)this);
        this.results = null;
    }

    public void resultChanged(LookupEvent le) {
        int selectedMovies = this.results.allInstances().size();
        LOG.info("Refresh (resultChanged) - selected movies: " + selectedMovies);
        if (selectedMovies == 1) {
            EventQueue.invokeLater(() -> {
                MovieListTopComponent movieList = (MovieListTopComponent)WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                if (movieList != null) {
                    LOG.info("result changed");
                    Movie selectedMovie = movieList.getSelectedMovie();
                    if (selectedMovie != null) {
                        LOG.info("it's a movie ... show pictures for " + selectedMovie.getTitle());
                        ArrayList<Person> persons = new ArrayList<Person>();
                        for (Scene scene : selectedMovie.getScenes()) {
                            persons.addAll(scene.getPersons(Scenerixx.unlocked));
                        }
                        LOG.info("passing " + persons.size() + " to showPersonPictures");
                        ShowPicturesAction.getInstance().showPersonPictures(persons);
                    }
                }
            });
        }
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in MovieChildFactory: " + String.valueOf(node));
    }

    public void reloadList(Node node, boolean reloadFromDb) {
        LOG.finest("Hook method reloadList in MovieChildFactory: " + String.valueOf(node));
    }

    protected boolean createKeys(List<INode> list) {
        Movie mov;
        LOG.info("CreateKeys: " + list.size());
        for (INode m : this.resultList) {
            if (m instanceof Movie && "[New Movie]".equalsIgnoreCase((mov = (Movie)m).getTitle())) {
                list.add(0, m);
                continue;
            }
            list.add(m);
        }
        for (int j = list.size() - 1; j >= 0; --j) {
            INode m;
            m = list.get(j);
            if (m instanceof Movie) {
                mov = (Movie)m;
                mov.setPositionInList(j + 1);
            }
            if (!(m instanceof Studio)) continue;
            Studio studio = (Studio)m;
            studio.setPositionInList(j + 1);
        }
        LOG.info("Copying " + list.size() + " nodes (from " + this.resultList.size() + ")");
        this.resultList.clear();
        this.resultList.addAll(list);
        return true;
    }

    protected Node createNodeForKey(final INode m) {
        Object result = null;
        if (m instanceof Movie) {
            final Movie mov = (Movie)m;
            result = new AbstractNode(Children.createLazy((Callable)new CallableSceneChildFactory(mov, this.showCounter, this.showLikeCounter, this.showRuntime, this.showRating, this.showPosition, this.getSearchTerms())), Lookups.singleton((Object)m)){

                public String getHtmlDisplayName() {
                    return this.getDisplayName();
                }

                public Action getPreferredAction() {
                    return super.getPreferredAction();
                }

                public Image getIcon(String iconPath) {
                    LOG.finer("getIcon : " + iconPath);
                    if (Scenerixx.showExpensiveMovieIcons) {
                        boolean allSet;
                        if (ScenerixxCommon.movieIdsOnDefaultPlaylist.contains(mov.getId())) {
                            LOG.finer("showExpensive && default playlist " + mov.getNameOfPlayable());
                            Image defaultPlaylistMergeImages = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"icons/notes.png"), (Image)ImageUtilities.loadImage((String)"icons/favourites.png"), (int)3, (int)2);
                            if (!mov.getScenes().isEmpty()) {
                                Image img = null;
                                if (!this.arePersonsAssociated()) {
                                    img = ImageUtilities.mergeImages((Image)defaultPlaylistMergeImages, (Image)ImageUtilities.loadImage((String)"icons.fugue/user-silhouette-question.png"), (int)1, (int)4);
                                    img = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)iconPath), (Image)img, (int)5, (int)5);
                                } else {
                                    img = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)iconPath), (Image)defaultPlaylistMergeImages, (int)7, (int)7);
                                }
                                img = this.applyRatingIcons(img);
                                img = this.applyWizardIcon(img);
                                return img;
                            }
                        } else if (ScenerixxCommon.movieIdsOnAnyPlaylist.contains(mov.getId())) {
                            LOG.finer("showExpensive && other playlist " + ((Movie)m).getNameOfPlayable());
                            if (!mov.getScenes().isEmpty()) {
                                Image img = null;
                                if (!this.arePersonsAssociated()) {
                                    Image mergeImages = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)iconPath), (Image)ImageUtilities.loadImage((String)"icons/notes.png"), (int)7, (int)7);
                                    img = ImageUtilities.mergeImages((Image)mergeImages, (Image)ImageUtilities.loadImage((String)"icons.fugue/user-silhouette-question.png"), (int)4, (int)4);
                                } else {
                                    img = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)iconPath), (Image)ImageUtilities.loadImage((String)"icons/notes.png"), (int)7, (int)7);
                                }
                                img = this.applyRatingIcons(img);
                                img = this.applyWizardIcon(img);
                                return img;
                            }
                        } else if (!mov.getScenes().isEmpty() && !(allSet = this.arePersonsAssociated())) {
                            Image img = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)iconPath), (Image)ImageUtilities.loadImage((String)"icons.fugue/user-silhouette-question.png"), (int)4, (int)4);
                            img = this.applyWizardIcon(img);
                            img = this.applyRatingIcons(img);
                            return img;
                        }
                    }
                    Image img = ImageUtilities.loadImage((String)iconPath);
                    img = this.applyRatingIcons(img);
                    img = this.applyWizardIcon(img);
                    return img;
                }

                private Image applyWizardIcon(Image img) {
                    if (mov.isWizardGenerated()) {
                        img = ImageUtilities.mergeImages((Image)img, (Image)ImageUtilities.loadImage((String)"icons.fatcow/bullet_red.png"), (int)-2, (int)-2);
                    }
                    return img;
                }

                private boolean arePersonsAssociated() {
                    boolean allSet = true;
                    for (Scene s : mov.getScenes()) {
                        if (!s.getPersons(Scenerixx.unlocked).isEmpty() || s.isBehindTheScenes()) continue;
                        allSet = false;
                        break;
                    }
                    return allSet;
                }

                private Image applyRatingIcons(Image img) {
                    if (mov.getRating() != null && mov.getRating() == 11) {
                        img = ImageUtilities.mergeImages((Image)img, (Image)ImageUtilities.loadImage((String)"icons.fugue/fire-small.png"), (int)-1, (int)4);
                    }
                    if (mov.getRating() != null && mov.getRating() == 12) {
                        img = ImageUtilities.mergeImages((Image)img, (Image)ImageUtilities.loadImage((String)"icons.fugue/fire-big.png"), (int)-1, (int)4);
                    }
                    return img;
                }

                public Image getOpenedIcon(int type) {
                    if (mov.isFavorite()) {
                        return this.getIcon("icons/favourites.png");
                    }
                    if (mov.isSecret()) {
                        LOG.finest("Use lock-icon for movie " + mov.getTitle());
                        return this.getIcon("icons/Lock.png");
                    }
                    if (!(mov.getScenes().size() != 1 || mov.isSnippet() || mov.isVr() || mov.isThreeD() || mov.isInteractive())) {
                        if (MovieType.CUMPILATION.equals((Object)mov.getType()) || MovieType.CUMPILATION.equals((Object)mov.getType2()) || MovieType.CUMPILATION.equals((Object)mov.getType3()) || MovieType.CUMPILATION.equals((Object)mov.getType4()) || MovieType.CUMPILATION.equals((Object)mov.getType5()) || MovieType.CUMPILATION.equals((Object)mov.getType6()) || mov.getMovietypes().contains(MovieType.CUMPILATION)) {
                            return this.getIcon("icons2/sperm.png");
                        }
                        if (MovieType.PMV.equals((Object)mov.getType()) || MovieType.PMV.equals((Object)mov.getType2()) || MovieType.PMV.equals((Object)mov.getType3()) || MovieType.PMV.equals((Object)mov.getType4()) || MovieType.PMV.equals((Object)mov.getType5()) || MovieType.PMV.equals((Object)mov.getType6()) || mov.getMovietypes().contains(MovieType.PMV)) {
                            return this.getIcon("icons.led/music_beam.png");
                        }
                        if (MovieType.COMPILATION.equals((Object)mov.getType()) || MovieType.COMPILATION.equals((Object)mov.getType2()) || MovieType.COMPILATION.equals((Object)mov.getType3()) || MovieType.COMPILATION.equals((Object)mov.getType4()) || MovieType.COMPILATION.equals((Object)mov.getType5()) || MovieType.COMPILATION.equals((Object)mov.getType6()) || mov.getMovietypes().contains(MovieType.COMPILATION)) {
                            return this.getIcon("icons.silk/bricks.png");
                        }
                        if (mov.isRegrettablyAwesome()) {
                            LOG.finest("Use radiation-icon for movie " + mov.getTitle());
                            return this.getIcon("icons/Radiation.png");
                        }
                        if (Scenerixx.showExpensiveMovieIcons && ((Scene)mov.getScenes().get(0)).isSummary()) {
                            LOG.finest("Use component-icon for movie " + mov.getTitle());
                            return this.getIcon("icons/Component.png");
                        }
                        LOG.finest("Use eye-icon for single scene " + mov.getTitle());
                        return this.getIcon("icons/Eye.png");
                    }
                    if (mov.getTubeUrl() != null && !mov.getTubeUrl().isEmpty()) {
                        LOG.finest("Use email-icon for movie " + mov.getTitle());
                        return this.getIcon("icons.fatcow/online_video_insert.png");
                    }
                    if (mov.isSnippet()) {
                        LOG.finest("Use lightning-icon for movie " + mov.getTitle());
                        return this.getIcon("icons/Lightning.png");
                    }
                    if (mov.isThreeD()) {
                        LOG.finest("Use 3d-glasses-icon for movie " + mov.getTitle());
                        return this.getIcon("icons8/3d-glasses.png");
                    }
                    if (mov.isInteractive()) {
                        LOG.finest("Use interactive-icon for movie " + mov.getTitle());
                        return this.getIcon("icons8/game-controller.png");
                    }
                    if (mov.isVr()) {
                        LOG.finest("Use microsoft-hololens-icon for movie " + mov.getTitle());
                        return this.getIcon("icons8/microsoft-hololens.png");
                    }
                    if (Scenerixx.showExpensiveMovieIcons && !MovieChildFactory.this.db.getMediumFiles((Movie)m, Scenerixx.unlocked).isEmpty() && ((MediumFile)MovieChildFactory.this.db.getMediumFiles((Movie)m, Scenerixx.unlocked).get(0)).getFileExtension() != null && ((MediumFile)MovieChildFactory.this.db.getMediumFiles((Movie)m, Scenerixx.unlocked).get(0)).getFileExtension().toLowerCase().endsWith("iso")) {
                        LOG.finest("Use harddisk-icon for movie " + mov.getTitle());
                        return this.getIcon("icons/harddisk.png");
                    }
                    if (mov.getStartMedium() != null) {
                        LOG.finest("Start medium is set. Use file-icon for movie " + mov.getTitle());
                        return this.getIcon("icons/film.png");
                    }
                    if (Scenerixx.showExpensiveMovieIcons && MovieChildFactory.this.db.getEntityService().find((EntityPathBase)QDvd.dvd).filter(f -> f.movie.eq((Object)mov)).count() > 0L) {
                        LOG.finest("Use DVD-icon for movie " + mov.getTitle());
                        return this.getIcon("icons/cd.png");
                    }
                    if (MovieChildFactory.this.db.getEntityService().find((EntityPathBase)QMediumFile.mediumFile).filter(f -> f.movie.eq((Object)mov)).count() > 0L) {
                        LOG.finest("medium is assigned. Use file-icon for movie " + mov.getTitle());
                        return this.getIcon("icons/film.png");
                    }
                    LOG.finest("Use questionmark icon for " + mov.getTitle());
                    return this.getIcon("icons/question.png");
                }

                public Image getIcon(int type) {
                    return this.getOpenedIcon(type);
                }

                public PasteType createPasteType(final Transferable t, final int action, final AbstractNode nodeToSelectAfterReload) {
                    return new PasteType(){

                        private void addPersonToScene(Person p, Scene scene, boolean saveDirectly) {
                            if (!p.getName().contains("Unknown") && scene.getPersons(Scenerixx.unlocked).contains(p)) {
                                AbstractTopComponent.notifyWarning(p.getName() + " is already added to this scene");
                            } else {
                                SceneDetails sd = new SceneDetails();
                                sd.setDateOfCreation(LocalDateTime.now());
                                sd.setScene(scene);
                                sd.setPerson(p);
                                scene.getDetails().add(sd);
                                if (saveDirectly) {
                                    MovieChildFactory.this.db.getEntityService().save((AbstractEntity)scene);
                                }
                                LOG.fine("added " + p.getName() + " to movie " + scene.getMovie().getTitle() + " scene " + scene.getPosition());
                            }
                        }

                        public Transferable paste() throws IOException {
                            Node[] nodeArray;
                            Node node = NodeTransfer.node((Transferable)t, (int)action);
                            Node[] nodes = NodeTransfer.nodes((Transferable)t, (int)action);
                            ScenerixxCommon common = new ScenerixxCommon();
                            if (node != null && node.getValue("person") != null && (nodeArray = node.getValue("person")) instanceof Person) {
                                Person p = (Person)nodeArray;
                                Movie movie = (Movie)this.getLookup().lookup(Movie.class);
                                movie = (Movie)MovieChildFactory.this.db.getEntityService().load(Movie.class, movie.getId().longValue());
                                if (movie != null && movie.getScenes().size() == 1) {
                                    this.addPersonToScene(p, (Scene)movie.getScenes().get(0), true);
                                    DetailsTopComponent detailTC = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                                    if (detailTC != null) {
                                        detailTC.updateDisplayNameOfSelectedNode();
                                    }
                                } else {
                                    AbstractTopComponent.notifyError("Persons can only be dropped to movie nodes if exactly one scene is associated to it. ");
                                }
                            } else if (node instanceof MediumFileChildFactory.MediumFileBeanNode) {
                                common.addMediumFileToMovie((MediumFile)node.getValue("mediumFile"), mov);
                                MovieChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                            } else if (nodes != null && nodes.length > 0) {
                                if (nodes[0].getValue("mediumFile") != null && nodes[0].getValue("mediumFile") instanceof MediumFile) {
                                    for (Node n : nodes) {
                                        Object object;
                                        if (n.getValue("mediumFile") == null || !((object = n.getValue("mediumFile")) instanceof MediumFile)) continue;
                                        MediumFile mf = (MediumFile)object;
                                        common.addMediumFileToMovie(mf, mov);
                                    }
                                } else if (nodes[0].getValue("person") != null && nodes[0].getValue("person") instanceof Person) {
                                    if (mov.getScenes().size() == 1) {
                                        for (Node n : nodes) {
                                            Object object;
                                            if (n.getValue("person") == null || !((object = n.getValue("person")) instanceof Person)) continue;
                                            Person person = (Person)object;
                                            this.addPersonToScene(person, (Scene)mov.getScenes().get(0), false);
                                        }
                                        MovieChildFactory.this.db.getEntityService().save((AbstractEntity)((Scene)mov.getScenes().get(0)));
                                        AbstractTopComponent.reloadMovieList(true);
                                    } else {
                                        AbstractTopComponent.notifyError("Persons can only be dropped to movie nodes if exactly one scene is associated to it. ");
                                    }
                                }
                                MovieChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                            } else {
                                LOG.fine("Something pasted to a movie but not a MediumFile / Person: " + node.getDisplayName());
                            }
                            MovieChildFactory.this.refresh(true);
                            return null;
                        }
                    };
                }

                public PasteType getDropType(Transferable t, int action, int index) {
                    return this.createPasteType(t, action, this);
                }

                public Action[] getActions(boolean context) {
                    Movie movie = (Movie)this.getLookup().lookup(Movie.class);
                    movie = (Movie)MovieChildFactory.this.db.getEntityService().load(Movie.class, movie.getId().longValue());
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(SystemAction.get(OpenMovieAction.class));
                    list.add(SystemAction.get(OpenMovieInternalPlayerAction.class));
                    list.add(SystemAction.get(OpenMoviesOwnInstanceAction.class));
                    list.add(SystemAction.get(OpenDirectoryAction.class));
                    list.add(null);
                    list.add(SystemAction.get(MarkAsFavoriteAction.class));
                    list.add((Action)SharedClassObject.findObject(AddToDefaultPlaylistAction.class, (boolean)true));
                    list.add((Action)SharedClassObject.findObject(AddToPlaylistAction.class, (boolean)true));
                    list.add(null);
                    list.add(SystemAction.get(AddSceneAction.class));
                    list.add(SystemAction.get(AddSeveralScenesAction.class));
                    list.add(SystemAction.get(AddBookmarkAction.class));
                    list.add(null);
                    list.add(SystemAction.get(AddPersonsAction.class));
                    list.add((Action)SharedClassObject.findObject(RemoveAllPersonsAction.class, (boolean)true));
                    list.add(null);
                    list.add(SystemAction.get(AddMovieTypeAction.class));
                    list.add(SystemAction.get(RemoveMovieTypeAction.class));
                    list.add(null);
                    list.add(SystemAction.get(SetStudioAction.class));
                    list.add(null);
                    list.add(SystemAction.get(PrefixTitleAction.class));
                    list.add(SystemAction.get(SetOffsetStarttimeAction.class));
                    list.add(SystemAction.get(ConfirmWizardDataAction.class));
                    list.add(SystemAction.get(SetSecretAction.class));
                    list.add(SystemAction.get(UnsetSecretAction.class));
                    if (MovieChildFactory.this.showCounter) {
                        list.add(SystemAction.get(ResetCounterAction.class));
                    }
                    list.add(null);
                    list.add(SystemAction.get(CompareMoviesAction.class));
                    list.add(SystemAction.get(SwapMediumFilesAction.class));
                    list.add(SystemAction.get(MarkAsNoDuplicateAction.class));
                    list.add(null);
                    if (MovieChildFactory.this.db.getScenerixxSettings().isShowExport()) {
                        list.add(SystemAction.get(ExportMovieToPublicFileAction.class));
                    }
                    list.add(null);
                    list.add(SystemAction.get(RecreateScreencapAction.class));
                    list.add(SystemAction.get(CopyScreencapsAction.class));
                    list.add(SystemAction.get(DeleteScreencapAction.class));
                    list.add(null);
                    list.add(new RemoveMediumFilesPopupAction((Node)this, movie));
                    list.add(new RemovePictureFilesPopupAction((Node)this, movie));
                    list.add(null);
                    list.add(SystemAction.get(DeletePlayableFromDatabaseAction.class));
                    list.add(SystemAction.get(DeleteMovieFromDiscAction.class));
                    Action[] actions = new Action[list.size()];
                    actions = list.toArray(actions);
                    return actions;
                }

                class RemoveMediumFilesPopupAction
                extends AbstractAction
                implements ActionListener,
                Presenter.Popup {
                    Movie movie;
                    Node node;

                    public RemoveMediumFilesPopupAction(Node node, Movie movie) {
                        this.node = node;
                        this.movie = movie;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }

                    public JMenuItem getPopupPresenter() {
                        JMenu main = new JMenu("Remove mediumfile from movie ");
                        List mediumFiles = MovieChildFactory.this.db.getMediumFiles(this.movie, Scenerixx.unlocked);
                        for (MediumFile mf : mediumFiles) {
                            main.add(new RemoveMediumFileAction(this.node, mf));
                        }
                        main.setEnabled(!mediumFiles.isEmpty());
                        Image image = ImageUtilities.loadImage((String)"icons/film.png");
                        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
                        main.setIcon(ImageUtilities.image2Icon((Image)image));
                        return main;
                    }
                }

                class RemovePictureFilesPopupAction
                extends AbstractAction
                implements ActionListener,
                Presenter.Popup {
                    Movie movie;
                    Node node;

                    public RemovePictureFilesPopupAction(Node node, Movie movie) {
                        this.node = node;
                        this.movie = movie;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }

                    public JMenuItem getPopupPresenter() {
                        JMenu main = new JMenu("Remove picture from movie ");
                        List pictures = this.movie.getPictures();
                        for (MediumFile mf : pictures) {
                            main.add(new RemovePictureFromMovieAction(this.node, mf));
                        }
                        main.setEnabled(!pictures.isEmpty());
                        Image image = ImageUtilities.loadImage((String)"icons/picture.png");
                        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
                        main.setIcon(ImageUtilities.image2Icon((Image)image));
                        return main;
                    }
                }

                class RemovePictureFromMovieAction
                extends AbstractAction {
                    private Node node;
                    private MediumFile mf;

                    public RemovePictureFromMovieAction(Node node, MediumFile mf) {
                        this.putValue("Name", "Remove " + mf.getFileName() + " [" + ScenerixxCommon.readableFileSize(mf.getFileSize()) + "]");
                        Image image = ImageUtilities.loadImage((String)"icons/picture.png");
                        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
                        this.putValue("SmallIcon", image);
                        this.node = node;
                        this.mf = mf;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Movie movie = (Movie)this.getLookup().lookup(Movie.class);
                        movie = (Movie)MovieChildFactory.this.db.getEntityService().load(Movie.class, movie.getId().longValue());
                        movie.getPictures().remove(this.mf);
                        MovieChildFactory.this.db.getEntityService().save((AbstractEntity)movie);
                        MovieChildFactory.this.reloadList(this.node);
                        AbstractTopComponent.reloadMediumFileList(Node.EMPTY);
                    }
                }

                class RemoveMediumFileAction
                extends AbstractAction {
                    private Node node;
                    private MediumFile mf;

                    public RemoveMediumFileAction(Node node, MediumFile mf) {
                        this.putValue("Name", "Remove " + mf.getFileName() + " [" + ScenerixxCommon.readableFileSize(mf.getFileSize()) + "]");
                        Image image = ImageUtilities.loadImage((String)"icons/film.png");
                        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
                        this.putValue("SmallIcon", image);
                        this.node = node;
                        this.mf = mf;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Movie movie = this.mf.getMovie();
                        this.mf.setMovie(null);
                        MovieChildFactory.this.db.getEntityService().save((AbstractEntity)this.mf);
                        movie.recalculateTotalRuntime();
                        MovieChildFactory.this.db.getEntityService().save((AbstractEntity)movie);
                        MovieChildFactory.this.reloadList(this.node, true);
                        AbstractTopComponent.reloadMediumFileList(Node.EMPTY);
                    }
                }
            };
            result.setName("" + mov.getId());
            Object displayName = "";
            if (this.showPosition) {
                int pos = mov.getPositionInList();
                String additionalSpace = "";
                if (pos <= 999) {
                    additionalSpace = "&nbsp;";
                }
                if (pos <= 99) {
                    additionalSpace = "&nbsp;&nbsp;";
                }
                if (pos <= 9) {
                    additionalSpace = "&nbsp;&nbsp;&nbsp;";
                }
                displayName = additionalSpace + pos + ". ";
            }
            if (!this.prefixMetadata) {
                displayName = (String)displayName + mov.getTitle();
            }
            if (this.showCounter) {
                int cnt = 0;
                Statistic stat = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.movie.eq((Object)mov)).findFirst();
                if (stat != null) {
                    cnt = stat.getStarted().size();
                }
                if (stat != null && stat.getMovie() != null) {
                    for (Scene s : stat.getMovie().getScenes()) {
                        Statistic statScene = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.scene.eq((Object)s)).findFirst();
                        if (statScene == null) continue;
                        cnt += statScene.getStarted().size();
                    }
                }
                if (this.prefixMetadata) {
                    String additionalSpace = "";
                    if (cnt <= 999) {
                        additionalSpace = "&nbsp;";
                    }
                    if (cnt <= 99) {
                        additionalSpace = "&nbsp;&nbsp;";
                    }
                    displayName = (String)displayName + " [" + additionalSpace + ScenerixxCommon.getSumSymbol(cnt) + "]";
                } else {
                    displayName = (String)displayName + " [" + ScenerixxCommon.getSumSymbol(cnt) + "]";
                }
            }
            if (this.showRuntime) {
                int runtime = mov.getTotalRuntime();
                String sRuntime = ScenerixxCommon.formatRuntime(runtime);
                displayName = (String)displayName + " [" + sRuntime + "]";
            }
            if (this.showRating) {
                int rating = 0;
                if (mov.getRating() != null) {
                    rating = mov.getRating();
                }
                displayName = (String)displayName + " [" + ScenerixxCommon.getColoredStar(rating, mov.getRatingDifferentiator()) + "]";
            }
            if (this.showYear) {
                displayName = mov.getReleaseYear() != null ? (String)displayName + " [" + mov.getReleaseYear() + "]" : (String)displayName + " [????]";
            }
            if (this.showResolution) {
                Integer width = null;
                Integer height = null;
                if (mov != null) {
                    if (mov.getStartMedium() != null) {
                        width = mov.getStartMedium().getWidth();
                        height = mov.getStartMedium().getHeight();
                    }
                    Object resolution = width != null ? width.toString() + " x " : "? x ";
                    resolution = height != null ? (String)resolution + height.toString() : (String)resolution + "?";
                    displayName = this.prefixMetadata ? (String)displayName + " [" + StringUtils.rightPad((String)resolution, (int)11) + "]" : (String)displayName + " [" + (String)resolution + "]";
                }
            }
            if (this.prefixMetadata) {
                displayName = (String)displayName + " " + mov.getTitle();
            }
            if (this.useDifferentColorCensored && (mov.isCensored() || mov.isDecensored())) {
                String highlightColor = "";
                if (mov.isCensored()) {
                    LOG.fine("censored. why oh why? " + mov.getTitle());
                    highlightColor = "FF6666";
                }
                if (mov.isDecensored()) {
                    LOG.fine("decensored: " + mov.getTitle());
                    highlightColor = "ffb3b3";
                }
                String startTag = "<b><font color=\"" + highlightColor + "\">";
                String endTag = "</font></b>";
                displayName = startTag + (String)displayName + endTag;
            }
            displayName = ScenerixxCommon.highlighting((String)displayName, this.getSearchTerms());
            result.setDisplayName((String)displayName);
            result.setValue("movie", (Object)m);
            boolean showTooltip = true;
            MovieListTopComponent movieList = (MovieListTopComponent)WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                showTooltip = movieList.cbShowTooltips.isSelected();
            }
            if (showTooltip) {
                int i = 1;
                String tooltip = mov.getTitle() + "<br><br>";
                if (!mov.getTypesAsString().isEmpty()) {
                    tooltip = tooltip + mov.getTypesAsString() + "<br><br>";
                }
                if (this.getResultList().size() <= 500) {
                    Medium medium;
                    for (Scene s : mov.getScenes()) {
                        tooltip = tooltip + i++ + ". ";
                        String personNames = s.getPersonNames(Scenerixx.unlocked);
                        tooltip = personNames.isEmpty() ? tooltip + "???" : tooltip + personNames;
                        tooltip = tooltip + "<br>";
                    }
                    if (mov.getStartMedium() != null && (medium = mov.getStartMedium()) instanceof MediumFile) {
                        MediumFile startMF = (MediumFile)medium;
                        tooltip = tooltip + "<br>First medium file (more might be associated): " + startMF.getFileCompletePath() + " [" + ScenerixxCommon.readableFileSize(startMF.getFileSize()) + "]";
                    }
                }
                if (mov.getDateOfCreation() != null) {
                    tooltip = tooltip + "<br>" + this.df.format(mov.getDateOfCreation()) + " (created)<br>" + this.df.format(mov.getDateOfLastModification()) + " (last modified)";
                }
                result.setShortDescription("<html>" + tooltip + "</html>");
            }
        } else if (m instanceof Studio) {
            Studio studio = (Studio)m;
            StudioChildFactory scf = new StudioChildFactory(new ArrayList<INode>());
            result = scf.createNode((INode)studio);
        }
        return result;
    }

    public Node createNode(Movie m) {
        return this.createNodeForKey((INode)m);
    }
}

