/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.mediumfile;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.nodes.BeanNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.medium.QDeletedMedium;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;
import xxx.scenerixx.scenerixxlib.service.MediumFileService;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.childfactories.actions.ResetCounterAction;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action.CreateMovieFromMediumFileAction;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action.HashAction;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action.OpenMediumFileAction;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action.RenameFileExtensionOnDiscAction;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action.RenameFileOnDiscAction;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action.SecretAction;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action.UpdateMediaInformationAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToDefaultPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.DeleteMediumFileAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.DeleteMediumFileFromDiscAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.OpenDirectoryAction;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class MediumFileChildFactory
extends ChildFactory<MediumFile> {
    public static final Logger LOG = Logger.getLogger(MediumFileChildFactory.class.getName());
    private List<MediumFile> resultList;
    private boolean showCounter = false;
    private boolean showDirectory = false;
    private boolean showPosition = false;
    private boolean showFileSize = false;
    private boolean showHashvalue = false;
    private String searchTerm = "";
    private String lastHashValue = "";
    String red = ScenerixxCommonLib.RED;
    String green = ScenerixxCommonLib.GREEN;
    String lastcolor = this.red;
    private final DB db = DB.getInstance();

    public MediumFileChildFactory(List<MediumFile> resultList, boolean showCounter) {
        this(resultList, showCounter, false, false);
    }

    public MediumFileChildFactory(List<MediumFile> resultList, boolean showCounter, boolean showDirectory, boolean showPosition) {
        this(resultList, showCounter, showDirectory, showPosition, false);
    }

    public MediumFileChildFactory(List<MediumFile> resultList, boolean showCounter, boolean showDirectory, boolean showPosition, boolean showFileSize) {
        this(resultList, showCounter, showDirectory, showPosition, showFileSize, false);
    }

    public MediumFileChildFactory(List<MediumFile> resultList, boolean showCounter, boolean showDirectory, boolean showPosition, boolean showFileSize, boolean showHashvalue) {
        this(resultList, showCounter, showDirectory, showPosition, showFileSize, showHashvalue, "");
    }

    public MediumFileChildFactory(List<MediumFile> resultList, boolean showCounter, boolean showDirectory, boolean showPosition, boolean showFileSize, boolean showHashvalue, String searchTerm) {
        this.resultList = resultList;
        this.showCounter = showCounter;
        this.showDirectory = showDirectory;
        this.showPosition = showPosition;
        this.showFileSize = showFileSize;
        this.showHashvalue = showHashvalue;
        this.searchTerm = searchTerm;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in MediumFileChildFactory: " + String.valueOf(node));
    }

    protected boolean createKeys(List<MediumFile> list) {
        int i = 1;
        for (MediumFile mf : this.resultList) {
            mf.setPositionInList(i++);
            list.add(mf);
        }
        return true;
    }

    protected Node createNodeForKey(MediumFile mf) {
        try {
            LOG.finest("create new node for key. MediumFile: " + String.valueOf(mf));
            MediumFileBeanNode mediumFileBeanNode = new MediumFileBeanNode(mf);
            Object displayName = mf.getFileName();
            if (this.showDirectory) {
                displayName = mf.getFileCompletePath();
            }
            String runtime = "??";
            if (mf.getDuration() != null) {
                runtime = ScenerixxCommon.readableDuration(mf.getDuration());
            }
            if (MediumFileService.isMovie((MediumFile)mf)) {
                displayName = (String)displayName + " [" + runtime + "]";
            }
            if (this.showCounter) {
                int cnt = 0;
                Statistic stat = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.medium.eq((Object)mf)).findFirst();
                if (stat != null) {
                    cnt = stat.getStarted().size();
                }
                displayName = (String)displayName + " [" + ScenerixxCommon.getSumSymbol(cnt) + "]";
            }
            if (this.showPosition) {
                displayName = mf.getPositionInList() + ". " + (String)displayName;
            }
            if (this.showFileSize) {
                displayName = (String)displayName + " [" + ScenerixxCommon.readableFileSize(mf.getFileSize()) + "]";
            }
            if (this.showHashvalue) {
                if (this.lastHashValue.isEmpty()) {
                    this.lastHashValue = mf.getHashValue();
                }
                if (!this.lastHashValue.equals(mf.getHashValue())) {
                    this.lastcolor = this.lastcolor.equals(this.red) ? this.green : this.red;
                    this.lastHashValue = mf.getHashValue();
                }
                displayName = "<font color=\"" + this.lastcolor + "\">" + mf.getHashValue() + "</font>: " + (String)displayName;
                LOG.info("current display name: " + (String)displayName);
            }
            displayName = ScenerixxCommon.highlighting((String)displayName, this.searchTerm);
            mediumFileBeanNode.setDisplayName((String)displayName);
            mediumFileBeanNode.setShortDescription(mf.getFileCompletePath());
            mediumFileBeanNode.setValue("mediumFile", mf);
            mediumFileBeanNode.setName("" + mf.getId());
            return mediumFileBeanNode;
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("Could not create medium file child node. An error occured: " + ex.getMessage());
            return null;
        }
    }

    public class MediumFileBeanNode
    extends BeanNode {
        public MediumFileBeanNode(MediumFile bean) throws IntrospectionException {
            super((Object)bean, Children.LEAF, Lookups.singleton((Object)bean));
        }

        public Action getPreferredAction() {
            LOG.info("open MediumFile " + ((MediumFile)this.getLookup().lookup(MediumFile.class)).getNameOfPlayable());
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                ((MovieListTopComponent)movieList).openVlc(((MediumFile)this.getLookup().lookup(MediumFile.class)).getNameOfPlayable(), null, null, null, (MediumFile)this.getLookup().lookup(MediumFile.class), true);
            }
            return null;
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    LOG.finest("Pasted " + MediumFileBeanNode.this.getDisplayName() + " - Bean: " + MediumFileBeanNode.this.getBean().toString());
                    MediumFileChildFactory.this.refresh(true);
                    return null;
                }
            };
        }

        public Transferable drag() throws IOException {
            LOG.finest("Dragging " + this.getBean().toString());
            return super.drag();
        }

        public Action[] getActions(boolean context) {
            MediumFile obj = (MediumFile)this.getLookup().lookup(MediumFile.class);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(SystemAction.get(OpenMediumFileAction.class));
            if (obj.getMovie() == null) {
                list.add(SystemAction.get(CreateMovieFromMediumFileAction.class));
            }
            list.add(null);
            list.add((Action)SharedClassObject.findObject(AddToDefaultPlaylistAction.class, (boolean)true));
            list.add((Action)SharedClassObject.findObject(AddToPlaylistAction.class, (boolean)true));
            SecretAction secretAction = (SecretAction)SystemAction.get(SecretAction.class);
            secretAction.setNodeToSelect((Node)this);
            if (obj.isSecret()) {
                secretAction.setName("Make secret mediumfile public");
            } else {
                secretAction.setName("Make mediumfile secret");
            }
            list.add((Object)secretAction);
            if (MediumFileChildFactory.this.showCounter) {
                list.add(SystemAction.get(ResetCounterAction.class));
            }
            list.add(null);
            list.add(SystemAction.get(OpenDirectoryAction.class));
            list.add(SystemAction.get(RenameFileOnDiscAction.class));
            list.add(SystemAction.get(RenameFileExtensionOnDiscAction.class));
            list.add(null);
            HashAction hashAction = (HashAction)SystemAction.get(HashAction.class);
            hashAction.setNodeToSelect((Node)this);
            if (obj.getHashValue() == null) {
                hashAction.setName("Hash file");
            } else {
                hashAction.setName("Re-hash file");
            }
            list.add((Object)hashAction);
            UpdateMediaInformationAction updateMediaInformation = (UpdateMediaInformationAction)SystemAction.get(UpdateMediaInformationAction.class);
            updateMediaInformation.setNodeToSelect((Node)this);
            if (obj.getHeight() == null && obj.getWidth() == null && obj.getDuration() == null) {
                updateMediaInformation.setName("Update media information");
            } else {
                updateMediaInformation.setName("Re-update media information");
            }
            list.add((Object)updateMediaInformation);
            list.add(null);
            list.add(SystemAction.get(DeleteMediumFileAction.class));
            list.add(SystemAction.get(DeleteMediumFileFromDiscAction.class));
            Action[] actions = new Action[list.size()];
            actions = list.toArray(actions);
            return actions;
        }

        public Image getIcon(int type) {
            MediumFile obj = (MediumFile)this.getLookup().lookup(MediumFile.class);
            Image image = null;
            image = obj.isSecret() ? ImageUtilities.loadImage((String)"icons/Lock.png") : (obj.isFavorite() ? ImageUtilities.loadImage((String)"icons/favourites.png") : (obj.getMovie() != null ? ImageUtilities.loadImage((String)"icons/Database.png") : (MediumFileService.isPicture((MediumFile)obj) ? ImageUtilities.loadImage((String)"icons/picture.png") : (MediumFileService.isMovie((MediumFile)obj) ? ImageUtilities.loadImage((String)"icons/play.png") : ImageUtilities.loadImage((String)"icons/unknown.png")))));
            long count = 0L;
            if (obj.getHashValue() != null) {
                count = MediumFileChildFactory.this.db.getEntityService().find((EntityPathBase)QDeletedMedium.deletedMedium).filter(f -> f.hashValue.isNotNull()).filter(f -> f.hashValue.eq((Object)obj.getHashValue())).count();
            }
            if (count > 0L) {
                image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/Error-badge.png"), (int)7, (int)7);
            }
            return image;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getHtmlDisplayName() {
            return this.getDisplayName();
        }
    }
}

