/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

class NativeLibraryUtils {
    NativeLibraryUtils() {
    }

    public static void loadFromJar() {
        String os = System.getProperty("os.name").toLowerCase();
        String bits = System.getProperty("os.arch").contains("64") ? "64" : "32";
        String libFilename = "libwebp-imageio.so";
        String platform = "linux";
        if (os.contains("win")) {
            platform = "win";
            libFilename = "webp-imageio.dll";
        } else if (os.contains("mac")) {
            platform = "mac";
            libFilename = "libwebp-imageio.dylib";
        }
        try (InputStream in = NativeLibraryUtils.class.getResourceAsStream(String.format("/native/%s/%s/%s", platform, bits, libFilename));){
            if (in == null) {
                throw new RuntimeException(String.format("Could not find WebP native library for %s %s in the jar", platform, bits));
            }
            File tmpLibraryFile = Files.createTempFile("", libFilename, new FileAttribute[0]).toFile();
            tmpLibraryFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tmpLibraryFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            System.load(tmpLibraryFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load native WebP library", e);
        }
    }
}

