/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.statistic;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.invoke.CallSite;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.XChartSeriesColors;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.Marker;
import org.knowm.xchart.style.markers.SeriesMarkers;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.enums.Nationality;
import xxx.scenerixx.scenerixxlib.model.person.ChartPosition;
import xxx.scenerixx.scenerixxlib.model.person.ChartPositionType;
import xxx.scenerixx.scenerixxlib.model.settings.QStatisticInternalSettings;
import xxx.scenerixx.scenerixxlib.model.settings.StatisticInternalSettings;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatisticInternal;
import xxx.scenerixx.scenerixxlib.model.statistic.StatisticInternal;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.RendererUtil;
import xxx.scenerixx.scenerixxmodule.windows.statistic.Bundle;
import xxx.scenerixx.scenerixxmodule.windows.statistic.StatisticService;
import xxx.scenerixx.scenerixxmodule.windows.statistic.WorldMap;

@TopComponent.Description(preferredID="StatisticTopComponent", iconBase="icons/Piechart.png", persistenceType=2)
public final class StatisticTopComponent
extends TopComponent {
    private static final Logger LOG = Logger.getLogger(StatisticTopComponent.class.getName());
    private final DB db = DB.getInstance();
    private XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(400)).title("Your collection")).xAxisTitle("Date").yAxisTitle("Y").build();
    private final DecimalFormat df = new DecimalFormat("+#.##;-#.##");
    private final DecimalFormat df2 = new DecimalFormat("###,###");
    private final DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private boolean hashedFiles = false;
    private boolean hashedFilesMissing = false;
    private boolean associatedMovies = false;
    private boolean associatedMoviesMissing = false;
    private boolean associatedScenes = false;
    private boolean associatedScenesMissing = false;
    private boolean sceneLengthSet = false;
    private boolean sceneLengthMissing = false;
    private boolean personsAssociated = false;
    private boolean personsAssociatedMissing = false;
    private boolean dateOfShootSet = false;
    private boolean dateOfShootMissing = false;
    private boolean studioSet = false;
    private boolean studioMissing = false;
    private boolean screencaps = false;
    private boolean screencapsMissing = false;
    private boolean mediaInformationSet = false;
    private boolean mediaInformationMissing = false;
    private boolean wizardDataConfirmedSet = false;
    private boolean wizardDataNotConfirmedMissing = false;
    private int showRecords = 20;
    private boolean alreadyUpdated = false;
    private boolean firstInit = true;
    private String html;
    private String htmlAppearances = "";
    private String htmlRuntime = "";
    private String htmlICame = "";
    private String htmlNationality = "";
    private StatisticService statService = new StatisticService();
    private final ScenerixxCommon scenerixxCommon = new ScenerixxCommon();
    private JButton btnReload;
    private JButton btnShowTop;
    private JCheckBox cbAppearance;
    private JCheckBox cbAssociatedMovieFiles;
    private JCheckBox cbAssociatedMovieFilesMissing;
    private JCheckBox cbDateOfShootMissing;
    private JCheckBox cbDateOfShootSet;
    private JCheckBox cbFemale;
    private JCheckBox cbHashedFiles;
    private JCheckBox cbHashedFilesMissing;
    private JCheckBox cbIcame;
    private JCheckBox cbMale;
    private JCheckBox cbMediaInformationMissing;
    private JCheckBox cbMediaInformationSet;
    private JCheckBox cbMoviesWithAssociatedScenes;
    private JCheckBox cbMoviesWithAssociatedScenesMissing;
    private JCheckBox cbNationality;
    private JCheckBox cbPersonsAssociated;
    private JCheckBox cbPersonsAssociatedMissing;
    private JCheckBox cbRuntime;
    private JCheckBox cbSceneLengthMissing;
    private JCheckBox cbSceneLengthSet;
    private JCheckBox cbScreencaps;
    private JCheckBox cbScreencapsMissing;
    private JCheckBox cbStudioMissing;
    private JCheckBox cbStudioSet;
    private JCheckBox cbTs;
    private JCheckBox cbUnknown;
    private JCheckBox cbWizardDataConfirmedSet;
    private JCheckBox cbWizardDataNotConfirmedMissing;
    private JComboBox<Integer> comboTopX;
    private JInternalFrame jInternalFrame1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPaneTopXResult;
    private JLabel lbAppearances;
    private JLabel lbICame;
    private JLabel lbNationality;
    private JLabel lbOutOfDate;
    private JLabel lbRuntime;
    private JLabel lbUserLastXRecords;
    private JPanel panelChart;
    private JTextField tfHighlight;
    private JTextField tfLastXRecords;
    private JTextField tfLimit;

    public StatisticTopComponent() {
        this.initEverything();
        this.putClientProperty("netbeans.winsys.tc.sliding_disabled", Boolean.FALSE);
    }

    public void revalidate() {
        super.revalidate();
        LOG.finer("revalidate ..");
        if (this.jInternalFrame1 != null) {
            this.jInternalFrame1.revalidate();
            LOG.finer("revalidated");
        }
    }

    private void initEverything() {
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            StatisticInternal stats;
            LOG.info("init statistic");
            if (Scenerixx.statisticInternal.getHashedFileCompletedWithSecrets() == 0 && Scenerixx.statisticInternal.getHashedFileMissingWithSecrets() == 0 && (stats = (StatisticInternal)this.db.getEntityService().find((EntityPathBase)QStatisticInternal.statisticInternal).order(new Function[]{f -> f.dateOfCreation.desc()}).findFirst()) != null) {
                Scenerixx.statisticInternal = stats;
            }
            this.initComponentsAndCheckboxes();
            this.initChart();
            this.initComponentsAndCheckboxes();
            this.jLabel1.setText(this.statService.loadStatistics(true));
            if (Scenerixx.statisticInternal.getHashedFileCompletedWithSecrets() == 0 && Scenerixx.statisticInternal.getHashedFileMissingWithSecrets() == 0) {
                this.btnReload.setText("Generate internal statistic");
            } else {
                this.btnReload.setText("Reload & Save");
            }
            this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(20);
            this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(20);
            this.jScrollPane3.getVerticalScrollBar().setUnitIncrement(20);
            this.jScrollPane4.getVerticalScrollBar().setUnitIncrement(20);
            this.jScrollPane5.getVerticalScrollBar().setUnitIncrement(20);
            this.jScrollPane6.getVerticalScrollBar().setUnitIncrement(20);
            this.jScrollPane7.getVerticalScrollBar().setUnitIncrement(20);
            ((XYStyler)this.chart.getStyler()).setToolTipsEnabled(true);
            this.jTabbedPaneTopXResult.setVisible(false);
            this.setName(Bundle.CTL_StatisticTopComponent());
            this.setToolTipText(Bundle.HINT_StatisticTopComponent());
            LOG.info("finished init statistic");
            SwingUtilities.invokeLater(() -> {
                LOG.info("Going to init worldmap");
                WorldMap worldMapPanel = new WorldMap();
                this.jInternalFrame1.setContentPane(worldMapPanel);
            });
        });
    }

    private void initTopX(int top) {
        LocalDateTime now = LocalDateTime.now();
        LOG.info("Initialize top " + top + " window: " + String.valueOf(now));
        int max = top;
        List appearanceMale = new ArrayList();
        if (this.cbMale.isSelected()) {
            appearanceMale = this.db.getPersonsByAppearance(Gender.MALE, false, Scenerixx.unlocked, this.cbUnknown.isSelected());
            if (!this.firstInit) {
                this.saveChartPosition(appearanceMale, ChartPositionType.Appearance);
            }
            appearanceMale = appearanceMale.subList(0, appearanceMale.size() >= max ? max : appearanceMale.size());
        }
        List appearanceFemale = new ArrayList();
        if (this.cbFemale.isSelected()) {
            appearanceFemale = this.db.getPersonsByAppearance(Gender.FEMALE, false, Scenerixx.unlocked, this.cbUnknown.isSelected());
            if (!this.firstInit) {
                this.saveChartPosition(appearanceFemale, ChartPositionType.Appearance);
            }
            appearanceFemale = appearanceFemale.subList(0, appearanceFemale.size() >= max ? max : appearanceFemale.size());
        }
        List appearanceTs = new ArrayList();
        if (this.cbTs.isSelected()) {
            appearanceTs = this.db.getPersonsByAppearance(Gender.TS, false, Scenerixx.unlocked, this.cbUnknown.isSelected());
            if (!this.firstInit) {
                this.saveChartPosition(appearanceTs, ChartPositionType.Appearance);
            }
            appearanceTs = appearanceTs.subList(0, appearanceTs.size() >= max ? max : appearanceTs.size());
        }
        TreeMap<Integer, Set<Nationality>> mapFemale = new TreeMap<Integer, Set<Nationality>>(Collections.reverseOrder());
        TreeMap<Integer, Set<Nationality>> mapMale = new TreeMap<Integer, Set<Nationality>>(Collections.reverseOrder());
        TreeMap<Integer, Set<Nationality>> mapTs = new TreeMap<Integer, Set<Nationality>>(Collections.reverseOrder());
        if (this.cbNationality.isSelected()) {
            for (Nationality n : Nationality.values()) {
                this.fillNationalityMap(n, mapMale, Gender.MALE);
                this.fillNationalityMap(n, mapFemale, Gender.FEMALE);
                this.fillNationalityMap(n, mapTs, Gender.TS);
            }
        }
        this.html = "<html><table><tr>";
        if (this.cbAppearance.isSelected()) {
            if (!(this.cbNationality.isSelected() || this.cbRuntime.isSelected() || this.cbIcame.isSelected())) {
                this.jTabbedPaneTopXResult.setSelectedIndex(0);
            }
            if (this.cbFemale.isSelected()) {
                this.html = this.html + "<td><b>Appearances (female)</b></td><td></td>";
            }
            if (this.cbMale.isSelected()) {
                this.html = this.html + "<td><b>Appearances (male)</b></td><td></td>";
            }
            if (this.cbTs.isSelected()) {
                this.html = this.html + "<td><b>Appearances (ts)</b></td><td></td>";
            }
            this.html = this.html + "</tr>";
            for (int i = 0; i < max; ++i) {
                if (i < appearanceFemale.size() || i < appearanceMale.size() || i < appearanceTs.size()) {
                    this.html = this.html + "<tr>";
                }
                if (this.cbFemale.isSelected() && i < appearanceFemale.size()) {
                    Person p = (Person)appearanceFemale.get(i);
                    long nr = this.db.getNumberOfAppearance(p, Scenerixx.unlocked);
                    this.addStatisticRow(p, i, nr, ChartPositionType.Appearance);
                }
                if (this.cbMale.isSelected() && i < appearanceMale.size()) {
                    Person p = (Person)appearanceMale.get(i);
                    long nr = this.db.getNumberOfAppearance(p, Scenerixx.unlocked);
                    this.addStatisticRow(p, i, nr, ChartPositionType.Appearance);
                }
                if (this.cbTs.isSelected() && i < appearanceTs.size()) {
                    Person p = (Person)appearanceTs.get(i);
                    long nr = this.db.getNumberOfAppearance(p, Scenerixx.unlocked);
                    this.addStatisticRow(p, i, nr, ChartPositionType.Appearance);
                }
                if (i >= appearanceFemale.size() && i >= appearanceMale.size() && i >= appearanceTs.size()) continue;
                this.html = this.html + "</tr>";
            }
            this.html = this.html + "</table></html>";
            this.htmlAppearances = this.html;
            this.lbAppearances.setText(this.htmlAppearances);
            LOG.info("finished appearance " + Duration.between(LocalDateTime.now(), now).toString());
        } else {
            this.lbAppearances.setText("Not requested yet");
        }
        if (this.cbRuntime.isSelected()) {
            if (!(this.cbAppearance.isSelected() || this.cbNationality.isSelected() || this.cbIcame.isSelected())) {
                this.jTabbedPaneTopXResult.setSelectedIndex(1);
            }
            List<Person> runtimeMale = new ArrayList();
            if (this.cbMale.isSelected()) {
                runtimeMale = this.db.getPersonsByRuntime(Gender.MALE, false, "", Scenerixx.unlocked, this.cbUnknown.isSelected());
            }
            List<Person> runtimeFemale = new ArrayList();
            if (this.cbFemale.isSelected()) {
                runtimeFemale = this.db.getPersonsByRuntime(Gender.FEMALE, false, "", Scenerixx.unlocked, this.cbUnknown.isSelected());
            }
            List<Person> runtimeTs = new ArrayList();
            if (this.cbTs.isSelected()) {
                runtimeTs = this.db.getPersonsByRuntime(Gender.TS, false, "", Scenerixx.unlocked, this.cbUnknown.isSelected());
            }
            this.html = "<html><table><tr>";
            this.html = this.html + "<tr></tr><tr>";
            this.html = this.html + "</tr>";
            for (int i = 0; i < max; ++i) {
                String sRuntime;
                Person p;
                if (i < runtimeFemale.size() || i < runtimeMale.size() || i < runtimeTs.size()) {
                    this.html = this.html + "<tr>";
                }
                if (i < runtimeFemale.size()) {
                    p = (Person)runtimeFemale.get(i);
                    sRuntime = this.scenerixxCommon.calculateTotalRuntime(p);
                    this.addStatisticRow(p, i, sRuntime, ChartPositionType.Runtime);
                }
                if (i < runtimeMale.size()) {
                    p = (Person)runtimeMale.get(i);
                    sRuntime = this.scenerixxCommon.calculateTotalRuntime(p);
                    this.addStatisticRow(p, i, sRuntime, ChartPositionType.Runtime);
                }
                if (i < runtimeTs.size()) {
                    p = (Person)runtimeTs.get(i);
                    sRuntime = this.scenerixxCommon.calculateTotalRuntime(p);
                    this.addStatisticRow(p, i, sRuntime, ChartPositionType.Runtime);
                }
                if (i >= runtimeFemale.size() && i >= runtimeMale.size() && i >= runtimeTs.size()) continue;
                this.html = this.html + "</tr>";
            }
            this.html = this.html + "</table></html>";
            this.htmlRuntime = this.html;
            this.lbRuntime.setText(this.htmlRuntime);
            if (this.cbMale.isSelected()) {
                this.saveChartPosition(runtimeMale, ChartPositionType.Runtime);
            }
            if (this.cbFemale.isSelected()) {
                this.saveChartPosition(runtimeFemale, ChartPositionType.Runtime);
            }
            if (this.cbTs.isSelected()) {
                this.saveChartPosition(runtimeTs, ChartPositionType.Runtime);
            }
            LOG.info("finished runtime " + Duration.between(LocalDateTime.now(), now).toString());
        } else {
            this.lbRuntime.setText("Not requested yet");
        }
        if (this.cbIcame.isSelected()) {
            if (!(this.cbAppearance.isSelected() || this.cbRuntime.isSelected() || this.cbNationality.isSelected())) {
                this.jTabbedPaneTopXResult.setSelectedIndex(2);
            }
            List<Person> icameMale = new ArrayList();
            if (this.cbMale.isSelected()) {
                icameMale = this.db.getPersonsByICame(Gender.MALE, false, Scenerixx.unlocked, this.cbUnknown.isSelected());
            }
            List<Person> icameFemale = new ArrayList();
            if (this.cbFemale.isSelected()) {
                icameFemale = this.db.getPersonsByICame(Gender.FEMALE, false, Scenerixx.unlocked, this.cbUnknown.isSelected());
            }
            List<Person> icameTs = new ArrayList();
            if (this.cbTs.isSelected()) {
                icameTs = this.db.getPersonsByICame(Gender.TS, false, Scenerixx.unlocked, this.cbUnknown.isSelected());
            }
            this.html = "<html><table><tr>";
            this.html = this.html + "</tr><tr></tr><tr></tr>  ";
            if (this.cbFemale.isSelected()) {
                this.html = this.html + "<td><b>I came (female)</b></td><td>Highest/lowest position</td><td>Last time</td>";
            }
            if (this.cbMale.isSelected()) {
                this.html = this.html + "<td><b>I came (male)</b></td><td>Highest/lowest position</td><td>Last time</td>";
            }
            if (this.cbTs.isSelected()) {
                this.html = this.html + "<td><b>I came (ts)</b></td><td>Highest/lowest position</td><td>Last time</td>";
            }
            this.html = this.html + "</tr>";
            int iCameGlobal = 0;
            for (int i = 0; i < max; ++i) {
                int icame;
                Person p;
                if (i < icameFemale.size() || i < icameMale.size() || i < icameTs.size()) {
                    this.html = this.html + "<tr>";
                }
                if (i < icameFemale.size()) {
                    p = (Person)icameFemale.get(i);
                    icame = this.db.getIcame(p);
                    iCameGlobal += icame;
                    this.addStatisticRow(p, i, icame, ChartPositionType.Icame);
                    this.html = this.html + this.addIcameRow(p);
                }
                if (i < icameMale.size()) {
                    p = (Person)icameMale.get(i);
                    icame = this.db.getIcame(p);
                    iCameGlobal += icame;
                    this.addStatisticRow(p, i, icame, ChartPositionType.Icame);
                    this.html = this.html + this.addIcameRow(p);
                }
                if (i < icameTs.size()) {
                    p = (Person)icameTs.get(i);
                    icame = this.db.getIcame(p);
                    iCameGlobal += icame;
                    this.addStatisticRow(p, i, icame, ChartPositionType.Icame);
                    this.html = this.html + this.addIcameRow(p);
                }
                if (i >= icameFemale.size() && i >= icameMale.size() && i >= icameTs.size()) continue;
                this.html = this.html + "</tr>";
            }
            this.html = this.html + "<tr><td>------------------------</td><td>----</td></tr>";
            this.html = this.html + "<tr><td>Total:</td><td>" + iCameGlobal + "</td></tr>";
            this.html = this.html + "</table></html>";
            this.htmlICame = this.html;
            this.lbICame.setText(this.htmlICame);
            if (this.cbMale.isSelected()) {
                this.saveChartPosition(icameMale, ChartPositionType.Icame);
            }
            if (this.cbFemale.isSelected()) {
                this.saveChartPosition(icameFemale, ChartPositionType.Icame);
            }
            if (this.cbTs.isSelected()) {
                this.saveChartPosition(icameTs, ChartPositionType.Icame);
            }
            LOG.info("finished i came " + Duration.between(LocalDateTime.now(), now).toString());
        } else {
            this.lbICame.setText("Not requested yet");
        }
        if (this.cbNationality.isSelected()) {
            if (!(this.cbAppearance.isSelected() || this.cbRuntime.isSelected() || this.cbIcame.isSelected())) {
                this.jTabbedPaneTopXResult.setSelectedIndex(3);
            }
            Set set = mapFemale.entrySet();
            LOG.info("map female size: " + mapFemale.size());
            this.html = "<html><table><tr>";
            this.html = this.html + "</tr>";
            if (set.size() > 1 && this.cbFemale.isSelected()) {
                Object htmlNationalityFemale = "<tr><td><b>Females by Nationality</b></td><td></td></tr>";
                int i = 1;
                int indexToShow = 1;
                int totalEntries = 0;
                for (Map.Entry e : set) {
                    totalEntries = ((Set)e.getValue()).size();
                }
                for (Map.Entry e : set) {
                    if ((Integer)e.getKey() == 0) continue;
                    if (i > totalEntries) break;
                    for (Object nationality : (Set)e.getValue()) {
                        htmlNationalityFemale = (String)htmlNationalityFemale + "<tr><td>" + indexToShow + ". <img src='" + String.valueOf(((Object)((Object)this)).getClass().getResource(RendererUtil.getFlagImagePath((Nationality)nationality))) + "'> " + nationality.getTitle() + "</td>";
                        htmlNationalityFemale = (String)htmlNationalityFemale + "<td>" + String.valueOf(e.getKey()) + "</td></tr>";
                        if (++indexToShow <= totalEntries && indexToShow <= (Integer)this.comboTopX.getSelectedItem()) continue;
                        break;
                    }
                    ++i;
                }
                LOG.info("nationality female: " + (String)htmlNationalityFemale + " - " + Duration.between(LocalDateTime.now(), now).toString());
                this.html = this.html + (String)htmlNationalityFemale;
            }
            Set setMale = mapMale.entrySet();
            LOG.info("map male size: " + mapMale.size());
            if (setMale.size() > 1 && this.cbMale.isSelected()) {
                Object htmlNationalityMale = "<tr></tr><tr><td><b>Males by Nationality</b></td><td></td></tr>";
                int iMale = 1;
                int indexToShowMale = 1;
                int totalEntries = 0;
                for (Map.Entry e : setMale) {
                    totalEntries = ((Set)e.getValue()).size();
                }
                for (Map.Entry e : setMale) {
                    System.out.print(String.valueOf(e.getKey()) + ": ");
                    System.out.println(e.getValue());
                    if ((Integer)e.getKey() == 0) continue;
                    if (iMale > totalEntries) break;
                    for (Nationality nationality : (Set)e.getValue()) {
                        htmlNationalityMale = (String)htmlNationalityMale + "<tr><td>" + indexToShowMale + ". <img src='" + String.valueOf(((Object)((Object)this)).getClass().getResource(RendererUtil.getFlagImagePath(nationality))) + "'> " + nationality.getTitle() + "</td>";
                        htmlNationalityMale = (String)htmlNationalityMale + "<td>" + String.valueOf(e.getKey()) + "</td></tr>";
                        if (++indexToShowMale <= totalEntries && indexToShowMale <= (Integer)this.comboTopX.getSelectedItem()) continue;
                        break;
                    }
                    ++iMale;
                }
                LOG.info("nationality male: " + (String)htmlNationalityMale + " - " + Duration.between(LocalDateTime.now(), now).toString());
                this.html = this.html + (String)htmlNationalityMale;
            }
            Set setTS = mapTs.entrySet();
            LOG.info("map ts size: " + mapTs.size());
            if (setTS.size() > 1 && this.cbTs.isSelected()) {
                Object htmlNationalityTS = "<tr></tr><tr><td><b>TS by Nationality</b></td><td></td></tr>";
                int iTS = 1;
                int indexToShowTS = 1;
                int totalEntries = 0;
                for (Map.Entry e : setTS) {
                    totalEntries = ((Set)e.getValue()).size();
                }
                for (Map.Entry e : setTS) {
                    System.out.print(String.valueOf(e.getKey()) + ": ");
                    System.out.println(e.getValue());
                    if ((Integer)e.getKey() == 0) continue;
                    if (iTS > totalEntries) break;
                    for (Nationality nationality : (Set)e.getValue()) {
                        htmlNationalityTS = (String)htmlNationalityTS + "<tr><td>" + indexToShowTS + ". <img src='" + String.valueOf(((Object)((Object)this)).getClass().getResource(RendererUtil.getFlagImagePath(nationality))) + "'> " + nationality.getTitle() + "</td>";
                        htmlNationalityTS = (String)htmlNationalityTS + "<td>" + String.valueOf(e.getKey()) + "</td></tr>";
                        if (++indexToShowTS <= totalEntries && indexToShowTS <= (Integer)this.comboTopX.getSelectedItem()) continue;
                        break;
                    }
                    ++iTS;
                }
                LOG.info("nationality ts: " + (String)htmlNationalityTS + " - " + Duration.between(LocalDateTime.now(), now).toString());
                this.html = this.html + (String)htmlNationalityTS;
            }
        } else {
            this.lbNationality.setText("Not requested yet");
            this.htmlNationality = this.lbNationality.getText();
        }
        if (this.cbNationality.isSelected()) {
            this.html = this.html + "</table></html>";
            this.htmlNationality = this.html;
            this.lbNationality.setText(this.htmlNationality);
        }
        LOG.info("htmlnationality: " + this.htmlNationality);
        this.highlight();
        this.jTabbedPaneTopXResult.setVisible(true);
    }

    private String addIcameRow(Person person) {
        Object data = "<td>";
        LocalDateTime lastIcame = this.db.getLastIcame(person);
        if (lastIcame != null) {
            long days = ChronoUnit.DAYS.between(lastIcame, LocalDateTime.now());
            if (days < 10L) {
                data = (String)data + "&nbsp;&nbsp;&nbsp;";
            } else if (days < 100L) {
                data = (String)data + "&nbsp;&nbsp;";
            } else if (days < 1000L) {
                data = (String)data + "&nbsp;";
            }
            data = (String)data + days + " days ago - " + this.dtf.format(lastIcame) + "&nbsp;&nbsp;&nbsp;";
        }
        data = (String)data + "</td>";
        return data;
    }

    private void addStatisticRow(Person p, int currentPosition, long amount, ChartPositionType type) {
        this.addStatisticRow(p, currentPosition, "" + amount, type);
    }

    private void addStatisticRow(Person p, int currentPosition, String amount, ChartPositionType type) {
        int chartPositionDiff = this.db.getChartPositionDiff(p, type);
        Object diffImage = "";
        if ((chartPositionDiff *= -1) < 0) {
            diffImage = "<img src='" + String.valueOf(((Object)((Object)this)).getClass().getResource("/icons.fugue/thermometer--minus.png")) + "'> ";
        }
        if (chartPositionDiff == 0) {
            diffImage = "<img src='" + String.valueOf(((Object)((Object)this)).getClass().getResource("/icons.fugue/thermometer--arrow.png")) + "'> ";
        }
        if (chartPositionDiff > 0) {
            diffImage = "<img src='" + String.valueOf(((Object)((Object)this)).getClass().getResource("/icons.fugue/thermometer--plus.png")) + "'> ";
        }
        LOG.info("Chart position (" + type.getTitle() + ") for " + p.getName() + ": " + chartPositionDiff);
        this.html = this.html + "<td>" + (currentPosition + 1) + ". <img src='" + String.valueOf(((Object)((Object)this)).getClass().getResource(RendererUtil.getFlagImagePath(p.getNationality()))) + "'> " + p.getName() + "</td><td>" + amount + " (" + (String)diffImage + chartPositionDiff + " | <img src='" + String.valueOf(((Object)((Object)this)).getClass().getResource("/icons.fugue/thermometer-high.png")) + "'> " + this.db.getChartPositionHighest(p, type) + " | <img src='" + String.valueOf(((Object)((Object)this)).getClass().getResource("/icons.fugue/thermometer-low.png")) + "'> " + this.db.getChartPositionLowest(p, type) + ")</td>";
    }

    private void saveChartPosition(List<Person> persons, ChartPositionType type) {
        int i = 1;
        for (Person p : persons) {
            ChartPosition chartPosition = new ChartPosition();
            chartPosition.setPerson(p);
            chartPosition.setPosition(i);
            chartPosition.setType(type);
            ++i;
            this.db.getEntityService().save((AbstractEntity)chartPosition);
        }
    }

    private void fillNationalityMap(Nationality n, SortedMap<Integer, Set<Nationality>> map, Gender gender) {
        long nationalitiesCnt = this.db.getPersonsByNationalityCount(gender, n, Scenerixx.unlocked);
        int nationalitiesCnt2 = (int)nationalitiesCnt;
        if (map.containsKey(nationalitiesCnt2)) {
            ((Set)map.get(nationalitiesCnt2)).add(n);
        } else {
            map.put(nationalitiesCnt2, new HashSet());
            ((Set)map.get(nationalitiesCnt2)).add(n);
        }
    }

    private void toggleCheckboxes() {
        if (this.cbMale.isSelected()) {
            this.cbMale.setIcon(ImageUtilities.loadImageIcon((String)"icons/male.png", (boolean)false));
        } else {
            this.cbMale.setIcon(null);
        }
        if (this.cbFemale.isSelected()) {
            this.cbFemale.setIcon(ImageUtilities.loadImageIcon((String)"icons/female.png", (boolean)false));
        } else {
            this.cbFemale.setIcon(null);
        }
        if (this.cbTs.isSelected()) {
            this.cbTs.setIcon(ImageUtilities.loadImageIcon((String)"icons2/transgender.png", (boolean)false));
        } else {
            this.cbTs.setIcon(null);
        }
        if (this.cbUnknown.isSelected()) {
            this.cbUnknown.setIcon(ImageUtilities.loadImageIcon((String)"icons.fatcow/user_ninja.png", (boolean)false));
        } else {
            this.cbUnknown.setIcon(null);
        }
        if (this.cbNationality.isSelected()) {
            this.cbNationality.setIcon(ImageUtilities.loadImageIcon((String)"icons.fatcow/change_language.png", (boolean)false));
        } else {
            this.cbNationality.setIcon(null);
        }
        if (this.cbRuntime.isSelected()) {
            this.cbRuntime.setIcon(ImageUtilities.loadImageIcon((String)"/icons/Stopwatch.png", (boolean)false));
        } else {
            this.cbRuntime.setIcon(null);
        }
        if (this.cbIcame.isSelected()) {
            this.cbIcame.setIcon(ImageUtilities.loadImageIcon((String)"/icons2/Heart.png", (boolean)false));
        } else {
            this.cbIcame.setIcon(null);
        }
        if (this.cbAppearance.isSelected()) {
            this.cbAppearance.setIcon(ImageUtilities.loadImageIcon((String)"icons.fatcow/counter.png", (boolean)false));
        } else {
            this.cbAppearance.setIcon(null);
        }
    }

    private void initComponentsAndCheckboxes() {
        this.initComponents();
        this.comboTopX.setModel(new DefaultComboBoxModel<Integer>(new Integer[]{5, 10, 15, 20, 25, 50, 100}));
        this.comboTopX.setSelectedItem(100);
        Font font = new Font("Monospaced", 0, 13);
        this.jLabel1.setFont(font);
        this.lbAppearances.setFont(font);
        this.lbICame.setFont(font);
        this.lbNationality.setFont(font);
        this.lbRuntime.setFont(font);
        this.loadSettings();
        this.cbHashedFiles.setSelected(this.hashedFiles);
        this.cbHashedFilesMissing.setSelected(this.hashedFilesMissing);
        this.cbAssociatedMovieFiles.setSelected(this.associatedMovies);
        this.cbAssociatedMovieFilesMissing.setSelected(this.associatedMoviesMissing);
        this.cbMoviesWithAssociatedScenes.setSelected(this.associatedScenes);
        this.cbMoviesWithAssociatedScenesMissing.setSelected(this.associatedScenesMissing);
        this.cbSceneLengthSet.setSelected(this.sceneLengthSet);
        this.cbSceneLengthMissing.setSelected(this.sceneLengthMissing);
        this.cbPersonsAssociated.setSelected(this.personsAssociated);
        this.cbPersonsAssociatedMissing.setSelected(this.personsAssociatedMissing);
        this.cbDateOfShootSet.setSelected(this.dateOfShootSet);
        this.cbDateOfShootMissing.setSelected(this.dateOfShootMissing);
        this.cbStudioSet.setSelected(this.studioSet);
        this.cbStudioMissing.setSelected(this.studioMissing);
        this.cbScreencaps.setSelected(this.screencaps);
        this.cbScreencapsMissing.setSelected(this.screencapsMissing);
        this.cbMediaInformationSet.setSelected(this.mediaInformationSet);
        this.cbMediaInformationMissing.setSelected(this.mediaInformationMissing);
        this.tfLastXRecords.setText("" + this.showRecords);
        this.cbWizardDataConfirmedSet.setSelected(this.wizardDataConfirmedSet);
        this.cbWizardDataNotConfirmedMissing.setSelected(this.wizardDataNotConfirmedMissing);
        this.lbOutOfDate.setVisible(false);
        this.toggleCheckboxes();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.panelChart = new XChartPanel((Chart)this.chart);
        this.cbSceneLengthSet = new JCheckBox();
        this.cbSceneLengthMissing = new JCheckBox();
        this.cbHashedFiles = new JCheckBox();
        this.cbHashedFilesMissing = new JCheckBox();
        this.cbAssociatedMovieFiles = new JCheckBox();
        this.cbAssociatedMovieFilesMissing = new JCheckBox();
        this.cbMoviesWithAssociatedScenes = new JCheckBox();
        this.cbMoviesWithAssociatedScenesMissing = new JCheckBox();
        this.cbPersonsAssociated = new JCheckBox();
        this.cbPersonsAssociatedMissing = new JCheckBox();
        this.cbDateOfShootSet = new JCheckBox();
        this.cbDateOfShootMissing = new JCheckBox();
        this.cbStudioSet = new JCheckBox();
        this.cbStudioMissing = new JCheckBox();
        this.cbScreencaps = new JCheckBox();
        this.cbScreencapsMissing = new JCheckBox();
        this.cbMediaInformationSet = new JCheckBox();
        this.cbMediaInformationMissing = new JCheckBox();
        this.tfLastXRecords = new JTextField();
        this.lbUserLastXRecords = new JLabel();
        this.cbWizardDataConfirmedSet = new JCheckBox();
        this.cbWizardDataNotConfirmedMissing = new JCheckBox();
        this.lbOutOfDate = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.comboTopX = new JComboBox();
        this.btnShowTop = new JButton();
        this.tfHighlight = new JTextField();
        this.cbFemale = new JCheckBox();
        this.cbMale = new JCheckBox();
        this.cbTs = new JCheckBox();
        this.cbUnknown = new JCheckBox();
        this.cbNationality = new JCheckBox();
        this.cbAppearance = new JCheckBox();
        this.cbRuntime = new JCheckBox();
        this.cbIcame = new JCheckBox();
        this.jTabbedPaneTopXResult = new JTabbedPane();
        this.jScrollPane4 = new JScrollPane();
        this.lbAppearances = new JLabel();
        this.jScrollPane7 = new JScrollPane();
        this.lbRuntime = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.lbICame = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.lbNationality = new JLabel();
        this.jLabel2 = new JLabel();
        this.tfLimit = new JTextField();
        this.jInternalFrame1 = new JInternalFrame();
        this.btnReload = new JButton();
        this.jLabel3 = new JLabel();
        GroupLayout panelChartLayout = new GroupLayout(this.panelChart);
        this.panelChart.setLayout(panelChartLayout);
        panelChartLayout.setHorizontalGroup(panelChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        panelChartLayout.setVerticalGroup(panelChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSceneLengthSet, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbSceneLengthSet.text"));
        this.cbSceneLengthSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbSceneLengthSetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbSceneLengthMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbSceneLengthMissing.text"));
        this.cbSceneLengthMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbSceneLengthMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbHashedFiles, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbHashedFiles.text"));
        this.cbHashedFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbHashedFilesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbHashedFilesMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbHashedFilesMissing.text"));
        this.cbHashedFilesMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbHashedFilesMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbAssociatedMovieFiles, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbAssociatedMovieFiles.text"));
        this.cbAssociatedMovieFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbAssociatedMovieFilesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbAssociatedMovieFilesMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbAssociatedMovieFilesMissing.text"));
        this.cbAssociatedMovieFilesMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbAssociatedMovieFilesMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbMoviesWithAssociatedScenes, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbMoviesWithAssociatedScenes.text"));
        this.cbMoviesWithAssociatedScenes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbMoviesWithAssociatedScenesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbMoviesWithAssociatedScenesMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbMoviesWithAssociatedScenesMissing.text"));
        this.cbMoviesWithAssociatedScenesMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbMoviesWithAssociatedScenesMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbPersonsAssociated, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbPersonsAssociated.text"));
        this.cbPersonsAssociated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbPersonsAssociatedActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbPersonsAssociatedMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbPersonsAssociatedMissing.text"));
        this.cbPersonsAssociatedMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbPersonsAssociatedMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbDateOfShootSet, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbDateOfShootSet.text"));
        this.cbDateOfShootSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbDateOfShootSetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbDateOfShootMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbDateOfShootMissing.text"));
        this.cbDateOfShootMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbDateOfShootMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbStudioSet, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbStudioSet.text"));
        this.cbStudioSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbStudioSetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbStudioMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbStudioMissing.text"));
        this.cbStudioMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbStudioMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbScreencaps, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbScreencaps.text"));
        this.cbScreencaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbScreencapsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbScreencapsMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbScreencapsMissing.text"));
        this.cbScreencapsMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbScreencapsMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbMediaInformationSet, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbMediaInformationSet.text"));
        this.cbMediaInformationSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbMediaInformationSetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbMediaInformationMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbMediaInformationMissing.text"));
        this.cbMediaInformationMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbMediaInformationMissingActionPerformed(evt);
            }
        });
        this.tfLastXRecords.setText(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.tfLastXRecords.text"));
        this.tfLastXRecords.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StatisticTopComponent.this.tfLastXRecordsFocusLost(evt);
            }
        });
        this.tfLastXRecords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.tfLastXRecordsActionPerformed(evt);
            }
        });
        this.tfLastXRecords.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StatisticTopComponent.this.tfLastXRecordsKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbUserLastXRecords, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.lbUserLastXRecords.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbWizardDataConfirmedSet, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbWizardDataConfirmedSet.text"));
        this.cbWizardDataConfirmedSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbWizardDataConfirmedSetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbWizardDataNotConfirmedMissing, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbWizardDataNotConfirmedMissing.text"));
        this.cbWizardDataNotConfirmedMissing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbWizardDataNotConfirmedMissingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbOutOfDate, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.lbOutOfDate.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbMoviesWithAssociatedScenes).addComponent(this.cbAssociatedMovieFiles).addComponent(this.panelChart, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lbOutOfDate).addGap(147, 147, 147).addComponent(this.lbUserLastXRecords).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfLastXRecords, -2, 51, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbSceneLengthSet).addComponent(this.cbHashedFiles).addComponent(this.cbPersonsAssociated).addComponent(this.cbDateOfShootSet).addComponent(this.cbStudioSet).addComponent(this.cbScreencaps).addComponent(this.cbMediaInformationSet).addComponent(this.cbWizardDataConfirmedSet)).addGap(75, 75, 75).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbWizardDataNotConfirmedMissing).addComponent(this.cbMediaInformationMissing).addComponent(this.cbAssociatedMovieFilesMissing).addComponent(this.cbHashedFilesMissing).addComponent(this.cbMoviesWithAssociatedScenesMissing).addComponent(this.cbSceneLengthMissing).addComponent(this.cbPersonsAssociatedMissing).addComponent(this.cbDateOfShootMissing).addComponent(this.cbStudioMissing).addComponent(this.cbScreencapsMissing)))).addContainerGap(287, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfLastXRecords, -2, -1, -2).addComponent(this.lbUserLastXRecords)).addComponent(this.lbOutOfDate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelChart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbHashedFiles).addComponent(this.cbHashedFilesMissing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAssociatedMovieFiles).addComponent(this.cbAssociatedMovieFilesMissing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbMoviesWithAssociatedScenes).addComponent(this.cbMoviesWithAssociatedScenesMissing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbSceneLengthSet).addComponent(this.cbSceneLengthMissing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbPersonsAssociated).addComponent(this.cbPersonsAssociatedMissing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDateOfShootSet).addComponent(this.cbDateOfShootMissing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbStudioSet).addComponent(this.cbStudioMissing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbScreencaps).addComponent(this.cbScreencapsMissing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbMediaInformationSet).addComponent(this.cbMediaInformationMissing)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbWizardDataConfirmedSet).addComponent(this.cbWizardDataNotConfirmedMissing)).addContainerGap(41, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jTabbedPane1.addTab(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jScrollPane1.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Piechart.png")), this.jScrollPane1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jLabel1.text"));
        this.jLabel1.setVerticalAlignment(1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -1, 864, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -1, 410, Short.MAX_VALUE).addContainerGap()));
        this.jScrollPane2.setViewportView(this.jPanel2);
        this.jTabbedPane1.addTab(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jScrollPane2.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.silk/sum.png")), this.jScrollPane2);
        this.btnShowTop.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/magnifier.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowTop, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.btnShowTop.text"));
        this.btnShowTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.btnShowTopActionPerformed(evt);
            }
        });
        this.tfHighlight.setText(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.tfHighlight.text"));
        this.tfHighlight.setToolTipText(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.tfHighlight.toolTipText"));
        this.tfHighlight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StatisticTopComponent.this.tfHighlightKeyReleased(evt);
            }
        });
        this.cbFemale.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbFemale, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbFemale.text"));
        this.cbFemale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbFemaleActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbMale, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbMale.text"));
        this.cbMale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbMaleActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbTs, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbTs.text"));
        this.cbTs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbTsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbUnknown, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbUnknown.text"));
        this.cbUnknown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbUnknownActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbNationality, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbNationality.text"));
        this.cbNationality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbNationalityActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbAppearance, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbAppearance.text"));
        this.cbAppearance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbAppearanceActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbRuntime, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbRuntime.text"));
        this.cbRuntime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbRuntimeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbIcame, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.cbIcame.text"));
        this.cbIcame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.cbIcameActionPerformed(evt);
            }
        });
        this.jTabbedPaneTopXResult.setTabLayoutPolicy(1);
        Mnemonics.setLocalizedText((JLabel)this.lbAppearances, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.lbAppearances.text"));
        this.lbAppearances.setVerticalAlignment(1);
        this.jScrollPane4.setViewportView(this.lbAppearances);
        this.jTabbedPaneTopXResult.addTab(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jScrollPane4.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/counter.png")), this.jScrollPane4);
        Mnemonics.setLocalizedText((JLabel)this.lbRuntime, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.lbRuntime.text"));
        this.lbRuntime.setVerticalAlignment(1);
        this.jScrollPane7.setViewportView(this.lbRuntime);
        this.jTabbedPaneTopXResult.addTab(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jScrollPane7.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Stopwatch.png")), this.jScrollPane7);
        Mnemonics.setLocalizedText((JLabel)this.lbICame, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.lbICame.text"));
        this.lbICame.setVerticalAlignment(1);
        this.jScrollPane6.setViewportView(this.lbICame);
        this.jTabbedPaneTopXResult.addTab(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jScrollPane6.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons2/Heart.png")), this.jScrollPane6);
        Mnemonics.setLocalizedText((JLabel)this.lbNationality, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.lbNationality.text"));
        this.lbNationality.setVerticalAlignment(1);
        this.jScrollPane5.setViewportView(this.lbNationality);
        this.jTabbedPaneTopXResult.addTab(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jScrollPane5.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/change_language.png")), this.jScrollPane5);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jLabel2.text"));
        this.tfLimit.setText(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.tfLimit.text"));
        this.tfLimit.setToolTipText(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.tfLimit.toolTipText"));
        this.tfLimit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                StatisticTopComponent.this.tfLimitKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                StatisticTopComponent.this.tfLimitKeyTyped(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTabbedPaneTopXResult).addGap(255, 255, 255)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.btnShowTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTopX, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfLimit, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfHighlight, -2, 150, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.cbFemale).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbMale).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbTs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbUnknown)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.cbAppearance).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbRuntime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbIcame).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbNationality))).addGap(0, 356, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboTopX, -2, -1, -2).addComponent(this.btnShowTop).addComponent(this.cbNationality).addComponent(this.cbAppearance).addComponent(this.cbRuntime).addComponent(this.cbIcame).addComponent(this.tfLimit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbFemale).addComponent(this.cbMale).addComponent(this.cbTs).addComponent(this.cbUnknown).addComponent(this.jLabel2).addComponent(this.tfHighlight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPaneTopXResult, -1, 341, Short.MAX_VALUE).addContainerGap()));
        this.jScrollPane3.setViewportView(this.jPanel3);
        this.jTabbedPane1.addTab(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jScrollPane3.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.silk/award_star_gold_2.png")), this.jScrollPane3);
        this.jInternalFrame1.setVisible(true);
        GroupLayout jInternalFrame1Layout = new GroupLayout(this.jInternalFrame1.getContentPane());
        this.jInternalFrame1.getContentPane().setLayout(jInternalFrame1Layout);
        jInternalFrame1Layout.setHorizontalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jInternalFrame1Layout.setVerticalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jInternalFrame1.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Earth.png")), this.jInternalFrame1);
        this.btnReload.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReload, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.btnReload.text"));
        this.btnReload.setToolTipText(NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.btnReload.toolTipText"));
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticTopComponent.this.btnReloadActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(StatisticTopComponent.class, (String)"StatisticTopComponent.jLabel3.text"));
        this.jLabel3.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 882, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnReload).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnReload))).addGap(14, 14, 14).addComponent(this.jTabbedPane1, -1, 463, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void cbUnknownActionPerformed(ActionEvent evt) {
        this.toggleCheckboxes();
    }

    private void cbTsActionPerformed(ActionEvent evt) {
        this.toggleCheckboxes();
    }

    private void cbMaleActionPerformed(ActionEvent evt) {
        this.toggleCheckboxes();
    }

    private void cbFemaleActionPerformed(ActionEvent evt) {
        this.toggleCheckboxes();
    }

    private void tfHighlightKeyReleased(KeyEvent evt) {
        this.highlight();
    }

    private void btnShowTopActionPerformed(ActionEvent evt) {
        this.initTopX();
    }

    private void cbWizardDataNotConfirmedMissingActionPerformed(ActionEvent evt) {
        this.wizardDataNotConfirmedMissing = this.cbWizardDataNotConfirmedMissing.isSelected();
        this.reloadStatistic(false);
    }

    private void cbWizardDataConfirmedSetActionPerformed(ActionEvent evt) {
        this.wizardDataConfirmedSet = this.cbWizardDataConfirmedSet.isSelected();
        this.reloadStatistic(false);
    }

    private void tfLastXRecordsKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.updateStats();
            this.alreadyUpdated = true;
        }
    }

    private void tfLastXRecordsActionPerformed(ActionEvent evt) {
    }

    private void tfLastXRecordsFocusLost(FocusEvent evt) {
        if (!this.alreadyUpdated) {
            this.updateStats();
        }
        this.alreadyUpdated = false;
    }

    private void cbMediaInformationMissingActionPerformed(ActionEvent evt) {
        this.mediaInformationMissing = this.cbMediaInformationMissing.isSelected();
        this.reloadStatistic(false);
    }

    private void cbMediaInformationSetActionPerformed(ActionEvent evt) {
        this.mediaInformationSet = this.cbMediaInformationSet.isSelected();
        this.reloadStatistic(false);
    }

    private void cbScreencapsMissingActionPerformed(ActionEvent evt) {
        this.screencapsMissing = this.cbScreencapsMissing.isSelected();
        this.reloadStatistic(false);
    }

    private void cbScreencapsActionPerformed(ActionEvent evt) {
        this.screencaps = this.cbScreencaps.isSelected();
        this.reloadStatistic(false);
    }

    private void cbStudioMissingActionPerformed(ActionEvent evt) {
        this.studioMissing = this.cbStudioMissing.isSelected();
        this.reloadStatistic(false);
    }

    private void cbStudioSetActionPerformed(ActionEvent evt) {
        this.studioSet = this.cbStudioSet.isSelected();
        this.reloadStatistic(false);
    }

    private void cbDateOfShootMissingActionPerformed(ActionEvent evt) {
        this.dateOfShootMissing = this.cbDateOfShootMissing.isSelected();
        this.reloadStatistic(false);
    }

    private void cbDateOfShootSetActionPerformed(ActionEvent evt) {
        this.dateOfShootSet = this.cbDateOfShootSet.isSelected();
        this.reloadStatistic(false);
    }

    private void cbPersonsAssociatedMissingActionPerformed(ActionEvent evt) {
        this.personsAssociatedMissing = this.cbPersonsAssociatedMissing.isSelected();
        this.reloadStatistic(false);
    }

    private void cbPersonsAssociatedActionPerformed(ActionEvent evt) {
        this.personsAssociated = this.cbPersonsAssociated.isSelected();
        this.reloadStatistic(false);
    }

    private void cbMoviesWithAssociatedScenesMissingActionPerformed(ActionEvent evt) {
        this.associatedScenesMissing = this.cbMoviesWithAssociatedScenesMissing.isSelected();
        this.reloadStatistic(false);
    }

    private void cbMoviesWithAssociatedScenesActionPerformed(ActionEvent evt) {
        this.associatedScenes = this.cbMoviesWithAssociatedScenes.isSelected();
        this.reloadStatistic(false);
    }

    private void cbAssociatedMovieFilesMissingActionPerformed(ActionEvent evt) {
        this.associatedMoviesMissing = this.cbAssociatedMovieFilesMissing.isSelected();
        this.reloadStatistic(false);
    }

    private void cbAssociatedMovieFilesActionPerformed(ActionEvent evt) {
        this.associatedMovies = this.cbAssociatedMovieFiles.isSelected();
        this.reloadStatistic(false);
    }

    private void cbHashedFilesMissingActionPerformed(ActionEvent evt) {
        this.hashedFilesMissing = this.cbHashedFilesMissing.isSelected();
        this.reloadStatistic(false);
    }

    private void cbHashedFilesActionPerformed(ActionEvent evt) {
        this.hashedFiles = this.cbHashedFiles.isSelected();
        this.reloadStatistic(false);
    }

    private void cbSceneLengthMissingActionPerformed(ActionEvent evt) {
        this.sceneLengthMissing = this.cbSceneLengthMissing.isSelected();
        this.startReloadStatistic(false);
    }

    private void cbSceneLengthSetActionPerformed(ActionEvent evt) {
        this.sceneLengthSet = this.cbSceneLengthSet.isSelected();
        this.startReloadStatistic(false);
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        this.startReloadStatistic(true);
    }

    private void cbNationalityActionPerformed(ActionEvent evt) {
        this.toggleCheckboxes();
    }

    private void cbAppearanceActionPerformed(ActionEvent evt) {
        this.toggleCheckboxes();
    }

    private void cbRuntimeActionPerformed(ActionEvent evt) {
        this.toggleCheckboxes();
    }

    private void cbIcameActionPerformed(ActionEvent evt) {
        this.toggleCheckboxes();
    }

    private void tfLimitKeyTyped(KeyEvent evt) {
    }

    private void tfLimitKeyPressed(KeyEvent evt) {
        this.comboTopX.setEnabled(this.tfLimit.getText().isBlank());
    }

    private void updateStats() {
        try {
            this.showRecords = Integer.parseInt(this.tfLastXRecords.getText());
        }
        catch (NumberFormatException ex) {
            this.showRecords = 10;
        }
        this.reloadStatistic(false);
    }

    private void highlight() {
        if (this.tfHighlight.getText().length() >= 2) {
            String[] split;
            this.lbAppearances.setText(this.htmlAppearances.replaceAll("(?i)" + this.tfHighlight.getText(), "<b><font color=\"red\">" + this.tfHighlight.getText() + "</b></font>"));
            this.lbICame.setText(this.htmlICame.replaceAll("(?i)" + this.tfHighlight.getText(), "<b><font color=\"red\">" + this.tfHighlight.getText() + "</b></font>"));
            this.lbRuntime.setText(this.htmlRuntime.replaceAll("(?i)" + this.tfHighlight.getText(), "<b><font color=\"red\">" + this.tfHighlight.getText() + "</b></font>"));
            Object tmpNationality = "";
            for (String s : split = this.htmlNationality.split(" ")) {
                LOG.info("s: " + s);
                tmpNationality = s.contains(".png") ? (String)tmpNationality + " " + s : (String)tmpNationality + " " + s.replaceAll("(?i)" + this.tfHighlight.getText(), "<b><font color=\"red\">" + this.tfHighlight.getText() + "</b></font>");
            }
            this.lbNationality.setText(((String)tmpNationality).trim());
        }
    }

    private void initTopX() {
        ArrayList<ProgressRunnable> tasks = new ArrayList<ProgressRunnable>();
        tasks.add(ph -> {
            ph.progress("Calculating the top lists... that might take a bit");
            Integer top = (Integer)this.comboTopX.getSelectedItem();
            if (!this.tfLimit.getText().isBlank()) {
                top = ScenerixxCommon.parseInt(this.tfLimit.getText());
            }
            this.initTopX(top);
            this.firstInit = false;
            return null;
        });
        Integer top = (Integer)this.comboTopX.getSelectedItem();
        if (!this.tfLimit.getText().isBlank()) {
            top = ScenerixxCommon.parseInt(this.tfLimit.getText());
        }
        BaseProgressUtils.showProgressDialogAndRun(ph -> {
            for (ProgressRunnable task : tasks) {
                task.run(ph);
            }
            return null;
        }, (String)("Calculating Top " + top), (boolean)true);
    }

    public void setDirty() {
        this.lbOutOfDate.setVisible(true);
    }

    public void startReloadStatistic(boolean saveNewCopy) {
        this.lbOutOfDate.setVisible(false);
        ArrayList<ProgressRunnable> tasks = new ArrayList<ProgressRunnable>();
        tasks.add(ph -> {
            ph.progress("Crunching some numbers... that might take a bit");
            this.reloadStatistic(saveNewCopy);
            WindowManager.getDefault().invokeWhenUIReady(() -> this.updateStats());
            return null;
        });
        BaseProgressUtils.showProgressDialogAndRun(ph -> {
            for (ProgressRunnable task : tasks) {
                task.run(ph);
            }
            return null;
        }, (String)"Reloading statistic", (boolean)true);
    }

    public void reloadStatistic(boolean saveNewCopy) {
        LOG.info("Reload statistic. Save copy: " + saveNewCopy);
        if (saveNewCopy) {
            Scenerixx.statisticInternal = this.scenerixxCommon.readStatisticInternalAndSaveCopy();
        }
        this.saveSettings();
        this.removeAll();
        this.initEverything();
        this.btnReload.setText("Reload & Save");
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            StatusDisplayer.getDefault().setStatusText("");
            this.lbUserLastXRecords.setText("finished calculating");
        });
    }

    private void initChart() {
        ArrayList<Integer> ySet;
        ArrayList<Date> xSet;
        ArrayList<Integer> yDataSceneLengthSet;
        ArrayList<Date> xDataSceneLengthSet;
        List stats = this.db.getEntityService().find((EntityPathBase)QStatisticInternal.statisticInternal).order(new Function[]{f -> f.dateOfCreation.desc()}).find((long)this.showRecords);
        if (stats.isEmpty()) {
            Scenerixx.statisticInternal = this.scenerixxCommon.readStatisticInternalAndSaveCopy();
            stats.add(Scenerixx.statisticInternal);
        }
        this.chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(700)).height(600)).title("Your collection in numbers")).xAxisTitle("Date").yAxisTitle("Amount").build();
        ((XYStyler)this.chart.getStyler()).setLegendPosition(Styler.LegendPosition.OutsideS);
        ((XYStyler)this.chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
        if (this.hashedFiles) {
            ArrayList<Date> xDataHashedFile = new ArrayList<Date>();
            ArrayList<Integer> yDataHashedFile = new ArrayList<Integer>();
            for (StatisticInternal s : stats) {
                xDataHashedFile.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    yDataHashedFile.add(s.getHashedFileCompletedWithSecrets());
                    continue;
                }
                yDataHashedFile.add(s.getHashedFileCompletedWithoutSecrets());
            }
            this.addSeriesAndTooltips(xDataHashedFile, yDataHashedFile, "Hashed files", XChartSeriesColors.GREEN, XChartSeriesColors.GREEN, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.hashedFilesMissing) {
            ArrayList<Date> xDataHashedFileMissing = new ArrayList<Date>();
            ArrayList<Integer> yDataHashedFileMissing = new ArrayList<Integer>();
            for (StatisticInternal s : stats) {
                xDataHashedFileMissing.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    yDataHashedFileMissing.add(s.getHashedFileMissingWithSecrets());
                    continue;
                }
                yDataHashedFileMissing.add(s.getHashedFileMissingWithoutSecrets());
            }
            this.addSeriesAndTooltips(xDataHashedFileMissing, yDataHashedFileMissing, "Hashed files missing", XChartSeriesColors.GREEN, XChartSeriesColors.RED, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
        }
        if (this.associatedMovies) {
            xDataSceneLengthSet = new ArrayList<Date>();
            yDataSceneLengthSet = new ArrayList<Integer>();
            for (StatisticInternal s : stats) {
                xDataSceneLengthSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    yDataSceneLengthSet.add(s.getAssociatedMovieFilesCompletedWithSecrets());
                    continue;
                }
                yDataSceneLengthSet.add(s.getAssociatedMovieFilesCompletedWithoutSecrets());
            }
            this.addSeriesAndTooltips(xDataSceneLengthSet, yDataSceneLengthSet, "Associated movie files", XChartSeriesColors.BLUE, XChartSeriesColors.GREEN, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.associatedMoviesMissing) {
            xDataSceneLengthSet = new ArrayList();
            yDataSceneLengthSet = new ArrayList();
            for (StatisticInternal s : stats) {
                xDataSceneLengthSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    yDataSceneLengthSet.add(s.getAssociatedMovieFilesMissingWithSecrets());
                    continue;
                }
                yDataSceneLengthSet.add(s.getAssociatedMovieFilesMissingWithoutSecrets());
            }
            this.addSeriesAndTooltips(xDataSceneLengthSet, yDataSceneLengthSet, "Associated movie files missing", XChartSeriesColors.BLUE, XChartSeriesColors.RED, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
        }
        if (this.associatedScenes) {
            xDataSceneLengthSet = new ArrayList();
            yDataSceneLengthSet = new ArrayList();
            for (StatisticInternal s : stats) {
                xDataSceneLengthSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    yDataSceneLengthSet.add(s.getMoviesWithAssociatedScenesCompletedWithSecrects());
                    continue;
                }
                yDataSceneLengthSet.add(s.getMoviesWithAssociatedScenesCompletedWithoutSecrects());
            }
            this.addSeriesAndTooltips(xDataSceneLengthSet, yDataSceneLengthSet, "Movies with associated scenes", XChartSeriesColors.BLACK, XChartSeriesColors.GREEN, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.associatedScenesMissing) {
            xDataSceneLengthSet = new ArrayList();
            yDataSceneLengthSet = new ArrayList();
            for (StatisticInternal s : stats) {
                xDataSceneLengthSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                xDataSceneLengthSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    yDataSceneLengthSet.add(s.getMoviesWithAssociatedScenesMissingWithSecrects());
                    continue;
                }
                yDataSceneLengthSet.add(s.getMoviesWithAssociatedScenesMissingWithoutSecrects());
            }
            this.addSeriesAndTooltips(xDataSceneLengthSet, yDataSceneLengthSet, "Movies without associated scenes", XChartSeriesColors.BLACK, XChartSeriesColors.RED, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
        }
        if (this.sceneLengthSet) {
            xDataSceneLengthSet = new ArrayList();
            yDataSceneLengthSet = new ArrayList();
            for (StatisticInternal s : stats) {
                xDataSceneLengthSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    yDataSceneLengthSet.add(s.getSceneLengthSetCompletedWithSecrects());
                    continue;
                }
                yDataSceneLengthSet.add(s.getSceneLengthSetCompletedWithoutSecrects());
            }
            this.addSeriesAndTooltips(xDataSceneLengthSet, yDataSceneLengthSet, "Scene length set", XChartSeriesColors.CYAN, XChartSeriesColors.GREEN, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.sceneLengthMissing) {
            xDataSceneLengthSet = new ArrayList();
            yDataSceneLengthSet = new ArrayList();
            for (StatisticInternal s : stats) {
                xDataSceneLengthSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    yDataSceneLengthSet.add(s.getSceneLengthSetMissingWithSecrects());
                    continue;
                }
                yDataSceneLengthSet.add(s.getSceneLengthSetMissingWithoutSecrects());
            }
            this.addSeriesAndTooltips(xDataSceneLengthSet, yDataSceneLengthSet, "Missing scene length", XChartSeriesColors.CYAN, XChartSeriesColors.RED, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
        }
        if (this.personsAssociated) {
            xSet = new ArrayList<Date>();
            ySet = new ArrayList<Integer>();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getPersonsAssociatedCompletedWithSecrects());
                    continue;
                }
                ySet.add(s.getPersonsAssociatedCompletedWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Associated persons", XChartSeriesColors.BROWN, XChartSeriesColors.GREEN, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.personsAssociatedMissing) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getPersonsAssociatedMissingWithSecrects());
                    continue;
                }
                ySet.add(s.getPersonsAssociatedMissingWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Associated persons missing", XChartSeriesColors.BROWN, XChartSeriesColors.RED, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
        }
        if (this.dateOfShootSet) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getDateOfShootSetCompletedWithSecrects());
                    continue;
                }
                ySet.add(s.getDateOfShootSetCompletedWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Date of shoot set", XChartSeriesColors.MAGENTA, XChartSeriesColors.GREEN, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.dateOfShootMissing) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getDateOfShootSetMissingWithSecrects());
                    continue;
                }
                ySet.add(s.getDateOfShootSetMissingWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Date of shoot missing", XChartSeriesColors.MAGENTA, XChartSeriesColors.RED, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
        }
        if (this.studioSet) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getStudioCompletedWithSecrects());
                    continue;
                }
                ySet.add(s.getStudioCompletedWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Studio set", XChartSeriesColors.LIGHT_GREY, XChartSeriesColors.GREEN, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.studioMissing) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getStudioMissingWithSecrects());
                    continue;
                }
                ySet.add(s.getStudioMissingWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Studio missing", XChartSeriesColors.LIGHT_GREY, XChartSeriesColors.RED, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
        }
        if (this.screencaps) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getScreencapsCompletedWithSecrects());
                    continue;
                }
                ySet.add(s.getScreencapsCompletedWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Generated screencaps", XChartSeriesColors.PURPLE, XChartSeriesColors.GREEN, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.screencapsMissing) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getScreencapsMissingWithSecrects());
                    continue;
                }
                ySet.add(s.getScreencapsMissingWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Missing Screencaps", XChartSeriesColors.PURPLE, XChartSeriesColors.RED, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
        }
        if (this.mediaInformationSet) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getMediaInformationCompletedWithSecrects());
                    continue;
                }
                ySet.add(s.getMediaInformationCompletedWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Media information set", XChartSeriesColors.YELLOW, XChartSeriesColors.GREEN, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.mediaInformationMissing) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getMediaInformationMissingWithSecrects());
                    continue;
                }
                ySet.add(s.getMediaInformationMissingWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Media information missing", XChartSeriesColors.YELLOW, XChartSeriesColors.RED, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
        }
        if (this.wizardDataConfirmedSet) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getWizardDataConfirmedWithSecrects());
                    continue;
                }
                ySet.add(s.getWizardDataConfirmedWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Wizard generated data confirmed", XChartSeriesColors.MAGENTA, XChartSeriesColors.ORANGE, SeriesMarkers.CIRCLE, SeriesLines.SOLID);
        }
        if (this.wizardDataNotConfirmedMissing) {
            xSet = new ArrayList();
            ySet = new ArrayList();
            for (StatisticInternal s : stats) {
                xSet.add(Date.from(s.getDateOfCreation().atZone(ZoneId.systemDefault()).toInstant()));
                if (Scenerixx.unlocked) {
                    ySet.add(s.getWizardDataNotConfirmedWithSecrects());
                    continue;
                }
                ySet.add(s.getWizardDataNotConfirmedWithoutSecrects());
            }
            this.addSeriesAndTooltips(xSet, ySet, "Wizard generated data not confirmed", XChartSeriesColors.ORANGE, XChartSeriesColors.PINK, SeriesMarkers.DIAMOND, SeriesLines.SOLID);
            ArrayList<Date> xSetHigh = new ArrayList<Date>();
            ArrayList<Integer> ySetHigh = new ArrayList<Integer>();
            ySetHigh.add(Collections.max(ySet));
            xSetHigh.add(Collections.min(xSet));
            ySetHigh.add(Collections.max(ySet));
            xSetHigh.add(Collections.max(xSet));
            XYSeries seriesMissingHigh = this.chart.addSeries("Wizard generated data not confirmed - high", xSetHigh, ySetHigh);
            seriesMissingHigh.setLineColor(XChartSeriesColors.LIGHT_GREY);
            seriesMissingHigh.setMarkerColor(Color.LIGHT_GRAY);
            seriesMissingHigh.setMarker(SeriesMarkers.NONE);
            seriesMissingHigh.setLineStyle(SeriesLines.DASH_DOT);
            ArrayList<Date> xSetLow = new ArrayList<Date>();
            ArrayList<Integer> ySetLow = new ArrayList<Integer>();
            ySetLow.add(Collections.min(ySet));
            xSetLow.add(Collections.min(xSet));
            ySetLow.add(Collections.min(ySet));
            xSetLow.add(Collections.max(xSet));
            XYSeries seriesMissingLow = this.chart.addSeries("Wizard generated data not confirmed - low", xSetLow, ySetLow);
            seriesMissingLow.setLineColor(XChartSeriesColors.LIGHT_GREY);
            seriesMissingLow.setMarkerColor(Color.LIGHT_GRAY);
            seriesMissingLow.setMarker(SeriesMarkers.NONE);
            seriesMissingLow.setLineStyle(SeriesLines.DASH_DASH);
        }
        this.panelChart = new XChartPanel((Chart)this.chart);
    }

    private void addSeriesAndTooltips(List<Date> xDataHashedFile, List<Integer> yDataHashedFile, String seriesName, Color lineColor, Color markerColor, Marker marker, BasicStroke lineStyle) {
        XYSeries seriesHashedFile = this.chart.addSeries(seriesName, xDataHashedFile, yDataHashedFile);
        seriesHashedFile.setLineColor(lineColor);
        seriesHashedFile.setMarkerColor(markerColor);
        seriesHashedFile.setMarker(marker);
        seriesHashedFile.setLineStyle(lineStyle);
        this.addTooltips(yDataHashedFile, xDataHashedFile, seriesHashedFile);
    }

    private void addTooltips(List<Integer> yDataHashedFile, List<Date> xDataHashedFile, XYSeries seriesHashedFile) {
        ArrayList<CallSite> tooltips = new ArrayList<CallSite>();
        for (int i = 0; i < yDataHashedFile.size(); ++i) {
            try {
                if (i == yDataHashedFile.size() - 1) {
                    tooltips.add((CallSite)((Object)(this.df2.format(yDataHashedFile.get(i)) + " - " + this.sdf.format(xDataHashedFile.get(i)))));
                } else {
                    double diffChange = (100.0 - Double.valueOf(yDataHashedFile.get(i).intValue()) * 100.0 / Double.valueOf(yDataHashedFile.get(i + 1).intValue())) * -1.0;
                    if (diffChange == 0.0) {
                        diffChange *= -1.0;
                    }
                    int absChange = yDataHashedFile.get(i) - yDataHashedFile.get(i + 1);
                    tooltips.add((CallSite)((Object)(this.df2.format(yDataHashedFile.get(i)) + " (Diff: " + absChange + " / " + this.df.format(diffChange) + "%) - " + this.sdf.format(xDataHashedFile.get(i)))));
                }
                LOG.finer("Add tooltip " + i + " " + (String)tooltips.get(i));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        String[] tooltipsArray = (String[])Arrays.stream(tooltips.toArray()).toArray(String[]::new);
        seriesHashedFile.setToolTips(tooltipsArray);
        seriesHashedFile.setCustomToolTips(true);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void saveSettings() {
        StatisticInternalSettings statSettings = (StatisticInternalSettings)this.db.getEntityService().find((EntityPathBase)QStatisticInternalSettings.statisticInternalSettings).findFirst();
        if (statSettings == null) {
            statSettings = new StatisticInternalSettings();
        }
        statSettings.setAssociatedMovies(this.cbAssociatedMovieFiles.isSelected());
        statSettings.setAssociatedMoviesMissing(this.cbAssociatedMovieFilesMissing.isSelected());
        statSettings.setAssociatedScenes(this.cbMoviesWithAssociatedScenes.isSelected());
        statSettings.setAssociatedScenesMissing(this.cbMoviesWithAssociatedScenesMissing.isSelected());
        statSettings.setDateOfShootMissing(this.cbDateOfShootMissing.isSelected());
        statSettings.setDateOfShootSet(this.cbDateOfShootSet.isSelected());
        statSettings.setHashedFiles(this.cbHashedFiles.isSelected());
        statSettings.setHashedFilesMissing(this.cbHashedFilesMissing.isSelected());
        statSettings.setMediaInformationMissing(this.cbMediaInformationMissing.isSelected());
        statSettings.setMediaInformationSet(this.cbMediaInformationSet.isSelected());
        statSettings.setPersonsAssociated(this.cbPersonsAssociated.isSelected());
        statSettings.setPersonsAssociatedMissing(this.cbPersonsAssociatedMissing.isSelected());
        statSettings.setSceneLengthMissing(this.cbSceneLengthMissing.isSelected());
        statSettings.setSceneLengthSet(this.cbSceneLengthSet.isSelected());
        statSettings.setScreencaps(this.cbScreencaps.isSelected());
        statSettings.setScreencapsMissing(this.cbScreencapsMissing.isSelected());
        statSettings.setWizardDataConfirmed(this.cbWizardDataConfirmedSet.isSelected());
        statSettings.setWizardDataNotConfirmed(this.cbWizardDataNotConfirmedMissing.isSelected());
        try {
            statSettings.setShowRecords(Integer.parseInt(this.tfLastXRecords.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            statSettings.setShowRecords(20);
        }
        statSettings.setStudioMissing(this.cbStudioMissing.isSelected());
        statSettings.setStudioSet(this.cbStudioSet.isSelected());
        this.db.getEntityService().save((AbstractEntity)statSettings);
    }

    private void loadSettings() {
        StatisticInternalSettings statSettings = (StatisticInternalSettings)this.db.getEntityService().find((EntityPathBase)QStatisticInternalSettings.statisticInternalSettings).findFirst();
        if (statSettings == null) {
            statSettings = new StatisticInternalSettings();
        }
        this.cbAssociatedMovieFiles.setSelected(statSettings.isAssociatedMovies());
        this.cbAssociatedMovieFilesMissing.setSelected(statSettings.isAssociatedMoviesMissing());
        this.cbMoviesWithAssociatedScenes.setSelected(statSettings.isAssociatedScenes());
        this.cbMoviesWithAssociatedScenesMissing.setSelected(statSettings.isAssociatedScenesMissing());
        this.cbDateOfShootMissing.setSelected(statSettings.isDateOfShootMissing());
        this.cbDateOfShootSet.setSelected(statSettings.isDateOfShootSet());
        this.cbHashedFiles.setSelected(statSettings.isHashedFiles());
        this.cbHashedFilesMissing.setSelected(statSettings.isHashedFilesMissing());
        this.cbMediaInformationMissing.setSelected(statSettings.isMediaInformationMissing());
        this.cbMediaInformationSet.setSelected(statSettings.isMediaInformationSet());
        this.cbPersonsAssociated.setSelected(statSettings.isPersonsAssociated());
        this.cbPersonsAssociatedMissing.setSelected(statSettings.isPersonsAssociatedMissing());
        this.cbSceneLengthMissing.setSelected(statSettings.isSceneLengthMissing());
        this.cbSceneLengthSet.setSelected(statSettings.isSceneLengthSet());
        this.cbScreencaps.setSelected(statSettings.isScreencaps());
        this.cbScreencapsMissing.setSelected(statSettings.isScreencapsMissing());
        this.tfLastXRecords.setText("" + statSettings.getShowRecords());
        this.cbStudioMissing.setSelected(statSettings.isStudioMissing());
        this.cbStudioSet.setSelected(statSettings.isStudioSet());
        this.cbWizardDataConfirmedSet.setSelected(statSettings.isWizardDataConfirmed());
        this.cbWizardDataNotConfirmedMissing.setSelected(statSettings.isWizardDataNotConfirmed());
        this.sceneLengthSet = this.cbSceneLengthSet.isSelected();
        this.sceneLengthMissing = this.cbSceneLengthMissing.isSelected();
        this.hashedFiles = this.cbHashedFiles.isSelected();
        this.hashedFilesMissing = this.cbHashedFilesMissing.isSelected();
        this.associatedMovies = this.cbAssociatedMovieFiles.isSelected();
        this.associatedMoviesMissing = this.cbAssociatedMovieFilesMissing.isSelected();
        this.associatedScenes = this.cbMoviesWithAssociatedScenes.isSelected();
        this.associatedScenesMissing = this.cbMoviesWithAssociatedScenesMissing.isSelected();
        this.personsAssociated = this.cbPersonsAssociated.isSelected();
        this.personsAssociatedMissing = this.cbPersonsAssociatedMissing.isSelected();
        this.dateOfShootSet = this.cbDateOfShootSet.isSelected();
        this.dateOfShootMissing = this.cbDateOfShootMissing.isSelected();
        this.studioSet = this.cbStudioSet.isSelected();
        this.studioMissing = this.cbStudioMissing.isSelected();
        this.screencaps = this.cbScreencaps.isSelected();
        this.screencapsMissing = this.cbScreencapsMissing.isSelected();
        this.mediaInformationSet = this.cbMediaInformationSet.isSelected();
        this.mediaInformationMissing = this.cbMediaInformationMissing.isSelected();
        this.wizardDataConfirmedSet = this.cbWizardDataConfirmedSet.isSelected();
        this.wizardDataNotConfirmedMissing = this.cbWizardDataNotConfirmedMissing.isSelected();
    }
}

