/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.person.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.awt.NotificationDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.Importer;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;

public class ImportPersonAction
extends NodeAction
implements Presenter.Popup {
    private DB db = DB.getInstance();

    public ImportPersonAction() {
        Image image = ImageUtilities.loadImage((String)"icons/Download.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] selectedNodes) {
        block5: {
            Importer imp = new Importer();
            JFileChooser jFileChooser1 = new JFileChooser();
            jFileChooser1.setCurrentDirectory(new File(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirPersons).getAbsoluteFile());
            int ret = jFileChooser1.showOpenDialog(null);
            if (ret == 0) {
                PersonListTopComponent.LOG.info("User selected a file to import: " + String.valueOf(jFileChooser1.getSelectedFile()));
                try {
                    Person p = imp.importPersonFile(jFileChooser1.getSelectedFile().getAbsolutePath(), false);
                    if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)p.getName())).count() > 0L) {
                        AbstractTopComponent.notifyError("There is already a person with the name " + p.getName() + ". I cannot handle this. Either delete the existing person or rename the person to import.");
                        break block5;
                    }
                    this.db.getEntityService().save((AbstractEntity)p);
                    AbstractTopComponent.reloadPersonList();
                    JOptionPane.showMessageDialog(null, " Imported " + p.getName());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
            } else {
                PersonListTopComponent.LOG.fine("User cancelled import.");
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Import Person";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    protected boolean asynchronous() {
        return false;
    }
}

