/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.notes;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.note.Note;
import xxx.scenerixx.scenerixxlib.note.QNote;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.NoteListRenderer;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.notes.Bundle;

@TopComponent.Description(preferredID="NotesTopComponent", iconBase="icons/Comment.png", persistenceType=0)
public final class NotesTopComponent
extends AbstractTopComponent {
    private static final Logger LOG = Logger.getLogger(NotesTopComponent.class.getName());
    private DB db = DB.getInstance();
    private Note currentNote;
    private Note currentEditedNote;
    boolean unsaved = false;
    private JButton btnDelete;
    private ButtonGroup btnGrpOrderBy;
    private JButton btnNew;
    private JButton btnSave;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList<String> listNotes;
    private JRadioButton rbCreated;
    private JRadioButton rbLastModification;
    private JRadioButton rbTitle;
    private JTextArea taNote;
    private JTextField tfTitle;

    public NotesTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_NotesTopComponent());
        this.setToolTipText(Bundle.HINT_NotesTopComponent());
        this.listNotes.setCellRenderer(new NoteListRenderer(this.listNotes.getBackground()));
        KeyStroke keySave = KeyStroke.getKeyStroke(83, 2);
        AbstractAction performSave = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotesTopComponent.this.saveNote();
            }
        };
        this.btnSave.setAction(performSave);
        this.btnSave.getActionMap().put("performSaveNote", performSave);
        this.btnSave.getInputMap(2).put(keySave, "performSaveNote");
        this.btnSave.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/OK.png")));
        this.currentNote = (Note)this.db.getEntityService().find((EntityPathBase)QNote.note).findFirst();
        this.reloadList();
        if (this.listNotes.getModel().getSize() > 0 && this.listNotes.getModel().getElementAt(0) != null) {
            this.listNotes.setSelectedIndex(0);
            this.currentNote = (Note)this.db.getEntityService().find((EntityPathBase)QNote.note).filter(f -> f.title.eq((Object)this.listNotes.getModel().getElementAt(0))).findFirst();
            this.loadNote(this.currentNote);
        }
    }

    private void initComponents() {
        this.btnGrpOrderBy = new ButtonGroup();
        this.btnNew = new JButton();
        this.btnSave = new JButton();
        this.btnDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.listNotes = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.taNote = new JTextArea();
        this.tfTitle = new JTextField();
        this.rbTitle = new JRadioButton();
        this.rbLastModification = new JRadioButton();
        this.rbCreated = new JRadioButton();
        this.btnNew.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Add.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNew, (String)NbBundle.getMessage(NotesTopComponent.class, (String)"NotesTopComponent.btnNew.text"));
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTopComponent.this.btnNewActionPerformed(evt);
            }
        });
        this.btnSave.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/OK.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave, (String)NbBundle.getMessage(NotesTopComponent.class, (String)"NotesTopComponent.btnSave.text"));
        this.btnSave.setToolTipText(NbBundle.getMessage(NotesTopComponent.class, (String)"NotesTopComponent.btnSave.toolTipText"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTopComponent.this.btnSaveActionPerformed(evt);
            }
        });
        this.btnDelete.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Erase.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelete, (String)NbBundle.getMessage(NotesTopComponent.class, (String)"NotesTopComponent.btnDelete.text"));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTopComponent.this.btnDeleteActionPerformed(evt);
            }
        });
        this.listNotes.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.listNotes.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NotesTopComponent.this.listNotesPropertyChange(evt);
            }
        });
        this.listNotes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                NotesTopComponent.this.listNotesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listNotes);
        this.taNote.setColumns(20);
        this.taNote.setRows(5);
        this.taNote.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NotesTopComponent.this.taNoteKeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.taNote);
        this.tfTitle.setText(NbBundle.getMessage(NotesTopComponent.class, (String)"NotesTopComponent.tfTitle.text"));
        this.tfTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTopComponent.this.tfTitleActionPerformed(evt);
            }
        });
        this.tfTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NotesTopComponent.this.tfTitleKeyTyped(evt);
            }
        });
        this.btnGrpOrderBy.add(this.rbTitle);
        Mnemonics.setLocalizedText((AbstractButton)this.rbTitle, (String)NbBundle.getMessage(NotesTopComponent.class, (String)"NotesTopComponent.rbTitle.text"));
        this.rbTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTopComponent.this.rbTitleActionPerformed(evt);
            }
        });
        this.btnGrpOrderBy.add(this.rbLastModification);
        this.rbLastModification.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbLastModification, (String)NbBundle.getMessage(NotesTopComponent.class, (String)"NotesTopComponent.rbLastModification.text"));
        this.rbLastModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTopComponent.this.rbLastModificationActionPerformed(evt);
            }
        });
        this.btnGrpOrderBy.add(this.rbCreated);
        Mnemonics.setLocalizedText((AbstractButton)this.rbCreated, (String)NbBundle.getMessage(NotesTopComponent.class, (String)"NotesTopComponent.rbCreated.text"));
        this.rbCreated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTopComponent.this.rbCreatedActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addComponent(this.btnNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbCreated).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbLastModification).addGap(0, 43, Short.MAX_VALUE)).addComponent(this.tfTitle)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNew).addComponent(this.btnSave).addComponent(this.btnDelete).addComponent(this.rbTitle).addComponent(this.rbLastModification).addComponent(this.rbCreated)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 156, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 66, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        this.deleteNote();
    }

    private void deleteNote() {
        if (0 == JOptionPane.showConfirmDialog(null, "Delete the note '" + this.currentNote.getTitle() + "'?", "Delete note?", 0)) {
            this.db.getEntityService().delete((AbstractEntity)this.currentNote);
            this.currentNote = null;
            this.unsetUnsaved();
            this.reloadList();
        }
    }

    private void unsetUnsaved() {
        this.unsaved = false;
        this.setName("Notes");
        this.currentEditedNote = null;
    }

    private void setUnsaved() {
        this.unsaved = true;
        this.setName("Notes *");
        this.currentEditedNote = this.currentNote;
    }

    private void tfTitleActionPerformed(ActionEvent evt) {
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        this.createNewNote();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        this.saveNote();
    }

    private void listNotesValueChanged(ListSelectionEvent evt) {
        LOG.finest("list value changed");
        if (this.listNotes.getSelectedValue() != null) {
            LOG.fine("listNotes.getSelectedValue(): " + this.listNotes.getSelectedValue());
            this.currentNote = (Note)this.db.getEntityService().find((EntityPathBase)QNote.note).filter(f -> f.title.eq((Object)this.listNotes.getSelectedValue())).findFirst();
        }
        if (this.currentNote != null) {
            this.reloadList();
        }
    }

    private void listNotesPropertyChange(PropertyChangeEvent evt) {
    }

    private void rbTitleActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void rbCreatedActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void rbLastModificationActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void taNoteKeyTyped(KeyEvent evt) {
        this.checkForChangingKeypress(evt);
    }

    private void tfTitleKeyTyped(KeyEvent evt) {
        this.checkForChangingKeypress(evt);
    }

    private void checkForChangingKeypress(KeyEvent evt) {
        if (Character.isLetterOrDigit(evt.getKeyChar()) || evt.getKeyChar() == '\b' || evt.getKeyChar() == ' ' || evt.getKeyChar() == '\u007f' || evt.getKeyChar() == '\n') {
            this.setUnsaved();
        }
    }

    private void saveNote() {
        if (this.currentNote == null && this.db.getEntityService().find((EntityPathBase)QNote.note).filter(f -> f.title.eq((Object)this.tfTitle.getText())).findFirst() != null) {
            JOptionPane.showMessageDialog(null, "There is already a note with the title '" + this.tfTitle.getText() + "'. Choose another title. Note was not saved.");
        } else if (this.tfTitle.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, "You need to provide a title. Note was not saved.");
        } else {
            if (this.currentNote == null) {
                this.currentNote = new Note();
            }
            this.currentNote.setTitle(this.tfTitle.getText());
            this.currentNote.setDescription(this.taNote.getText());
            int caret = this.taNote.getCaretPosition();
            LOG.info("caret position: " + caret);
            this.currentNote = (Note)this.db.getEntityService().save((AbstractEntity)this.currentNote);
            this.unsetUnsaved();
            NotesTopComponent.notifyInfo("Saved note");
            this.reloadList();
            this.taNote.setCaretPosition(caret);
        }
    }

    private void loadNote(Note note) {
        this.askForSavingChanges();
        if (note != null) {
            this.btnDelete.setEnabled(true);
            this.currentNote = note;
            this.taNote.setText(note.getDescription());
            this.tfTitle.setText(note.getTitle());
            if (note.getTitle() != null) {
                for (int i = 0; i < this.listNotes.getModel().getSize(); ++i) {
                    if (!note.getTitle().equals(this.listNotes.getModel().getElementAt(i))) continue;
                    this.listNotes.setSelectedIndex(i);
                }
            }
            this.unsetUnsaved();
        } else {
            this.taNote.setText("");
            this.tfTitle.setText("");
            this.btnDelete.setEnabled(false);
            LOG.info("Could not load. Note was null");
        }
    }

    private void createNewNote() {
        this.askForSavingChanges();
        Note note = new Note();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        note.setTitle("[New Note " + df.format(LocalDateTime.now()) + "]");
        this.currentNote = (Note)this.db.getEntityService().save((AbstractEntity)note);
        this.unsetUnsaved();
        this.reloadList();
    }

    private void reloadList() {
        Object[] titles;
        ListSelectionListener[] listSelectionListeners;
        LOG.fine("Reload notes list");
        for (ListSelectionListener listener : listSelectionListeners = this.listNotes.getListSelectionListeners()) {
            this.listNotes.removeListSelectionListener(listener);
        }
        this.listNotes.clearSelection();
        this.db.evictCache(Note.class);
        List notes = null;
        if (this.rbTitle.isSelected()) {
            notes = this.db.getEntityService().find((EntityPathBase)QNote.note).order(new Function[]{f -> f.title.asc()}).find();
        } else if (this.rbCreated.isSelected()) {
            notes = this.db.getEntityService().find((EntityPathBase)QNote.note).order(new Function[]{f -> f.dateOfCreation.asc()}).find();
        } else if (this.rbLastModification.isSelected()) {
            notes = this.db.getEntityService().find((EntityPathBase)QNote.note).order(new Function[]{f -> f.dateOfLastModification.asc()}).find();
        }
        DefaultListModel<String> listNotesModel = new DefaultListModel<String>();
        for (Object o : titles = notes.stream().map(f -> f.getTitle()).collect(Collectors.toList()).toArray()) {
            listNotesModel.addElement((String)o);
        }
        if (this.currentNote != null) {
            this.loadNote(this.currentNote);
        } else {
            this.currentNote = (Note)this.db.getEntityService().find((EntityPathBase)QNote.note).findFirst();
            this.loadNote(this.currentNote);
        }
        this.listNotes.setModel(listNotesModel);
        for (ListSelectionListener listener : listSelectionListeners) {
            this.listNotes.addListSelectionListener(listener);
        }
    }

    @Override
    public void componentOpened() {
    }

    @Override
    public void componentClosed() {
        this.askForSavingChanges();
    }

    private void askForSavingChanges() throws HeadlessException {
        if (this.unsaved && 0 == JOptionPane.showConfirmDialog(null, "Save unsaved note '" + this.currentEditedNote.getTitle() + "'?", "Save note?", 0)) {
            LOG.info(this.currentEditedNote.getDescription());
            this.currentEditedNote.setDescription(this.taNote.getText());
            if (this.tfTitle.getText().isEmpty()) {
                this.tfTitle.setText("[New Note]");
            }
            this.currentEditedNote.setTitle(this.tfTitle.getText());
            this.currentNote = this.currentEditedNote = (Note)this.db.getEntityService().save((AbstractEntity)this.currentEditedNote);
            this.unsetUnsaved();
            this.reloadList();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        if (this.unsaved) {
            p.setProperty("title", this.tfTitle.getText());
            p.setProperty("desc", this.taNote.getText());
        } else {
            p.setProperty("title", "");
            p.setProperty("desc", "");
        }
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        if (p.getProperty("title") != null && !p.getProperty("title").isEmpty() || p.getProperty("desc") != null && !p.getProperty("desc").isEmpty()) {
            this.tfTitle.setText(p.getProperty("title"));
            this.taNote.setText(p.getProperty("desc"));
            this.currentNote = (Note)this.db.getEntityService().find((EntityPathBase)QNote.note).filter(f -> f.title.eq((Object)this.tfTitle.getText())).findFirst();
            this.setUnsaved();
        }
    }
}

