/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util.gui.panel;

import java.awt.FlowLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openide.util.ImageUtilities;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;

public class PlaylistSelectionPanel
extends JPanel {
    public static final Logger LOG = Logger.getLogger(PlaylistSelectionPanel.class.getName());
    private PlaylistService ps = new PlaylistService();
    private final JComboBox<Playlist> comboPlaylists = new JComboBox();
    private final JComboBox<String> comboOrderBy = new JComboBox();
    private boolean gainedFocusBefore;
    private static Playlist lastSelectedPlaylist = null;
    private static Boolean orderByDate = null;

    public void gainedFocus() {
        if (!this.gainedFocusBefore) {
            this.gainedFocusBefore = true;
            this.comboPlaylists.requestFocusInWindow();
        }
    }

    public PlaylistSelectionPanel() {
        super(new FlowLayout());
        this.add(new JLabel("Playlist: "));
        this.add(this.comboPlaylists);
        this.comboOrderBy.addActionListener(ae -> {
            boolean byDate = true;
            orderByDate = true;
            if (((String)this.comboOrderBy.getSelectedItem()).contains("name")) {
                byDate = false;
                orderByDate = false;
            }
            List playlists = this.ps.getPlaylists(Scenerixx.unlocked, byDate);
            Playlist[] toArray = playlists.toArray(new Playlist[playlists.size()]);
            this.comboPlaylists.setModel(new DefaultComboBoxModel<Playlist>(toArray));
            LOG.info("try to find last selected: " + String.valueOf(lastSelectedPlaylist));
            for (int i = 0; i < this.comboPlaylists.getItemCount(); ++i) {
                Playlist tmpP = this.comboPlaylists.getItemAt(i);
                if (lastSelectedPlaylist == null) break;
                if (tmpP.getId().longValue() != lastSelectedPlaylist.getId().longValue()) continue;
                this.comboPlaylists.setSelectedIndex(i);
                LOG.info("last selected found: " + String.valueOf(lastSelectedPlaylist));
                break;
            }
        });
        this.add(this.comboOrderBy);
        JButton btnCreate = new JButton("Create new playlist");
        Image image = ImageUtilities.loadImage((String)"icons/notes.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/badgeAdd.png"), (int)4, (int)4);
        btnCreate.setIcon(ImageUtilities.image2Icon((Image)image));
        this.add(btnCreate);
        btnCreate.addActionListener(evt -> {
            String showInputDialog = JOptionPane.showInputDialog("Name for the new playlist", (Object)"");
            if (showInputDialog != null) {
                if (this.ps.exists(showInputDialog)) {
                    JOptionPane.showMessageDialog(null, "You have already a playlist with this name", "Playlist already exists", 2);
                } else {
                    Playlist p = new Playlist();
                    p.setName(showInputDialog);
                    p = (Playlist)DB.getInstance().getEntityService().save((AbstractEntity)p);
                    List playlists = this.ps.getPlaylists(Scenerixx.unlocked, true);
                    Playlist[] toArray = playlists.toArray(new Playlist[playlists.size()]);
                    this.comboPlaylists.setModel(new DefaultComboBoxModel<Playlist>(toArray));
                    p = (Playlist)DB.getInstance().getEntityService().load(Playlist.class, p.getId().longValue());
                    for (int i = 0; i < this.comboPlaylists.getItemCount(); ++i) {
                        Playlist tmpP = this.comboPlaylists.getItemAt(i);
                        if (tmpP.getId().longValue() != p.getId().longValue()) continue;
                        this.comboPlaylists.setSelectedIndex(i);
                        break;
                    }
                    this.comboPlaylists.setSelectedItem(p);
                    lastSelectedPlaylist = p;
                }
            }
        });
        List playlists = this.ps.getPlaylists(Scenerixx.unlocked, true);
        Playlist[] toArray = playlists.toArray(new Playlist[playlists.size()]);
        this.comboPlaylists.setModel(new DefaultComboBoxModel<Playlist>(toArray));
        ArrayList<String> orderBy = new ArrayList<String>();
        orderBy.add("by date");
        orderBy.add("by name");
        String[] toArrayOrderBy = orderBy.toArray(new String[orderBy.size()]);
        this.comboOrderBy.setModel(new DefaultComboBoxModel<String>(toArrayOrderBy));
        if (orderByDate == null || orderByDate.booleanValue()) {
            this.comboOrderBy.setSelectedIndex(0);
        } else {
            this.comboOrderBy.setSelectedIndex(1);
        }
    }

    public Playlist getPlaylist() {
        LOG.info("Last selected: " + String.valueOf(lastSelectedPlaylist));
        lastSelectedPlaylist = (Playlist)this.comboPlaylists.getSelectedItem();
        return (Playlist)this.comboPlaylists.getSelectedItem();
    }

    public void setPlaylist(Playlist playlist) {
        LOG.info("trying to set playlist " + String.valueOf(playlist));
        if (playlist == null) {
            PlaylistService ps = new PlaylistService();
            playlist = ps.getDefaultPlaylist(Scenerixx.unlocked);
        }
        if (playlist == null) {
            this.comboPlaylists.setSelectedItem(playlist);
        } else {
            for (int i = 0; i < this.comboPlaylists.getItemCount(); ++i) {
                Playlist tmpP = this.comboPlaylists.getItemAt(i);
                if (tmpP.getId().longValue() != playlist.getId().longValue()) continue;
                this.comboPlaylists.setSelectedIndex(i);
                break;
            }
            this.comboPlaylists.setSelectedItem(playlist);
        }
    }

    public static Playlist getLastSelectedPlaylist() {
        return lastSelectedPlaylist;
    }

    public JComboBox<Playlist> getComboPlaylist() {
        return this.comboPlaylists;
    }
}

