/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.openide.util.Exceptions;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class ScreencapService {
    private static final Logger LOG = Logger.getLogger(ScreencapService.class.getName());
    private static NumberFormat formatter = new DecimalFormat("0000");

    public static boolean generateSceneScreencaps(Scene s) {
        DB db = DB.getInstance();
        ScenerixxSettings settings = db.getScenerixxSettings();
        LOG.info("*************** GENERATE SCENE SCREENCAPS *********");
        if (s.getTotalRuntime() <= 0) {
            LOG.fine("Runtime for " + s.getPosition() + " scene in movie " + s.getMovieAssociated().getTitle() + " is not known. Skip it.");
            return true;
        }
        if (Files.exists(Paths.get(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator + s.getId() + "_" + s.getPosition() + ".png", new String[0]), new LinkOption[0]) || Files.exists(Paths.get(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator + s.getId() + "_" + formatter.format(s.getPosition()) + ".png", new String[0]), new LinkOption[0])) {
            LOG.fine("Screencap for scene " + s.getPosition() + " of movie " + s.getMovieAssociated().getTitle() + " already exists");
            return true;
        }
        if (!Files.exists(Paths.get(((MediumFile)s.getStartMedium()).getFileCompletePath(), new String[0]), new LinkOption[0])) {
            LOG.fine("Cannot create screencap for " + ((MediumFile)s.getStartMedium()).getFileCompletePath() + " since the file is not available.\n");
        } else {
            LOG.fine("Generate screencap for scene " + s.getPosition() + " in movie " + s.getMovieAssociated().getTitle());
            try {
                if (s.getStartMedium().equals(s.getEndMedium())) {
                    LOG.fine("scene start and end are in the same file");
                    if (ScreencapService.createSceneTemporaryImages(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator, s, s.getId(), s.getPosition(), s.getTotalRuntime(), LocalTime.MIN.plusSeconds(s.getStartTime() + 10), settings.getScreencapPicsPerCol() * settings.getScreencapPicsPerRow(), -1, 1)) {
                        ScreencapService.stitch(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator, settings, s.getId(), s.getPosition());
                    }
                } else {
                    LOG.fine("scene start and end are NOT in the same file");
                    int totalImagesInStartMedium = settings.getScreencapPicsPerCol() * settings.getScreencapPicsPerRow();
                    int totalImagesInEndMedium = settings.getScreencapPicsPerCol() * settings.getScreencapPicsPerRow();
                    int secondsInEndMedium = s.getEndTime();
                    int secondsInStartMedium = s.getTotalRuntime() - secondsInEndMedium;
                    double percStartMedium = 100.0;
                    percStartMedium = secondsInEndMedium <= secondsInStartMedium ? (double)secondsInStartMedium / (double)(secondsInStartMedium + secondsInEndMedium) : (double)secondsInEndMedium / (double)(secondsInStartMedium + secondsInEndMedium);
                    totalImagesInStartMedium = (int)((double)totalImagesInStartMedium * percStartMedium);
                    LOG.info("percStart " + percStartMedium + " - images in startmedium: " + totalImagesInStartMedium + " - images in endmedium: " + (totalImagesInEndMedium -= totalImagesInStartMedium));
                    LOG.info("CREATE FOR START MEDIUM");
                    if (ScreencapService.createSceneTemporaryImages(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator, s, s.getId(), s.getPosition(), secondsInStartMedium, LocalTime.MIN.plusSeconds(s.getStartTime() + 10), totalImagesInStartMedium, totalImagesInEndMedium, 1)) {
                        ScreencapService.stitch(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator, settings, s.getId(), s.getPosition());
                    }
                }
            }
            catch (IOException ioe) {
                LOG.severe("io-error during stitching");
            }
        }
        return false;
    }

    public static void createMovieScreencap(Movie m, int i, int totalImages) throws IOException {
        DB db = DB.getInstance();
        List mfs = db.getMediumFilesOrderedByScene(m, true);
        LOG.info("Got " + mfs.size() + " medium files for: " + m.getTitle() + " (movie id: " + m.getId() + ")");
        boolean error = false;
        for (MediumFile mf2 : mfs) {
            if (ScreencapService.createTemporaryImages(Scenerixx.scenerixxScreencapDir + File.separator, mf2, m.getId(), ++i, mf2.getDuration() / 1000, LocalTime.of(0, 0, 10), totalImages, i - 1)) continue;
            error = true;
            break;
        }
        if (!error) {
            ScreencapService.stitch(Scenerixx.scenerixxScreencapDir + File.separator, db.getScenerixxSettings(), m.getId(), i);
        }
        LOG.info("----------- createMovieScreencaps END -----");
    }

    public static boolean createTemporaryImages(String outputPath, MediumFile mf, Long id, int index, int runtimeInSeconds, LocalTime startTime, int totalImages, int startIndex) {
        return ScreencapService.createTemporaryImages(outputPath, List.of(mf), id, index, runtimeInSeconds, startTime, totalImages, startIndex);
    }

    public static boolean createTemporaryImages(String outputPath, List<MediumFile> mfs, Long id, int index, int runtimeInSeconds, LocalTime startTime, int totalImages, int startIndex) {
        try {
            LOG.info("*** CREATE TEMPORARY IMAGES ***");
            if (mfs.size() > 1) {
                LOG.info("*** WARNING! More than one medium file***");
            }
            LOG.info("id: " + id + "\nindex: " + index + "\nruntimeInSeconds: " + runtimeInSeconds + "\nstartTime: " + String.valueOf(startTime) + "\nTotal images: " + totalImages + "\nstartIndex: " + startIndex);
            ScenerixxSettings settings = DB.getInstance().getScenerixxSettings();
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            LocalTime time = startTime;
            double totalRuntimeMovie = 0.0;
            for (MediumFile mf : DB.getInstance().getMediumFiles(mfs.get(0).getMovie(), Scenerixx.unlocked)) {
                totalRuntimeMovie += (double)(mf.getDuration() / 100);
            }
            if (totalRuntimeMovie <= 0.0) {
                LOG.severe("ABORT: We have no runtime.");
                File dir = new File(outputPath);
                WildcardFileFilter fileFilter = new WildcardFileFilter(id + "*tmp*.png");
                File[] imgFiles = dir.listFiles((FileFilter)fileFilter);
                if (imgFiles == null) {
                    LOG.info("Could not find files. Nothing to clean up");
                } else {
                    LOG.info("Clean up and return");
                    ScreencapService.deleteTemporaryImageFiles(imgFiles);
                    return false;
                }
            }
            for (MediumFile mf : mfs) {
                int totalTotalImages = settings.getScreencapPicsPerCol() * settings.getScreencapPicsPerRow();
                LOG.info("total total images  " + totalTotalImages);
                LOG.info("total runtinme  " + totalRuntimeMovie);
                double percentageMfFromTotalRuntime = (double)(mf.getDuration() / 100) / totalRuntimeMovie;
                LOG.info("percentageMfFromTotalRuntime " + percentageMfFromTotalRuntime);
                int imagesPerMediumFile = (int)((double)totalTotalImages * percentageMfFromTotalRuntime);
                if (imagesPerMediumFile == 0) {
                    imagesPerMediumFile = 1;
                }
                LOG.info("imagesPerMediumFile " + imagesPerMediumFile);
                int interval = (runtimeInSeconds - 11) / imagesPerMediumFile;
                if (interval <= 0) {
                    LOG.warning("Calculated was: " + interval + ". Set to 1.");
                    interval = 1;
                }
                int i = startIndex;
                LOG.info("interval: " + interval + " | totalImages / mfs.size() = " + totalImages / mfs.size());
                boolean correctedOutOfRangeAlready = false;
                for (int k = 1; k <= imagesPerMediumFile; ++k) {
                    String timestamp = timeFormatter.format(time);
                    if (time.getHour() * 60 * 60 + time.getMinute() * 60 + time.getSecond() > mf.getTotalRuntime()) {
                        if (correctedOutOfRangeAlready) break;
                        LOG.info("Out of range: time: " + timestamp + " - total runtime: " + mf.getTotalRuntime());
                        time = LocalTime.of(mf.getTotalRuntime() / 3600 % 24, mf.getTotalRuntime() / 60 % 60, mf.getTotalRuntime() % 60);
                        time = time.minusSeconds(10L);
                        timestamp = timeFormatter.format(time);
                        LOG.info("new time: " + String.valueOf(time));
                        correctedOutOfRangeAlready = true;
                    }
                    LOG.finer("Current timestamp: " + timestamp + " k: " + k);
                    String outputfile = outputPath + id + "_" + formatter.format(index) + "_tmp_" + formatter.format(i) + ".png";
                    ++i;
                    ArrayList<Object> paras = new ArrayList<Object>();
                    paras.add(settings.getPathToFfmpeg() + "ffmpeg");
                    paras.add("-ss");
                    paras.add(timestamp);
                    paras.add("-i");
                    paras.add(mf.getFileCompletePath());
                    paras.add("-vf");
                    if (mf.getWidth() < mf.getHeight()) {
                        paras.add("scale=-1:" + settings.getScreencapHeight());
                    } else {
                        paras.add("scale=" + settings.getScreencapWidth() + ":" + settings.getScreencapHeight());
                    }
                    paras.add("-threads");
                    paras.add("1");
                    paras.add("-nostdin");
                    paras.add("-frames:v");
                    paras.add("1");
                    paras.add(outputfile);
                    String[] tmpParas = (String[])paras.toArray(String[]::new);
                    try {
                        LOG.finer("Calling FFmpeg with following parameters: " + paras.stream().map(x -> x).collect(Collectors.joining(", ")));
                        Process processDuration = new ProcessBuilder(tmpParas).redirectErrorStream(true).start();
                        processDuration.waitFor(10L, TimeUnit.SECONDS);
                    }
                    catch (IOException | InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        LOG.severe("Could not create screencaps. Make sure FFmpeg can be found in the classpath or configure it's path in the options. " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    time = time.plusSeconds(interval);
                }
                ++index;
                time = startTime;
            }
        }
        catch (Exception ex) {
            LOG.severe("Could not create temporary image: " + ex.getMessage() + "\nStarttime: " + String.valueOf(startTime) + " - runtime: " + runtimeInSeconds + " - totalImages: " + totalImages + " - id: " + id + " - outputpath: " + outputPath + " - mfs: " + mfs.size() + " - mf(0): " + (mfs.isEmpty() ? "null" : mfs.get(0).getFileCompletePath()));
            ex.printStackTrace();
        }
        LOG.info("----------- createTemporaryImages END -----");
        return true;
    }

    public static boolean createSceneTemporaryImages(String outputPath, Scene scene, Long id, int index, int runtimeInSeconds, LocalTime startTime, int totalImagesStart, int totalImagesEnd, int startIndex) {
        try {
            ArrayList<MediumFile> mfs = new ArrayList<MediumFile>();
            LOG.info("*** CREATE TEMPORARY IMAGES FOR A SCENE ***");
            if (mfs.size() > 1) {
                LOG.info("*** WARNING! More than one medium file***");
            }
            LOG.info("id: " + id + "\nindex: " + index + "\nruntimeInSeconds: " + runtimeInSeconds + "\nstartTime: " + String.valueOf(startTime) + "\nTotal images: " + totalImagesStart + "\nstartIndex: " + startIndex);
            mfs.clear();
            mfs.add((MediumFile)scene.getStartMedium());
            if (scene.getEndMedium() != null && !scene.getStartMedium().equals(scene.getEndMedium())) {
                mfs.add((MediumFile)scene.getEndMedium());
            }
            ScenerixxSettings settings = DB.getInstance().getScenerixxSettings();
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            LocalTime time = startTime;
            int currentMfIndex = 0;
            for (MediumFile mf : mfs) {
                if (currentMfIndex > 0) {
                    totalImagesStart = totalImagesEnd;
                    time = LocalTime.of(0, 0, 13);
                }
                LOG.info("mf: " + mf.getFileCompletePath() + " - duration: " + mf.getDuration());
                int totalTotalImages = settings.getScreencapPicsPerCol() * settings.getScreencapPicsPerRow();
                LOG.info("total total images  " + totalTotalImages);
                int interval = -1;
                interval = (runtimeInSeconds - 11) / totalImagesStart;
                if (currentMfIndex > 0) {
                    int secInSTartMedium = scene.getStartMedium().getDuration() / 1000 - scene.getStartTime();
                    int secInEndMedium = scene.getTotalRuntime() - secInSTartMedium;
                    interval = (secInEndMedium - 11) / totalImagesEnd;
                }
                if (interval <= 0) {
                    LOG.warning("Calculated was: " + interval + ". Set to 1.");
                    interval = 1;
                }
                int i = startIndex;
                LOG.info("interval: " + interval + " | totalImages / mfs.size() = " + totalImagesStart / mfs.size());
                boolean correctedOutOfRangeAlready = false;
                for (int k = 1; k <= totalImagesStart; ++k) {
                    String timestamp = timeFormatter.format(time);
                    if (time.getHour() * 60 * 60 + time.getMinute() * 60 + time.getSecond() > mf.getTotalRuntime()) {
                        if (correctedOutOfRangeAlready) break;
                        LOG.info("Out of range: time: " + timestamp + " - total runtime: " + mf.getTotalRuntime());
                        time = LocalTime.of(mf.getTotalRuntime() / 3600 % 24, mf.getTotalRuntime() / 60 % 60, mf.getTotalRuntime() % 60);
                        time = time.minusSeconds(10L);
                        timestamp = timeFormatter.format(time);
                        LOG.info("new time: " + String.valueOf(time));
                        correctedOutOfRangeAlready = true;
                    }
                    LOG.fine("Current timestamp: " + timestamp + " k: " + k);
                    String outputfile = outputPath + id + "_" + formatter.format(index) + "_tmp_" + formatter.format(i) + ".png";
                    ++i;
                    ArrayList<Object> paras = new ArrayList<Object>();
                    paras.add(settings.getPathToFfmpeg() + "ffmpeg");
                    paras.add("-ss");
                    paras.add(timestamp);
                    paras.add("-i");
                    paras.add(mf.getFileCompletePath());
                    paras.add("-vf");
                    if (mf.getWidth() < mf.getHeight()) {
                        paras.add("scale=-1:" + settings.getScreencapHeight());
                    } else {
                        paras.add("scale=" + settings.getScreencapWidth() + ":" + settings.getScreencapHeight());
                    }
                    paras.add("-threads");
                    paras.add("1");
                    paras.add("-nostdin");
                    paras.add("-frames:v");
                    paras.add("1");
                    paras.add(outputfile);
                    String[] tmpParas = (String[])paras.toArray(String[]::new);
                    try {
                        LOG.finer("Calling FFmpeg with following parameters: " + paras.stream().map(x -> x).collect(Collectors.joining(", ")));
                        Process processDuration = new ProcessBuilder(tmpParas).redirectErrorStream(true).start();
                        processDuration.waitFor(10L, TimeUnit.SECONDS);
                    }
                    catch (IOException | InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        LOG.severe("Could not create screencaps. Make sure FFmpeg can be found in the classpath or configure it's path in the options. " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    time = time.plusSeconds(interval);
                }
                ++index;
                time = startTime;
                correctedOutOfRangeAlready = false;
                ++currentMfIndex;
            }
        }
        catch (Exception ex) {
            LOG.severe("Could not create temporary image: " + ex.getMessage() + "\nStarttime: " + String.valueOf(startTime) + " - runtime: " + runtimeInSeconds + " - totalImages: " + totalImagesStart + " - id: " + id + " - outputpath: " + outputPath);
            ex.printStackTrace();
        }
        LOG.info("----------- createSceneTemporaryImages END -----");
        return true;
    }

    public static void stitch(String path, ScenerixxSettings settings, Long id, int i) throws IOException {
        LOG.info("*** S T I T C H ***");
        boolean error = false;
        LOG.fine("stitch - path: " + path + " - id: " + id + " - i: " + i + " - row: " + settings.getScreencapPicsPerRow() + " col: " + settings.getScreencapPicsPerCol());
        String finalFileName = path + id + "_" + formatter.format(i) + ".png";
        LOG.fine("Merge temporary pictures into the final one: " + finalFileName);
        int totalImagesToStitch = settings.getScreencapPicsPerRow() * settings.getScreencapPicsPerCol();
        File[] imgFiles = new File[totalImagesToStitch];
        File dir = new File(path);
        WildcardFileFilter fileFilter = new WildcardFileFilter(id + "*tmp*.png");
        Object[] files = dir.listFiles((FileFilter)fileFilter);
        if (files == null) {
            LOG.severe("Could not find files. Stop stitching");
            return;
        }
        Arrays.sort(files);
        int upperLimit = 0;
        if (files.length <= imgFiles.length) {
            upperLimit = files.length;
        } else {
            upperLimit = imgFiles.length;
            LOG.info("files array is longer. that does not seem to be right");
        }
        LOG.info("files to stitch: " + files.length + " - upper limit: " + upperLimit);
        for (int i2 = 0; i2 < upperLimit; ++i2) {
            System.out.println(files[i2]);
            imgFiles[i2] = files[i2];
        }
        BufferedImage finalImg = new BufferedImage(settings.getScreencapWidth() * settings.getScreencapPicsPerCol(), settings.getScreencapHeight() * settings.getScreencapPicsPerRow(), 2);
        int num = 0;
        for (int y = 0; y < settings.getScreencapPicsPerRow() && !error; ++y) {
            for (int x = 0; x < settings.getScreencapPicsPerCol() && !error; ++x) {
                try {
                    LOG.fine("Reading: " + num + " - y: " + y + " - x: " + x);
                    if (imgFiles[num] == null || !imgFiles[num].exists()) {
                        LOG.info("Could not read file. Continue.");
                        continue;
                    }
                    BufferedImage buffImage = ImageIO.read(imgFiles[num]);
                    finalImg.createGraphics().drawImage(buffImage, null, settings.getScreencapWidth() * x, settings.getScreencapHeight() * y);
                    ++num;
                    continue;
                }
                catch (IIOException ex) {
                    LOG.severe("Error reading file at index " + num + ": " + imgFiles[num].getAbsolutePath() + " - Reason: " + ex.getMessage());
                    ex.printStackTrace();
                    error = true;
                }
            }
        }
        if (!error) {
            LOG.info("Image stitched together.");
            ImageIO.write((RenderedImage)finalImg, "png", new File(finalFileName));
            LOG.info("Image Saved for playable item with id " + id + " under " + finalFileName);
        } else {
            LOG.info("An error occured during stiching.");
        }
        ScreencapService.deleteTemporaryImageFiles(imgFiles);
        LOG.info("----------- Stitch END -----");
    }

    private static void deleteTemporaryImageFiles(File[] imgFiles) {
        boolean errorDelete = false;
        LOG.fine("Delete temporary pictures.");
        for (File f : imgFiles) {
            if (f == null) continue;
            try {
                LOG.finer("Deleting temporary file " + f.getAbsolutePath());
                Files.delete(f.toPath());
            }
            catch (Exception ex) {
                LOG.severe("An error occured deleting temporary files: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (errorDelete) {
            LOG.severe("An error occured deleting temporary files");
        }
    }

    public static void deleteSceneScreencaps(List<Scene> scenes) {
        for (Scene s : scenes) {
            File f;
            if (Files.exists(Paths.get(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator + s.getId() + "_" + formatter.format(s.getPosition()) + ".png", new String[0]), new LinkOption[0])) {
                f = new File(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator + s.getId() + "_" + formatter.format(s.getPosition()) + ".png");
                if (f.delete()) {
                    AbstractTopComponent.notifyInfo("Deleted screencap for scene: " + s.getNameOfPlayable());
                    LOG.fine("Deleted screencap for scene: " + s.getNameOfPlayable());
                    continue;
                }
                AbstractTopComponent.notifyError("Could not delete screencap for scene: " + s.getNameOfPlayable() + ". Maybe no screencap exists.");
                continue;
            }
            f = new File(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator + s.getId() + "_" + s.getPosition() + ".png");
            if (f.delete()) {
                AbstractTopComponent.notifyInfo("Deleted screencap for scene: " + s.getNameOfPlayable());
                LOG.fine("Deleted screencap for scene: " + s.getNameOfPlayable());
                continue;
            }
            AbstractTopComponent.notifyError("Could not delete screencap for scene: " + s.getNameOfPlayable() + ". Maybe no screencap exists.");
        }
    }
}

