/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import xxx.scenerixx.scenerixxlib.model.search.SearchQuery;
import xxx.scenerixx.scenerixxmodule.util.AutoCompleteBehaviour;

public abstract class AbstractAutocompleter {
    private int MAX_RESULTS = 500;
    private final int MAX_VISIBLE_ROWS = 20;
    private static final Logger LOG = Logger.getLogger(AbstractAutocompleter.class.getName());
    protected List<SearchQuery> choices = new ArrayList<SearchQuery>();
    private final AutoCompleteBehaviour<SearchQuery> autoComplete = new AutoCompleteBehaviour();

    public AbstractAutocompleter(int maxResults, final boolean orderByName) {
        this.autoComplete.setCallback((AutoCompleteBehaviour.IAutoCompleteCallback<SearchQuery>)new AutoCompleteBehaviour.DefaultAutoCompleteCallback<SearchQuery>(){

            @Override
            public List<SearchQuery> getProposals(String input) {
                LOG.info("current input: " + input);
                String lower = input.toLowerCase();
                ArrayList<SearchQuery> result = new ArrayList<SearchQuery>();
                for (SearchQuery choice : AbstractAutocompleter.this.choices) {
                    if (choice.getSearchQuery().isBlank()) {
                        LOG.info("Search term was blank");
                        continue;
                    }
                    if (!choice.getSearchQuery().toLowerCase().contains(lower)) continue;
                    if (result.isEmpty()) {
                        LOG.info("first result: " + choice.getSearchQuery() + " - " + String.valueOf(choice.getTab()));
                        result.add(choice);
                        continue;
                    }
                    LOG.info("We have already " + result.size() + " entries");
                    boolean exists = false;
                    for (SearchQuery sq : result) {
                        LOG.finest("sq [xxx]: " + sq.getSearchQuery() + " - " + choice.getSearchQuery() + " | " + String.valueOf(sq.getTab()) + " - " + String.valueOf(choice.getTab()));
                        if (!sq.getSearchQuery().equalsIgnoreCase(choice.getSearchQuery()) || !sq.getTab().equals((Object)choice.getTab())) continue;
                        LOG.finest("we have it already: " + String.valueOf(sq.getTab()) + " - " + sq.getSearchQuery());
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    result.add(choice);
                }
                if (orderByName) {
                    LOG.fine("order by name");
                    result.sort((one, two) -> one.getSearchQuery().compareTo(two.getSearchQuery()));
                } else {
                    LOG.fine("order by date of creation");
                    result.sort((one, two) -> two.getDateOfCreation().compareTo(one.getDateOfCreation()));
                }
                AbstractAutocompleter.this.adjustVisibleRows(result.size());
                return result.subList(0, result.size() <= AbstractAutocompleter.this.MAX_RESULTS ? result.size() : AbstractAutocompleter.this.MAX_RESULTS);
            }

            @Override
            public String getStringToInsert(SearchQuery s) {
                LOG.info("return " + String.valueOf(s));
                return s.getSearchQuery();
            }
        });
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                SearchQuery p = (SearchQuery)value;
                LOG.finer("Text: " + p.getSearchQuery());
                this.setText(p.getSearchQuery());
                return result;
            }
        };
        this.autoComplete.setListCellRenderer(renderer);
        this.autoComplete.setInitialPopupSize(new Dimension(350, 300));
        this.autoComplete.setVisibleRowCount(20);
    }

    public void adjustVisibleRows(int results) {
        LOG.info("adjust: " + results);
        if (results < 20) {
            this.autoComplete.setVisibleRowCount(results);
        } else {
            this.autoComplete.setVisibleRowCount(20);
        }
    }

    public List<SearchQuery> getChoices() {
        LOG.info("Abstract get CHOICES");
        return this.choices;
    }

    public void setChoices(List<SearchQuery> choices) {
        this.choices = choices;
    }

    public AutoCompleteBehaviour<SearchQuery> getAutoComplete() {
        return this.autoComplete;
    }
}

