/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.special;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.enums.BodyPart;
import xxx.scenerixx.scenerixxlib.model.enums.BodyPartSize;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxmodule.childfactories.person.PersonChildFactory;

public class BodyPartSizeChildFactory
extends ChildFactory<BodyPartSize> {
    public static final Logger LOG = Logger.getLogger(BodyPartSizeChildFactory.class.getName());
    private List<BodyPartSize> bodyPartSizeList;
    private DB db = DB.getInstance();
    private Gender gender = null;
    private boolean showCounter = false;
    private boolean showBirthyear = false;
    private boolean showRating = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showSecret = false;
    private boolean showPosition = false;
    private BodyPart bodyPart;

    public BodyPartSizeChildFactory(Gender gender, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showSecret, boolean showPosition, BodyPart bodyPart) {
        this.bodyPartSizeList = new ArrayList<BodyPartSize>(Arrays.asList(BodyPartSize.values()));
        this.gender = gender;
        this.showCounter = showCounter;
        this.showBirthyear = showBirthyear;
        this.showRating = showRating;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showSecret = showSecret;
        this.showPosition = showPosition;
        this.bodyPart = bodyPart;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in BodyPartSizeChildFactory");
    }

    protected boolean createKeys(List<BodyPartSize> list) {
        for (BodyPartSize bodyPartSize : this.bodyPartSizeList) {
            list.add(bodyPartSize);
        }
        return true;
    }

    protected Node createNodeForKey(BodyPartSize bodyPartSize) {
        LOG.finest("create new node for BodyPartSize: " + bodyPartSize.toString());
        AbstractNode result = new AbstractNode(this, Children.create((ChildFactory)new PersonChildFactory(this.db.getPersonsByBodyPartSize(this.gender, bodyPartSize, this.showSecret, this.bodyPart), this.showCounter, this.showBirthyear, this.showRating, this.showLikeCounter, this.showRuntime, false, this.showPosition), (boolean)true)){

            public Image getOpenedIcon(int type) {
                return ImageUtilities.loadImage((String)"icons/Folder.png");
            }

            public Image getIcon(int type) {
                return this.getOpenedIcon(type);
            }
        };
        String app = " [" + this.db.getPersonsByBodyPartSizeCount(this.gender, bodyPartSize, this.showSecret, this.bodyPart) + "]";
        result.setDisplayName(bodyPartSize.getTitle() + app);
        result.setValue("bodyPartSize", (Object)bodyPartSize);
        result.setName(bodyPartSize.getTitle());
        return result;
    }
}

