/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.QSceneDetails;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class RemoveAllPersonsAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(RemoveAllPersonsAction.class.getName());
    private final DB db = DB.getInstance();
    private final ScenerixxCommon common = new ScenerixxCommon();

    public RemoveAllPersonsAction() {
        Image image = ImageUtilities.loadImage((String)"icons/persons.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int selectedScenes = 0;
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("movie") == null || !((object = n.getValue("movie")) instanceof Movie)) continue;
            Movie movie = (Movie)object;
            selectedScenes += movie.getScenes().size();
        }
        if (0 == JOptionPane.showConfirmDialog(null, "Should we remove all persons from " + ScenerixxCommon.singularPlural(selectedScenes, "scene", "scenes", true) + "?", "Confirm removing persons?", 0)) {
            MovieListTopComponent movieList = (MovieListTopComponent)WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            Movie nextMovie = ScenerixxCommon.readInNextNode(movieList);
            for (Node n : activatedNodes) {
                Iterator iterator;
                if (n.getValue("movie") == null || !((iterator = n.getValue("movie")) instanceof Movie)) continue;
                Movie movie = (Movie)iterator;
                LOG.fine("Remove person data for movie " + movie.getNameOfPlayable());
                iterator = movie.getScenes().iterator();
                while (iterator.hasNext()) {
                    Scene s = (Scene)iterator.next();
                    for (Person person : s.getPersons(Scenerixx.unlocked)) {
                        SceneDetails sd = (SceneDetails)this.db.getEntityService().find((EntityPathBase)QSceneDetails.sceneDetails).filter(f -> f.person.eq((Object)person)).filter(f -> f.scene.eq((Object)s)).findFirst();
                        if (sd == null) continue;
                        this.db.getEntityService().delete((AbstractEntity)sd);
                        LOG.fine("Removed " + person.getName());
                    }
                }
            }
            int tmpSelectedScenes = selectedScenes;
            SwingUtilities.invokeLater(() -> {
                AbstractTopComponent.notifyInfo("Removed persons from " + ScenerixxCommon.singularPlural(tmpSelectedScenes, "scene", "scenes", true));
                movieList.reloadList();
                movieList.setNextNode(nextMovie);
            });
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Remove all persons from scenes";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

