/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class CopyScreencapsAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(CopyScreencapsAction.class.getName());

    public CopyScreencapsAction() {
        Image image = ImageUtilities.loadImage((String)"icons.silk/camera.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/move_all.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        Movie movie;
        int selectedNodes = 0;
        ArrayList<Movie> movies = new ArrayList<Movie>();
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("movie") == null || !((object = n.getValue("movie")) instanceof Movie)) continue;
            movie = (Movie)object;
            movies.add(movie);
            ++selectedNodes;
        }
        if (0 == JOptionPane.showConfirmDialog(null, "Should we copy the screencaps to the movie folder(s)?", "Copy screencaps?", 0)) {
            for (Node n : activatedNodes) {
                Object object;
                if (n.getValue("movie") == null || !((object = n.getValue("movie")) instanceof Movie)) continue;
                movie = (Movie)object;
                for (int i = 1; i <= movie.getScenes().size(); ++i) {
                    this.copyScreencap(movie, i, Scenerixx.scenerixxScreencapDir + File.separator + movie.getId());
                    for (Scene s : movie.getScenes()) {
                        this.copyScreencap(movie, i, Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator + s.getId());
                    }
                }
            }
            AbstractTopComponent.notifyInfo("Finished copying screencaps");
        }
    }

    private void copyScreencap(Movie movie, int i, String baseDir) {
        File file = new File(baseDir + "_" + i + ".png");
        LOG.info("Checking " + file.getAbsolutePath());
        if (file.exists()) {
            LOG.info("File exists");
            File destFile = new File(((MediumFile)movie.getStartMedium()).getFileCompletePath());
            LOG.info("Start medium: " + destFile.getAbsolutePath());
            try {
                String destString = String.valueOf(destFile.toPath().getParent()) + File.separator;
                destString = destString + Exporter.removeSpecialChars((String)movie.getTitle(), (boolean)false);
                if (file.getAbsolutePath().contains(File.separator + "scene" + File.separator)) {
                    destString = destString + "_scene";
                } else {
                    LOG.info("scenes: " + movie.getScenes().size());
                }
                destString = destString + "_" + i + ".png";
                LOG.info("destName: " + destString);
                Path destToPath = new File(destString).toPath();
                LOG.info("desttopath: " + String.valueOf(destToPath));
                if (!new File(destToPath.toFile().getCanonicalPath()).exists()) {
                    LOG.info("Copy " + String.valueOf(file.toPath().getFileName()) + " to " + String.valueOf(destToPath));
                    Path copy = Files.copy(file.toPath(), destToPath, StandardCopyOption.COPY_ATTRIBUTES);
                    LOG.info("Copy " + String.valueOf(copy.getFileName()) + " to " + String.valueOf(destToPath));
                } else {
                    LOG.info(String.valueOf(destToPath) + " already exists");
                }
            }
            catch (FileSystemException ex) {
                AbstractTopComponent.notifyError("Looks like that the filename is too long: " + ex.getMessage());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Copy screencaps to source folder";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

