/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class ConfirmWizardDataAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(ConfirmWizardDataAction.class.getName());
    private final DB db = DB.getInstance();
    private final ScenerixxCommon common = new ScenerixxCommon();

    public ConfirmWizardDataAction() {
        Image image = ImageUtilities.loadImage((String)"icons/Magic wand.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int selectedMovies = 0;
        for (Node n : activatedNodes) {
            if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
            ++selectedMovies;
        }
        if (0 == JOptionPane.showConfirmDialog(null, "Should the wizard data for " + ScenerixxCommon.singularPlural(selectedMovies, "movie", "movies", true) + " be confirmed?", "Confirm wizard data?", 0)) {
            MovieListTopComponent movieList = (MovieListTopComponent)WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            Movie nextMovie = ScenerixxCommon.readInNextNode(movieList);
            for (Node n : activatedNodes) {
                if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
                LOG.fine("Confirm wizard data for movie " + ((Movie)n.getValue("movie")).getNameOfPlayable());
                Movie movie = (Movie)n.getValue("movie");
                movie.setWizardGenerated(false);
                this.db.getEntityService().save((AbstractEntity)movie);
            }
            int tmpSelectedMovies = selectedMovies;
            SwingUtilities.invokeLater(() -> {
                AbstractTopComponent.notifyInfo("Confirmed wizard data for " + ScenerixxCommon.singularPlural(tmpSelectedMovies, "movie", "movies", true));
                movieList.reloadList();
                movieList.setNextNode(nextMovie);
                AbstractTopComponent.dirtyMediumFileList();
            });
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Confirm wizard data";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

