/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.action;

import java.awt.Image;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.MediumFileChildFactory;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class RenameFileExtensionOnDiscAction
extends NodeAction
implements Presenter.Popup {
    private DB db = DB.getInstance();

    public RenameFileExtensionOnDiscAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/tab_edit.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        MediumFile obj = (MediumFile)activatedNodes[0].getValue("mediumFile");
        String fileExtension = obj.getFileExtension();
        String fileNameWithoutExtension = obj.getFileName().substring(0, obj.getFileName().length() - obj.getFileExtension().length());
        String onlyPath = obj.getFileCompletePath().substring(0, obj.getFileCompletePath().length() - obj.getFileName().length());
        String oldCompletePath = obj.getFileCompletePath();
        if (!Files.exists(Paths.get(oldCompletePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            JOptionPane.showMessageDialog(null, "Error renaming the file '" + oldCompletePath + "'. It does not seem to exist. Is the device available?", "Error renaming", 0);
        } else {
            String showInputDialog = JOptionPane.showInputDialog("Enter a new file extension.", (Object)fileExtension);
            if (showInputDialog != null) {
                String newCompletePath = onlyPath + fileNameWithoutExtension + showInputDialog;
                try {
                    Path dest = Paths.get(newCompletePath, new String[0]);
                    if (Files.exists(dest, LinkOption.NOFOLLOW_LINKS)) {
                        JOptionPane.showMessageDialog(null, "Cannot rename. Another file with this name exists already!", "Error", 0);
                    } else if (Files.exists(Paths.get(oldCompletePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                        obj.setFileName(fileNameWithoutExtension + showInputDialog);
                        obj.setFileCompletePath(newCompletePath);
                        obj.setFileExtension(showInputDialog);
                        Files.move(Paths.get(oldCompletePath, new String[0]), dest, StandardCopyOption.ATOMIC_MOVE);
                        MediumFileChildFactory.LOG.finest("Renamed the file '" + oldCompletePath + "' to '" + obj.getFileCompletePath() + "'");
                        JOptionPane.showMessageDialog(null, "Renamed the file \n'" + oldCompletePath + "' \nto \n'" + obj.getFileCompletePath() + "'");
                        obj = (MediumFile)this.db.getEntityService().save((AbstractEntity)obj);
                    } else {
                        JOptionPane.showMessageDialog(null, "Error renaming the file '" + oldCompletePath + "'. It does not seem to exist. Is the device available?", "Error renaming", 0);
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Error renaming the file \n'" + oldCompletePath + "' \nto \n'" + obj.getFileCompletePath() + "'");
                }
                AbstractTopComponent.reloadMediumFileList();
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public String getName() {
        return "Rename file extension on disc";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

