/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.actions;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.db.EntityService;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class ResetCounterAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(ResetCounterAction.class.getName());
    private final DB db = DB.getInstance();

    public ResetCounterAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/counter.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        boolean updatePlayable = false;
        boolean updateMediumFile = false;
        for (Node n : activatedNodes) {
            Object object;
            Statistic stat = null;
            EntityService.Finder filter = null;
            EntityService.Finder find = this.db.getEntityService().find((EntityPathBase)QStatistic.statistic);
            Movie p = null;
            if (n.getValue("movie") != null && (object = n.getValue("movie")) instanceof Movie) {
                Movie m = (Movie)object;
                filter = find.filter(f -> f.movie.eq((Object)m));
                p = m;
                updatePlayable = true;
            }
            if (n.getValue("scene") != null && (object = n.getValue("scene")) instanceof Scene) {
                Scene s = (Scene)object;
                filter = find.filter(f -> f.scene.eq((Object)s));
                p = s;
                updatePlayable = true;
            }
            if (n.getValue("bookmark") != null && (object = n.getValue("bookmark")) instanceof Bookmark) {
                Bookmark b = (Bookmark)object;
                filter = find.filter(f -> f.bookmark.eq((Object)b));
                p = b;
                updatePlayable = true;
            }
            if (n.getValue("mediumFile") != null && (object = n.getValue("mediumFile")) instanceof MediumFile) {
                MediumFile mf = (MediumFile)object;
                filter = find.filter(f -> f.medium.eq((Object)mf));
                p = mf;
                updateMediumFile = true;
            }
            if ((stat = (Statistic)filter.findFirst()) != null) {
                stat.getStarted().clear();
            }
            this.db.getEntityService().save((AbstractEntity)stat);
            LOG.finest("Resetted counter for " + p.getNameOfPlayable());
            Movie tmpP = p;
            boolean tmpUpdatePlayable = updatePlayable;
            boolean tmpUpdateMediumFile = updateMediumFile;
            SwingUtilities.invokeLater(() -> ResetCounterAction.lambda$performAction$4((IPlayable)tmpP, tmpUpdatePlayable, tmpUpdateMediumFile));
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Reset Counter";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    protected boolean asynchronous() {
        return false;
    }

    private static /* synthetic */ void lambda$performAction$4(IPlayable tmpP, boolean tmpUpdatePlayable, boolean tmpUpdateMediumFile) {
        AbstractTopComponent.notifyInfo("Resetted counter for " + tmpP.getNameOfPlayable());
        if (tmpUpdatePlayable) {
            AbstractTopComponent.reloadMovieList(true);
        }
        if (tmpUpdateMediumFile) {
            AbstractTopComponent.reloadMediumFileList();
        }
    }
}

