/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;

public class EnumeratedMetadata
extends MetadataConverter {
    private String m_enumeratedType;

    public EnumeratedMetadata() {
        super("<enumerated>");
        this.m_enumeratedType = "ORDINAL";
    }

    public EnumeratedMetadata(MetadataAccessor accessor) {
        super(null, accessor);
    }

    public EnumeratedMetadata(MetadataAnnotation enumerated, MetadataAccessor accessor) {
        super(enumerated, accessor);
        this.m_enumeratedType = enumerated.getAttributeString("value");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof EnumeratedMetadata) {
            EnumeratedMetadata enumerated = (EnumeratedMetadata)objectToCompare;
            return this.valuesMatch(this.m_enumeratedType, enumerated.getEnumeratedType());
        }
        return false;
    }

    public int hashCode() {
        return this.m_enumeratedType != null ? this.m_enumeratedType.hashCode() : 0;
    }

    public String getEnumeratedType() {
        return this.m_enumeratedType;
    }

    public static boolean isValidEnumeratedType(MetadataClass cls) {
        return cls.isEnum();
    }

    @Override
    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (!EnumeratedMetadata.isValidEnumeratedType(referenceClass)) {
            throw ValidationException.invalidTypeForEnumeratedAttribute((String)mapping.getAttributeName(), (Object)referenceClass, (Object)accessor.getJavaClass());
        }
        ArrayList<MetadataField> annotatedFields = new ArrayList<MetadataField>();
        Collection<MetadataField> fields = referenceClass.getFields().values();
        for (MetadataField field : fields) {
            if (!field.isAnnotationPresent("jakarta.persistence.EnumeratedValue")) continue;
            annotatedFields.add(field);
        }
        if (annotatedFields.size() > 1) {
            throw ValidationException.incorrectNumberOfEnumeratedValueAnnotation((Object)referenceClass.getName());
        }
        Field field = null;
        if (annotatedFields.size() == 1) {
            try {
                Class clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(referenceClass.getName()));
                field = (Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(clazz, ((MetadataField)annotatedFields.get(0)).getName(), true));
            }
            catch (PrivilegedActionException exception) {
                throw ValidationException.invalidFieldForClass((String)((MetadataField)annotatedFields.get(0)).getName(), (Object)referenceClass);
            }
        }
        boolean isOrdinal = true;
        if (this.m_enumeratedType != null) {
            isOrdinal = this.m_enumeratedType.equals("ORDINAL");
        }
        if (field != null) {
            if (isOrdinal) {
                if (!BasicTypeHelperImpl.getInstance().isIntegralType(field.getType()) || field.getType().equals(Character.TYPE) || field.getType().equals(Character.class)) {
                    throw ValidationException.invalidFieldTypeForOrdinalEnumType((String)((MetadataField)annotatedFields.get(0)).getName(), (Object)referenceClass);
                }
            } else if (!field.getType().equals(String.class)) {
                throw ValidationException.invalidFieldTypeForStringEnumType((String)((MetadataField)annotatedFields.get(0)).getName(), (Object)referenceClass);
            }
        }
        this.setConverter(mapping, (Converter)new EnumTypeConverter(mapping, referenceClass.getName(), isOrdinal, field), isForMapKey);
    }

    public void setEnumeratedType(String enumerated) {
        this.m_enumeratedType = enumerated;
    }
}

