/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class DuplicateFinder {
    public static final Logger LOG = Logger.getLogger(DuplicateFinder.class.getName());

    public double compareFiles(String fileOne, String fileTwo) throws IOException {
        BufferedImage img1 = ImageIO.read(new File(fileOne));
        BufferedImage img2 = ImageIO.read(new File(fileTwo));
        double percentage = -1.0;
        int w1 = img1.getWidth();
        int w2 = img2.getWidth();
        int h1 = img1.getHeight();
        int h2 = img2.getHeight();
        if (w1 != w2 || h1 != h2) {
            LOG.info("Both images should have same dimensions");
        } else {
            long diff = 0L;
            for (int j = 0; j < h1; ++j) {
                for (int i = 0; i < w1; ++i) {
                    int pixel1 = img1.getRGB(i, j);
                    Color color1 = new Color(pixel1, true);
                    int r1 = color1.getRed();
                    int g1 = color1.getGreen();
                    int b1 = color1.getBlue();
                    int pixel2 = img2.getRGB(i, j);
                    Color color2 = new Color(pixel2, true);
                    int r2 = color2.getRed();
                    int g2 = color2.getGreen();
                    int b2 = color2.getBlue();
                    long data = Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2);
                    diff += data;
                }
            }
            double avg = diff / (long)(w1 * h1 * 3);
            percentage = avg / 255.0 * 100.0;
            LOG.finer("Difference: " + percentage);
        }
        return percentage;
    }
}

