/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.model.playlist;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;

@Entity
public class Playlist
extends AbstractEntity
implements Serializable {
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="playlist")
    @OrderBy(value="pos")
    private List<PlaylistEntry> entries = new ArrayList<PlaylistEntry>();
    private boolean defaultPlaylist = false;
    private boolean secret;
    private boolean archived;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PlaylistEntry> getEntries(boolean showSecret) {
        if ("History".equals(this.name)) {
            PlaylistService ps = new PlaylistService();
            return ps.getHistoryPlaylistEntries(showSecret);
        }
        if ("Secret History".equals(this.name)) {
            PlaylistService ps = new PlaylistService();
            return ps.getSecretHistoryPlaylistEntries();
        }
        if (this.entries == null) {
            return new ArrayList<PlaylistEntry>();
        }
        if (showSecret) {
            return this.entries;
        }
        this.entries.removeIf(pe -> pe.getMovie() != null && pe.getMovie().isSecret() || pe.getBookmark() != null && pe.getBookmark().isSecret() || pe.getScene() != null && pe.getScene().getMovieAssociated() != null && pe.getScene().getMovieAssociated().isSecret() || pe.getMediumFile() != null && pe.getMediumFile().isSecret());
        return this.entries;
    }

    public void setEntries(List<PlaylistEntry> entries) {
        this.entries = entries;
    }

    public boolean isDefaultPlaylist() {
        return this.defaultPlaylist;
    }

    public void setDefaultPlaylist(boolean defaultPlaylist) {
        this.defaultPlaylist = defaultPlaylist;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public void setSecret(boolean secret) {
        this.secret = secret;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public boolean isTemporaryPlaylist() {
        return "[TEMPORARY PLAYLIST]".equals(this.name);
    }

    public boolean isHistoryPlaylist() {
        return "History".equals(this.name);
    }

    public boolean isSecretHistoryPlaylist() {
        return "Secret History".equals(this.name);
    }

    public List<IPlayablePlaylistItems> getPlayables(boolean showSecrets) {
        ArrayList<IPlayablePlaylistItems> result = new ArrayList<IPlayablePlaylistItems>();
        for (PlaylistEntry pe : this.entries) {
            if (pe.getBookmark() != null) {
                result.add(pe.getBookmark());
            }
            if (pe.getScene() != null) {
                result.add(pe.getScene());
            }
            if (pe.getMovie() != null) {
                result.add(pe.getMovie());
            }
            if (pe.getMediumFile() != null) {
                result.add(pe.getMediumFile());
            }
            if (pe.getPerson() != null) {
                result.add(pe.getPerson());
            }
            if (pe.getStudio() == null) continue;
            result.add(pe.getStudio());
        }
        return result;
    }

    public String toString() {
        return this.name;
    }
}

