/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.StudioWebsites;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;

@Entity
public class Studio
extends AbstractEntity
implements Serializable,
IPlayablePlaylistItems,
INode {
    private String name;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH, CascadeType.DETACH}, mappedBy="studio")
    private List<StudioWebsites> studioWebsites = new ArrayList<StudioWebsites>();
    private String homepage;
    private String homepage2;
    private String wikipedia;
    private String twitter;
    private String twitter2;
    @Lob
    private String otherUrls;
    private Integer yearFounded;
    private Integer yearDefunct;
    @OneToOne
    private Studio parent;
    @Lob
    private String publicDescription;
    @Enumerated(value=EnumType.STRING)
    private MovieType type1;
    @Enumerated(value=EnumType.STRING)
    private MovieType type2;
    @Enumerated(value=EnumType.STRING)
    private MovieType type3;
    @Enumerated(value=EnumType.STRING)
    private MovieType type4;
    @Enumerated(value=EnumType.STRING)
    private MovieType type5;
    @Enumerated(value=EnumType.STRING)
    private MovieType type6;
    private transient boolean noDbConnection = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<StudioWebsites> getStudioWebsites() {
        return this.studioWebsites;
    }

    public void setStudioWebsites(List<StudioWebsites> studioWebsites) {
        this.studioWebsites = studioWebsites;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getWikipedia() {
        return this.wikipedia;
    }

    public void setWikipedia(String wikipedia) {
        this.wikipedia = wikipedia;
    }

    public String getTwitter() {
        return this.twitter;
    }

    public void setTwitter(String twitter) {
        this.twitter = twitter;
    }

    public String getHomepage2() {
        return this.homepage2;
    }

    public void setHomepage2(String homepage2) {
        this.homepage2 = homepage2;
    }

    public String getTwitter2() {
        return this.twitter2;
    }

    public void setTwitter2(String twitter2) {
        this.twitter2 = twitter2;
    }

    public String getOtherUrls() {
        return this.otherUrls;
    }

    public void setOtherUrls(String otherUrls) {
        this.otherUrls = otherUrls;
    }

    public Integer getYearFounded() {
        return this.yearFounded;
    }

    public void setYearFounded(Integer yearFounded) {
        this.yearFounded = yearFounded;
    }

    public Integer getYearDefunct() {
        return this.yearDefunct;
    }

    public void setYearDefunct(Integer yearDefunct) {
        this.yearDefunct = yearDefunct;
    }

    public Studio getParent() {
        return this.parent;
    }

    public void setParent(Studio parent) {
        this.parent = parent;
    }

    public String getPublicDescription() {
        return this.publicDescription;
    }

    public void setPublicDescription(String publicDescription) {
        this.publicDescription = publicDescription;
    }

    public MovieType getType1() {
        return this.type1;
    }

    public void setType1(MovieType type1) {
        this.type1 = type1;
    }

    public MovieType getType2() {
        return this.type2;
    }

    public void setType2(MovieType type2) {
        this.type2 = type2;
    }

    public MovieType getType3() {
        return this.type3;
    }

    public void setType3(MovieType type3) {
        this.type3 = type3;
    }

    public MovieType getType4() {
        return this.type4;
    }

    public void setType4(MovieType type4) {
        this.type4 = type4;
    }

    public MovieType getType5() {
        return this.type5;
    }

    public void setType5(MovieType type5) {
        this.type5 = type5;
    }

    public MovieType getType6() {
        return this.type6;
    }

    public void setType6(MovieType type6) {
        this.type6 = type6;
    }

    public List<INode> getMoviesAsINode(boolean showSecrets) {
        if (this.noDbConnection) {
            return new ArrayList<INode>();
        }
        ArrayList<INode> result = new ArrayList<INode>();
        for (Movie m : DB.getInstance().getMovies(this, showSecrets)) {
            result.add(m);
        }
        return result;
    }

    public List<Movie> getMovies(boolean showSecrets) {
        if (this.noDbConnection) {
            return new ArrayList<Movie>();
        }
        return DB.getInstance().getMovies(this, showSecrets);
    }

    public List<Studio> getChildren() {
        if (this.noDbConnection) {
            return new ArrayList<Studio>();
        }
        return DB.getInstance().getStudios(this);
    }

    public List<INode> getChildrenAsINode() {
        ArrayList<INode> result = new ArrayList<INode>();
        for (Studio s : this.getChildren()) {
            result.add(s);
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + Objects.hashCode(this.name);
        hash = 31 * hash + Objects.hashCode(this.homepage);
        hash = 31 * hash + Objects.hashCode(this.homepage2);
        hash = 31 * hash + Objects.hashCode(this.wikipedia);
        hash = 31 * hash + Objects.hashCode(this.twitter);
        hash = 31 * hash + Objects.hashCode(this.twitter2);
        hash = 31 * hash + Objects.hashCode(this.otherUrls);
        hash = 31 * hash + Objects.hashCode(this.yearFounded);
        hash = 31 * hash + Objects.hashCode(this.yearDefunct);
        hash = 31 * hash + Objects.hashCode(this.parent);
        hash = 31 * hash + Objects.hashCode(this.publicDescription);
        hash = 31 * hash + Objects.hashCode(this.type1);
        hash = 31 * hash + Objects.hashCode(this.type2);
        hash = 31 * hash + Objects.hashCode(this.type3);
        hash = 31 * hash + Objects.hashCode(this.type4);
        hash = 31 * hash + Objects.hashCode(this.type5);
        hash = 31 * hash + Objects.hashCode(this.type6);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Studio other = (Studio)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.homepage, other.homepage)) {
            return false;
        }
        if (!Objects.equals(this.homepage2, other.homepage2)) {
            return false;
        }
        if (!Objects.equals(this.wikipedia, other.wikipedia)) {
            return false;
        }
        if (!Objects.equals(this.twitter, other.twitter)) {
            return false;
        }
        if (!Objects.equals(this.twitter2, other.twitter2)) {
            return false;
        }
        if (!Objects.equals(this.otherUrls, other.otherUrls)) {
            return false;
        }
        if (!Objects.equals(this.publicDescription, other.publicDescription)) {
            return false;
        }
        if (!Objects.equals(this.yearFounded, other.yearFounded)) {
            return false;
        }
        if (!Objects.equals(this.yearDefunct, other.yearDefunct)) {
            return false;
        }
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (this.type1 != other.type1) {
            return false;
        }
        if (this.type2 != other.type2) {
            return false;
        }
        if (this.type3 != other.type3) {
            return false;
        }
        if (this.type4 != other.type4) {
            return false;
        }
        if (this.type5 != other.type5) {
            return false;
        }
        return this.type6 == other.type6;
    }
}

