/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.exporter;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.ExportLevel;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Cumshot;
import xxx.scenerixx.scenerixxlib.model.Goldenshower;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.PersonBody;
import xxx.scenerixx.scenerixxlib.model.PersonWebsites;
import xxx.scenerixx.scenerixxlib.model.QCumshot;
import xxx.scenerixx.scenerixxlib.model.QGoldenshower;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.StudioWebsites;
import xxx.scenerixx.scenerixxlib.model.enums.Appearance;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxlib.model.enums.Clothes;
import xxx.scenerixx.scenerixxlib.model.enums.Jewelry;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.enums.Toys;
import xxx.scenerixx.scenerixxlib.model.medium.Dvd;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;

public class Exporter {
    private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder docBuilder;
    private Document doc;
    private DB db = DB.getInstance();
    private final Logger LOGGER = LoggerFactory.getLogger(Exporter.class);

    public void init() {
        try {
            this.docBuilder = this.docFactory.newDocumentBuilder();
            this.doc = this.docBuilder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            java.util.logging.Logger.getLogger(Exporter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String removeSpecialChars(String s) {
        return Exporter.removeSpecialChars(s, true);
    }

    public static String removeSpecialChars(String s, boolean underscore) {
        if (s == null) {
            return "";
        }
        s = s.replace("<", " ");
        s = s.replace(">", " ");
        s = s.replace(":", " ");
        s = s.replace("/", " ");
        s = s.replace("\\", "");
        s = s.replace("|", " ");
        s = s.replace("?", " ");
        s = s.replace("*", " ");
        s = s.replace("#", " ");
        s = s.replace("-", " ");
        if (underscore) {
            s = s.replace(" ", "_");
        }
        return s;
    }

    public String exportMovieToFile(Movie m, String path, ExportLevel level) throws TransformerException {
        this.init();
        Element rootElement = this.createRootElement();
        rootElement.appendChild(this.createVersionElement(this.doc));
        rootElement.appendChild(this.createMovieElement(m, level));
        String filename = this.getDestinationFileName(m);
        this.createHashFiles(m, filename, path);
        return this.transformToFile(path + File.separator + filename);
    }

    public String getDestinationFileName(Movie m) {
        String suffix = "_movie.";
        String filename = Exporter.removeSpecialChars(m.getTitle().substring(0, Math.min(m.getTitle().length(), 120))) + suffix + "scenerixx";
        return filename;
    }

    private void createHashFiles(Movie m, String scenerixxFilename, String path) {
        PrintWriter writer;
        for (Medium medium : this.db.getMediums(m, true)) {
            try {
                writer = new PrintWriter(path + File.separator + medium.getHashValue(), "UTF-8");
                writer.println(scenerixxFilename);
                writer.close();
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(Exporter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (Scene s : m.getScenes()) {
            if (s.getStartMedium() != null) {
                try {
                    writer = new PrintWriter(path + File.separator + s.getStartMedium().getHashValue(), "UTF-8");
                    writer.println(scenerixxFilename);
                    writer.close();
                }
                catch (IOException ex) {
                    java.util.logging.Logger.getLogger(Exporter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (s.getEndMedium() == null) continue;
            try {
                writer = new PrintWriter(path + File.separator + s.getEndMedium().getHashValue(), "UTF-8");
                writer.println(scenerixxFilename);
                writer.close();
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(Exporter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String exportStudioToFile(Studio s, String path, boolean overwrite) throws TransformerException {
        this.init();
        Element rootElement = this.createRootElement();
        rootElement.appendChild(this.createVersionElement(this.doc));
        rootElement.appendChild(this.createStudioElement(s, this.doc));
        String suffix = "_studio.scenerixx";
        if (new File(this.getDestinationFileName(s, path)).exists() && !overwrite) {
            int i = 1;
            while (new File(path + File.separator + Exporter.removeSpecialChars(s.getName()) + "_" + i + suffix).exists()) {
                ++i;
            }
            return this.transformToFile(path + File.separator + Exporter.removeSpecialChars(s.getName()) + "_" + i + suffix);
        }
        return this.transformToFile(path + File.separator + Exporter.removeSpecialChars(s.getName()) + suffix);
    }

    public String getDestinationFileName(Studio s, String path) {
        if (!path.endsWith(File.separator)) {
            return path + File.separator + Exporter.removeSpecialChars(s.getName()) + "_studio.scenerixx";
        }
        return path + Exporter.removeSpecialChars(s.getName()) + "_studio.scenerixx";
    }

    public String getDestinationFileName(Person p, String path) {
        if (!path.endsWith(File.separator)) {
            return path + File.separator + Exporter.removeSpecialChars(p.getName()) + "_person.scenerixx";
        }
        return path + Exporter.removeSpecialChars(p.getName()) + "_person.scenerixx";
    }

    public String exportPersonToFile(Person p, String path, boolean overwrite) throws TransformerException {
        this.init();
        Element rootElement = this.createRootElement();
        rootElement.appendChild(this.createVersionElement(this.doc));
        rootElement.appendChild(this.createPersonElement(p, this.doc));
        String suffix = "_person.scenerixx";
        if (new File(this.getDestinationFileName(p, path)).exists() && !overwrite) {
            int i = 1;
            while (new File(path + File.separator + Exporter.removeSpecialChars(p.getName()) + "_" + i + suffix).exists()) {
                ++i;
            }
            return this.transformToFile(path + File.separator + Exporter.removeSpecialChars(p.getName()) + "_" + i + suffix);
        }
        return this.transformToFile(path + File.separator + Exporter.removeSpecialChars(p.getName()) + suffix);
    }

    private String transformToFile(String fileName) throws TransformerException {
        File outputFile = null;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("encoding", "UTF-8");
        DOMSource source = new DOMSource(this.doc);
        outputFile = new File(fileName);
        StreamResult result = new StreamResult(outputFile);
        transformer.transform(source, result);
        return outputFile.getAbsolutePath();
    }

    private Element createRootElement() {
        Element rootElement = this.doc.createElement("scenerixx");
        this.doc.appendChild(rootElement);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Element creationDate = this.doc.createElement("dateOfCreation");
        creationDate.appendChild(this.doc.createTextNode(df.format(new Date())));
        rootElement.appendChild(creationDate);
        return rootElement;
    }

    public Element createVersionElement(Document doc) {
        Element versionRoot = doc.createElement("version");
        Element codename = doc.createElement("codename");
        codename.appendChild(doc.createTextNode("hanna"));
        versionRoot.appendChild(codename);
        Element version = doc.createElement("version");
        version.appendChild(doc.createTextNode("5.3.0"));
        versionRoot.appendChild(version);
        return versionRoot;
    }

    private Element addElement(String tagName, String value) {
        Element element = this.doc.createElement(tagName);
        element.appendChild(this.doc.createTextNode(value));
        return element;
    }

    private Element createMovieElement(Movie m, ExportLevel exportlevel) {
        return this.createMovieElement(m, exportlevel, null);
    }

    /*
     * WARNING - void declaration
     */
    private Element createMovieElement(Movie m, ExportLevel exportlevel, List<MediumFile> mfs) {
        Dvd dvd;
        void var8_23;
        Element movie = this.doc.createElement("movie");
        if (m.isSecret()) {
            return movie;
        }
        movie.appendChild(this.addElement("level", "" + exportlevel.getLevel()));
        movie.appendChild(this.addElement("title", m.getTitle()));
        movie.appendChild(this.addElement("alternativeTitle", m.getAlternativeTitle()));
        movie.appendChild(this.addElement("officialUrl", m.getOfficialUrl()));
        movie.appendChild(this.addElement("iafdUrl", m.getIafdUrl()));
        movie.appendChild(this.addElement("tubeUrl", m.getTubeUrl()));
        movie.appendChild(this.addElement("tubeTitle", m.getTubeTitle()));
        if (m.getReleaseDay() != null) {
            movie.appendChild(this.addElement("releaseDay", "" + m.getReleaseDay()));
        }
        if (m.getReleaseMonth() != null) {
            movie.appendChild(this.addElement("releaseMonth", "" + m.getReleaseMonth()));
        }
        if (m.getReleaseYear() != null) {
            movie.appendChild(this.addElement("releaseYear", "" + m.getReleaseYear()));
        }
        if (m.getPublicDescription() != null) {
            movie.appendChild(this.addElement("publicdescription", m.getPublicDescription()));
        }
        if (m.getType() != null) {
            movie.appendChild(this.addElement("type", m.getType().name()));
        }
        if (m.getType2() != null) {
            movie.appendChild(this.addElement("type2", m.getType2().name()));
        }
        if (m.getType3() != null) {
            movie.appendChild(this.addElement("type3", m.getType3().name()));
        }
        if (m.getType4() != null) {
            movie.appendChild(this.addElement("type4", m.getType4().name()));
        }
        if (m.getType5() != null) {
            movie.appendChild(this.addElement("type5", m.getType5().name()));
        }
        if (m.getType6() != null) {
            movie.appendChild(this.addElement("type6", m.getType6().name()));
        }
        if (!m.getMovietypes().isEmpty()) {
            Element movietypesRootElement = this.doc.createElement("movietypesRoot");
            for (MovieType movieType : m.getMovietypes()) {
                Element element = this.doc.createElement("movietype");
                element.appendChild(this.doc.createTextNode(movieType.name()));
                movietypesRootElement.appendChild(element);
            }
            movie.appendChild(movietypesRootElement);
        }
        if (m.getLanguageSpoken() != null) {
            movie.appendChild(this.addElement("spokenLanguage", m.getLanguageSpoken().name()));
        }
        if (m.getLanguageSubtitles() != null) {
            movie.appendChild(this.addElement("spokenSubtitles", m.getLanguageSubtitles().name()));
        }
        if (m.isSynchronizedAudio()) {
            movie.appendChild(this.addElement("synchronizedAudio", "" + m.isSynchronizedAudio()));
        }
        if (m.isCensored()) {
            movie.appendChild(this.addElement("censored", "" + m.isCensored()));
        }
        if (m.isDecensored()) {
            movie.appendChild(this.addElement("decensored", "" + m.isDecensored()));
        }
        if (m.isVertical()) {
            movie.appendChild(this.addElement("vertical", "" + m.isVertical()));
        }
        if (m.isMirrored()) {
            movie.appendChild(this.addElement("mirrored", "" + m.isMirrored()));
        }
        if (m.isSnippet()) {
            movie.appendChild(this.addElement("snippet", "" + m.isSnippet()));
        }
        if (m.isInteractive()) {
            movie.appendChild(this.addElement("interactive", "" + m.isInteractive()));
        }
        if (m.isThreeD()) {
            movie.appendChild(this.addElement("threed", "" + m.isThreeD()));
        }
        if (m.isVr()) {
            movie.appendChild(this.addElement("vr", "" + m.isVr()));
        }
        if (m.getMinutesOfSilence() != null) {
            movie.appendChild(this.addElement("minutesOfSilence", m.getMinutesOfSilence()));
        }
        if (m.getShotInCountry() != null) {
            movie.appendChild(this.addElement("shotInCountry", m.getShotInCountry().name()));
        }
        Element persons = this.doc.createElement("persons");
        for (Scene scene : m.getScenes()) {
            for (SceneDetails sd : scene.getDetails()) {
                if (sd.getPerson() != null && sd.getPerson().isSecret()) continue;
                persons.appendChild(this.createPersonElement(sd.getPerson(), this.doc));
            }
        }
        movie.appendChild(persons);
        Element scenes = this.doc.createElement("scenes");
        for (Scene scene : m.getScenes()) {
            scenes.appendChild(this.createSceneElement(scene));
        }
        movie.appendChild(scenes);
        Element element = this.doc.createElement("bookmarks");
        for (Bookmark b : m.getBookmarks(false)) {
            element.appendChild(this.createBookmarkElement(b));
        }
        movie.appendChild(element);
        if (m.getStudio() != null) {
            movie.appendChild(this.createStudioElement(m.getStudio(), this.doc));
        }
        Object var8_20 = null;
        if (mfs == null) {
            List<MediumFile> list = this.db.getMediumFiles(m, true);
        } else {
            List<MediumFile> list = mfs;
        }
        if (!var8_23.isEmpty()) {
            Element mediumfilesElement = this.doc.createElement("mediumfiles");
            for (MediumFile mf : var8_23) {
                Element mediumfileElement = this.doc.createElement("mediumfile");
                mediumfileElement.appendChild(this.createMediumElement(mf));
                mediumfilesElement.appendChild(mediumfileElement);
            }
            movie.appendChild(mediumfilesElement);
        }
        if ((dvd = this.db.getDvd(m, true)) != null) {
            Element dvdElement = this.doc.createElement("dvd");
            dvdElement.appendChild(this.createMediumElement(dvd));
            movie.appendChild(dvdElement);
        }
        if (!m.getPictures().isEmpty()) {
            Element pictures = this.doc.createElement("pictures");
            for (MediumFile mediumFile : m.getPictures()) {
                pictures.appendChild(this.createMediumElement(mediumFile));
            }
            movie.appendChild(pictures);
        }
        return movie;
    }

    private Element createSceneElement(Scene s) {
        Element scene = this.doc.createElement("scene");
        Element pos = this.doc.createElement("pos");
        pos.appendChild(this.doc.createTextNode("" + s.getPosition()));
        scene.appendChild(pos);
        Element bonus = this.doc.createElement("bonus");
        bonus.appendChild(this.doc.createTextNode("" + s.isBonusScene()));
        scene.appendChild(bonus);
        Element intercut = this.doc.createElement("intercut");
        intercut.appendChild(this.doc.createTextNode("" + s.isIntercut()));
        scene.appendChild(intercut);
        Element summary = this.doc.createElement("summary");
        summary.appendChild(this.doc.createTextNode("" + s.isSummary()));
        scene.appendChild(summary);
        Element behindScenes = this.doc.createElement("behindTheScenes");
        behindScenes.appendChild(this.doc.createTextNode("" + s.isBehindTheScenes()));
        scene.appendChild(behindScenes);
        Element incomplete = this.doc.createElement("incomplete");
        incomplete.appendChild(this.doc.createTextNode("" + s.isIncomplete()));
        scene.appendChild(incomplete);
        Element condomsUsed = this.doc.createElement("condomsUsed");
        condomsUsed.appendChild(this.doc.createTextNode("" + s.isCondomsUsed()));
        scene.appendChild(condomsUsed);
        if (s.getChapter() != null) {
            Element chapter = this.doc.createElement("chapter");
            chapter.appendChild(this.doc.createTextNode("" + s.getChapter()));
            scene.appendChild(chapter);
        }
        if (s.getTitle() != null) {
            Element title = this.doc.createElement("title");
            title.appendChild(this.doc.createTextNode("" + s.getTitle()));
            scene.appendChild(title);
        }
        if (s.getDateOfShootDay() != null) {
            Element shootDay = this.doc.createElement("shootDay");
            shootDay.appendChild(this.doc.createTextNode("" + s.getDateOfShootDay()));
            scene.appendChild(shootDay);
        }
        if (s.getDateOfShootMonth() != null) {
            Element shootMonth = this.doc.createElement("shootMonth");
            shootMonth.appendChild(this.doc.createTextNode("" + s.getDateOfShootMonth()));
            scene.appendChild(shootMonth);
        }
        if (s.getDateOfShootYear() != null) {
            Element shootYear = this.doc.createElement("shootYear");
            shootYear.appendChild(this.doc.createTextNode("" + s.getDateOfShootYear()));
            scene.appendChild(shootYear);
        }
        if (s.getSoundQuality() != null) {
            Element soundQuality = this.doc.createElement("soundQuality");
            soundQuality.appendChild(this.doc.createTextNode(s.getSoundQuality().name()));
            scene.appendChild(soundQuality);
        }
        if (s.getVideoQuality() != null) {
            Element videoQuality = this.doc.createElement("videoQuality");
            videoQuality.appendChild(this.doc.createTextNode(s.getVideoQuality().name()));
            scene.appendChild(videoQuality);
        }
        if (s.getType() != null) {
            Element type = this.doc.createElement("type");
            type.appendChild(this.doc.createTextNode(s.getType().name()));
            scene.appendChild(type);
        }
        if (s.getType2() != null) {
            Element type2 = this.doc.createElement("type2");
            type2.appendChild(this.doc.createTextNode(s.getType2().name()));
            scene.appendChild(type2);
        }
        if (s.getType3() != null) {
            Element type3 = this.doc.createElement("type3");
            type3.appendChild(this.doc.createTextNode(s.getType3().name()));
            scene.appendChild(type3);
        }
        if (s.getType4() != null) {
            Element type4 = this.doc.createElement("type4");
            type4.appendChild(this.doc.createTextNode(s.getType4().name()));
            scene.appendChild(type4);
        }
        if (s.getType5() != null) {
            Element type5 = this.doc.createElement("type5");
            type5.appendChild(this.doc.createTextNode(s.getType5().name()));
            scene.appendChild(type5);
        }
        if (s.getType6() != null) {
            Element type6 = this.doc.createElement("type6");
            type6.appendChild(this.doc.createTextNode(s.getType6().name()));
            scene.appendChild(type6);
        }
        if (!s.getMovietypes().isEmpty()) {
            Element movietypesRootElement = this.doc.createElement("movietypesRoot");
            for (MovieType mt : s.getMovietypes()) {
                Element movietypeElement = this.doc.createElement("movietype");
                movietypeElement.appendChild(this.doc.createTextNode(mt.name()));
                movietypesRootElement.appendChild(movietypeElement);
            }
            scene.appendChild(movietypesRootElement);
        }
        if (s.getLocation1() != null) {
            Element location1 = this.doc.createElement("location1");
            location1.appendChild(this.doc.createTextNode(s.getLocation1().name()));
            scene.appendChild(location1);
        }
        if (s.getLocation2() != null) {
            Element location2 = this.doc.createElement("location2");
            location2.appendChild(this.doc.createTextNode(s.getLocation2().name()));
            scene.appendChild(location2);
        }
        if (s.getLocation3() != null) {
            Element location3 = this.doc.createElement("location3");
            location3.appendChild(this.doc.createTextNode(s.getLocation3().name()));
            scene.appendChild(location3);
        }
        if (s.getShotInCountry() != null) {
            scene.appendChild(this.addElement("shotInCountry", s.getShotInCountry().name()));
        }
        Element starttime = this.doc.createElement("starttime");
        starttime.appendChild(this.doc.createTextNode("" + s.getStartTime()));
        scene.appendChild(starttime);
        Element endtime = this.doc.createElement("endtime");
        endtime.appendChild(this.doc.createTextNode("" + s.getEndTime()));
        scene.appendChild(endtime);
        if (s.getStartMedium() != null) {
            Element startmedium = this.doc.createElement("startMedium");
            startmedium.appendChild(this.createMediumElement(s.getStartMedium()));
            scene.appendChild(startmedium);
        }
        if (s.getEndMedium() != null) {
            Element endmedium = this.doc.createElement("endMedium");
            endmedium.appendChild(this.createMediumElement(s.getEndMedium()));
            scene.appendChild(endmedium);
        }
        if (s.getPublicDescription() != null) {
            Element description = this.doc.createElement("publicdescription");
            description.appendChild(this.doc.createTextNode(s.getPublicDescription()));
            scene.appendChild(description);
        }
        Element sceneDetails = this.doc.createElement("scenedetails");
        for (SceneDetails sceneDetails2 : s.getDetails()) {
            sceneDetails.appendChild(this.createSceneDetailsElement(sceneDetails2));
        }
        scene.appendChild(sceneDetails);
        Element bookmarks = this.doc.createElement("bookmarks");
        for (Bookmark b : s.getBookmarks(false)) {
            bookmarks.appendChild(this.createBookmarkElement(b));
        }
        scene.appendChild(bookmarks);
        if (!s.getPictures().isEmpty()) {
            Element element = this.doc.createElement("pictures");
            for (MediumFile mf : s.getPictures()) {
                element.appendChild(this.createMediumElement(mf));
            }
            scene.appendChild(element);
        }
        return scene;
    }

    private Element createMediumElement(Medium m) {
        MediumFile mediumFile;
        this.LOGGER.info("create medium element: " + m.getHashValue());
        Element mediumElement = this.doc.createElement("medium");
        Element part = this.doc.createElement("part");
        part.appendChild(this.doc.createTextNode("" + m.getPart()));
        mediumElement.appendChild(part);
        if (m.getHashValue() != null) {
            Element hash = this.doc.createElement("hash");
            hash.appendChild(this.doc.createTextNode(m.getHashValue()));
            mediumElement.appendChild(hash);
        }
        if (m.getWidth() != null) {
            Element width = this.doc.createElement("width");
            width.appendChild(this.doc.createTextNode("" + m.getWidth()));
            mediumElement.appendChild(width);
        }
        if (m.getHeight() != null) {
            Element height = this.doc.createElement("height");
            height.appendChild(this.doc.createTextNode("" + m.getHeight()));
            mediumElement.appendChild(height);
        }
        if (m.getDuration() != null) {
            Element duration = this.doc.createElement("duration");
            duration.appendChild(this.doc.createTextNode("" + m.getDuration()));
            mediumElement.appendChild(duration);
        }
        if (m instanceof MediumFile && (mediumFile = (MediumFile)m).getDesyncAudio() != null) {
            Element fileName = this.doc.createElement("audioDesync");
            fileName.appendChild(this.doc.createTextNode("" + mediumFile.getDesyncAudio()));
            mediumElement.appendChild(fileName);
        }
        return mediumElement;
    }

    private Element createBookmarkElement(Bookmark b) {
        Cumshot cs;
        Element quantityDifferentiator;
        Element quantity;
        Element swallow;
        Goldenshower gs;
        Element passivePerson;
        Element primaryPerson;
        Element bookmark = this.doc.createElement("bookmark");
        Element starttime = this.doc.createElement("starttime");
        starttime.appendChild(this.doc.createTextNode("" + b.getStartTime()));
        bookmark.appendChild(starttime);
        Element endtime = this.doc.createElement("endtime");
        endtime.appendChild(this.doc.createTextNode("" + b.getEndTime()));
        bookmark.appendChild(endtime);
        Element looping = this.doc.createElement("looping");
        looping.appendChild(this.doc.createTextNode("" + b.isLooping()));
        bookmark.appendChild(looping);
        Element position = this.doc.createElement("position");
        position.appendChild(this.doc.createTextNode("" + b.getPosition()));
        bookmark.appendChild(position);
        if (b.getPublicDescription() != null) {
            Element description = this.doc.createElement("publicdescription");
            description.appendChild(this.doc.createTextNode(b.getPublicDescription()));
            bookmark.appendChild(description);
        }
        if (b.getBookmarkTitle() != null) {
            Element bookmarktitle = this.doc.createElement("bookmarktitle");
            bookmarktitle.appendChild(this.doc.createTextNode(b.getBookmarkTitle()));
            bookmark.appendChild(bookmarktitle);
        }
        if (b.getTitle() != null) {
            Element title = this.doc.createElement("title");
            title.appendChild(this.doc.createTextNode("" + b.getTitle()));
            bookmark.appendChild(title);
        }
        if (b.getChapter() != null) {
            Element chapter = this.doc.createElement("chapter");
            chapter.appendChild(this.doc.createTextNode("" + b.getChapter()));
            bookmark.appendChild(chapter);
        }
        if (b.getType() != null) {
            Element type = this.doc.createElement("type");
            type.appendChild(this.doc.createTextNode(b.getType().name()));
            bookmark.appendChild(type);
        }
        if (b.getPrimaryPerson() != null) {
            primaryPerson = this.doc.createElement("primaryPerson");
            primaryPerson.appendChild(this.doc.createTextNode(b.getPrimaryPerson().getName()));
            bookmark.appendChild(primaryPerson);
        }
        if (b.getPrimaryPerson2() != null) {
            primaryPerson = this.doc.createElement("primaryPerson2");
            primaryPerson.appendChild(this.doc.createTextNode(b.getPrimaryPerson2().getName()));
            bookmark.appendChild(primaryPerson);
        }
        if (b.getPrimaryPerson3() != null) {
            primaryPerson = this.doc.createElement("primaryPerson3");
            primaryPerson.appendChild(this.doc.createTextNode(b.getPrimaryPerson3().getName()));
            bookmark.appendChild(primaryPerson);
        }
        if (b.getPassivePerson1() != null) {
            passivePerson = this.doc.createElement("passivePerson1");
            passivePerson.appendChild(this.doc.createTextNode(b.getPassivePerson1().getName()));
            bookmark.appendChild(passivePerson);
        }
        if (b.getPassivePerson2() != null) {
            passivePerson = this.doc.createElement("passivePerson2");
            passivePerson.appendChild(this.doc.createTextNode(b.getPassivePerson2().getName()));
            bookmark.appendChild(passivePerson);
        }
        if (b.getPassivePerson3() != null) {
            passivePerson = this.doc.createElement("passivePerson3");
            passivePerson.appendChild(this.doc.createTextNode(b.getPassivePerson3().getName()));
            bookmark.appendChild(passivePerson);
        }
        if (b.getRoughness() != null) {
            bookmark.appendChild(this.addElement("roughnessActive1", b.getRoughness().name()));
        }
        if (b.getRoughnessDifferentiator() != null) {
            bookmark.appendChild(this.addElement("roughnessActiveDifferentiator1", b.getRoughnessDifferentiator().name()));
        }
        if (b.getRoughnessActive2() != null) {
            bookmark.appendChild(this.addElement("roughnessActive2", b.getRoughnessActive2().name()));
        }
        if (b.getRoughnessActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("roughnessActiveDifferentiator2", b.getRoughnessActiveDifferentiator2().name()));
        }
        if (b.getRoughnessActive3() != null) {
            bookmark.appendChild(this.addElement("roughnessActive3", b.getRoughnessActive3().name()));
        }
        if (b.getRoughnessActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("roughnessActiveDifferentiator3", b.getRoughnessActiveDifferentiator3().name()));
        }
        if (b.getRoughness() != null) {
            bookmark.appendChild(this.addElement("roughnessPassive1", b.getRoughness().name()));
        }
        if (b.getRoughnessDifferentiator() != null) {
            bookmark.appendChild(this.addElement("roughnessPassiveDifferentiator1", b.getRoughnessDifferentiator().name()));
        }
        if (b.getRoughnessPassive2() != null) {
            bookmark.appendChild(this.addElement("roughnessPassive2", b.getRoughnessPassive2().name()));
        }
        if (b.getRoughnessPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("roughnessPassiveDifferentiator2", b.getRoughnessPassiveDifferentiator2().name()));
        }
        if (b.getRoughnessPassive3() != null) {
            bookmark.appendChild(this.addElement("roughnessPassive3", b.getRoughnessPassive3().name()));
        }
        if (b.getRoughnessPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("roughnessPassiveDifferentiator3", b.getRoughnessPassiveDifferentiator3().name()));
        }
        if (b.getIntensity() != null) {
            bookmark.appendChild(this.addElement("intensityActive1", b.getIntensity().name()));
        }
        if (b.getIntensityDifferentiator() != null) {
            bookmark.appendChild(this.addElement("intensityActiveDifferentiator1", b.getIntensityDifferentiator().name()));
        }
        if (b.getIntensityActive2() != null) {
            bookmark.appendChild(this.addElement("intensityActive2", b.getIntensityActive2().name()));
        }
        if (b.getIntensityActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("intensityActiveDifferentiator2", b.getIntensityActiveDifferentiator2().name()));
        }
        if (b.getIntensityActive3() != null) {
            bookmark.appendChild(this.addElement("intensityActive3", b.getIntensityActive3().name()));
        }
        if (b.getIntensityActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("intensityActiveDifferentiator3", b.getIntensityActiveDifferentiator3().name()));
        }
        if (b.getIntensity() != null) {
            bookmark.appendChild(this.addElement("intensityPassive1", b.getIntensity().name()));
        }
        if (b.getIntensityDifferentiator() != null) {
            bookmark.appendChild(this.addElement("intensityPassiveDifferentiator1", b.getIntensityDifferentiator().name()));
        }
        if (b.getIntensityPassive2() != null) {
            bookmark.appendChild(this.addElement("intensityPassive2", b.getIntensityPassive2().name()));
        }
        if (b.getIntensityPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("intensityPassiveDifferentiator2", b.getIntensityPassiveDifferentiator2().name()));
        }
        if (b.getIntensityPassive3() != null) {
            bookmark.appendChild(this.addElement("intensityPassive3", b.getIntensityPassive3().name()));
        }
        if (b.getIntensityPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("intensityPassiveDifferentiator3", b.getIntensityPassiveDifferentiator3().name()));
        }
        if (b.getSpeed() != null) {
            bookmark.appendChild(this.addElement("speedActive1", b.getSpeed().name()));
        }
        if (b.getSpeedDifferentiator() != null) {
            bookmark.appendChild(this.addElement("speedActiveDifferentiator1", b.getSpeedDifferentiator().name()));
        }
        if (b.getSpeedActive2() != null) {
            bookmark.appendChild(this.addElement("speedActive2", b.getSpeedActive2().name()));
        }
        if (b.getSpeedActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("speedActiveDifferentiator2", b.getSpeedActiveDifferentiator2().name()));
        }
        if (b.getSpeedActive3() != null) {
            bookmark.appendChild(this.addElement("speedActive3", b.getSpeedActive3().name()));
        }
        if (b.getSpeedActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("speedActiveDifferentiator3", b.getSpeedActiveDifferentiator3().name()));
        }
        if (b.getSpeed() != null) {
            bookmark.appendChild(this.addElement("speedPassive1", b.getSpeed().name()));
        }
        if (b.getSpeedDifferentiator() != null) {
            bookmark.appendChild(this.addElement("speedPassiveDifferentiator1", b.getSpeedDifferentiator().name()));
        }
        if (b.getSpeedPassive2() != null) {
            bookmark.appendChild(this.addElement("speedPassive2", b.getSpeedPassive2().name()));
        }
        if (b.getSpeedPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("speedPassiveDifferentiator2", b.getSpeedPassiveDifferentiator2().name()));
        }
        if (b.getSpeedPassive3() != null) {
            bookmark.appendChild(this.addElement("speedPassive3", b.getSpeedPassive3().name()));
        }
        if (b.getSpeedPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("speedPassiveDifferentiator3", b.getSpeedPassiveDifferentiator3().name()));
        }
        if (b.getPositionActive1() != null) {
            bookmark.appendChild(this.addElement("positionActive1", b.getPositionActive1().name()));
        }
        if (b.getPositionActive2() != null) {
            bookmark.appendChild(this.addElement("positionActive2", b.getPositionActive2().name()));
        }
        if (b.getPositionActive3() != null) {
            bookmark.appendChild(this.addElement("positionActive3", b.getPositionActive3().name()));
        }
        if (b.getPositionPassive1() != null) {
            bookmark.appendChild(this.addElement("positionPassive1", b.getPositionPassive1().name()));
        }
        if (b.getPositionPassive2() != null) {
            bookmark.appendChild(this.addElement("positionPassive2", b.getPositionPassive2().name()));
        }
        if (b.getPositionPassive3() != null) {
            bookmark.appendChild(this.addElement("positionPassive3", b.getPositionPassive3().name()));
        }
        if (b.getPain() != null) {
            bookmark.appendChild(this.addElement("painActive1", b.getPain().name()));
        }
        if (b.getPainDifferentiator() != null) {
            bookmark.appendChild(this.addElement("painActiveDifferentiator1", b.getPainDifferentiator().name()));
        }
        if (b.getPainActive2() != null) {
            bookmark.appendChild(this.addElement("painActive2", b.getPainActive2().name()));
        }
        if (b.getPainActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("painActiveDifferentiator2", b.getPainActiveDifferentiator2().name()));
        }
        if (b.getPainActive3() != null) {
            bookmark.appendChild(this.addElement("painActive3", b.getPainActive3().name()));
        }
        if (b.getPainActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("painActiveDifferentiator3", b.getPainActiveDifferentiator3().name()));
        }
        if (b.getPain() != null) {
            bookmark.appendChild(this.addElement("painPassive1", b.getPain().name()));
        }
        if (b.getPainDifferentiator() != null) {
            bookmark.appendChild(this.addElement("painPassiveDifferentiator1", b.getPainDifferentiator().name()));
        }
        if (b.getPainPassive2() != null) {
            bookmark.appendChild(this.addElement("painPassive2", b.getPainPassive2().name()));
        }
        if (b.getPainPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("painPassiveDifferentiator2", b.getPainPassiveDifferentiator2().name()));
        }
        if (b.getPainPassive3() != null) {
            bookmark.appendChild(this.addElement("painPassive3", b.getPainPassive3().name()));
        }
        if (b.getPainPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("painPassiveDifferentiator3", b.getPainPassiveDifferentiator3().name()));
        }
        if (b.getDisgustedActive1() != null) {
            bookmark.appendChild(this.addElement("disgustedActive1", b.getDisgustedActive1().name()));
        }
        if (b.getDisgustedActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("disgustedActiveDifferentiator1", b.getDisgustedActiveDifferentiator1().name()));
        }
        if (b.getDisgustedActive2() != null) {
            bookmark.appendChild(this.addElement("disgustedActive2", b.getDisgustedActive2().name()));
        }
        if (b.getDisgustedActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("disgustedActiveDifferentiator2", b.getDisgustedActiveDifferentiator2().name()));
        }
        if (b.getDisgustedActive3() != null) {
            bookmark.appendChild(this.addElement("disgustedActive3", b.getDisgustedActive3().name()));
        }
        if (b.getDisgustedActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("disgustedActiveDifferentiator3", b.getDisgustedActiveDifferentiator3().name()));
        }
        if (b.getDisgustedPassive1() != null) {
            bookmark.appendChild(this.addElement("disgustedPassive1", b.getDisgustedPassive1().name()));
        }
        if (b.getDisgustedPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("disgustedPassiveDifferentiator1", b.getDisgustedPassiveDifferentiator1().name()));
        }
        if (b.getDisgustedPassive2() != null) {
            bookmark.appendChild(this.addElement("disgustedPassive2", b.getDisgustedPassive2().name()));
        }
        if (b.getDisgustedPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("disgustedPassiveDifferentiator2", b.getDisgustedPassiveDifferentiator2().name()));
        }
        if (b.getDisgustedPassive3() != null) {
            bookmark.appendChild(this.addElement("disgustedPassive3", b.getDisgustedPassive3().name()));
        }
        if (b.getDisgustedPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("disgustedPassiveDifferentiator3", b.getDisgustedPassiveDifferentiator3().name()));
        }
        if (b.getEnjoymentActive1() != null) {
            bookmark.appendChild(this.addElement("enjoymentActive1", b.getEnjoymentActive1().name()));
        }
        if (b.getEnjoymentActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("enjoymentActiveDifferentiator1", b.getEnjoymentActiveDifferentiator1().name()));
        }
        if (b.getEnjoymentActive2() != null) {
            bookmark.appendChild(this.addElement("enjoymentActive2", b.getEnjoymentActive2().name()));
        }
        if (b.getEnjoymentActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("enjoymentActiveDifferentiator2", b.getEnjoymentActiveDifferentiator2().name()));
        }
        if (b.getEnjoymentActive3() != null) {
            bookmark.appendChild(this.addElement("enjoymentActive3", b.getEnjoymentActive3().name()));
        }
        if (b.getEnjoymentActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("enjoymentActiveDifferentiator3", b.getEnjoymentActiveDifferentiator3().name()));
        }
        if (b.getEnjoymentPassive1() != null) {
            bookmark.appendChild(this.addElement("enjoymentPassive1", b.getEnjoymentPassive1().name()));
        }
        if (b.getEnjoymentPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("enjoymentPassiveDifferentiator1", b.getEnjoymentPassiveDifferentiator1().name()));
        }
        if (b.getEnjoymentPassive2() != null) {
            bookmark.appendChild(this.addElement("enjoymentPassive2", b.getEnjoymentPassive2().name()));
        }
        if (b.getEnjoymentPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("enjoymentPassiveDifferentiator2", b.getEnjoymentPassiveDifferentiator2().name()));
        }
        if (b.getEnjoymentPassive3() != null) {
            bookmark.appendChild(this.addElement("enjoymentPassive3", b.getEnjoymentPassive3().name()));
        }
        if (b.getEnjoymentPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("enjoymentPassiveDifferentiator3", b.getEnjoymentPassiveDifferentiator3().name()));
        }
        if (b.getMoaningActive1() != null) {
            bookmark.appendChild(this.addElement("moaningActive1", b.getMoaningActive1().name()));
        }
        if (b.getMoaningActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("moaningActiveDifferentiator1", b.getMoaningActiveDifferentiator1().name()));
        }
        if (b.getMoaningActive2() != null) {
            bookmark.appendChild(this.addElement("moaningActive2", b.getMoaningActive2().name()));
        }
        if (b.getMoaningActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("moaningActiveDifferentiator2", b.getMoaningActiveDifferentiator2().name()));
        }
        if (b.getMoaningActive3() != null) {
            bookmark.appendChild(this.addElement("moaningActive3", b.getMoaningActive3().name()));
        }
        if (b.getMoaningActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("moaningActiveDifferentiator3", b.getMoaningActiveDifferentiator3().name()));
        }
        if (b.getMoaningPassive1() != null) {
            bookmark.appendChild(this.addElement("moaningPassive1", b.getMoaningPassive1().name()));
        }
        if (b.getMoaningPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("moaningPassiveDifferentiator1", b.getMoaningPassiveDifferentiator1().name()));
        }
        if (b.getMoaningPassive2() != null) {
            bookmark.appendChild(this.addElement("moaningPassive2", b.getMoaningPassive2().name()));
        }
        if (b.getMoaningPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("moaningPassiveDifferentiator2", b.getMoaningPassiveDifferentiator2().name()));
        }
        if (b.getMoaningPassive3() != null) {
            bookmark.appendChild(this.addElement("moaningPassive3", b.getMoaningPassive3().name()));
        }
        if (b.getMoaningPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("moaningPassiveDifferentiator3", b.getMoaningPassiveDifferentiator3().name()));
        }
        if (b.getScreamingActive1() != null) {
            bookmark.appendChild(this.addElement("screamingActive1", b.getScreamingActive1().name()));
        }
        if (b.getScreamingActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("screamingActiveDifferentiator1", b.getScreamingActiveDifferentiator1().name()));
        }
        if (b.getScreamingActive2() != null) {
            bookmark.appendChild(this.addElement("screamingActive2", b.getScreamingActive2().name()));
        }
        if (b.getScreamingActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("screamingActiveDifferentiator2", b.getScreamingActiveDifferentiator2().name()));
        }
        if (b.getScreamingActive3() != null) {
            bookmark.appendChild(this.addElement("screamingActive3", b.getScreamingActive3().name()));
        }
        if (b.getScreamingActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("screamingActiveDifferentiator3", b.getScreamingActiveDifferentiator3().name()));
        }
        if (b.getScreamingPassive1() != null) {
            bookmark.appendChild(this.addElement("screamingPassive1", b.getScreamingPassive1().name()));
        }
        if (b.getScreamingPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("screamingPassiveDifferentiator1", b.getScreamingPassiveDifferentiator1().name()));
        }
        if (b.getScreamingPassive2() != null) {
            bookmark.appendChild(this.addElement("screamingPassive2", b.getScreamingPassive2().name()));
        }
        if (b.getScreamingPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("screamingPassiveDifferentiator2", b.getScreamingPassiveDifferentiator2().name()));
        }
        if (b.getScreamingPassive3() != null) {
            bookmark.appendChild(this.addElement("screamingPassive3", b.getScreamingPassive3().name()));
        }
        if (b.getScreamingPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("screamingPassiveDifferentiator3", b.getScreamingPassiveDifferentiator3().name()));
        }
        if (b.getTitsBouncingActive1() != null) {
            bookmark.appendChild(this.addElement("titsBouncingActive1", b.getTitsBouncingActive1().name()));
        }
        if (b.getTitsBouncingActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("titsBouncingActiveDifferentiator1", b.getTitsBouncingActiveDifferentiator1().name()));
        }
        if (b.getTitsBouncingActive2() != null) {
            bookmark.appendChild(this.addElement("titsBouncingActive2", b.getTitsBouncingActive2().name()));
        }
        if (b.getTitsBouncingActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("titsBouncingActiveDifferentiator2", b.getTitsBouncingActiveDifferentiator2().name()));
        }
        if (b.getTitsBouncingActive3() != null) {
            bookmark.appendChild(this.addElement("titsBouncingActive3", b.getTitsBouncingActive3().name()));
        }
        if (b.getTitsBouncingActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("titsBouncingActiveDifferentiator3", b.getTitsBouncingActiveDifferentiator3().name()));
        }
        if (b.getTitsBouncingPassive1() != null) {
            bookmark.appendChild(this.addElement("titsBouncingPassive1", b.getTitsBouncingPassive1().name()));
        }
        if (b.getTitsBouncingPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("titsBouncingPassiveDifferentiator1", b.getTitsBouncingPassiveDifferentiator1().name()));
        }
        if (b.getTitsBouncingPassive2() != null) {
            bookmark.appendChild(this.addElement("titsBouncingPassive2", b.getTitsBouncingPassive2().name()));
        }
        if (b.getTitsBouncingPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("titsBouncingPassiveDifferentiator2", b.getTitsBouncingPassiveDifferentiator2().name()));
        }
        if (b.getTitsBouncingPassive3() != null) {
            bookmark.appendChild(this.addElement("titsBouncingPassive3", b.getTitsBouncingPassive3().name()));
        }
        if (b.getTitsBouncingPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("titsBouncingPassiveDifferentiator3", b.getTitsBouncingPassiveDifferentiator3().name()));
        }
        if (b.getDirtyTalkActive1() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkActive1", b.getDirtyTalkActive1().name()));
        }
        if (b.getDirtyTalkActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkActiveDifferentiator1", b.getDirtyTalkActiveDifferentiator1().name()));
        }
        if (b.getDirtyTalkActive2() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkActive2", b.getDirtyTalkActive2().name()));
        }
        if (b.getDirtyTalkActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkActiveDifferentiator2", b.getDirtyTalkActiveDifferentiator2().name()));
        }
        if (b.getDirtyTalkActive3() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkActive3", b.getDirtyTalkActive3().name()));
        }
        if (b.getDirtyTalkActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkActiveDifferentiator3", b.getDirtyTalkActiveDifferentiator3().name()));
        }
        if (b.getDirtyTalkPassive1() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkPassive1", b.getDirtyTalkPassive1().name()));
        }
        if (b.getDirtyTalkPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkPassiveDifferentiator1", b.getDirtyTalkPassiveDifferentiator1().name()));
        }
        if (b.getDirtyTalkPassive2() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkPassive2", b.getDirtyTalkPassive2().name()));
        }
        if (b.getDirtyTalkPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkPassiveDifferentiator2", b.getDirtyTalkPassiveDifferentiator2().name()));
        }
        if (b.getDirtyTalkPassive3() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkPassive3", b.getDirtyTalkPassive3().name()));
        }
        if (b.getDirtyTalkPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkPassiveDifferentiator3", b.getDirtyTalkPassiveDifferentiator3().name()));
        }
        if (b.getDirtyTalkIntensityActive1() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityActive1", b.getDirtyTalkIntensityActive1().name()));
        }
        if (b.getDirtyTalkIntensityActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityActiveDifferentiator1", b.getDirtyTalkIntensityActiveDifferentiator1().name()));
        }
        if (b.getDirtyTalkIntensityActive2() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityActive2", b.getDirtyTalkIntensityActive2().name()));
        }
        if (b.getDirtyTalkIntensityActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityActiveDifferentiator2", b.getDirtyTalkIntensityActiveDifferentiator2().name()));
        }
        if (b.getDirtyTalkIntensityActive3() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityActive3", b.getDirtyTalkIntensityActive3().name()));
        }
        if (b.getDirtyTalkIntensityActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityActiveDifferentiator3", b.getDirtyTalkIntensityActiveDifferentiator3().name()));
        }
        if (b.getDirtyTalkIntensityPassive1() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityPassive1", b.getDirtyTalkIntensityPassive1().name()));
        }
        if (b.getDirtyTalkIntensityPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityPassiveDifferentiator1", b.getDirtyTalkIntensityPassiveDifferentiator1().name()));
        }
        if (b.getDirtyTalkIntensityPassive2() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityPassive2", b.getDirtyTalkIntensityPassive2().name()));
        }
        if (b.getDirtyTalkIntensityPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityPassiveDifferentiator2", b.getDirtyTalkIntensityPassiveDifferentiator2().name()));
        }
        if (b.getDirtyTalkIntensityPassive3() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityPassive3", b.getDirtyTalkIntensityPassive3().name()));
        }
        if (b.getDirtyTalkIntensityPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("dirtyTalkIntensityPassiveDifferentiator3", b.getDirtyTalkIntensityPassiveDifferentiator3().name()));
        }
        if (b.getDominatingActive1() != null) {
            bookmark.appendChild(this.addElement("dominatingActive1", b.getDominatingActive1().name()));
        }
        if (b.getDominatingActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("dominatingActiveDifferentiator1", b.getDominatingActiveDifferentiator1().name()));
        }
        if (b.getDominatingActive2() != null) {
            bookmark.appendChild(this.addElement("dominatingActive2", b.getDominatingActive2().name()));
        }
        if (b.getDominatingActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("dominatingActiveDifferentiator2", b.getDominatingActiveDifferentiator2().name()));
        }
        if (b.getDominatingActive3() != null) {
            bookmark.appendChild(this.addElement("dominatingActive3", b.getDominatingActive3().name()));
        }
        if (b.getDominatingActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("dominatingActiveDifferentiator3", b.getDominatingActiveDifferentiator3().name()));
        }
        if (b.getDominatingPassive1() != null) {
            bookmark.appendChild(this.addElement("dominatingPassive1", b.getDominatingPassive1().name()));
        }
        if (b.getDominatingPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("dominatingPassiveDifferentiator1", b.getDominatingPassiveDifferentiator1().name()));
        }
        if (b.getDominatingPassive2() != null) {
            bookmark.appendChild(this.addElement("dominatingPassive2", b.getDominatingPassive2().name()));
        }
        if (b.getDominatingPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("dominatingPassiveDifferentiator2", b.getDominatingPassiveDifferentiator2().name()));
        }
        if (b.getDominatingPassive3() != null) {
            bookmark.appendChild(this.addElement("dominatingPassive3", b.getDominatingPassive3().name()));
        }
        if (b.getDominatingPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("dominatingPassiveDifferentiator3", b.getDominatingPassiveDifferentiator3().name()));
        }
        if (b.getSubmissiveActive1() != null) {
            bookmark.appendChild(this.addElement("submissiveActive1", b.getSubmissiveActive1().name()));
        }
        if (b.getSubmissiveActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("submissiveActiveDifferentiator1", b.getSubmissiveActiveDifferentiator1().name()));
        }
        if (b.getSubmissiveActive2() != null) {
            bookmark.appendChild(this.addElement("submissiveActive2", b.getSubmissiveActive2().name()));
        }
        if (b.getSubmissiveActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("submissiveActiveDifferentiator2", b.getSubmissiveActiveDifferentiator2().name()));
        }
        if (b.getSubmissiveActive3() != null) {
            bookmark.appendChild(this.addElement("submissiveActive3", b.getSubmissiveActive3().name()));
        }
        if (b.getSubmissiveActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("submissiveActiveDifferentiator3", b.getSubmissiveActiveDifferentiator3().name()));
        }
        if (b.getSubmissivePassive1() != null) {
            bookmark.appendChild(this.addElement("submissivePassive1", b.getSubmissivePassive1().name()));
        }
        if (b.getSubmissivePassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("submissivePassiveDifferentiator1", b.getSubmissivePassiveDifferentiator1().name()));
        }
        if (b.getSubmissivePassive2() != null) {
            bookmark.appendChild(this.addElement("submissivePassive2", b.getSubmissivePassive2().name()));
        }
        if (b.getSubmissivePassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("submissivePassiveDifferentiator2", b.getSubmissivePassiveDifferentiator2().name()));
        }
        if (b.getSubmissivePassive3() != null) {
            bookmark.appendChild(this.addElement("submissivePassive3", b.getSubmissivePassive3().name()));
        }
        if (b.getSubmissivePassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("submissivePassiveDifferentiator3", b.getSubmissivePassiveDifferentiator3().name()));
        }
        if (b.getCumCoveredActive1() != null) {
            bookmark.appendChild(this.addElement("cumCoveredActive1", b.getCumCoveredActive1().name()));
        }
        if (b.getCumCoveredActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("cumCoveredActiveDifferentiator1", b.getCumCoveredActiveDifferentiator1().name()));
        }
        if (b.getCumCoveredActive2() != null) {
            bookmark.appendChild(this.addElement("cumCoveredActive2", b.getCumCoveredActive2().name()));
        }
        if (b.getCumCoveredActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("cumCoveredActiveDifferentiator2", b.getCumCoveredActiveDifferentiator2().name()));
        }
        if (b.getCumCoveredActive3() != null) {
            bookmark.appendChild(this.addElement("cumCoveredActive3", b.getCumCoveredActive3().name()));
        }
        if (b.getCumCoveredActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("cumCoveredActiveDifferentiator3", b.getCumCoveredActiveDifferentiator3().name()));
        }
        if (b.getCumCoveredPassive1() != null) {
            bookmark.appendChild(this.addElement("cumCoveredPassive1", b.getCumCoveredPassive1().name()));
        }
        if (b.getCumCoveredPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("cumCoveredPassiveDifferentiator1", b.getCumCoveredPassiveDifferentiator1().name()));
        }
        if (b.getCumCoveredPassive2() != null) {
            bookmark.appendChild(this.addElement("cumCoveredPassive2", b.getCumCoveredPassive2().name()));
        }
        if (b.getCumCoveredPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("cumCoveredPassiveDifferentiator2", b.getCumCoveredPassiveDifferentiator2().name()));
        }
        if (b.getCumCoveredPassive3() != null) {
            bookmark.appendChild(this.addElement("cumCoveredPassive3", b.getCumCoveredPassive3().name()));
        }
        if (b.getCumCoveredPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("cumCoveredPassiveDifferentiator3", b.getCumCoveredPassiveDifferentiator3().name()));
        }
        if (b.getEyeContactWithCameraActive1() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraActive1", b.getEyeContactWithCameraActive1().name()));
        }
        if (b.getEyeContactWithCameraActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraActiveDifferentiator1", b.getEyeContactWithCameraActiveDifferentiator1().name()));
        }
        if (b.getEyeContactWithCameraActive2() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraActive2", b.getEyeContactWithCameraActive2().name()));
        }
        if (b.getEyeContactWithCameraActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraActiveDifferentiator2", b.getEyeContactWithCameraActiveDifferentiator2().name()));
        }
        if (b.getEyeContactWithCameraActive3() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraActive3", b.getEyeContactWithCameraActive3().name()));
        }
        if (b.getEyeContactWithCameraActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraActiveDifferentiator3", b.getEyeContactWithCameraActiveDifferentiator3().name()));
        }
        if (b.getEyeContactWithCameraPassive1() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraPassive1", b.getEyeContactWithCameraPassive1().name()));
        }
        if (b.getEyeContactWithCameraPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraPassiveDifferentiator1", b.getEyeContactWithCameraPassiveDifferentiator1().name()));
        }
        if (b.getEyeContactWithCameraPassive2() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraPassive2", b.getEyeContactWithCameraPassive2().name()));
        }
        if (b.getEyeContactWithCameraPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraPassiveDifferentiator2", b.getEyeContactWithCameraPassiveDifferentiator2().name()));
        }
        if (b.getEyeContactWithCameraPassive3() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraPassive3", b.getEyeContactWithCameraPassive3().name()));
        }
        if (b.getEyeContactWithCameraPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithCameraPassiveDifferentiator3", b.getEyeContactWithCameraPassiveDifferentiator3().name()));
        }
        if (b.getEyeContactWithPartnerActive1() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerActive1", b.getEyeContactWithPartnerActive1().name()));
        }
        if (b.getEyeContactWithPartnerActiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerActiveDifferentiator1", b.getEyeContactWithPartnerActiveDifferentiator1().name()));
        }
        if (b.getEyeContactWithPartnerActive2() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerActive2", b.getEyeContactWithPartnerActive2().name()));
        }
        if (b.getEyeContactWithPartnerActiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerActiveDifferentiator2", b.getEyeContactWithPartnerActiveDifferentiator2().name()));
        }
        if (b.getEyeContactWithPartnerActive3() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerActive3", b.getEyeContactWithPartnerActive3().name()));
        }
        if (b.getEyeContactWithPartnerActiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerActiveDifferentiator3", b.getEyeContactWithPartnerActiveDifferentiator3().name()));
        }
        if (b.getEyeContactWithPartnerPassive1() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerPassive1", b.getEyeContactWithPartnerPassive1().name()));
        }
        if (b.getEyeContactWithPartnerPassiveDifferentiator1() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerPassiveDifferentiator1", b.getEyeContactWithPartnerPassiveDifferentiator1().name()));
        }
        if (b.getEyeContactWithPartnerPassive2() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerPassive2", b.getEyeContactWithPartnerPassive2().name()));
        }
        if (b.getEyeContactWithPartnerPassiveDifferentiator2() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerPassiveDifferentiator2", b.getEyeContactWithPartnerPassiveDifferentiator2().name()));
        }
        if (b.getEyeContactWithPartnerPassive3() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerPassive3", b.getEyeContactWithPartnerPassive3().name()));
        }
        if (b.getEyeContactWithPartnerPassiveDifferentiator3() != null) {
            bookmark.appendChild(this.addElement("eyeContactWithPartnerPassiveDifferentiator3", b.getEyeContactWithPartnerPassiveDifferentiator3().name()));
        }
        if (!b.getToys().isEmpty()) {
            Element toysRootElement = this.doc.createElement("toysRoot");
            for (Toys toy : b.getToys()) {
                Element toysElement = this.doc.createElement("toys");
                toysElement.appendChild(this.doc.createTextNode(toy.name()));
                toysRootElement.appendChild(toysElement);
            }
            bookmark.appendChild(toysRootElement);
        }
        if (b.getType() == BookmarkType.GOLDENSHOWER && (gs = (Goldenshower)this.db.getEntityService().find(QGoldenshower.goldenshower).filter(f -> f.bookmark.eq(b)).findFirst()) != null) {
            Element colorDifferentiator;
            Element goldenshowerRoot = this.doc.createElement("goldenshower");
            if (gs.getDripping() != null) {
                Element dripping = this.doc.createElement("dripping");
                dripping.appendChild(this.doc.createTextNode("" + gs.getDripping()));
                goldenshowerRoot.appendChild(dripping);
            }
            if (gs.getGargle() != null) {
                Element gargle = this.doc.createElement("gargle");
                gargle.appendChild(this.doc.createTextNode("" + gs.getGargle()));
                goldenshowerRoot.appendChild(gargle);
            }
            if (gs.getRecap() != null) {
                Element recap = this.doc.createElement("recap");
                recap.appendChild(this.doc.createTextNode("" + gs.getRecap()));
                goldenshowerRoot.appendChild(recap);
            }
            if (gs.getSwallow() != null) {
                swallow = this.doc.createElement("swallow");
                swallow.appendChild(this.doc.createTextNode("" + gs.getSwallow()));
                goldenshowerRoot.appendChild(swallow);
            }
            if (gs.getColor() != null) {
                Element color = this.doc.createElement("color");
                color.appendChild(this.doc.createTextNode(String.valueOf(gs.getColor())));
                goldenshowerRoot.appendChild(color);
            }
            if (gs.getColorDifferentiator() != null) {
                colorDifferentiator = this.doc.createElement("colorDifferentiator");
                colorDifferentiator.appendChild(this.doc.createTextNode(String.valueOf(gs.getColorDifferentiator())));
                goldenshowerRoot.appendChild(colorDifferentiator);
            }
            if (gs.getColorDifferentiator() != null) {
                colorDifferentiator = this.doc.createElement("colorDifferentiator");
                colorDifferentiator.appendChild(this.doc.createTextNode(String.valueOf(gs.getColorDifferentiator())));
                goldenshowerRoot.appendChild(colorDifferentiator);
            }
            if (gs.getQuantity() != null) {
                quantity = this.doc.createElement("quantity");
                quantity.appendChild(this.doc.createTextNode(String.valueOf(gs.getQuantity())));
                goldenshowerRoot.appendChild(quantity);
            }
            if (gs.getQuantityDifferentiator() != null) {
                quantityDifferentiator = this.doc.createElement("quantityDifferentiator");
                quantityDifferentiator.appendChild(this.doc.createTextNode(String.valueOf(gs.getQuantityDifferentiator())));
                goldenshowerRoot.appendChild(quantityDifferentiator);
            }
            if (gs.getTarget1Person1() != null) {
                Element target1Person1 = this.doc.createElement("target1Person1");
                target1Person1.appendChild(this.doc.createTextNode(String.valueOf(gs.getTarget1Person1())));
                goldenshowerRoot.appendChild(target1Person1);
            }
        }
        if (b.isCumshotType() && (cs = (Cumshot)this.db.getEntityService().find(QCumshot.cumshot).filter(f -> f.bookmark.eq(b)).findFirst()) != null) {
            Element csPosition;
            Element enjoymentDifferentiator;
            Element enjoyment;
            Element disgustedDifferentiator;
            Element disgusted;
            Element cumshotRoot = this.doc.createElement("cumshot");
            if (cs.getCleanup() != null) {
                Element cleanup = this.doc.createElement("cleanup");
                cleanup.appendChild(this.doc.createTextNode("" + cs.getCleanup()));
                cumshotRoot.appendChild(cleanup);
            }
            if (cs.getSwallow() != null) {
                swallow = this.doc.createElement("swallow");
                swallow.appendChild(this.doc.createTextNode("" + cs.getSwallow()));
                cumshotRoot.appendChild(swallow);
            }
            if (cs.getDisgusted() != null) {
                disgusted = this.doc.createElement("disgusted");
                disgusted.appendChild(this.doc.createTextNode(cs.getDisgusted().name()));
                cumshotRoot.appendChild(disgusted);
            }
            if (cs.getDisgustedDifferentiator() != null) {
                disgustedDifferentiator = this.doc.createElement("disgustedDifferentiator");
                disgustedDifferentiator.appendChild(this.doc.createTextNode(cs.getDisgustedDifferentiator().name()));
                cumshotRoot.appendChild(disgustedDifferentiator);
            }
            if (cs.getDisgusted2() != null) {
                disgusted = this.doc.createElement("disgusted2");
                disgusted.appendChild(this.doc.createTextNode(cs.getDisgusted2().name()));
                cumshotRoot.appendChild(disgusted);
            }
            if (cs.getDisgustedDifferentiator2() != null) {
                disgustedDifferentiator = this.doc.createElement("disgustedDifferentiator2");
                disgustedDifferentiator.appendChild(this.doc.createTextNode(cs.getDisgustedDifferentiator2().name()));
                cumshotRoot.appendChild(disgustedDifferentiator);
            }
            if (cs.getDisgustedDifferentiator3() != null) {
                disgustedDifferentiator = this.doc.createElement("disgustedDifferentiator3");
                disgustedDifferentiator.appendChild(this.doc.createTextNode(cs.getDisgustedDifferentiator3().name()));
                cumshotRoot.appendChild(disgustedDifferentiator);
            }
            if (cs.getEnjoyment() != null) {
                enjoyment = this.doc.createElement("enjoyment");
                enjoyment.appendChild(this.doc.createTextNode(cs.getEnjoyment().name()));
                cumshotRoot.appendChild(enjoyment);
            }
            if (cs.getEnjoymentDifferentiator() != null) {
                enjoymentDifferentiator = this.doc.createElement("enjoymentDifferentiator");
                enjoymentDifferentiator.appendChild(this.doc.createTextNode(cs.getEnjoymentDifferentiator().name()));
                cumshotRoot.appendChild(enjoymentDifferentiator);
            }
            if (cs.getEnjoyment2() != null) {
                enjoyment = this.doc.createElement("enjoyment2");
                enjoyment.appendChild(this.doc.createTextNode(cs.getEnjoyment2().name()));
                cumshotRoot.appendChild(enjoyment);
            }
            if (cs.getEnjoymentDifferentiator2() != null) {
                enjoymentDifferentiator = this.doc.createElement("enjoymentDifferentiator2");
                enjoymentDifferentiator.appendChild(this.doc.createTextNode(cs.getEnjoymentDifferentiator2().name()));
                cumshotRoot.appendChild(enjoymentDifferentiator);
            }
            if (cs.getEnjoyment3() != null) {
                enjoyment = this.doc.createElement("enjoyment3");
                enjoyment.appendChild(this.doc.createTextNode(cs.getEnjoyment3().name()));
                cumshotRoot.appendChild(enjoyment);
            }
            if (cs.getEnjoymentDifferentiator3() != null) {
                enjoymentDifferentiator = this.doc.createElement("enjoymentDifferentiator3");
                enjoymentDifferentiator.appendChild(this.doc.createTextNode(cs.getEnjoymentDifferentiator3().name()));
                cumshotRoot.appendChild(enjoymentDifferentiator);
            }
            if (cs.getQuantity() != null) {
                quantity = this.doc.createElement("quantity");
                quantity.appendChild(this.doc.createTextNode(cs.getQuantity().name()));
                cumshotRoot.appendChild(quantity);
            }
            if (cs.getQuantityDifferentiator() != null) {
                quantityDifferentiator = this.doc.createElement("quantityDifferentiator");
                quantityDifferentiator.appendChild(this.doc.createTextNode(cs.getQuantityDifferentiator().name()));
                cumshotRoot.appendChild(quantityDifferentiator);
            }
            if (cs.getPosition() != null) {
                csPosition = this.doc.createElement("position");
                csPosition.appendChild(this.doc.createTextNode(cs.getPosition().name()));
                cumshotRoot.appendChild(csPosition);
            }
            if (cs.getPosition2() != null) {
                csPosition = this.doc.createElement("position2");
                csPosition.appendChild(this.doc.createTextNode(cs.getPosition2().name()));
                cumshotRoot.appendChild(csPosition);
            }
            if (cs.getPosition3() != null) {
                csPosition = this.doc.createElement("position3");
                csPosition.appendChild(this.doc.createTextNode(cs.getPosition3().name()));
                cumshotRoot.appendChild(csPosition);
            }
            bookmark.appendChild(cumshotRoot);
        }
        if (b.getMedium() != null) {
            Element startmedium = this.doc.createElement("startMedium");
            startmedium.appendChild(this.createMediumElement(b.getMedium()));
            bookmark.appendChild(startmedium);
        }
        if (b.getEndMedium() != null) {
            Element endmedium = this.doc.createElement("endMedium");
            endmedium.appendChild(this.createMediumElement(b.getEndMedium()));
            bookmark.appendChild(endmedium);
        }
        if (!b.getChildren(false).isEmpty()) {
            Element subBookmarks = this.doc.createElement("subBookmarks");
            for (Bookmark subBookmark : b.getChildren(false)) {
                subBookmarks.appendChild(this.createBookmarkElement(subBookmark));
            }
            bookmark.appendChild(subBookmarks);
        }
        if (!b.getPictures().isEmpty()) {
            Element pictures = this.doc.createElement("pictures");
            for (MediumFile mf : b.getPictures()) {
                pictures.appendChild(this.createMediumElement(mf));
            }
            bookmark.appendChild(pictures);
        }
        return bookmark;
    }

    private Element createSceneDetailsElement(SceneDetails sd) {
        Element sceneDetails = this.doc.createElement("scenedetail");
        Element person = this.doc.createElement("person");
        if (sd.getPerson() != null && !sd.getPerson().isSecret()) {
            person.appendChild(this.doc.createTextNode(sd.getPerson().getName()));
        } else {
            java.util.logging.Logger.getLogger(Exporter.class.getName()).log(Level.INFO, "no person associated to scene details");
        }
        sceneDetails.appendChild(person);
        if (sd.getCreditedAs() != null) {
            Element creditedAs = this.doc.createElement("creditedAs");
            creditedAs.appendChild(this.doc.createTextNode(sd.getCreditedAs()));
            sceneDetails.appendChild(creditedAs);
        }
        if (sd.getHairColor() != null) {
            Element hairColor = this.doc.createElement("hairColor");
            hairColor.appendChild(this.doc.createTextNode(sd.getHairColor().name()));
            sceneDetails.appendChild(hairColor);
        }
        if (sd.getHairLength() != null) {
            Element hairLength = this.doc.createElement("hairLength");
            hairLength.appendChild(this.doc.createTextNode(sd.getHairLength().name()));
            sceneDetails.appendChild(hairLength);
        }
        if (sd.getHairType() != null) {
            Element hairType = this.doc.createElement("hairType");
            hairType.appendChild(this.doc.createTextNode(sd.getHairType().name()));
            sceneDetails.appendChild(hairType);
        }
        if (sd.getHairStyle() != null) {
            Element hairStyle = this.doc.createElement("hairStyle");
            hairStyle.appendChild(this.doc.createTextNode(sd.getHairStyle().name()));
            sceneDetails.appendChild(hairStyle);
        }
        if (sd.getPubicHairLength() != null) {
            Element pubicHair = this.doc.createElement("pubicHair");
            pubicHair.appendChild(this.doc.createTextNode(sd.getPubicHairLength().name()));
            sceneDetails.appendChild(pubicHair);
        }
        if (sd.getMakeup() != null) {
            Element makeup = this.doc.createElement("makeup");
            makeup.appendChild(this.doc.createTextNode(sd.getMakeup().name()));
            sceneDetails.appendChild(makeup);
        }
        if (sd.getMakeupDifferentiator() != null) {
            Element makeupDifferentiator = this.doc.createElement("makeupDifferentiator");
            makeupDifferentiator.appendChild(this.doc.createTextNode(sd.getMakeupDifferentiator().name()));
            sceneDetails.appendChild(makeupDifferentiator);
        }
        if (sd.getFreckles() != null) {
            Element freckles = this.doc.createElement("freckles");
            freckles.appendChild(this.doc.createTextNode(sd.getFreckles().name()));
            sceneDetails.appendChild(freckles);
        }
        if (sd.getFrecklesDifferentiator() != null) {
            Element frecklesDifferentiator = this.doc.createElement("frecklesDifferentiator");
            frecklesDifferentiator.appendChild(this.doc.createTextNode(sd.getFrecklesDifferentiator().name()));
            sceneDetails.appendChild(frecklesDifferentiator);
        }
        if (sd.getSkinTone() != null) {
            Element skinTone = this.doc.createElement("skinTone");
            skinTone.appendChild(this.doc.createTextNode(sd.getSkinTone().name()));
            sceneDetails.appendChild(skinTone);
        }
        if (sd.getSkinToneDifferentiator() != null) {
            Element skinToneDifferentiator = this.doc.createElement("skinToneDifferentiator");
            skinToneDifferentiator.appendChild(this.doc.createTextNode(sd.getSkinToneDifferentiator().name()));
            sceneDetails.appendChild(skinToneDifferentiator);
        }
        if (sd.getNails() != null) {
            Element nails = this.doc.createElement("nails");
            nails.appendChild(this.doc.createTextNode(sd.getNails().name()));
            sceneDetails.appendChild(nails);
        }
        if (sd.getNailsDifferentiator() != null) {
            Element nailsDifferentiator = this.doc.createElement("nailsDifferentiator");
            nailsDifferentiator.appendChild(this.doc.createTextNode(sd.getNailsDifferentiator().name()));
            sceneDetails.appendChild(nailsDifferentiator);
        }
        if (sd.getDirtyTalk() != null) {
            Element dirtytalk = this.doc.createElement("dirtytalk");
            dirtytalk.appendChild(this.doc.createTextNode(sd.getDirtyTalk().name()));
            sceneDetails.appendChild(dirtytalk);
        }
        if (sd.getDirtyTalkDifferentiator() != null) {
            Element dirtytalkDifferentiator = this.doc.createElement("dirtytalkDifferentiator");
            dirtytalkDifferentiator.appendChild(this.doc.createTextNode(sd.getDirtyTalkDifferentiator().name()));
            sceneDetails.appendChild(dirtytalkDifferentiator);
        }
        if (sd.getDirtyTalkIntensity() != null) {
            Element dirtytalkIntensity = this.doc.createElement("dirtytalkIntensity");
            dirtytalkIntensity.appendChild(this.doc.createTextNode(sd.getDirtyTalkIntensity().name()));
            sceneDetails.appendChild(dirtytalkIntensity);
        }
        if (sd.getDirtyTalkIntensityDifferentiator() != null) {
            Element dirtytalkIntensityDifferentiator = this.doc.createElement("dirtytalkIntensityDifferentiator");
            dirtytalkIntensityDifferentiator.appendChild(this.doc.createTextNode(sd.getDirtyTalkIntensityDifferentiator().name()));
            sceneDetails.appendChild(dirtytalkIntensityDifferentiator);
        }
        if (sd.getDominating() != null) {
            Element dominating = this.doc.createElement("dominating");
            dominating.appendChild(this.doc.createTextNode(sd.getDominating().name()));
            sceneDetails.appendChild(dominating);
        }
        if (sd.getDominatingDifferentiator() != null) {
            Element dominatingDifferentiator = this.doc.createElement("dominatingDifferentiator");
            dominatingDifferentiator.appendChild(this.doc.createTextNode(sd.getDominatingDifferentiator().name()));
            sceneDetails.appendChild(dominatingDifferentiator);
        }
        if (sd.getDisgusted() != null) {
            Element disgusted = this.doc.createElement("disgusted");
            disgusted.appendChild(this.doc.createTextNode(sd.getDisgusted().name()));
            sceneDetails.appendChild(disgusted);
        }
        if (sd.getDisgustedDifferentiator() != null) {
            Element disgustedDifferentiator = this.doc.createElement("disgustedDifferentiator");
            disgustedDifferentiator.appendChild(this.doc.createTextNode(sd.getDisgustedDifferentiator().name()));
            sceneDetails.appendChild(disgustedDifferentiator);
        }
        if (sd.getEnjoyment() != null) {
            Element enjoyment = this.doc.createElement("enjoyment");
            enjoyment.appendChild(this.doc.createTextNode(sd.getEnjoyment().name()));
            sceneDetails.appendChild(enjoyment);
        }
        if (sd.getEnjoymentDifferentiator() != null) {
            Element enjoymentDifferentiator = this.doc.createElement("enjoymentDifferentiator");
            enjoymentDifferentiator.appendChild(this.doc.createTextNode(sd.getEnjoymentDifferentiator().name()));
            sceneDetails.appendChild(enjoymentDifferentiator);
        }
        if (sd.getMoaning() != null) {
            Element moaning = this.doc.createElement("moaning");
            moaning.appendChild(this.doc.createTextNode(sd.getMoaning().name()));
            sceneDetails.appendChild(moaning);
        }
        if (sd.getMoaningDifferentiator() != null) {
            Element moaningDifferentiator = this.doc.createElement("moaningDifferentiator");
            moaningDifferentiator.appendChild(this.doc.createTextNode(sd.getMoaningDifferentiator().name()));
            sceneDetails.appendChild(moaningDifferentiator);
        }
        if (sd.getScreaming() != null) {
            Element screaming = this.doc.createElement("screaming");
            screaming.appendChild(this.doc.createTextNode(sd.getScreaming().name()));
            sceneDetails.appendChild(screaming);
        }
        if (sd.getScreamingDifferentiator() != null) {
            Element screamingDifferentiator = this.doc.createElement("screamingDifferentiator");
            screamingDifferentiator.appendChild(this.doc.createTextNode(sd.getScreamingDifferentiator().name()));
            sceneDetails.appendChild(screamingDifferentiator);
        }
        if (sd.getTitsBouncing() != null) {
            Element titsBouncing = this.doc.createElement("titsBouncing");
            titsBouncing.appendChild(this.doc.createTextNode(sd.getTitsBouncing().name()));
            sceneDetails.appendChild(titsBouncing);
        }
        if (sd.getTitsBouncingDifferentiator() != null) {
            Element titsBouncingDifferentiator = this.doc.createElement("titsBouncingDifferentiator");
            titsBouncingDifferentiator.appendChild(this.doc.createTextNode(sd.getTitsBouncingDifferentiator().name()));
            sceneDetails.appendChild(titsBouncingDifferentiator);
        }
        if (sd.getTattoos() != null) {
            Element tattoos = this.doc.createElement("tattoos");
            tattoos.appendChild(this.doc.createTextNode(sd.getTattoos().name()));
            sceneDetails.appendChild(tattoos);
        }
        if (sd.getTattoosDifferentiator() != null) {
            Element tattoosDifferentiator = this.doc.createElement("tattoosDifferentiator");
            tattoosDifferentiator.appendChild(this.doc.createTextNode(sd.getTattoosDifferentiator().name()));
            sceneDetails.appendChild(tattoosDifferentiator);
        }
        if (sd.getBodyType() != null) {
            Element bodytype = this.doc.createElement("bodytype");
            bodytype.appendChild(this.doc.createTextNode(sd.getBodyType().name()));
            sceneDetails.appendChild(bodytype);
        }
        if (sd.getBodyTypeDifferentiator() != null) {
            Element bodytypeDifferentiator = this.doc.createElement("bodytypeDifferentiator");
            bodytypeDifferentiator.appendChild(this.doc.createTextNode(sd.getBodyTypeDifferentiator().name()));
            sceneDetails.appendChild(bodytypeDifferentiator);
        }
        if (sd.isFakeTits() != null) {
            Element fakeTits = this.doc.createElement("fakeTits");
            fakeTits.appendChild(this.doc.createTextNode("" + sd.isFakeTits()));
            sceneDetails.appendChild(fakeTits);
        }
        if (sd.getFakeTitsObviousness() != null) {
            Element fakeTitsObviousness = this.doc.createElement("fakeTitsObviousness");
            fakeTitsObviousness.appendChild(this.doc.createTextNode(sd.getFakeTitsObviousness().name()));
            sceneDetails.appendChild(fakeTitsObviousness);
        }
        if (sd.getFakeTitsObviousnessDifferentiator() != null) {
            Element fakeTitsObviousnessDifferentiator = this.doc.createElement("fakeTitsObviousnessDifferentiator");
            fakeTitsObviousnessDifferentiator.appendChild(this.doc.createTextNode(sd.getFakeTitsObviousnessDifferentiator().name()));
            sceneDetails.appendChild(fakeTitsObviousnessDifferentiator);
        }
        if (sd.isFaceCensored() != null) {
            Element faceCensored = this.doc.createElement("faceCensored");
            faceCensored.appendChild(this.doc.createTextNode("" + sd.isFaceCensored()));
            sceneDetails.appendChild(faceCensored);
        }
        if (sd.isBraces() != null) {
            Element braces = this.doc.createElement("braces");
            braces.appendChild(this.doc.createTextNode("" + sd.isBraces()));
            sceneDetails.appendChild(braces);
        }
        if (sd.isNonSex() != null) {
            Element nonSex = this.doc.createElement("nonSex");
            nonSex.appendChild(this.doc.createTextNode("" + sd.isNonSex()));
            sceneDetails.appendChild(nonSex);
        }
        if (sd.isCuck() != null) {
            Element cuck = this.doc.createElement("cuck");
            cuck.appendChild(this.doc.createTextNode("" + sd.isCuck()));
            sceneDetails.appendChild(cuck);
        }
        if (sd.getTitsSize() != null) {
            Element titsSize = this.doc.createElement("titsSize");
            titsSize.appendChild(this.doc.createTextNode(sd.getTitsSize().name()));
            sceneDetails.appendChild(titsSize);
        }
        if (sd.getTitsSizeDifferentiator() != null) {
            Element titsSizeDifferentiator = this.doc.createElement("titsSizeDifferentiator");
            titsSizeDifferentiator.appendChild(this.doc.createTextNode(sd.getTitsSizeDifferentiator().name()));
            sceneDetails.appendChild(titsSizeDifferentiator);
        }
        if (sd.getAssSize() != null) {
            Element assSize = this.doc.createElement("assSize");
            assSize.appendChild(this.doc.createTextNode(sd.getAssSize().name()));
            sceneDetails.appendChild(assSize);
        }
        if (sd.getAssSizeDifferentiator() != null) {
            Element assSizeDifferentiator = this.doc.createElement("assSizeDifferentiator");
            assSizeDifferentiator.appendChild(this.doc.createTextNode(sd.getAssSizeDifferentiator().name()));
            sceneDetails.appendChild(assSizeDifferentiator);
        }
        if (sd.getDickSize() != null) {
            Element dickSize = this.doc.createElement("dickSize");
            dickSize.appendChild(this.doc.createTextNode(sd.getDickSize().name()));
            sceneDetails.appendChild(dickSize);
        }
        if (sd.getDickSizeDifferentiator() != null) {
            Element dickSizeDifferentiator = this.doc.createElement("dickSizeDifferentiator");
            dickSizeDifferentiator.appendChild(this.doc.createTextNode(sd.getDickSizeDifferentiator().name()));
            sceneDetails.appendChild(dickSizeDifferentiator);
        }
        if (sd.getLanguageSpoken() != null) {
            Element spokenLanguage = this.doc.createElement("spokenLanguage");
            spokenLanguage.appendChild(this.doc.createTextNode(sd.getLanguageSpoken().name()));
            sceneDetails.appendChild(spokenLanguage);
        }
        if (!sd.getClothes().isEmpty()) {
            Element clothesRootElement = this.doc.createElement("clothesRoot");
            for (Clothes c : sd.getClothes()) {
                Element clothesElement = this.doc.createElement("clothes");
                clothesElement.appendChild(this.doc.createTextNode(c.name()));
                clothesRootElement.appendChild(clothesElement);
            }
            sceneDetails.appendChild(clothesRootElement);
        }
        if (!sd.getAppearances().isEmpty()) {
            Element appearancesRootElement = this.doc.createElement("appearancesRoot");
            for (Appearance app : sd.getAppearances()) {
                Element appearancesElement = this.doc.createElement("appearance");
                appearancesElement.appendChild(this.doc.createTextNode(app.name()));
                appearancesRootElement.appendChild(appearancesElement);
            }
            sceneDetails.appendChild(appearancesRootElement);
        }
        if (!sd.getJewelry().isEmpty()) {
            Element jewelryRootElement = this.doc.createElement("jewelryRoot");
            for (Jewelry j : sd.getJewelry()) {
                Element jewelryElement = this.doc.createElement("jewelry");
                jewelryElement.appendChild(this.doc.createTextNode(j.name()));
                jewelryRootElement.appendChild(jewelryElement);
            }
            sceneDetails.appendChild(jewelryRootElement);
        }
        return sceneDetails;
    }

    public Element createStudioElement(Studio s, Document doc) {
        Element studio = doc.createElement("studio");
        Element name = doc.createElement("name");
        name.appendChild(doc.createTextNode(s.getName()));
        studio.appendChild(name);
        if (s.getStudioWebsites() != null) {
            Element studioWebsitesRootElement = doc.createElement("studioWebsitesRoot");
            for (StudioWebsites pw : s.getStudioWebsites()) {
                Element studioWebsite = doc.createElement("studioWebsite");
                Element site = doc.createElement("site");
                site.appendChild(doc.createTextNode(pw.getSocialWebsite().toString()));
                Element url = doc.createElement("url");
                url.appendChild(doc.createTextNode(pw.getUrl()));
                studioWebsite.appendChild(site);
                studioWebsite.appendChild(url);
                studioWebsitesRootElement.appendChild(studioWebsite);
            }
            studio.appendChild(studioWebsitesRootElement);
        }
        if (s.getHomepage() != null) {
            Element homepage = doc.createElement("homepage");
            homepage.appendChild(doc.createTextNode(s.getHomepage()));
            studio.appendChild(homepage);
        }
        if (s.getHomepage2() != null) {
            Element homepage2 = doc.createElement("homepage2");
            homepage2.appendChild(doc.createTextNode(s.getHomepage2()));
            studio.appendChild(homepage2);
        }
        if (s.getTwitter() != null) {
            Element twitter = doc.createElement("twitter");
            twitter.appendChild(doc.createTextNode(s.getTwitter()));
            studio.appendChild(twitter);
        }
        if (s.getTwitter2() != null) {
            Element twitter2 = doc.createElement("twitter2");
            twitter2.appendChild(doc.createTextNode(s.getTwitter2()));
            studio.appendChild(twitter2);
        }
        if (s.getWikipedia() != null) {
            Element wikipedia = doc.createElement("wikipedia");
            wikipedia.appendChild(doc.createTextNode(s.getWikipedia()));
            studio.appendChild(wikipedia);
        }
        if (s.getOtherUrls() != null) {
            Element otherUrls = doc.createElement("otherUrls");
            otherUrls.appendChild(doc.createTextNode(s.getOtherUrls()));
            studio.appendChild(otherUrls);
        }
        if (s.getYearFounded() != null) {
            Element yearFounded = doc.createElement("yearFounded");
            yearFounded.appendChild(doc.createTextNode("" + s.getYearFounded()));
            studio.appendChild(yearFounded);
        }
        if (s.getYearDefunct() != null) {
            Element yearDefunct = doc.createElement("yearDefunct");
            yearDefunct.appendChild(doc.createTextNode("" + s.getYearDefunct()));
            studio.appendChild(yearDefunct);
        }
        if (s.getPublicDescription() != null) {
            Element desc = doc.createElement("description");
            desc.appendChild(doc.createTextNode(s.getPublicDescription()));
            studio.appendChild(desc);
        }
        if (s.getType1() != null) {
            Element type1 = doc.createElement("type1");
            type1.appendChild(doc.createTextNode(s.getType1().name()));
            studio.appendChild(type1);
        }
        if (s.getType2() != null) {
            Element type2 = doc.createElement("type2");
            type2.appendChild(doc.createTextNode(s.getType2().name()));
            studio.appendChild(type2);
        }
        if (s.getType3() != null) {
            Element type3 = doc.createElement("type3");
            type3.appendChild(doc.createTextNode(s.getType3().name()));
            studio.appendChild(type3);
        }
        if (s.getType4() != null) {
            Element type4 = doc.createElement("type4");
            type4.appendChild(doc.createTextNode(s.getType4().name()));
            studio.appendChild(type4);
        }
        if (s.getType5() != null) {
            Element type5 = doc.createElement("type5");
            type5.appendChild(doc.createTextNode(s.getType5().name()));
            studio.appendChild(type5);
        }
        if (s.getType6() != null) {
            Element type6 = doc.createElement("type6");
            type6.appendChild(doc.createTextNode(s.getType6().name()));
            studio.appendChild(type6);
        }
        if (s.getParent() != null) {
            Element parent = doc.createElement("parent");
            java.util.logging.Logger.getLogger(Exporter.class.getName()).log(Level.INFO, "parent: " + s.getParent().getName());
            parent.appendChild(this.createStudioElement(s.getParent(), doc));
            studio.appendChild(parent);
        }
        return studio;
    }

    public Element createPersonElement(Person p, Document doc) {
        Element person = doc.createElement("person");
        if (p != null && p.isSecret() || p == null) {
            java.util.logging.Logger.getLogger(Exporter.class.getName()).log(Level.SEVERE, "passed person was null");
            return person;
        }
        Element name = doc.createElement("name");
        name.appendChild(doc.createTextNode(p.getName()));
        person.appendChild(name);
        Element gender = doc.createElement("gender");
        if (p.getGender() != null) {
            gender.appendChild(doc.createTextNode(p.getGender().name()));
            person.appendChild(gender);
        }
        if (p.getRealName() != null) {
            Element realName = doc.createElement("realName");
            realName.appendChild(doc.createTextNode(p.getRealName()));
            person.appendChild(realName);
        }
        if (p.getTwitter() != null) {
            Element twitter = doc.createElement("twitter");
            twitter.appendChild(doc.createTextNode(p.getTwitter()));
            person.appendChild(twitter);
        }
        if (p.getWikipedia() != null) {
            Element wikipedia = doc.createElement("wikipedia");
            wikipedia.appendChild(doc.createTextNode(p.getWikipedia()));
            person.appendChild(wikipedia);
        }
        if (p.getIafd() != null) {
            Element iafd = doc.createElement("iafd");
            iafd.appendChild(doc.createTextNode(p.getIafd()));
            person.appendChild(iafd);
        }
        if (p.getInstagram() != null) {
            Element instagram = doc.createElement("instagram");
            instagram.appendChild(doc.createTextNode(p.getInstagram()));
            person.appendChild(instagram);
        }
        if (p.getOfficialHomepage() != null) {
            Element officialHomepage = doc.createElement("officialHomepage");
            officialHomepage.appendChild(doc.createTextNode(p.getOfficialHomepage()));
            person.appendChild(officialHomepage);
        }
        if (p.getOtherUrls() != null) {
            Element otherUrls = doc.createElement("otherUrls");
            otherUrls.appendChild(doc.createTextNode(p.getOtherUrls()));
            person.appendChild(otherUrls);
        }
        if (p.getPersonWebsites() != null) {
            Element personWebsitesRootElement = doc.createElement("personWebsitesRoot");
            for (PersonWebsites pw : p.getPersonWebsites()) {
                Element personWebsite = doc.createElement("personWebsite");
                Element site = doc.createElement("site");
                site.appendChild(doc.createTextNode(pw.getSocialWebsite().toString()));
                Element url = doc.createElement("url");
                url.appendChild(doc.createTextNode(pw.getUrl()));
                personWebsite.appendChild(site);
                personWebsite.appendChild(url);
                personWebsitesRootElement.appendChild(personWebsite);
            }
            person.appendChild(personWebsitesRootElement);
        }
        if (p.getBirthYear() != null) {
            Element birthYear = doc.createElement("birthYear");
            birthYear.appendChild(doc.createTextNode(p.getBirthYear().toString()));
            person.appendChild(birthYear);
        }
        if (p.getBirthMonth() != null) {
            Element birthMonth = doc.createElement("birthMonth");
            birthMonth.appendChild(doc.createTextNode(p.getBirthMonth().toString()));
            person.appendChild(birthMonth);
        }
        if (p.getBirthDay() != null) {
            Element birthDay = doc.createElement("birthDay");
            birthDay.appendChild(doc.createTextNode(p.getBirthDay().toString()));
            person.appendChild(birthDay);
        }
        if (p.getDeathYear() != null) {
            Element deathYear = doc.createElement("deathYear");
            deathYear.appendChild(doc.createTextNode(p.getDeathYear().toString()));
            person.appendChild(deathYear);
        }
        if (p.getDeathMonth() != null) {
            Element deathMonth = doc.createElement("deathMonth");
            deathMonth.appendChild(doc.createTextNode(p.getDeathMonth().toString()));
            person.appendChild(deathMonth);
        }
        if (p.getDeathDay() != null) {
            Element deathDay = doc.createElement("deathDay");
            deathDay.appendChild(doc.createTextNode(p.getDeathDay().toString()));
            person.appendChild(deathDay);
        }
        if (p.getCauseOfDeath() != null) {
            Element causeOfDeath = doc.createElement("causeOfDeathDay");
            causeOfDeath.appendChild(doc.createTextNode(p.getCauseOfDeath().name()));
            person.appendChild(causeOfDeath);
        }
        if (p.getCauseOfDeathComment() != null) {
            Element causeOfDeathComment = doc.createElement("causeOfDeathComment");
            causeOfDeathComment.appendChild(doc.createTextNode(p.getCauseOfDeathComment()));
            person.appendChild(causeOfDeathComment);
        }
        if (p.getNationality() != null) {
            Element nationality = doc.createElement("nationality");
            nationality.appendChild(doc.createTextNode(p.getNationality().name()));
            person.appendChild(nationality);
        }
        if (p.getEthnicity() != null) {
            Element ethnicity = doc.createElement("ethnicity");
            ethnicity.appendChild(doc.createTextNode(p.getEthnicity().name()));
            person.appendChild(ethnicity);
        }
        if (p.getHeightInCm() != null) {
            Element heightInCm = doc.createElement("heightInCm");
            heightInCm.appendChild(doc.createTextNode(p.getHeightInCm().toString()));
            person.appendChild(heightInCm);
        }
        if (p.getPersonHeight() != null) {
            Element personHeight = doc.createElement("personHeight");
            personHeight.appendChild(doc.createTextNode(p.getPersonHeight().name()));
            person.appendChild(personHeight);
        }
        if (p.getPersonHeightDifferentiator() != null) {
            Element personHeightDifferentiator = doc.createElement("personHeightDifferentiator");
            personHeightDifferentiator.appendChild(doc.createTextNode(p.getPersonHeightDifferentiator().name()));
            person.appendChild(personHeightDifferentiator);
        }
        if (p.getHairColor() != null) {
            Element hairColor = doc.createElement("haircolor");
            hairColor.appendChild(doc.createTextNode(p.getHairColor().name()));
            person.appendChild(hairColor);
        }
        if (p.getDickSize() != null) {
            Element dickSize = doc.createElement("dickSize");
            dickSize.appendChild(doc.createTextNode(p.getDickSize().name()));
            person.appendChild(dickSize);
        }
        if (p.getDickSizeDifferentiator() != null) {
            Element dickSizeDifferentiator = doc.createElement("dickSizeDifferentiator");
            dickSizeDifferentiator.appendChild(doc.createTextNode(p.getDickSizeDifferentiator().name()));
            person.appendChild(dickSizeDifferentiator);
        }
        if (!p.getPersonBodys().isEmpty()) {
            Element personBodyRootElement = doc.createElement("personBodyRoot");
            for (PersonBody pb : p.getPersonBodys()) {
                SimpleDateFormat df;
                Element personBody = doc.createElement("personBody");
                if (pb.getStartDate() != null) {
                    df = new SimpleDateFormat("yyyy-MM-dd");
                    Element validFromDate = doc.createElement("validFrom");
                    validFromDate.appendChild(doc.createTextNode(df.format(Date.from(pb.getStartDate().atStartOfDay(ZoneId.systemDefault()).toInstant()))));
                    personBody.appendChild(validFromDate);
                }
                if (pb.getEndDate() != null) {
                    df = new SimpleDateFormat("yyyy-MM-dd");
                    Element validEndDate = doc.createElement("validEnd");
                    validEndDate.appendChild(doc.createTextNode(df.format(Date.from(pb.getEndDate().atStartOfDay(ZoneId.systemDefault()).toInstant()))));
                    personBody.appendChild(validEndDate);
                }
                if (pb.getBodyType() != null) {
                    Element bodytype = doc.createElement("bodytype");
                    bodytype.appendChild(doc.createTextNode(pb.getBodyType().name()));
                    personBody.appendChild(bodytype);
                }
                if (pb.getBodyTypeDifferentiator() != null) {
                    Element bodytypeDifferentiator = doc.createElement("bodytypeDifferentiator");
                    bodytypeDifferentiator.appendChild(doc.createTextNode(pb.getBodyTypeDifferentiator().name()));
                    personBody.appendChild(bodytypeDifferentiator);
                }
                if (pb.isFakeTits() != null) {
                    Element fakeTits = doc.createElement("fakeTits");
                    fakeTits.appendChild(doc.createTextNode("" + pb.isFakeTits()));
                    personBody.appendChild(fakeTits);
                }
                if (pb.getFakeTitsObviousness() != null) {
                    Element fakeTitsObviousness = doc.createElement("fakeTitsObviousness");
                    fakeTitsObviousness.appendChild(doc.createTextNode(pb.getFakeTitsObviousness().name()));
                    personBody.appendChild(fakeTitsObviousness);
                }
                if (pb.getFakeTitsDifferentiator() != null) {
                    Element fakeTitsObviousnessDifferentiator = doc.createElement("fakeTitsObviousnessDifferentiator");
                    fakeTitsObviousnessDifferentiator.appendChild(doc.createTextNode(pb.getFakeTitsDifferentiator().name()));
                    personBody.appendChild(fakeTitsObviousnessDifferentiator);
                }
                if (pb.getTitsSize() != null) {
                    Element titsSize = doc.createElement("titsSize");
                    titsSize.appendChild(doc.createTextNode(pb.getTitsSize().name()));
                    personBody.appendChild(titsSize);
                }
                if (pb.getTitsSizeDifferentiator() != null) {
                    Element titsSizeDifferentiator = doc.createElement("titsSizeDifferentiator");
                    titsSizeDifferentiator.appendChild(doc.createTextNode(pb.getTitsSizeDifferentiator().name()));
                    personBody.appendChild(titsSizeDifferentiator);
                }
                if (pb.getAssSize() != null) {
                    Element asssize = doc.createElement("assSize");
                    asssize.appendChild(doc.createTextNode(pb.getAssSize().name()));
                    personBody.appendChild(asssize);
                }
                if (pb.getAssSizeDifferentiator() != null) {
                    Element assSizeDifferentiator = doc.createElement("assSizeDifferentiator");
                    assSizeDifferentiator.appendChild(doc.createTextNode(pb.getAssSizeDifferentiator().name()));
                    personBody.appendChild(assSizeDifferentiator);
                }
                Element defaultPersonBody = doc.createElement("defaultPersonBody");
                defaultPersonBody.appendChild(doc.createTextNode("" + pb.isDefaultPersonBody()));
                personBody.appendChild(defaultPersonBody);
                if (!pb.getAppearance().isEmpty()) {
                    Element appearanceRootElement = doc.createElement("appearanceRoot");
                    for (Appearance app : pb.getAppearance()) {
                        Element appElement = doc.createElement("appearance");
                        appElement.appendChild(doc.createTextNode(app.name()));
                        appearanceRootElement.appendChild(appElement);
                    }
                    personBody.appendChild(appearanceRootElement);
                }
                personBodyRootElement.appendChild(personBody);
            }
            person.appendChild(personBodyRootElement);
        }
        return person;
    }
}

