/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.comparator;

import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.Scene;

public class INodeComparator
implements Comparator<INode> {
    private DB.OrderBy orderBy;
    private final Logger LOG = LoggerFactory.getLogger(INodeComparator.class);

    public INodeComparator(DB.OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public int compare(INode one, INode other) {
        block38: {
            if (DB.OrderBy.TITLE.equals((Object)this.orderBy)) {
                if (one instanceof Scene) {
                    Scene scene = (Scene)one;
                    return scene.getMovie().getTitle().compareTo(((Scene)other).getMovie().getTitle());
                }
                if (one instanceof Bookmark) {
                    Bookmark bookmark = (Bookmark)one;
                    return bookmark.getMovieAssociated().getTitle().compareTo(((Bookmark)other).getMovieAssociated().getTitle());
                }
            } else {
                if (DB.OrderBy.RESOLUTION.equals((Object)this.orderBy)) {
                    try {
                        if (one instanceof Scene) {
                            Scene scene = (Scene)one;
                            this.LOG.debug("one : {}  - other: {}", (Object)scene.getMovie().getTitle(), (Object)((Scene)other).getMovie().getTitle());
                            if (scene.getMovie().getStartMedium() == null) {
                                return 0;
                            }
                            return scene.getMovie().getStartMedium().getHeight().compareTo(((Scene)other).getMovie().getStartMedium().getHeight());
                        }
                        if (one instanceof Bookmark) {
                            Bookmark bookmark = (Bookmark)one;
                            if (bookmark.getMovieAssociated().getStartMedium() == null) {
                                return 1;
                            }
                            return bookmark.getMovieAssociated().getStartMedium().getHeight().compareTo(((Bookmark)other).getMovieAssociated().getStartMedium().getHeight());
                        }
                        break block38;
                    }
                    catch (Exception ex) {
                        return 0;
                    }
                }
                if (DB.OrderBy.RUNTIME.equals((Object)this.orderBy)) {
                    if (one instanceof Scene) {
                        Scene scene = (Scene)one;
                        return Integer.valueOf(((Scene)other).getTotalRuntime()).compareTo(scene.getTotalRuntime());
                    }
                    if (one instanceof Bookmark) {
                        Bookmark bookmark = (Bookmark)one;
                        return Integer.valueOf(((Bookmark)other).getTotalRuntime()).compareTo(bookmark.getTotalRuntime());
                    }
                } else if (DB.OrderBy.CREATED.equals((Object)this.orderBy)) {
                    if (one instanceof Scene) {
                        Scene scene = (Scene)one;
                        if (((Scene)other).getDateOfCreation() == null) {
                            return -1;
                        }
                        if (scene.getDateOfCreation() == null) {
                            return 1;
                        }
                        return ((Scene)other).getDateOfCreation().compareTo(scene.getDateOfCreation());
                    }
                    if (one instanceof Bookmark) {
                        Bookmark bookmark = (Bookmark)one;
                        if (((Bookmark)other).getDateOfCreation() == null) {
                            return -1;
                        }
                        if (bookmark.getDateOfCreation() == null) {
                            return 1;
                        }
                        return ((Bookmark)other).getDateOfCreation().compareTo(bookmark.getDateOfCreation());
                    }
                } else if (DB.OrderBy.LASTMODIFICATION.equals((Object)this.orderBy)) {
                    if (one instanceof Scene) {
                        Scene scene = (Scene)one;
                        return ((Scene)other).getDateOfLastModification().compareTo(scene.getDateOfLastModification());
                    }
                    if (one instanceof Bookmark) {
                        Bookmark bookmark = (Bookmark)one;
                        return ((Bookmark)other).getDateOfLastModification().compareTo(bookmark.getDateOfLastModification());
                    }
                } else if (DB.OrderBy.RATING.equals((Object)this.orderBy)) {
                    if (one instanceof Scene) {
                        Scene scene = (Scene)one;
                        if (scene.getRating() == null) {
                            scene.setRating(-1);
                        }
                        if (((Scene)other).getRating() == null) {
                            ((Scene)other).setRating(-1);
                        }
                        int compareTo = Integer.valueOf(((Scene)other).getRating()).compareTo((int)scene.getRating());
                        if (scene.getRating() == -1) {
                            scene.setRating(null);
                        }
                        if (((Scene)other).getRating() == -1) {
                            ((Scene)other).setRating(null);
                        }
                        return compareTo;
                    }
                    if (one instanceof Bookmark) {
                        Bookmark bookmark = (Bookmark)one;
                        if (bookmark.getRating() == null) {
                            bookmark.setRating(-1);
                        }
                        if (((Bookmark)other).getRating() == null) {
                            ((Bookmark)other).setRating(-1);
                        }
                        int compareTo = Integer.valueOf(((Bookmark)other).getRating()).compareTo((int)bookmark.getRating());
                        if (bookmark.getRating() == -1) {
                            bookmark.setRating(null);
                        }
                        if (((Bookmark)other).getRating() == -1) {
                            ((Bookmark)other).setRating(null);
                        }
                        return compareTo;
                    }
                }
            }
        }
        return 0;
    }
}

