/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.RefCountedObject;
import org.freedesktop.gstreamer.lowlevel.GPointer;
import org.freedesktop.gstreamer.lowlevel.GstMiniObjectAPI;
import org.freedesktop.gstreamer.lowlevel.GstMiniObjectPtr;

public abstract class MiniObject
extends RefCountedObject {
    protected MiniObject(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstMiniObjectPtr.class, GstMiniObjectPtr::new), init.ownsHandle), init.needRef);
    }

    protected MiniObject(Handle handle, boolean needRef) {
        super(handle, needRef);
    }

    public boolean isWritable() {
        return GstMiniObjectAPI.GSTMINIOBJECT_API.gst_mini_object_is_writable(this);
    }

    protected <T extends MiniObject> T makeWritable() {
        MiniObject result = GstMiniObjectAPI.GSTMINIOBJECT_API.gst_mini_object_make_writable(this);
        if (result == null) {
            throw new NullPointerException("Could not make " + this.getClass().getSimpleName() + " writable");
        }
        return (T)result;
    }

    public <T extends MiniObject> T copy() {
        MiniObject result = GstMiniObjectAPI.GSTMINIOBJECT_API.gst_mini_object_copy(this);
        if (result == null) {
            throw new NullPointerException("Could not make a copy of " + this.getClass().getSimpleName());
        }
        return (T)result;
    }

    public int getRefCount() {
        GstMiniObjectAPI.MiniObjectStruct struct = new GstMiniObjectAPI.MiniObjectStruct(this.getRawPointer());
        return (Integer)struct.readField("refcount");
    }

    protected static class Handle
    extends RefCountedObject.Handle {
        public Handle(GstMiniObjectPtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected void disposeNativeHandle(GPointer ptr) {
            GstMiniObjectAPI.GSTMINIOBJECT_API.gst_mini_object_unref(ptr.as(GstMiniObjectPtr.class, GstMiniObjectPtr::new));
        }

        @Override
        protected void ref() {
            GstMiniObjectAPI.GSTMINIOBJECT_API.gst_mini_object_ref(this.getPointer());
        }

        @Override
        protected void unref() {
            GstMiniObjectAPI.GSTMINIOBJECT_API.gst_mini_object_unref(this.getPointer());
        }

        @Override
        protected GstMiniObjectPtr getPointer() {
            return (GstMiniObjectPtr)super.getPointer();
        }
    }
}

