/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.freedesktop.gstreamer.Bin;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.BufferPool;
import org.freedesktop.gstreamer.Bus;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.Clock;
import org.freedesktop.gstreamer.Context;
import org.freedesktop.gstreamer.DateTime;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.ElementFactory;
import org.freedesktop.gstreamer.GhostPad;
import org.freedesktop.gstreamer.GstException;
import org.freedesktop.gstreamer.Pad;
import org.freedesktop.gstreamer.PadTemplate;
import org.freedesktop.gstreamer.Pipeline;
import org.freedesktop.gstreamer.Plugin;
import org.freedesktop.gstreamer.PluginFeature;
import org.freedesktop.gstreamer.Promise;
import org.freedesktop.gstreamer.Registry;
import org.freedesktop.gstreamer.SDPMessage;
import org.freedesktop.gstreamer.Sample;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.TagList;
import org.freedesktop.gstreamer.Version;
import org.freedesktop.gstreamer.controller.Controllers;
import org.freedesktop.gstreamer.elements.Elements;
import org.freedesktop.gstreamer.event.Event;
import org.freedesktop.gstreamer.glib.GError;
import org.freedesktop.gstreamer.glib.GLib;
import org.freedesktop.gstreamer.glib.GMainContext;
import org.freedesktop.gstreamer.glib.MainContextExecutorService;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.GstAPI;
import org.freedesktop.gstreamer.lowlevel.GstParseAPI;
import org.freedesktop.gstreamer.lowlevel.GstTypes;
import org.freedesktop.gstreamer.message.Message;
import org.freedesktop.gstreamer.query.Query;
import org.freedesktop.gstreamer.video.Video;
import org.freedesktop.gstreamer.webrtc.WebRTC;

public final class Gst {
    private static final Logger LOG = Logger.getLogger(Gst.class.getName());
    private static final AtomicInteger INIT_COUNT = new AtomicInteger(0);
    private static final boolean CHECK_VERSIONS = !Boolean.getBoolean("gstreamer.suppressVersionChecks");
    private static final boolean DISABLE_EXTERNAL = Boolean.getBoolean("gstreamer.disableExternalTypes");
    private static ScheduledExecutorService executorService;
    private static volatile CountDownLatch quit;
    private static GMainContext mainContext;
    private static boolean useDefaultContext;
    private static List<Runnable> shutdownTasks;
    private static int minorVersion;
    private static final ThreadFactory threadFactory;

    private Gst() {
    }

    public static Version getVersion() {
        long[] major = new long[]{0L};
        long[] minor = new long[]{0L};
        long[] micro = new long[]{0L};
        long[] nano = new long[]{0L};
        GstAPI.GST_API.gst_version(major, minor, micro, nano);
        return new Version((int)major[0], (int)minor[0], (int)micro[0], (int)nano[0]);
    }

    public static String getVersionString() {
        return GstAPI.GST_API.gst_version_string();
    }

    public static boolean isSegTrapEnabled() {
        return GstAPI.GST_API.gst_segtrap_is_enabled();
    }

    public static void setSegTrap(boolean enabled) {
        GstAPI.GST_API.gst_segtrap_set_enabled(enabled);
    }

    public static final synchronized boolean isInitialized() {
        return INIT_COUNT.get() > 0;
    }

    public static ScheduledExecutorService getExecutor() {
        return executorService;
    }

    public static void quit() {
        quit.countDown();
    }

    public static Element parseLaunch(String pipelineDescription, List<GError> errors) {
        Pointer[] err = new Pointer[]{null};
        Element pipeline = GstParseAPI.GSTPARSE_API.gst_parse_launch(pipelineDescription, err);
        if (pipeline == null) {
            throw new GstException(Gst.extractError(err[0]));
        }
        if (err[0] != null) {
            if (errors != null) {
                errors.add(Gst.extractError(err[0]));
            } else {
                LOG.log(Level.WARNING, Gst.extractError(err[0]).getMessage());
            }
        }
        return pipeline;
    }

    public static Element parseLaunch(String pipelineDescription) {
        return Gst.parseLaunch(pipelineDescription, null);
    }

    public static Element parseLaunch(String[] pipelineDescription, List<GError> errors) {
        Pointer[] err = new Pointer[]{null};
        Element pipeline = GstParseAPI.GSTPARSE_API.gst_parse_launchv(pipelineDescription, err);
        if (pipeline == null) {
            throw new GstException(Gst.extractError(err[0]));
        }
        if (err[0] != null) {
            if (errors != null) {
                errors.add(Gst.extractError(err[0]));
            } else {
                LOG.log(Level.WARNING, Gst.extractError(err[0]).getMessage());
            }
        }
        return pipeline;
    }

    public static Element parseLaunch(String[] pipelineDescription) {
        return Gst.parseLaunch(pipelineDescription, null);
    }

    public static Bin parseBinFromDescription(String binDescription, boolean ghostUnlinkedPads, List<GError> errors) {
        Pointer[] err = new Pointer[]{null};
        Bin bin = GstParseAPI.GSTPARSE_API.gst_parse_bin_from_description(binDescription, ghostUnlinkedPads, err);
        if (bin == null) {
            throw new GstException(Gst.extractError(err[0]));
        }
        if (err[0] != null) {
            if (errors != null) {
                errors.add(Gst.extractError(err[0]));
            } else {
                LOG.log(Level.WARNING, Gst.extractError(err[0]).getMessage());
            }
        }
        return bin;
    }

    public static Bin parseBinFromDescription(String binDescription, boolean ghostUnlinkedPads) {
        return Gst.parseBinFromDescription(binDescription, ghostUnlinkedPads, null);
    }

    private static GError extractError(Pointer errorPtr) {
        GstAPI.GErrorStruct struct = new GstAPI.GErrorStruct(errorPtr);
        struct.read();
        GError err = new GError(struct.getCode(), struct.getMessage());
        GlibAPI.GLIB_API.g_error_free(struct);
        return err;
    }

    public static void main() {
        try {
            CountDownLatch latch = quit;
            if (latch != null) {
                latch.await();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            quit = new CountDownLatch(1);
        }
    }

    public static void invokeLater(Runnable task) {
        Gst.getExecutor().execute(task);
    }

    public static GMainContext getMainContext() {
        return mainContext;
    }

    public static final void init() throws GstException {
        Gst.init(Version.BASELINE, "gst1-java-core", new String[0]);
    }

    public static final void init(Version requiredVersion) throws GstException {
        Gst.init(requiredVersion, "gst1-java-core", new String[0]);
    }

    public static final synchronized String[] init(String progname, String ... args) throws GstException {
        return Gst.init(Version.BASELINE, progname, args);
    }

    public static final synchronized String[] init(Version requestedVersion, String progname, String ... args) throws GstException {
        if (CHECK_VERSIONS) {
            Version availableVersion = Gst.getVersion();
            if (requestedVersion.getMajor() != 1 || availableVersion.getMajor() != 1) {
                throw new GstException("gst1-java-core only supports GStreamer 1.x");
            }
            if (requestedVersion.getMinor() < 8) {
                requestedVersion = new Version(1, 8);
            }
            if (!availableVersion.checkSatisfies(requestedVersion)) {
                throw new GstException(String.format("The requested version of GStreamer is not available\nRequested : %s\nAvailable : %s\n", requestedVersion, availableVersion));
            }
        }
        if (INIT_COUNT.getAndIncrement() > 0) {
            if (CHECK_VERSIONS && requestedVersion.getMinor() > minorVersion) {
                minorVersion = requestedVersion.getMinor();
            }
            return args;
        }
        NativeArgs argv = new NativeArgs(progname, args);
        Pointer[] error = new Pointer[]{null};
        if (!GstAPI.GST_API.gst_init_check(argv.argcRef, argv.argvRef, error)) {
            INIT_COUNT.decrementAndGet();
            throw new GstException(Gst.extractError(error[0]));
        }
        LOG.fine("after gst_init, argc=" + argv.argcRef.getValue());
        Version runningVersion = Gst.getVersion();
        if (runningVersion.getMajor() != 1) {
            LOG.warning("gst1-java-core only supports GStreamer 1.x");
        }
        if (useDefaultContext) {
            mainContext = GMainContext.getDefaultContext();
            executorService = new MainContextExecutorService(mainContext);
        } else {
            mainContext = new GMainContext();
            executorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        }
        quit = new CountDownLatch(1);
        Gst.loadAllClasses();
        if (CHECK_VERSIONS) {
            minorVersion = requestedVersion.getMinor();
        }
        return argv.toStringArray();
    }

    public static final synchronized void deinit() {
        if (INIT_COUNT.decrementAndGet() > 0) {
            return;
        }
        for (Object task : shutdownTasks.toArray()) {
            ((Runnable)task).run();
        }
        executorService.shutdown();
        Gst.quit();
        try {
            if (!executorService.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        mainContext = null;
        System.gc();
        GstAPI.GST_API.gst_deinit();
    }

    static void addStaticShutdownTask(Runnable task) {
        shutdownTasks.add(task);
    }

    public static void setUseDefaultContext(boolean useDefault) {
        useDefaultContext = useDefault;
    }

    public static void checkVersion(int major, int minor) {
        if (CHECK_VERSIONS && (major != 1 || minor > minorVersion)) {
            throw new GstException("Not supported by requested GStreamer version");
        }
    }

    public static boolean testVersion(int major, int minor) {
        return !CHECK_VERSIONS || major == 1 && minor <= minorVersion;
    }

    private static synchronized void loadAllClasses() {
        Stream.of(new GLib.Types(), new Types(), new Event.Types(), new Message.Types(), new Query.Types(), new Controllers(), new Elements(), new WebRTC.Types(), new Video.Types()).flatMap(NativeObject.TypeProvider::types).forEachOrdered(GstTypes::register);
        if (!DISABLE_EXTERNAL) {
            try {
                ServiceLoader<NativeObject.TypeProvider> extProviders = ServiceLoader.load(NativeObject.TypeProvider.class);
                extProviders.iterator().forEachRemaining(prov -> prov.types().forEachOrdered(GstTypes::register));
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error during external types registration", t);
            }
        }
    }

    static {
        quit = new CountDownLatch(1);
        useDefaultContext = false;
        shutdownTasks = Collections.synchronizedList(new ArrayList());
        minorVersion = Integer.MAX_VALUE;
        threadFactory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable task) {
                String name = "gstreamer service thread " + this.counter.incrementAndGet();
                Thread t = new Thread(task, name);
                t.setDaemon(true);
                t.setPriority(5);
                return t;
            }
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Since {
        public int major() default 1;

        public int minor();
    }

    public static class Types
    implements NativeObject.TypeProvider {
        @Override
        public Stream<NativeObject.TypeRegistration<?>> types() {
            return Stream.of(Natives.registration(Bin.class, "GstBin", Bin::new), Natives.registration(Buffer.class, "GstBuffer", Buffer::new), Natives.registration(BufferPool.class, "GstBufferPool", BufferPool::new), Natives.registration(Bus.class, "GstBus", Bus::new), Natives.registration(Caps.class, "GstCaps", Caps::new), Natives.registration(Clock.class, "GstClock", Clock::new), Natives.registration(Context.class, "GstContext", Context::new), Natives.registration(DateTime.class, "GstDateTime", DateTime::new), Natives.registration(Element.class, "GstElement", Element::new), Natives.registration(ElementFactory.class, "GstElementFactory", ElementFactory::new), Natives.registration(GhostPad.class, "GstGhostPad", GhostPad::new), Natives.registration(Pad.class, "GstPad", Pad::new), Natives.registration(PadTemplate.class, "GstPadTemplate", PadTemplate::new), Natives.registration(Pipeline.class, "GstPipeline", Pipeline::new), Natives.registration(Plugin.class, "GstPlugin", Plugin::new), Natives.registration(PluginFeature.class, "GstPluginFeature", PluginFeature::new), Natives.registration(Promise.class, "GstPromise", Promise::new), Natives.registration(Registry.class, "GstRegistry", Registry::new), Natives.registration(SDPMessage.class, "GstSDPMessage", SDPMessage::new), Natives.registration(Sample.class, "GstSample", Sample::new), Natives.registration(Structure.class, "GstStructure", Structure::new), Natives.registration(TagList.class, "GstTagList", TagList::new));
        }
    }

    private static class NativeArgs {
        public IntByReference argcRef;
        public PointerByReference argvRef;
        Memory[] argsCopy;
        Memory argvMemory;

        public NativeArgs(String progname, String[] args) {
            this.argsCopy = new Memory[args.length + 2];
            this.argvMemory = new Memory((long)(this.argsCopy.length * Native.POINTER_SIZE));
            Memory arg = new Memory((long)(progname.getBytes().length + 4));
            arg.setString(0L, progname);
            this.argsCopy[0] = arg;
            for (int i = 0; i < args.length; ++i) {
                arg = new Memory((long)(args[i].getBytes().length + 1));
                arg.setString(0L, args[i]);
                this.argsCopy[i + 1] = arg;
            }
            this.argvMemory.write(0L, (Pointer[])this.argsCopy, 0, this.argsCopy.length);
            this.argvRef = new PointerByReference((Pointer)this.argvMemory);
            this.argcRef = new IntByReference(args.length + 1);
        }

        String[] toStringArray() {
            ArrayList<String> args = new ArrayList<String>();
            Pointer argv = this.argvRef.getValue();
            for (int i = 1; i < this.argcRef.getValue(); ++i) {
                Pointer arg = argv.getPointer((long)(i * Native.POINTER_SIZE));
                if (arg == null) continue;
                args.add(arg.getString(0L));
            }
            return args.toArray(new String[args.size()]);
        }
    }
}

