/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxhub.web;

import com.google.common.net.UrlEscapers;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.media.video.Video;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.FileSystemResource;
import org.apache.wicket.resource.FileSystemResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxhub.web.ScenerixxHubSession;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxserver.web.VideoPage;

public class VideoCard
extends Panel {
    String moviePath = "";
    private LoadableDetachableModel<Movie> movie;
    private transient DB db = DB.getInstance();
    private transient Path path;
    private transient FileSystemResourceReference ref;
    private transient Video video = null;
    private final Logger LOGGER = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    public VideoCard(String id, LoadableDetachableModel<Movie> movie) {
        super(id);
        this.movie = movie;
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer wmc = new WebMarkupContainer("wmc");
        Object shortenedTitle = ((Movie)this.movie.getObject()).getTitle().substring(0, Math.min(27, ((Movie)this.movie.getObject()).getTitle().length()));
        if (((Movie)this.movie.getObject()).getTitle().length() > 27) {
            shortenedTitle = (String)shortenedTitle + "...";
        }
        this.add(new Component[]{new Label("titleShortened", (Serializable)shortenedTitle)});
        wmc.add(new Behavior[]{new AttributeModifier("tg", (Serializable)((Movie)this.movie.getObject()).getId())});
        this.add(new Component[]{wmc});
        Object year = "";
        if (((Movie)this.movie.getObject()).getReleaseYear() != null) {
            year = "" + ((Movie)this.movie.getObject()).getReleaseYear();
        }
        this.add(new Component[]{new Label("year", (Serializable)year).setVisible(!((String)year).isEmpty())});
        Object runtime = "???";
        if (((Movie)this.movie.getObject()).getTotalRuntime() > 0) {
            runtime = "" + ((Movie)this.movie.getObject()).getTotalRuntime() / 60;
        }
        this.add(new Component[]{new Label("runtime", (Serializable)runtime)});
        final WebMarkupContainer wmcScenePerformers = new WebMarkupContainer("wmcScenePerformers");
        RepeatingView scenePerformers = new RepeatingView("scenePerformers");
        for (Scene sc : ((Movie)this.movie.getObject()).getScenes()) {
            WebMarkupContainer wmcPerformers = new WebMarkupContainer(scenePerformers.newChildId());
            String personNames = sc.getPersonNames(ScenerixxHubSession.get().isUnlocked());
            if (personNames.isEmpty()) {
                personNames = "???";
            }
            wmcPerformers.add(new Component[]{new Label("names", (Serializable)((Object)(sc.getPos() + ". " + personNames)))});
            scenePerformers.add(new Component[]{wmcPerformers});
        }
        wmcScenePerformers.add(new Component[]{scenePerformers});
        wmcScenePerformers.setOutputMarkupPlaceholderTag(true);
        wmcScenePerformers.setVisible(false);
        this.add(new Component[]{wmcScenePerformers});
        List mediumFiles = this.db.getMediumFiles((Movie)this.movie.getObject(), false);
        if (!mediumFiles.isEmpty()) {
            this.moviePath = ((MediumFile)mediumFiles.get(0)).getFileCompletePath();
            this.LOGGER.info("org: " + this.moviePath);
            this.moviePath = UrlEscapers.urlFragmentEscaper().escape(this.moviePath);
            this.LOGGER.info("enc: " + this.moviePath);
            this.moviePath = this.moviePath.replace("\u2026", "%E2%80%A6");
            this.moviePath = this.moviePath.replace("#", "%23");
            this.LOGGER.info("end: " + this.moviePath);
            this.moviePath = "file:///" + this.moviePath;
        } else {
            this.LOGGER.error("Oooops, no medium files for " + ((Movie)this.movie.getObject()).getTitle() + " (ID: " + ((Movie)this.movie.getObject()).getId() + ")");
        }
        try {
            this.LOGGER.info("movie path : " + this.moviePath);
            if (this.moviePath.isEmpty()) {
                this.LOGGER.error("That shouldn't happen. No path to medium found");
                this.moviePath = "https://mphomeservices.it/videos/it-chaptertwo.mp4";
                this.video = new Video("video", this.moviePath);
            } else {
                this.path = FileSystemResourceReference.getPath((URI)URI.create(this.moviePath));
                this.ref = new FileSystemResourceReference("video_" + new Date().toString() + ((Movie)this.movie.getObject()).getId()){

                    protected FileSystemResource getFileSystemResource() {
                        return new FileSystemResource(Path.of(URI.create(VideoCard.this.moviePath)));
                    }
                };
                this.video = new Video("video", (ResourceReference)this.ref);
            }
            this.video.setOutputMarkupId(true);
            this.video.setControls(Boolean.valueOf(false));
            this.video.setHeight(Integer.valueOf(120));
            this.video.setAutoplay(false);
            this.video.setPoster((ResourceReference)new PackageResourceReference(VideoCard.class, "placeholder.png"));
            this.LOGGER.info("autoplay: " + this.video.isAutoplay());
            wmc.add(new Component[]{this.video});
            this.add(new Component[]{new AjaxLink("playButton"){

                public void onClick(AjaxRequestTarget target) {
                    VideoCard.this.LOGGER.info("playbutton pressed");
                    if (VideoCard.this.video != null) {
                        VideoCard.this.video.setControls(Boolean.valueOf(true));
                        VideoCard.this.video.setAutoplay(true);
                        target.add(new Component[]{VideoCard.this.video});
                    } else {
                        VideoCard.this.LOGGER.info("video was null");
                    }
                }
            }});
            this.add(new Component[]{new AjaxLink("detailsButton"){

                public void onClick(AjaxRequestTarget target) {
                    VideoCard.this.LOGGER.info("details-button pressed");
                    wmcScenePerformers.setVisible(!wmcScenePerformers.isVisible());
                    target.add(new Component[]{wmcScenePerformers});
                }
            }});
        }
        catch (Exception ex) {
            this.LOGGER.error("Ooops, something went wrong: " + ex.getMessage());
            java.util.logging.Logger.getLogger(VideoPage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

