/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.tools.rectangle.CoordinatePosition;
import impl.org.controlsfx.tools.rectangle.CoordinatePositions;
import impl.org.controlsfx.tools.rectangle.Rectangles2D;
import impl.org.controlsfx.tools.rectangle.change.MoveChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.NewChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.Rectangle2DChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToEastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNorthChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNortheastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNorthwestChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSouthChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSoutheastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSouthwestChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToWestChangeStrategy;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.controlsfx.control.SnapshotView;

public class SnapshotViewSkin
extends SkinBase<SnapshotView> {
    private static final double RELATIVE_EDGE_TOLERANCE = 0.015;
    private Node node;
    private final GridPane gridPane = SnapshotViewSkin.createGridPane();
    private final Rectangle selectedArea = new Rectangle();
    private final Rectangle unselectedArea = new Rectangle();
    private final Node mouseNode = this.createMouseNode();
    private SelectionChange selectionChange;
    private final Consumer<Boolean> setSelectionChanging = this.createSetSelectionChanging();

    public SnapshotViewSkin(SnapshotView snapshotView) {
        super((Control)snapshotView);
        this.buildSceneGraph();
        this.initializeAreas();
        this.registerChangeListener((ObservableValue)snapshotView.nodeProperty(), e -> this.updateNode());
        this.registerChangeListener((ObservableValue)snapshotView.selectionProperty(), e -> this.updateSelection());
    }

    private static GridPane createGridPane() {
        GridPane pane = new GridPane();
        pane.setAlignment(Pos.CENTER);
        return pane;
    }

    private Node createMouseNode() {
        Rectangle mouseNode = new Rectangle();
        mouseNode.setFill((Paint)Color.TRANSPARENT);
        mouseNode.setManaged(false);
        mouseNode.widthProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).widthProperty());
        mouseNode.heightProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).heightProperty());
        mouseNode.addEventHandler(MouseEvent.ANY, this::handleMouseEvent);
        mouseNode.mouseTransparentProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).selectionMouseTransparentProperty());
        return mouseNode;
    }

    private Consumer<Boolean> createSetSelectionChanging() {
        return changing -> this.getNode().getProperties().put((Object)SnapshotView.SELECTION_CHANGING_PROPERTY_KEY, changing);
    }

    private void buildSceneGraph() {
        this.getChildren().addAll((Object[])new Node[]{this.gridPane, this.unselectedArea, this.selectedArea, this.mouseNode});
        this.updateNode();
    }

    private void initializeAreas() {
        this.styleAreas();
        this.bindAreaCoordinatesTogether();
        this.bindAreaVisibilityToSelection();
    }

    private void styleAreas() {
        this.selectedArea.fillProperty().bind(((SnapshotView)this.getSkinnable()).selectionAreaFillProperty());
        this.selectedArea.strokeProperty().bind(((SnapshotView)this.getSkinnable()).selectionBorderPaintProperty());
        this.selectedArea.strokeWidthProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).selectionBorderWidthProperty());
        this.selectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.selectedArea.setManaged(false);
        this.selectedArea.setMouseTransparent(true);
        this.unselectedArea.setFill((Paint)Color.TRANSPARENT);
        this.unselectedArea.strokeProperty().bind(((SnapshotView)this.getSkinnable()).unselectedAreaFillProperty());
        this.unselectedArea.strokeWidthProperty().bind((ObservableValue)Bindings.max((ObservableNumberValue)((SnapshotView)this.getSkinnable()).widthProperty(), (ObservableNumberValue)((SnapshotView)this.getSkinnable()).heightProperty()));
        this.unselectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.unselectedArea.setManaged(false);
        this.unselectedArea.setMouseTransparent(true);
    }

    private void bindAreaCoordinatesTogether() {
        this.unselectedArea.xProperty().bind((ObservableValue)this.selectedArea.xProperty());
        this.unselectedArea.yProperty().bind((ObservableValue)this.selectedArea.yProperty());
        this.unselectedArea.widthProperty().bind((ObservableValue)this.selectedArea.widthProperty());
        this.unselectedArea.heightProperty().bind((ObservableValue)this.selectedArea.heightProperty());
    }

    private void bindAreaVisibilityToSelection() {
        ReadOnlyBooleanProperty selectionExists = ((SnapshotView)this.getSkinnable()).hasSelectionProperty();
        BooleanProperty selectionActive = ((SnapshotView)this.getSkinnable()).selectionActiveProperty();
        BooleanBinding existsAndActive = Bindings.and((ObservableBooleanValue)selectionExists, (ObservableBooleanValue)selectionActive);
        this.selectedArea.visibleProperty().bind((ObservableValue)existsAndActive);
        this.unselectedArea.visibleProperty().bind((ObservableValue)existsAndActive);
        new Clipper((SnapshotView)this.getSkinnable(), (Node)this.unselectedArea, () -> this.unselectedArea.visibleProperty().bind((ObservableValue)existsAndActive));
    }

    private void updateNode() {
        if (this.node != null) {
            this.gridPane.getChildren().remove((Object)this.node);
        }
        this.node = ((SnapshotView)this.getSkinnable()).getNode();
        if (this.node != null) {
            this.gridPane.getChildren().add(0, (Object)this.node);
        }
    }

    private void updateSelection() {
        boolean showSelection;
        boolean bl = showSelection = ((SnapshotView)this.getSkinnable()).hasSelection() && ((SnapshotView)this.getSkinnable()).isSelectionActive();
        if (showSelection) {
            Rectangle2D selection = ((SnapshotView)this.getSkinnable()).getSelection();
            this.setSelection(selection.getMinX(), selection.getMinY(), selection.getWidth(), selection.getHeight());
        } else {
            this.setSelection(0.0, 0.0, 0.0, 0.0);
        }
    }

    private void setSelection(double x, double y, double width, double height) {
        this.selectedArea.setX(x);
        this.selectedArea.setY(y);
        this.selectedArea.setWidth(width);
        this.selectedArea.setHeight(height);
    }

    private void handleMouseEvent(MouseEvent event) {
        Cursor newCursor = this.handleMouseEventImpl(event);
        this.mouseNode.setCursor(newCursor);
    }

    private Cursor handleMouseEventImpl(MouseEvent mouseEvent) {
        Objects.requireNonNull(mouseEvent, "The argument 'mouseEvent' must not be null.");
        EventType eventType = mouseEvent.getEventType();
        SelectionEvent selectionEvent = this.createSelectionEvent(mouseEvent);
        if (eventType == MouseEvent.MOUSE_MOVED) {
            return this.getCursor(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            return this.handleMousePressedEvent(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_DRAGGED) {
            return this.handleMouseDraggedEvent(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_RELEASED) {
            return this.handleMouseReleasedEvent(selectionEvent);
        }
        return Cursor.DEFAULT;
    }

    private SelectionEvent createSelectionEvent(MouseEvent mouseEvent) {
        Point2D point = new Point2D(mouseEvent.getX(), mouseEvent.getY());
        Rectangle2D selectionBounds = this.createBoundsForCurrentBoundary();
        CoordinatePosition position = this.computePosition(point);
        return new SelectionEvent(mouseEvent, point, selectionBounds, position);
    }

    private Rectangle2D createBoundsForCurrentBoundary() {
        SnapshotView.Boundary boundary = ((SnapshotView)this.getSkinnable()).getSelectionAreaBoundary();
        switch (boundary) {
            case CONTROL: {
                return new Rectangle2D(0.0, 0.0, this.getControlWidth(), this.getControlHeight());
            }
            case NODE: {
                boolean nodeExists;
                boolean bl = nodeExists = this.getSnapshotNode() != null;
                if (nodeExists) {
                    Bounds nodeBounds = this.getSnapshotNode().getBoundsInParent();
                    return Rectangles2D.fromBounds(nodeBounds);
                }
                return Rectangle2D.EMPTY;
            }
        }
        throw new IllegalArgumentException("The boundary " + String.valueOf((Object)boundary) + " is not fully implemented.");
    }

    private CoordinatePosition computePosition(Point2D point) {
        boolean controlHasNoSpace;
        boolean noSelection = !((SnapshotView)this.getSkinnable()).hasSelection() || !((SnapshotView)this.getSkinnable()).isSelectionActive();
        boolean bl = controlHasNoSpace = this.getControlWidth() == 0.0 || this.getControlHeight() == 0.0;
        if (noSelection || controlHasNoSpace) {
            return CoordinatePosition.OUT_OF_RECTANGLE;
        }
        double tolerance = this.computeTolerance();
        return SnapshotViewSkin.computePosition(this.getSelection(), point, tolerance);
    }

    private double computeTolerance() {
        double controlMeanLength = Math.sqrt(this.getControlWidth() * this.getControlHeight());
        return 0.015 * controlMeanLength;
    }

    private static CoordinatePosition computePosition(Rectangle2D selection, Point2D point, double tolerance) {
        CoordinatePosition onEdge = CoordinatePositions.onEdges(selection, point, tolerance);
        if (onEdge != null) {
            return onEdge;
        }
        return CoordinatePositions.inRectangle(selection, point);
    }

    private Cursor handleMousePressedEvent(SelectionEvent selectionEvent) {
        if (selectionEvent.isPointInSelectionBounds()) {
            Cursor cursor = this.getCursor(selectionEvent);
            Rectangle2DChangeStrategy selectionChangeStrategy = this.getChangeStrategy(selectionEvent);
            boolean deactivateSelectionIfClick = SnapshotViewSkin.willDeactivateSelectionIfClick(selectionEvent);
            this.selectionChange = new SelectionChangeByStrategy((SnapshotView)this.getSkinnable(), this.setSelectionChanging, selectionChangeStrategy, cursor, deactivateSelectionIfClick);
            this.selectionChange.beginSelectionChange(selectionEvent.getPoint());
        } else {
            this.selectionChange = NoSelectionChange.INSTANCE;
        }
        return this.selectionChange.getCursor();
    }

    private Cursor handleMouseDraggedEvent(SelectionEvent selectionEvent) {
        this.selectionChange.continueSelectionChange(selectionEvent.getPoint());
        return this.selectionChange.getCursor();
    }

    private Cursor handleMouseReleasedEvent(SelectionEvent selectionEvent) {
        this.selectionChange.endSelectionChange(selectionEvent.getPoint());
        this.selectionChange = null;
        return this.getCursor(selectionEvent);
    }

    private Cursor getCursor(SelectionEvent selectionEvent) {
        if (!selectionEvent.isPointInSelectionBounds()) {
            return this.getRegularCursor();
        }
        switch (selectionEvent.getPosition()) {
            case IN_RECTANGLE: {
                return Cursor.MOVE;
            }
            case OUT_OF_RECTANGLE: {
                return this.getRegularCursor();
            }
            case NORTH_EDGE: {
                return Cursor.N_RESIZE;
            }
            case NORTHEAST_EDGE: {
                return Cursor.NE_RESIZE;
            }
            case EAST_EDGE: {
                return Cursor.E_RESIZE;
            }
            case SOUTHEAST_EDGE: {
                return Cursor.SE_RESIZE;
            }
            case SOUTH_EDGE: {
                return Cursor.S_RESIZE;
            }
            case SOUTHWEST_EDGE: {
                return Cursor.SW_RESIZE;
            }
            case WEST_EDGE: {
                return Cursor.W_RESIZE;
            }
            case NORTHWEST_EDGE: {
                return Cursor.NW_RESIZE;
            }
        }
        throw new IllegalArgumentException("The position " + String.valueOf((Object)selectionEvent.getPosition()) + " is not fully implemented.");
    }

    private Cursor getRegularCursor() {
        return ((SnapshotView)this.getSkinnable()).getCursor();
    }

    private Rectangle2DChangeStrategy getChangeStrategy(SelectionEvent selectionEvent) {
        boolean mousePressed;
        boolean bl = mousePressed = selectionEvent.getMouseEvent().getEventType() == MouseEvent.MOUSE_PRESSED;
        if (!mousePressed) {
            throw new IllegalArgumentException();
        }
        Rectangle2D selectionBounds = selectionEvent.getSelectionBounds();
        switch (selectionEvent.getPosition()) {
            case IN_RECTANGLE: {
                return new MoveChangeStrategy(this.getSelection(), selectionBounds);
            }
            case OUT_OF_RECTANGLE: {
                return new NewChangeStrategy(this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case NORTH_EDGE: {
                return new ToNorthChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case NORTHEAST_EDGE: {
                return new ToNortheastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case EAST_EDGE: {
                return new ToEastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case SOUTHEAST_EDGE: {
                return new ToSoutheastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case SOUTH_EDGE: {
                return new ToSouthChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case SOUTHWEST_EDGE: {
                return new ToSouthwestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case WEST_EDGE: {
                return new ToWestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case NORTHWEST_EDGE: {
                return new ToNorthwestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
        }
        throw new IllegalArgumentException("The position " + String.valueOf((Object)selectionEvent.getPosition()) + " is not fully implemented.");
    }

    private static boolean willDeactivateSelectionIfClick(SelectionEvent selectionEvent) {
        boolean rightClick = selectionEvent.getMouseEvent().getButton() == MouseButton.SECONDARY;
        boolean outOfAreaClick = selectionEvent.getPosition() == CoordinatePosition.OUT_OF_RECTANGLE;
        return rightClick || outOfAreaClick;
    }

    private double getControlWidth() {
        return ((SnapshotView)this.getSkinnable()).getWidth();
    }

    private double getControlHeight() {
        return ((SnapshotView)this.getSkinnable()).getHeight();
    }

    private Node getSnapshotNode() {
        return ((SnapshotView)this.getSkinnable()).getNode();
    }

    private Rectangle2D getSelection() {
        return ((SnapshotView)this.getSkinnable()).getSelection();
    }

    private boolean isSelectionRatioFixed() {
        return ((SnapshotView)this.getSkinnable()).isSelectionRatioFixed();
    }

    private double getSelectionRatio() {
        return ((SnapshotView)this.getSkinnable()).getFixedSelectionRatio();
    }

    private static class Clipper {
        private final SnapshotView snapshotView;
        private final Node clippedNode;
        private final Runnable rebindClippedNodeVisibility;
        private final Rectangle controlClip;
        private final Rectangle nodeClip;
        private final ChangeListener<Bounds> updateControlClipToNewBoundsListener;
        private final ChangeListener<Bounds> updateNodeClipToNewBoundsListener;

        public Clipper(SnapshotView snapshotView, Node clippedNode, Runnable rebindClippedNodeVisibility) {
            this.snapshotView = snapshotView;
            this.clippedNode = clippedNode;
            this.rebindClippedNodeVisibility = rebindClippedNodeVisibility;
            this.controlClip = new Rectangle();
            this.updateControlClipToNewBoundsListener = (o, oldBounds, newBounds) -> Clipper.resizeRectangleToBounds(this.controlClip, newBounds);
            this.nodeClip = new Rectangle();
            this.updateNodeClipToNewBoundsListener = (o, oldBounds, newBounds) -> Clipper.resizeRectangleToBounds(this.nodeClip, newBounds);
            this.setClipping();
            snapshotView.unselectedAreaBoundaryProperty().addListener((o, oldBoundary, newBoundary) -> this.setClipping());
        }

        private void setClipping() {
            SnapshotView.Boundary boundary = this.snapshotView.getUnselectedAreaBoundary();
            switch (boundary) {
                case CONTROL: {
                    this.clipToControl();
                    break;
                }
                case NODE: {
                    this.clipToNode();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The boundary " + String.valueOf((Object)boundary) + " is not fully implemented.");
                }
            }
        }

        private void clipToControl() {
            this.updateNodeClipToChangingNode((ObservableValue<? extends Node>)this.snapshotView.nodeProperty(), this.snapshotView.getNode(), null);
            Clipper.resizeRectangleToBounds(this.controlClip, this.snapshotView.getBoundsInLocal());
            this.snapshotView.boundsInLocalProperty().addListener(this.updateControlClipToNewBoundsListener);
            this.setClip((Node)this.controlClip);
        }

        private void clipToNode() {
            this.updateNodeClipToChangingNode((ObservableValue<? extends Node>)this.snapshotView.nodeProperty(), null, this.snapshotView.getNode());
            this.snapshotView.nodeProperty().addListener(this::updateNodeClipToChangingNode);
            this.setClip((Node)this.nodeClip);
        }

        private void updateNodeClipToChangingNode(ObservableValue<? extends Node> o, Node oldNode, Node newNode) {
            Clipper.resizeRectangleToNodeBounds(this.nodeClip, newNode);
            if (oldNode != null) {
                oldNode.boundsInParentProperty().removeListener(this.updateNodeClipToNewBoundsListener);
            }
            if (newNode != null) {
                newNode.boundsInParentProperty().addListener(this.updateNodeClipToNewBoundsListener);
            }
        }

        private static void resizeRectangleToNodeBounds(Rectangle rectangle, Node node) {
            if (node == null) {
                Clipper.resizeRectangleToZero(rectangle);
            } else {
                Clipper.resizeRectangleToBounds(rectangle, node.getBoundsInParent());
            }
        }

        private static void resizeRectangleToZero(Rectangle rectangle) {
            rectangle.setX(0.0);
            rectangle.setY(0.0);
            rectangle.setWidth(0.0);
            rectangle.setHeight(0.0);
        }

        private static void resizeRectangleToBounds(Rectangle rectangle, Bounds bounds) {
            rectangle.setX(bounds.getMinX());
            rectangle.setY(bounds.getMinY());
            rectangle.setWidth(bounds.getWidth());
            rectangle.setHeight(bounds.getHeight());
        }

        private void setClip(Node clip) {
            boolean workAroundVisibilityProblem;
            boolean bl = workAroundVisibilityProblem = !this.clippedNode.isVisible();
            if (workAroundVisibilityProblem) {
                this.clippedNode.visibleProperty().unbind();
                this.clippedNode.setVisible(true);
            }
            this.clippedNode.setClip(clip);
            if (workAroundVisibilityProblem) {
                this.rebindClippedNodeVisibility.run();
            }
        }
    }

    private static class SelectionEvent {
        private final MouseEvent mouseEvent;
        private final Point2D point;
        private final Rectangle2D selectionBounds;
        private final CoordinatePosition position;

        public SelectionEvent(MouseEvent mouseEvent, Point2D point, Rectangle2D selectionBounds, CoordinatePosition position) {
            this.mouseEvent = mouseEvent;
            this.point = point;
            this.selectionBounds = selectionBounds;
            this.position = position;
        }

        public MouseEvent getMouseEvent() {
            return this.mouseEvent;
        }

        public Point2D getPoint() {
            return this.point;
        }

        public Rectangle2D getSelectionBounds() {
            return this.selectionBounds;
        }

        public boolean isPointInSelectionBounds() {
            return this.selectionBounds.contains(this.point);
        }

        public CoordinatePosition getPosition() {
            return this.position;
        }
    }

    private static class SelectionChangeByStrategy
    implements SelectionChange {
        private final SnapshotView snapshotView;
        private final Consumer<Boolean> setSelectionChanging;
        private final Rectangle2DChangeStrategy selectionChangeStrategy;
        private final Cursor cursor;
        private final boolean deactivateSelectionIfClick;
        private Point2D startingPoint;
        private boolean mouseMoved;

        public SelectionChangeByStrategy(SnapshotView snapshotView, Consumer<Boolean> setSelectionChanging, Rectangle2DChangeStrategy selectionChangeStrategy, Cursor cursor, boolean deactivateSelectionIfClick) {
            this.snapshotView = snapshotView;
            this.setSelectionChanging = setSelectionChanging;
            this.selectionChangeStrategy = selectionChangeStrategy;
            this.cursor = cursor;
            this.deactivateSelectionIfClick = deactivateSelectionIfClick;
        }

        @Override
        public void beginSelectionChange(Point2D point) {
            this.startingPoint = point;
            this.setSelectionChanging.accept(true);
            Rectangle2D newSelection = this.selectionChangeStrategy.beginChange(point);
            this.snapshotView.setSelection(newSelection);
        }

        @Override
        public void continueSelectionChange(Point2D point) {
            this.updateMouseMoved(point);
            Rectangle2D newSelection = this.selectionChangeStrategy.continueChange(point);
            this.snapshotView.setSelection(newSelection);
        }

        @Override
        public void endSelectionChange(Point2D point) {
            boolean deactivateSelection;
            this.updateMouseMoved(point);
            Rectangle2D newSelection = this.selectionChangeStrategy.endChange(point);
            this.snapshotView.setSelection(newSelection);
            boolean bl = deactivateSelection = this.deactivateSelectionIfClick && !this.mouseMoved;
            if (deactivateSelection) {
                this.snapshotView.setSelection(null);
            }
            this.setSelectionChanging.accept(false);
        }

        private void updateMouseMoved(Point2D point) {
            boolean mouseMovedNow;
            if (this.mouseMoved) {
                return;
            }
            this.mouseMoved = mouseMovedNow = !this.startingPoint.equals((Object)point);
        }

        @Override
        public Cursor getCursor() {
            return this.cursor;
        }
    }

    private static interface SelectionChange {
        public void beginSelectionChange(Point2D var1);

        public void continueSelectionChange(Point2D var1);

        public void endSelectionChange(Point2D var1);

        public Cursor getCursor();
    }

    private static class NoSelectionChange
    implements SelectionChange {
        public static final NoSelectionChange INSTANCE = new NoSelectionChange();

        private NoSelectionChange() {
        }

        @Override
        public void beginSelectionChange(Point2D point) {
        }

        @Override
        public void continueSelectionChange(Point2D point) {
        }

        @Override
        public void endSelectionChange(Point2D point) {
        }

        @Override
        public Cursor getCursor() {
            return Cursor.DEFAULT;
        }
    }
}

