/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxhub.web;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteRenderer;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.DefaultCssAutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxhub.web.IndexPage;
import xxx.scenerixx.scenerixxhub.web.ScenerixxHubSession;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.db.EntityService;
import xxx.scenerixx.scenerixxlib.model.QMovie;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;

public class Menu
extends Panel {
    private transient DB db = null;
    private transient PlaylistService ps = new PlaylistService();
    private final Logger LOGGER = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String currentSearchSelection = null;
    private Model<String> passwordModel = Model.of((Serializable)((Object)""));
    private AjaxLink<Void> ajaxLink = null;

    public Menu(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        final ScenerixxSettings settings = this.getDB().getScenerixxSettings();
        this.add(new Component[]{new BookmarkablePageLink("index", IndexPage.class)});
        this.initCategories();
        this.initSearch();
        this.initPlaylists();
        final WebMarkupContainer wmc = new WebMarkupContainer("wmc");
        Form form = new Form("form"){

            protected void onSubmit() {
                super.onSubmit();
                String password = (String)((Object)Menu.this.passwordModel.getObject());
                if (settings.getSecretPassword() != null) {
                    if (BCrypt.checkpw((String)new String(password), (String)settings.getSecretPassword())) {
                        ScenerixxHubSession.get().setUnlocked(true);
                    } else {
                        ScenerixxHubSession.get().setUnlocked(false);
                    }
                    this.setResponsePage(IndexPage.class);
                }
            }
        };
        PasswordTextField passwordTextField = new PasswordTextField("password", this.passwordModel);
        form.add(new Component[]{passwordTextField});
        wmc.add(new Component[]{form});
        this.add(new Component[]{wmc});
        wmc.setOutputMarkupPlaceholderTag(true);
        wmc.setVisible(false);
        this.ajaxLink = new AjaxLink<Void>("showModalUnlockSecretItemsLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                if (ScenerixxHubSession.get().isUnlocked()) {
                    ScenerixxHubSession.get().setUnlocked(false);
                    Menu.this.ajaxLink.setBody((IModel)Model.of((Serializable)((Object)"Unlock session")));
                    target.add(new Component[]{Menu.this.ajaxLink});
                    this.setResponsePage(IndexPage.class);
                } else if (settings == null || settings.getSecretPassword() == null) {
                    ScenerixxHubSession.get().setUnlocked(true);
                    wmc.setVisible(false);
                    Menu.this.ajaxLink.setBody((IModel)Model.of((Serializable)((Object)"Lock session")));
                    target.add(new Component[]{wmc, Menu.this.ajaxLink});
                    this.setResponsePage(IndexPage.class);
                } else {
                    wmc.setVisible(true);
                    target.add(new Component[]{wmc});
                }
            }
        };
        if (ScenerixxHubSession.get().isUnlocked()) {
            this.ajaxLink.setBody((IModel)Model.of((Serializable)((Object)"Lock session")));
        } else {
            this.ajaxLink.setBody((IModel)Model.of((Serializable)((Object)"Unlock session")));
        }
        this.add(new Component[]{this.ajaxLink});
        AjaxLink<Void> logoutLink = new AjaxLink<Void>("logoutLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ScenerixxHubSession.get().signOut();
                this.setResponsePage(IndexPage.class);
            }

            public boolean isVisible() {
                ScenerixxSettings scenerixxSettings = Menu.this.getDB().getScenerixxSettings();
                if (scenerixxSettings == null) {
                    return false;
                }
                return scenerixxSettings.getStartPassword() != null;
            }
        };
        this.add(new Component[]{logoutLink});
    }

    private void initSearch() {
        IModel<String> model = new IModel<String>(){
            private String value = null;

            public String getObject() {
                return this.value;
            }

            public void setObject(String object) {
                this.value = object;
            }

            public void detach() {
            }
        };
        String searchString = "";
        Model searchModel = Model.of((Serializable)((Object)searchString));
        AbstractAutoCompleteRenderer autoCompleteRenderer = new AbstractAutoCompleteRenderer(){

            protected final String getTextValue(Object object) {
                String movieTitle = (String)object;
                return movieTitle;
            }

            protected final void renderChoice(Object object, Response response, String criteria) {
                response.write((CharSequence)this.getTextValue(object));
            }
        };
        AutoCompleteTextField<String> searchfield = new AutoCompleteTextField<String>("searchfield", (IModel)model, (IAutoCompleteRenderer)autoCompleteRenderer){

            protected Iterator<String> getChoices(String input) {
                String[] searchTerms;
                Menu.this.LOGGER.debug("get choices  " + input);
                if (Strings.isEmpty((String)input)) {
                    List emptyList = Collections.emptyList();
                    return emptyList.iterator();
                }
                EntityService.Finder find = Menu.this.getDB().getEntityService().find((EntityPathBase)QMovie.movie);
                EntityService.Finder filter = null;
                for (String term : searchTerms = input.split(" ")) {
                    filter = find.filter(f -> f.title.containsIgnoreCase(term));
                }
                List movies = filter.find(50L);
                List movieTitles = movies.stream().filter(f -> {
                    MediumFile mf;
                    Medium patt0$temp = f.getStartMedium();
                    return patt0$temp instanceof MediumFile && ((mf = (MediumFile)patt0$temp).getFileExtension().equalsIgnoreCase("m4v") || mf.getFileExtension().equalsIgnoreCase("mp4"));
                }).map(f -> f.getTitle()).collect(Collectors.toList());
                return movieTitles.iterator();
            }

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(DefaultCssAutoCompleteTextField.class, "DefaultCssAutoCompleteTextField.css")));
            }
        };
        Form form = new Form("searchForm", (AutoCompleteTextField)searchfield){
            final /* synthetic */ AutoCompleteTextField val$searchfield;
            {
                this.val$searchfield = autoCompleteTextField;
                super(arg0);
            }

            protected void onSubmit() {
                super.onSubmit();
                Menu.this.LOGGER.info("submitted current search : " + (String)this.val$searchfield.getModelObject());
                this.setResponsePage(IndexPage.class, new PageParameters().add("searchTerm", this.val$searchfield.getModelObject()));
            }
        };
        searchfield.add(new Behavior[]{new AjaxFormSubmitBehavior(form, "change", (IModel)model){
            final /* synthetic */ IModel val$model;
            {
                this.val$model = iModel;
                super(arg0, arg1);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                Menu.this.currentSearchSelection = (String)this.val$model.getObject();
                Menu.this.LOGGER.info("selection : " + (String)this.val$model.getObject());
            }

            protected void onError(AjaxRequestTarget target) {
                Menu.this.LOGGER.info("an error occured getting the search results");
            }
        }});
        form.add(new Component[]{searchfield});
        this.add(new Component[]{form});
        this.add(new Component[]{new BookmarkablePageLink("topRated", IndexPage.class, new PageParameters().add("sorting", (Object)"topRated")).setBody((IModel)Model.of((Serializable)((Object)"Top Rated")))});
        this.add(new Component[]{new BookmarkablePageLink("lastAdded", IndexPage.class, new PageParameters().add("sorting", (Object)"lastAdded")).setBody((IModel)Model.of((Serializable)((Object)"Last Added")))});
        this.add(new Component[]{new BookmarkablePageLink("lastSeen", IndexPage.class, new PageParameters().add("sorting", (Object)"lastSeen")).setBody((IModel)Model.of((Serializable)((Object)"Last Seen")))});
        this.add(new Component[]{new BookmarkablePageLink("random", IndexPage.class, new PageParameters().add("sorting", (Object)"random")).setBody((IModel)Model.of((Serializable)((Object)"Random")))});
    }

    private void initCategories() {
        RepeatingView categories = new RepeatingView("categories");
        List<MovieType> movieTypesAsList = Arrays.asList(MovieType.values());
        Collections.sort(movieTypesAsList, new Comparator<MovieType>(this){

            @Override
            public int compare(MovieType o1, MovieType o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (MovieType mt : movieTypesAsList) {
            categories.add(new Component[]{new BookmarkablePageLink(categories.newChildId(), IndexPage.class, new PageParameters().add("movieType", (Object)mt)).setBody((IModel)Model.of((Serializable)mt))});
        }
        this.add(new Component[]{categories});
    }

    private void initPlaylists() {
        RepeatingView playlists = new RepeatingView("playlists");
        for (Playlist pl : this.ps.getPlaylists(ScenerixxHubSession.get().isUnlocked(), true)) {
            playlists.add(new Component[]{new BookmarkablePageLink(playlists.newChildId(), IndexPage.class, new PageParameters().add("playlistId", (Object)pl.getId())).setBody((IModel)Model.of((Serializable)((Object)pl.getName())))});
        }
        this.add(new Component[]{playlists});
    }

    private DB getDB() {
        if (this.db == null) {
            this.db = DB.getInstance();
        }
        return this.db;
    }
}

