/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxhub.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxhub.web.AbstractBasePage;
import xxx.scenerixx.scenerixxhub.web.ScenerixxHubSession;
import xxx.scenerixx.scenerixxhub.web.SearchResultPanel;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;

public class IndexPage
extends AbstractBasePage {
    private final Logger LOGGER = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private transient PlaylistService ps = new PlaylistService();
    private static int MAX_MOVIES = 50;

    public IndexPage(PageParameters parameters) {
        super(parameters);
        StringValue movieTypeParam = parameters.get("movieType");
        StringValue searchTerm = parameters.get("searchTerm");
        StringValue sorting = parameters.get("sorting");
        Long playlistId = parameters.get("playlistId").toLong(-1L);
        if (!movieTypeParam.isNull()) {
            this.LOGGER.info("Show movies with the type'" + movieTypeParam.toString() + "'");
            MovieType movieType = MovieType.get((String)movieTypeParam.toString());
            List movies = this.db.getMovies(movieType, ScenerixxHubSession.get().isUnlocked()).stream().map(f -> f.getId()).collect(Collectors.toList());
            this.add(new Component[]{new SearchResultPanel("searchResult", (IModel<List<Long>>)Model.ofList(movies))});
        } else if (playlistId != -1L) {
            ArrayList<Long> movies = new ArrayList<Long>();
            Playlist p = (Playlist)this.db.getEntityService().load(Playlist.class, playlistId.longValue());
            this.LOGGER.info("Show movies from playlist'" + p.getName() + "'");
            for (IPlayablePlaylistItems playable : p.getPlayables(ScenerixxHubSession.get().isUnlocked())) {
                if (!(playable instanceof IPlayable)) continue;
                movies.add(((IPlayable)playable).getMovieAssociated().getId());
            }
            this.add(new Component[]{new SearchResultPanel("searchResult", (IModel<List<Long>>)Model.ofList(movies))});
        } else if (!searchTerm.isNull()) {
            this.LOGGER.info("Show movies with the search term '" + searchTerm.toString() + "'");
            List movies = this.db.getMovies(searchTerm.toString(), DB.OrderBy.TITLE, ScenerixxHubSession.get().isUnlocked(), (long)MAX_MOVIES).stream().map(f -> f.getId()).collect(Collectors.toList());
            this.add(new Component[]{new SearchResultPanel("searchResult", (IModel<List<Long>>)Model.ofList(movies))});
        } else if (!sorting.isNull()) {
            if (sorting.toString().equalsIgnoreCase("topRated")) {
                this.LOGGER.info("Show in top rated order");
                List movies = this.db.getMovies(DB.OrderBy.RATING, ScenerixxHubSession.get().isUnlocked(), (long)MAX_MOVIES).stream().map(f -> f.getId()).collect(Collectors.toList());
                this.add(new Component[]{new SearchResultPanel("searchResult", (IModel<List<Long>>)Model.ofList(movies))});
            } else if (sorting.toString().equalsIgnoreCase("lastAdded")) {
                this.LOGGER.info("Show in last added order");
                List movies = this.db.getMovies(DB.OrderBy.LASTMODIFICATION, ScenerixxHubSession.get().isUnlocked(), (long)MAX_MOVIES).stream().map(f -> f.getId()).collect(Collectors.toList());
                this.add(new Component[]{new SearchResultPanel("searchResult", (IModel<List<Long>>)Model.ofList(movies))});
            } else if (sorting.toString().equalsIgnoreCase("lastSeen")) {
                this.LOGGER.info("Show in last seen order");
                ArrayList<Long> movies = new ArrayList<Long>();
                List pes = this.ps.getHistoryPlaylistEntries(false);
                for (PlaylistEntry pe : pes) {
                    movies.add(pe.getMovie().getId());
                }
                List subList = new ArrayList();
                if (!movies.isEmpty()) {
                    subList = movies.subList(0, Math.min(movies.size() - 1, MAX_MOVIES));
                }
                this.add(new Component[]{new SearchResultPanel("searchResult", (IModel<List<Long>>)Model.ofList(subList))});
            } else if (sorting.toString().equalsIgnoreCase("random")) {
                this.LOGGER.info("Show in random order");
                List movies = this.db.getMovies(ScenerixxHubSession.get().isUnlocked()).stream().map(f -> f.getId()).collect(Collectors.toList());
                List<Object> subList = new ArrayList();
                if (!movies.isEmpty()) {
                    Collections.shuffle(movies);
                    subList = movies.subList(0, Math.min(movies.size() - 1, MAX_MOVIES));
                }
                this.add(new Component[]{new SearchResultPanel("searchResult", (IModel<List<Long>>)Model.ofList(subList))});
            }
        } else {
            this.LOGGER.info("Show all movies");
            List movies = this.db.getMovies(ScenerixxHubSession.get().isUnlocked(), 1000L);
            this.add(new Component[]{new SearchResultPanel("searchResult", (IModel<List<Long>>)Model.ofList(movies.stream().map(f -> f.getId()).collect(Collectors.toList())))});
        }
    }
}

