/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.util;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

@Converter(autoApply=true)
public class ZonedDateTimeConverter
implements AttributeConverter<ZonedDateTime, Date> {
    private static final Logger LOGGER = Logger.getLogger(ZonedDateTimeConverter.class.getName());

    public Date convertToDatabaseColumn(ZonedDateTime attribute) {
        if (attribute == null) {
            return null;
        }
        LOGGER.log(Level.ALL, "Converting zdt {0} to UTC", attribute);
        ZonedDateTime inUTC = attribute.withZoneSameInstant(ZoneId.of("UTC"));
        LOGGER.log(Level.ALL, "Converted zdt: {0}", inUTC);
        ZonedDateTime backToSystemDefault = inUTC.withZoneSameLocal(ZoneId.systemDefault());
        LOGGER.log(Level.ALL, "In system default: {0}", backToSystemDefault);
        Date result = Date.from(backToSystemDefault.toInstant());
        LOGGER.log(Level.ALL, "Result: {0}", result);
        return result;
    }

    public ZonedDateTime convertToEntityAttribute(Date dbDateInUTC) {
        if (dbDateInUTC == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(dbDateInUTC.getTime()), ZoneId.systemDefault()).withZoneSameLocal(ZoneId.of("UTC"));
    }
}

