/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.model.playlist;

import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import java.time.format.DateTimeFormatter;
import java.util.List;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;

@Entity
public class PlaylistEntry
extends AbstractEntity
implements IPlayablePlaylistItems {
    @ManyToOne
    private Playlist playlist;
    private int pos;
    @OneToOne
    private Movie movie;
    @OneToOne
    private Scene scene;
    @OneToOne
    private Bookmark bookmark;
    @OneToOne
    private MediumFile mediumFile;
    @OneToOne
    private Person person;
    @OneToOne
    private Studio studio;

    public Playlist getPlaylist() {
        if (this.playlist == null) {
            return new Playlist();
        }
        return this.playlist;
    }

    public void setPlaylist(Playlist playlist) {
        this.playlist = playlist;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    @Override
    public int getPositionInList() {
        return this.getPos() + 1;
    }

    public Movie getMovie() {
        return this.movie;
    }

    public void setMovie(Movie movie) {
        this.movie = movie;
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(Bookmark bookmark) {
        this.bookmark = bookmark;
    }

    public MediumFile getMediumFile() {
        return this.mediumFile;
    }

    public void setMediumFile(MediumFile mediumFile) {
        this.mediumFile = mediumFile;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
    }

    public String getNameOfPlayable() {
        Object res = "";
        if (this.bookmark != null) {
            res = this.bookmark.getNameOfPlayable();
        }
        if (this.scene != null) {
            res = this.scene.getNameOfPlayable();
        }
        if (this.movie != null) {
            res = this.movie.getNameOfPlayable();
        }
        if (this.mediumFile != null) {
            res = this.mediumFile.getNameOfPlayable();
        }
        if (this.person != null) {
            res = this.person.getName();
        }
        if (this.studio != null) {
            res = this.studio.getName();
        }
        if (this.getPlaylist() != null && "History".equals(this.getPlaylist().getName())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            res = (String)res + " [" + df.format(this.getDateOfCreation()) + "]";
        }
        return res;
    }

    public String getRuntime() {
        Long runtime = 0L;
        if (this.bookmark != null && this.bookmark.getTotalRuntime() > 0) {
            runtime = runtime + (long)this.bookmark.getTotalRuntime();
        }
        if (this.scene != null && this.scene.getTotalRuntime() > 0) {
            runtime = runtime + (long)this.scene.getTotalRuntime();
        }
        if (this.movie != null && this.movie.getTotalRuntime() > 0) {
            runtime = runtime + (long)this.movie.getTotalRuntime();
        }
        if (this.mediumFile != null && this.mediumFile.getTotalRuntime() > 0) {
            runtime = runtime + (long)this.mediumFile.getTotalRuntime();
        }
        if (this.person != null) {
            List<Scene> scenes = DB.getInstance().getScenes(this.person, true);
            for (Scene s : scenes) {
                if (s.getTotalRuntime() <= 0) continue;
                runtime = runtime + (long)s.getTotalRuntime();
            }
            Object sRuntime = "";
            if (runtime / 86400L > 0L) {
                sRuntime = String.format("%02d", runtime / 86400L) + "d:";
            }
            sRuntime = (String)sRuntime + String.format("%02d", runtime / 3600L % 24L) + ":" + String.format("%02d", runtime / 60L % 60L) + ":" + String.format("%02d", runtime % 60L);
            return sRuntime;
        }
        return String.format("%02d", runtime / 3600L % 24L) + ":" + String.format("%02d", runtime / 60L % 60L) + ":" + String.format("%02d", runtime % 60L);
    }

    public int getStarttime() {
        int result = 0;
        if (this.bookmark != null && this.bookmark.getStartTime() > 0) {
            result = this.bookmark.getStartTime();
        }
        if (this.scene != null && this.scene.getStartTime() > 0) {
            result = this.scene.getStartTime();
        }
        return result;
    }

    public int getEndtime() {
        int result = 0;
        if (this.bookmark != null && this.bookmark.getEndTime() > 0) {
            result = this.bookmark.getEndTime();
        }
        if (this.scene != null && this.scene.getEndTime() > 0) {
            result = this.scene.getEndTime();
        }
        return result;
    }
}

