/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxlib.model.enums.Differentiator;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.enums.Location;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.enums.Nationality;
import xxx.scenerixx.scenerixxlib.model.enums.PartnerCompatibility;
import xxx.scenerixx.scenerixxlib.model.enums.Quality;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.util.json.ExcludeGson;

@Entity
public class Scene
extends AbstractEntity
implements INode,
IPlayable,
Serializable,
IPlayablePlaylistItems {
    private static transient DB db = null;
    @ExcludeGson
    @ManyToOne
    private Movie movie;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="scene", fetch=FetchType.LAZY)
    private List<SceneDetails> details = new ArrayList<SceneDetails>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="scene")
    @OrderBy(value="position")
    private List<Bookmark> bookmarks = new ArrayList<Bookmark>();
    @ExcludeGson
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH, CascadeType.DETACH})
    private List<MediumFile> pictures = new ArrayList<MediumFile>();
    @ExcludeGson
    @OneToOne
    private Medium startMedium;
    @ExcludeGson
    @OneToOne
    private Medium endMedium;
    private int startTime;
    private int endTime;
    private int pos;
    private Integer title;
    private Integer chapter;
    private Integer dateOfShootDay;
    private Integer dateOfShootMonth;
    private Integer dateOfShootYear;
    private boolean favorite;
    private boolean regrettablyAwesome;
    private boolean bonusScene;
    private boolean behindTheScenes;
    private boolean condomsUsed;
    private boolean summary;
    private boolean intercut;
    private boolean incomplete;
    @Lob
    private String publicDescription;
    @Lob
    private String privateDescription;
    @Enumerated(value=EnumType.STRING)
    private Location location1;
    @Enumerated(value=EnumType.STRING)
    private Location location2;
    @Enumerated(value=EnumType.STRING)
    private Location location3;
    @Enumerated(value=EnumType.STRING)
    private Quality soundQuality;
    @Enumerated(value=EnumType.STRING)
    private Differentiator soundQualityDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Quality videoQuality;
    @Enumerated(value=EnumType.STRING)
    private Differentiator videoQualityDifferentiator;
    @Enumerated(value=EnumType.STRING)
    private Nationality shotInCountry;
    @Enumerated(value=EnumType.STRING)
    private MovieType type;
    @Enumerated(value=EnumType.STRING)
    private MovieType type2;
    @Enumerated(value=EnumType.STRING)
    private MovieType type3;
    @Enumerated(value=EnumType.STRING)
    private MovieType type4;
    @Enumerated(value=EnumType.STRING)
    private MovieType type5;
    @Enumerated(value=EnumType.STRING)
    private MovieType type6;
    @ElementCollection(fetch=FetchType.EAGER)
    @Enumerated(value=EnumType.STRING)
    private Collection<MovieType> movietypes;
    @Enumerated(value=EnumType.STRING)
    private PartnerCompatibility partnerCompatibility;
    @Enumerated(value=EnumType.STRING)
    private Differentiator partnerCompatibilityDifferentiator;
    private Integer immersion;
    @Enumerated(value=EnumType.STRING)
    private Differentiator immersionDifferentiator;

    public Integer getTitle() {
        return this.title;
    }

    public void setTitle(Integer title) {
        this.title = title;
    }

    public Integer getChapter() {
        return this.chapter;
    }

    public void setChapter(Integer chapter) {
        this.chapter = chapter;
    }

    public Movie getMovie() {
        return this.movie;
    }

    public void setMovie(Movie movie) {
        this.movie = movie;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public List<Person> getPersons(boolean secret) {
        return this.getDB().getPersons(this, secret);
    }

    public List<Bookmark> getBookmarks(boolean showSecret) {
        if (showSecret) {
            return this.bookmarks;
        }
        ArrayList<Bookmark> result = new ArrayList<Bookmark>(this.bookmarks);
        for (Bookmark b : this.bookmarks) {
            if (!b.isSecret() || showSecret) continue;
            result.remove(b);
        }
        return result;
    }

    public void setBookmarks(List<Bookmark> bookmarks) {
        this.bookmarks = bookmarks;
    }

    public SceneDetails getDetails(Person p) {
        for (SceneDetails sd : this.details) {
            if (!p.equals(sd.getPerson())) continue;
            return sd;
        }
        return null;
    }

    public SceneDetails getCompleteDetails() {
        for (SceneDetails sd : this.details) {
            if (sd.getPerson() != null) continue;
            return sd;
        }
        return null;
    }

    public List<SceneDetails> getDetails() {
        return this.details;
    }

    public void setDetails(List<SceneDetails> details) {
        this.details = details;
    }

    @Override
    public Medium getStartMedium() {
        return this.startMedium;
    }

    public void setStartMedium(Medium startMedium) {
        this.startMedium = startMedium;
    }

    @Override
    public Medium getEndMedium() {
        return this.endMedium;
    }

    public void setEndMedium(Medium endMedium) {
        this.endMedium = endMedium;
    }

    @Override
    public Movie getMovieAssociated() {
        return this.movie;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int startTime) {
        this.startTime = startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int endTime) {
        this.endTime = endTime;
    }

    @Override
    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public boolean isRegrettablyAwesome() {
        return this.regrettablyAwesome;
    }

    public void setRegrettablyAwesome(boolean regrettablyAwesome) {
        this.regrettablyAwesome = regrettablyAwesome;
    }

    public boolean isBonusScene() {
        return this.bonusScene;
    }

    public void setBonusScene(boolean bonusScene) {
        this.bonusScene = bonusScene;
    }

    public boolean isBehindTheScenes() {
        return this.behindTheScenes;
    }

    public void setBehindTheScenes(boolean behindTheScenes) {
        this.behindTheScenes = behindTheScenes;
    }

    public boolean isCondomsUsed() {
        return this.condomsUsed;
    }

    public void setCondomsUsed(boolean condomsUsed) {
        this.condomsUsed = condomsUsed;
    }

    public Integer getDateOfShootDay() {
        return this.dateOfShootDay;
    }

    public void setDateOfShootDay(Integer dateOfShootDay) {
        this.dateOfShootDay = dateOfShootDay;
    }

    public Integer getDateOfShootMonth() {
        return this.dateOfShootMonth;
    }

    public void setDateOfShootMonth(Integer dateOfShootMonth) {
        this.dateOfShootMonth = dateOfShootMonth;
    }

    public Integer getDateOfShootYear() {
        return this.dateOfShootYear;
    }

    public void setDateOfShootYear(Integer dateOfShootYear) {
        this.dateOfShootYear = dateOfShootYear;
    }

    public String getPublicDescription() {
        return this.publicDescription;
    }

    public void setPublicDescription(String publicDescription) {
        this.publicDescription = publicDescription;
    }

    public String getPrivateDescription() {
        return this.privateDescription;
    }

    public void setPrivateDescription(String privateDescription) {
        this.privateDescription = privateDescription;
    }

    @Override
    public List<MediumFile> getPictures() {
        if (this.pictures == null) {
            return new ArrayList<MediumFile>();
        }
        return this.pictures;
    }

    public void setPictures(List<MediumFile> pictures) {
        this.pictures = pictures;
    }

    public Location getLocation1() {
        return this.location1;
    }

    public void setLocation1(Location location1) {
        this.location1 = location1;
    }

    public Location getLocation2() {
        return this.location2;
    }

    public void setLocation2(Location location2) {
        this.location2 = location2;
    }

    public Location getLocation3() {
        return this.location3;
    }

    public void setLocation3(Location location3) {
        this.location3 = location3;
    }

    public Quality getSoundQuality() {
        return this.soundQuality;
    }

    public void setSoundQuality(Quality soundQuality) {
        this.soundQuality = soundQuality;
    }

    public Differentiator getSoundQualityDifferentiator() {
        return this.soundQualityDifferentiator;
    }

    public void setSoundQualityDifferentiator(Differentiator soundQualityDifferentiator) {
        this.soundQualityDifferentiator = soundQualityDifferentiator;
    }

    public Differentiator getVideoQualityDifferentiator() {
        return this.videoQualityDifferentiator;
    }

    public void setVideoQualityDifferentiator(Differentiator videoQualityDifferentiator) {
        this.videoQualityDifferentiator = videoQualityDifferentiator;
    }

    public Quality getVideoQuality() {
        return this.videoQuality;
    }

    public void setVideoQuality(Quality videoQuality) {
        this.videoQuality = videoQuality;
    }

    public MovieType getType() {
        return this.type;
    }

    public void setType(MovieType type) {
        this.type = type;
    }

    public MovieType getType2() {
        return this.type2;
    }

    public void setType2(MovieType type2) {
        this.type2 = type2;
    }

    public MovieType getType3() {
        return this.type3;
    }

    public void setType3(MovieType type3) {
        this.type3 = type3;
    }

    public MovieType getType4() {
        return this.type4;
    }

    public void setType4(MovieType type4) {
        this.type4 = type4;
    }

    public MovieType getType5() {
        return this.type5;
    }

    public void setType5(MovieType type5) {
        this.type5 = type5;
    }

    public MovieType getType6() {
        return this.type6;
    }

    public void setType6(MovieType type6) {
        this.type6 = type6;
    }

    public Collection<MovieType> getMovietypes() {
        if (this.movietypes == null) {
            this.movietypes = new ArrayList<MovieType>();
        }
        return this.movietypes;
    }

    public void setMovietypes(Collection<MovieType> movietypes) {
        this.movietypes = movietypes;
    }

    public boolean isSummary() {
        return this.summary;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public boolean isIntercut() {
        return this.intercut;
    }

    public void setIntercut(boolean intercut) {
        this.intercut = intercut;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    public PartnerCompatibility getPartnerCompatibility() {
        return this.partnerCompatibility;
    }

    public void setPartnerCompatibility(PartnerCompatibility partnerCompatibility) {
        this.partnerCompatibility = partnerCompatibility;
    }

    public Integer getImmersion() {
        return this.immersion;
    }

    public void setImmersion(Integer immersion) {
        this.immersion = immersion;
    }

    public Differentiator getImmersionDifferentiator() {
        return this.immersionDifferentiator;
    }

    public void setImmersionDifferentiator(Differentiator immersionDifferentiator) {
        this.immersionDifferentiator = immersionDifferentiator;
    }

    public Differentiator getPartnerCompatibilityDifferentiator() {
        return this.partnerCompatibilityDifferentiator;
    }

    public void setPartnerCompatibilityDifferentiator(Differentiator partnerCompatibilityDifferentiator) {
        this.partnerCompatibilityDifferentiator = partnerCompatibilityDifferentiator;
    }

    public Nationality getShotInCountry() {
        return this.shotInCountry;
    }

    public void setShotInCountry(Nationality shotInCountry) {
        this.shotInCountry = shotInCountry;
    }

    public String toString() {
        return "Scene " + this.pos + " of movie " + this.movie.getTitle();
    }

    @Override
    public String getNameOfPlayable() {
        Object names = "";
        for (Person p : this.getPersons(false)) {
            names = (String)names + p.getName() + " & ";
        }
        if (((String)names).endsWith(" & ")) {
            names = ((String)names).substring(0, ((String)names).length() - " & ".length());
        }
        if (((String)names).isEmpty()) {
            names = "n/a";
        }
        Object movieName = " of unknkown movie ";
        if (this.movie != null) {
            movieName = " of movie '" + this.movie.getTitle() + "'";
        }
        return "Scene " + this.pos + (String)movieName + ", starring: " + (String)names;
    }

    public String getPersonNames(boolean showSecret) {
        ArrayList<String> namesListFemales = new ArrayList<String>();
        ArrayList<String> namesListTs = new ArrayList<String>();
        ArrayList<String> namesListMales = new ArrayList<String>();
        for (SceneDetails tmpSd : this.getDetails()) {
            if (tmpSd.getPerson() == null || !showSecret && tmpSd.getPerson().isSecret()) continue;
            if (Gender.FEMALE.equals(tmpSd.getPerson().getGender())) {
                namesListFemales.add(tmpSd.getPerson().getDisplayedName());
            }
            if (Gender.TS.equals(tmpSd.getPerson().getGender())) {
                namesListTs.add(tmpSd.getPerson().getDisplayedName());
            }
            if (!Gender.MALE.equals(tmpSd.getPerson().getGender())) continue;
            namesListMales.add(tmpSd.getPerson().getDisplayedName());
        }
        return Stream.of(namesListFemales.stream().sorted().collect(Collectors.joining(" & ")), namesListTs.stream().sorted().collect(Collectors.joining(" & ")), namesListMales.stream().sorted().collect(Collectors.joining(" & "))).filter(Predicate.not(String::isBlank)).collect(Collectors.joining(" & "));
    }

    @Override
    public int getTotalRuntime() {
        int result = -1;
        if (this.startMedium != null && this.startMedium.equals(this.endMedium)) {
            result = this.endTime - this.startTime;
        } else if (this.startMedium != null && this.endMedium != null && !this.startMedium.equals(this.endMedium)) {
            int firstPart = 0;
            if (this.startMedium.getDuration() != null) {
                firstPart = this.startMedium.getDuration() / 1000 - this.startTime;
            }
            int secondPart = this.endTime;
            result = firstPart + secondPart;
            if (this.endMedium.getPart() - this.startMedium.getPart() != 1) {
                List<MediumFile> mediumFiles = this.getDB().getMediumFiles(this.getMovie(), true);
                for (int i = this.startMedium.getPart(); i < this.endMedium.getPart() - 1; ++i) {
                    result += mediumFiles.get(i).getDuration() / 1000;
                }
            }
        }
        for (Bookmark b : this.getBookmarks(true)) {
            Logger.getLogger(Scene.class.getName()).log(Level.FINE, "check ignore bookmarks " + b.getBookmarkTitle());
            if (!BookmarkType.IGNORE.equals(b.getType())) continue;
            Logger.getLogger(Scene.class.getName()).log(Level.FINE, "subtract " + b.getTotalRuntime() + " from scene " + this.getNameOfPlayable());
            result -= b.getTotalRuntime();
        }
        return result;
    }

    public boolean isSingleScene() {
        return this.movie.getScenes().size() == 1;
    }

    public String getTypesAsString() {
        ArrayList<String> typesList = new ArrayList<String>();
        if (this.type != null) {
            typesList.add(this.type.getTitle());
        }
        if (this.type2 != null) {
            typesList.add(this.type2.getTitle());
        }
        if (this.type3 != null) {
            typesList.add(this.type3.getTitle());
        }
        if (this.type4 != null) {
            typesList.add(this.type4.getTitle());
        }
        if (this.type5 != null) {
            typesList.add(this.type5.getTitle());
        }
        if (this.type6 != null) {
            typesList.add(this.type6.getTitle());
        }
        this.movietypes.stream().forEach(f -> typesList.add(f.toString()));
        return typesList.stream().collect(Collectors.joining(", "));
    }

    private DB getDB() {
        if (db == null) {
            db = DB.getInstance();
        }
        return db;
    }
}

