/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.exporter;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.input.SAXBuilder;
import xxx.scenerixx.scenerixxlib.PreviousCodenames;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Cumshot;
import xxx.scenerixx.scenerixxlib.model.Goldenshower;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.PersonBody;
import xxx.scenerixx.scenerixxlib.model.PersonWebsites;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.StudioWebsites;
import xxx.scenerixx.scenerixxlib.model.enums.Appearance;
import xxx.scenerixx.scenerixxlib.model.enums.BodyPartSize;
import xxx.scenerixx.scenerixxlib.model.enums.BodyType;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxlib.model.enums.CauseOfDeath;
import xxx.scenerixx.scenerixxlib.model.enums.Clothes;
import xxx.scenerixx.scenerixxlib.model.enums.Differentiator;
import xxx.scenerixx.scenerixxlib.model.enums.DirtyTalkIntensity;
import xxx.scenerixx.scenerixxlib.model.enums.Dominating;
import xxx.scenerixx.scenerixxlib.model.enums.Ethnicity;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.enums.GoldenshowerColor;
import xxx.scenerixx.scenerixxlib.model.enums.HairColor;
import xxx.scenerixx.scenerixxlib.model.enums.HairLength;
import xxx.scenerixx.scenerixxlib.model.enums.HairStyle;
import xxx.scenerixx.scenerixxlib.model.enums.HairType;
import xxx.scenerixx.scenerixxlib.model.enums.Intensity;
import xxx.scenerixx.scenerixxlib.model.enums.Jewelry;
import xxx.scenerixx.scenerixxlib.model.enums.Language;
import xxx.scenerixx.scenerixxlib.model.enums.Location;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.enums.Nationality;
import xxx.scenerixx.scenerixxlib.model.enums.PartnerCompatibility;
import xxx.scenerixx.scenerixxlib.model.enums.PersonHeight;
import xxx.scenerixx.scenerixxlib.model.enums.Position;
import xxx.scenerixx.scenerixxlib.model.enums.PubicHairLength;
import xxx.scenerixx.scenerixxlib.model.enums.Quality;
import xxx.scenerixx.scenerixxlib.model.enums.Quantity;
import xxx.scenerixx.scenerixxlib.model.enums.SkinTone;
import xxx.scenerixx.scenerixxlib.model.enums.SocialWebsites;
import xxx.scenerixx.scenerixxlib.model.enums.Speed;
import xxx.scenerixx.scenerixxlib.model.enums.Toys;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.medium.QMediumFile;

public class Importer {
    public static final Logger LOG = Logger.getLogger(Importer.class.getName());
    private DB db = DB.getInstance();

    public List<Person> importPersonsFromMovieFile(String filepath) throws Exception {
        ArrayList<Person> persons = new ArrayList<Person>();
        try {
            Element rootNode = this.initImport(filepath);
            List list = rootNode.getChildren("movie");
            for (int i = 0; i < list.size(); ++i) {
                Element node = (Element)list.get(i);
                List personsList = node.getChildren("persons");
                for (int j = 0; j < personsList.size(); ++j) {
                    Element personsNode = (Element)personsList.get(j);
                    List personList = personsNode.getChildren("person");
                    for (int k = 0; k < personList.size(); ++k) {
                        Person p = new Person();
                        Element personNode = (Element)personList.get(k);
                        this.readPersonNode(p, personNode);
                        this.readPersonBodyRootNode(node, true, p);
                        this.readOtherNodes(personNode, p, persons);
                    }
                }
                LOG.fine("Persons read: " + persons.size());
            }
        }
        catch (IOException io) {
            LOG.severe(io.getMessage());
        }
        catch (JDOMException jdomex) {
            LOG.severe(jdomex.getMessage());
        }
        return persons;
    }

    private Element initImport(String filepath) throws IOException, JDOMException, Exception {
        SAXBuilder builder = new SAXBuilder();
        File xmlFile = new File(filepath);
        Document document = builder.build(xmlFile);
        Element rootNode = document.getRootElement();
        if (!"scenerixx".equals(rootNode.getName())) {
            throw new Exception("don't know how to handle this");
        }
        List versionList = rootNode.getChildren("version");
        String codename = ((Element)versionList.get(0)).getChildText("codename");
        try {
            PreviousCodenames.valueOf(codename);
        }
        catch (IllegalArgumentException iae) {
            throw new Exception("You are trying to import a file which was created with a newer version of Scenerixx. Upgrade at least to a version with codename '" + codename + "'");
        }
        return rootNode;
    }

    public Movie importMovieFile(String filepath) throws Exception {
        Movie result = null;
        ArrayList<Person> persons = new ArrayList<Person>();
        try {
            Element rootNode = this.initImport(filepath);
            List list = rootNode.getChildren("movie");
            for (int i = 0; i < list.size(); ++i) {
                Movie m = new Movie();
                Element node = (Element)list.get(i);
                m.setTitle(node.getChildText("title"));
                if (node.getChildText("alternativeTitle") != null) {
                    m.setAlternativeTitle(node.getChildText("alternativeTitle"));
                }
                if (node.getChildText("officialUrl") != null) {
                    m.setOfficialUrl(node.getChildText("officialUrl"));
                }
                if (node.getChildText("iafdUrl") != null) {
                    m.setIafdUrl(node.getChildText("iafdUrl"));
                }
                if (node.getChildText("tubeUrl") != null) {
                    m.setTubeUrl(node.getChildText("tubeUrl"));
                }
                if (node.getChildText("tubeTitle") != null) {
                    m.setTubeTitle(node.getChildText("tubeTitle"));
                }
                if (node.getChildText("releaseDay") != null) {
                    m.setReleaseDay(Integer.parseInt(node.getChildText("releaseDay")));
                }
                if (node.getChildText("releaseMonth") != null) {
                    m.setReleaseMonth(Integer.parseInt(node.getChildText("releaseMonth")));
                }
                if (node.getChildText("releaseYear") != null) {
                    m.setReleaseYear(Integer.parseInt(node.getChildText("releaseYear")));
                }
                if (node.getChildText("publicdescription") != null) {
                    m.setPublicDescription(node.getChildText("publicdescription"));
                }
                if (node.getChildText("type") != null) {
                    m.setType(MovieType.valueOf(node.getChildText("type")));
                }
                if (node.getChildText("type2") != null) {
                    m.setType2(MovieType.valueOf(node.getChildText("type2")));
                }
                if (node.getChildText("type3") != null) {
                    m.setType3(MovieType.valueOf(node.getChildText("type3")));
                }
                if (node.getChildText("type4") != null) {
                    m.setType4(MovieType.valueOf(node.getChildText("type4")));
                }
                if (node.getChildText("type5") != null) {
                    m.setType5(MovieType.valueOf(node.getChildText("type5")));
                }
                if (node.getChildText("type6") != null) {
                    m.setType6(MovieType.valueOf(node.getChildText("type6")));
                }
                List movietypes = node.getChildren("movietypesRoot");
                for (int mtI = 0; mtI < movietypes.size(); ++mtI) {
                    Element movietypeNode = (Element)movietypes.get(mtI);
                    List movietypesList = movietypeNode.getChildren("movietype");
                    for (int mtJ = 0; mtJ < movietypesList.size(); ++mtJ) {
                        List content = ((Element)movietypesList.get(mtJ)).getContent();
                        if (content.size() != 1) continue;
                        m.getMovietypes().add(MovieType.valueOf(((Text)content.get(0)).getText()));
                    }
                }
                if (node.getChildText("spokenLanguage") != null) {
                    m.setLanguageSpoken(Language.valueOf(node.getChildText("spokenLanguage")));
                }
                if (node.getChildText("spokenSubtitles") != null) {
                    m.setLanguageSubtitles(Language.valueOf(node.getChildText("spokenSubtitles")));
                }
                if (node.getChildText("synchronizedAudio") != null && "true".equalsIgnoreCase(node.getChildText("synchronizedAudio"))) {
                    m.setSynchronizedAudio(true);
                }
                if (node.getChildText("censored") != null && "true".equalsIgnoreCase(node.getChildText("censored"))) {
                    m.setCensored(true);
                }
                if (node.getChildText("decensored") != null && "true".equalsIgnoreCase(node.getChildText("decensored"))) {
                    m.setDecensored(true);
                }
                if (node.getChildText("vertical") != null && "true".equalsIgnoreCase(node.getChildText("vertical"))) {
                    m.setVertical(true);
                }
                if (node.getChildText("mirrored") != null && "true".equalsIgnoreCase(node.getChildText("mirrored"))) {
                    m.setMirrored(true);
                }
                if (node.getChildText("snippet") != null && "true".equalsIgnoreCase(node.getChildText("snippet"))) {
                    m.setSnippet(true);
                }
                if (node.getChildText("interactive") != null && "true".equalsIgnoreCase(node.getChildText("interactive"))) {
                    m.setInteractive(true);
                }
                if (node.getChildText("threed") != null && "true".equalsIgnoreCase(node.getChildText("threed"))) {
                    m.setThreeD(true);
                }
                if (node.getChildText("vr") != null && "true".equalsIgnoreCase(node.getChildText("vr"))) {
                    m.setVr(true);
                }
                if (node.getChildText("minutesOfSilence") != null) {
                    m.setMinutesOfSilence(node.getChildText("minutesOfSilence"));
                }
                if (node.getChildText("shotInCountry") != null) {
                    m.setShotInCountry(Nationality.getEnum(node.getChildText("shotInCountry")));
                }
                if (node.getChildText("privateDescription") != null) {
                    m.setPrivateDescription(node.getChildText("privateDescription"));
                }
                if (node.getChildText("rating") != null) {
                    m.setRating(Integer.valueOf(node.getChildText("rating")));
                }
                if (node.getChildText("ratingDifferentiator") != null) {
                    m.setRatingDifferentiator(Differentiator.valueOf(node.getChildText("ratingDifferentiator")));
                }
                List personsList = node.getChildren("persons");
                for (int j = 0; j < personsList.size(); ++j) {
                    Element personsNode = (Element)personsList.get(j);
                    List personList = personsNode.getChildren("person");
                    for (int k = 0; k < personList.size(); ++k) {
                        Person p = new Person();
                        Element personNode = (Element)personList.get(k);
                        this.readPersonNode(p, personNode);
                        this.readPersonBodyRootNode(personNode, true, p);
                        this.readOtherNodes(personNode, p, persons);
                        persons.add(p);
                    }
                }
                List studioList = node.getChildren("studio");
                for (int studioI = 0; studioI < studioList.size(); ++studioI) {
                    Element studioNode = (Element)studioList.get(studioI);
                    Studio s = this.readStudioNode(studioNode);
                    m.setStudio(s);
                }
                List sceneNodesList = node.getChildren("scenes");
                for (int scenesI = 0; scenesI < sceneNodesList.size(); ++scenesI) {
                    Element scenesNode = (Element)sceneNodesList.get(scenesI);
                    List sceneList = scenesNode.getChildren("scene");
                    for (int scenesJ = 0; scenesJ < sceneList.size(); ++scenesJ) {
                        Scene s = new Scene();
                        s.setDateOfCreation(LocalDateTime.now());
                        s.setMovie(m);
                        Element sceneNode = (Element)sceneList.get(scenesJ);
                        s.setPos(Integer.parseInt(sceneNode.getChildText("pos")));
                        if ("true".equalsIgnoreCase(sceneNode.getChildText("behindTheScenes"))) {
                            s.setBehindTheScenes(true);
                        }
                        if ("true".equalsIgnoreCase(sceneNode.getChildText("bonus"))) {
                            s.setBonusScene(true);
                        }
                        if ("true".equalsIgnoreCase(sceneNode.getChildText("summary"))) {
                            s.setSummary(true);
                        }
                        if ("true".equalsIgnoreCase(sceneNode.getChildText("intercut"))) {
                            s.setIntercut(true);
                        }
                        if ("true".equalsIgnoreCase(sceneNode.getChildText("incomplete"))) {
                            s.setIncomplete(true);
                        }
                        if ("true".equalsIgnoreCase(sceneNode.getChildText("condomsUsed"))) {
                            s.setCondomsUsed(true);
                        }
                        if (sceneNode.getChildText("chapter") != null) {
                            s.setChapter(Integer.parseInt(sceneNode.getChildText("chapter")));
                        }
                        if (sceneNode.getChildText("title") != null) {
                            s.setChapter(Integer.parseInt(sceneNode.getChildText("title")));
                        }
                        if (sceneNode.getChildText("shootDay") != null) {
                            s.setDateOfShootDay(Integer.parseInt(sceneNode.getChildText("shootDay")));
                        }
                        if (sceneNode.getChildText("shootMonth") != null) {
                            s.setDateOfShootMonth(Integer.parseInt(sceneNode.getChildText("shootMonth")));
                        }
                        if (sceneNode.getChildText("shootYear") != null) {
                            s.setDateOfShootYear(Integer.parseInt(sceneNode.getChildText("shootYear")));
                        }
                        if (sceneNode.getChildText("location1") != null) {
                            s.setLocation1(Location.valueOf(sceneNode.getChildText("location1")));
                        }
                        if (sceneNode.getChildText("location2") != null) {
                            s.setLocation2(Location.valueOf(sceneNode.getChildText("location2")));
                        }
                        if (sceneNode.getChildText("location3") != null) {
                            s.setLocation3(Location.valueOf(sceneNode.getChildText("location3")));
                        }
                        if (sceneNode.getChildText("partnerCompatibility") != null) {
                            s.setPartnerCompatibility(PartnerCompatibility.valueOf(sceneNode.getChildText("partnerCompatibility")));
                        }
                        if (sceneNode.getChildText("type") != null) {
                            s.setType(MovieType.valueOf(sceneNode.getChildText("type")));
                        }
                        if (sceneNode.getChildText("type2") != null) {
                            s.setType2(MovieType.valueOf(sceneNode.getChildText("type2")));
                        }
                        if (sceneNode.getChildText("type3") != null) {
                            s.setType3(MovieType.valueOf(sceneNode.getChildText("type3")));
                        }
                        if (sceneNode.getChildText("type4") != null) {
                            s.setType4(MovieType.valueOf(sceneNode.getChildText("type4")));
                        }
                        if (sceneNode.getChildText("type5") != null) {
                            s.setType5(MovieType.valueOf(sceneNode.getChildText("type5")));
                        }
                        if (sceneNode.getChildText("type6") != null) {
                            s.setType6(MovieType.valueOf(sceneNode.getChildText("type6")));
                        }
                        if (sceneNode.getChildText("soundQuality") != null) {
                            s.setSoundQuality(Quality.valueOf(sceneNode.getChildText("soundQuality")));
                        }
                        if (sceneNode.getChildText("videoQuality") != null) {
                            s.setVideoQuality(Quality.valueOf(sceneNode.getChildText("videoQuality")));
                        }
                        if (sceneNode.getChildText("privateDescription") != null) {
                            s.setPrivateDescription(sceneNode.getChildText("privateDescription"));
                        }
                        if (sceneNode.getChildText("publicdescription") != null) {
                            s.setPublicDescription(sceneNode.getChildText("publicdescription"));
                        }
                        if (sceneNode.getChildText("shotInCountry") != null) {
                            s.setShotInCountry(Nationality.getEnum(sceneNode.getChildText("shotInCountry")));
                        }
                        s.setStartTime(Integer.parseInt(sceneNode.getChildText("starttime")));
                        s.setEndTime(Integer.parseInt(sceneNode.getChildText("endtime")));
                        List sceneStartMediumChildren = sceneNode.getChildren("startMedium");
                        LOG.info("start medium list size " + sceneStartMediumChildren.size());
                        for (int sm = 0; sm < sceneStartMediumChildren.size(); ++sm) {
                            Element smNode = (Element)sceneStartMediumChildren.get(sm);
                            if (smNode.getChild("medium").getChildText("hash") == null) continue;
                            LOG.info("hash: " + smNode.getChild("medium").getChildText("hash"));
                            MediumFile mediumFromDb = this.db.getMediumFile(smNode.getChild("medium").getChildText("hash"), true);
                            s.setStartMedium(mediumFromDb);
                        }
                        List sceneEndMediumChildren = sceneNode.getChildren("endMedium");
                        LOG.info("end medium list size " + sceneStartMediumChildren.size());
                        for (int sm = 0; sm < sceneEndMediumChildren.size(); ++sm) {
                            Element smNode = (Element)sceneEndMediumChildren.get(sm);
                            if (smNode.getChild("medium").getChildText("hash") == null) continue;
                            LOG.info("hash: " + smNode.getChild("medium").getChildText("hash"));
                            MediumFile mediumFromDb = this.db.getMediumFile(smNode.getChild("medium").getChildText("hash"), true);
                            s.setEndMedium(mediumFromDb);
                        }
                        if (sceneNode.getChildText("publicDescription") != null) {
                            s.setPublicDescription(sceneNode.getChildText("publicDescription"));
                        }
                        List scenedetailsList = sceneNode.getChildren("scenedetails");
                        for (int scenedetailsI = 0; scenedetailsI < scenedetailsList.size(); ++scenedetailsI) {
                            Element scenedetailsNode = (Element)scenedetailsList.get(scenedetailsI);
                            List scenedetailList = scenedetailsNode.getChildren("scenedetail");
                            for (int scenedetailsJ = 0; scenedetailsJ < scenedetailList.size(); ++scenedetailsJ) {
                                SceneDetails sd = this.readInSceneDetails(scenedetailList, scenedetailsJ, s);
                                s.getDetails().add(sd);
                            }
                        }
                        List bookmarksList = sceneNode.getChildren("bookmarks");
                        for (int bookmarksI = 0; bookmarksI < bookmarksList.size(); ++bookmarksI) {
                            this.readInBookmark(bookmarksList, bookmarksI, s);
                        }
                        m.getScenes().add(s);
                    }
                }
                List bookmarkNodesList = node.getChildren("bookmarks");
                for (int bookmarksI = 0; bookmarksI < bookmarkNodesList.size(); ++bookmarksI) {
                    Element bookmarksNode = (Element)bookmarkNodesList.get(bookmarksI);
                    List bookmarkList = bookmarksNode.getChildren("bookmark");
                    for (int bookmarksJ = 0; bookmarksJ < bookmarkList.size(); ++bookmarksJ) {
                        Bookmark b = new Bookmark();
                        b.setDateOfCreation(LocalDateTime.now());
                        b.setMovie(m);
                        Element bookmarkNode = (Element)bookmarkList.get(bookmarksJ);
                        b.setBookmarkTitle(bookmarkNode.getChildText("bookmarktitle"));
                        if (bookmarkNode.getChildText("chapter") != null) {
                            b.setChapter(Integer.parseInt(bookmarkNode.getChildText("chapter")));
                        }
                        if (bookmarkNode.getChildText("title") != null) {
                            b.setTitle(Integer.parseInt(bookmarkNode.getChildText("title")));
                        }
                        if (bookmarkNode.getChildText("starttime") != null) {
                            b.setStartTime(Integer.parseInt(bookmarkNode.getChildText("starttime")));
                        }
                        if (bookmarkNode.getChildText("endtime") != null) {
                            b.setEndTime(Integer.parseInt(bookmarkNode.getChildText("endtime")));
                        }
                        if (bookmarkNode.getChildText("looping") != null && "true".equalsIgnoreCase(bookmarkNode.getChildText("looping"))) {
                            b.setLooping(true);
                        }
                        if (bookmarkNode.getChildText("favorite") != null && "true".equalsIgnoreCase(bookmarkNode.getChildText("favorite"))) {
                            b.setFavorite(true);
                        }
                        if (bookmarkNode.getChildText("position") != null) {
                            b.setPosition(Integer.parseInt(bookmarkNode.getChildText("position")));
                        }
                        if (bookmarkNode.getChildText("publicdescription") != null) {
                            b.setPublicDescription(bookmarkNode.getChildText("publicdescription"));
                        }
                        if (bookmarkNode.getChildText("type") != null) {
                            b.setType(BookmarkType.valueOf(bookmarkNode.getChildText("type")));
                        }
                        m.getBookmarks(true).add(b);
                    }
                }
                List mediumFileNodesList = node.getChildren("mediumfiles");
                for (int mfsI = 0; mfsI < mediumFileNodesList.size(); ++mfsI) {
                    Element mediumfileNode = (Element)mediumFileNodesList.get(mfsI);
                    List mediumfileList = mediumfileNode.getChildren("mediumfile");
                    for (int mediumfileJ = 0; mediumfileJ < mediumfileList.size(); ++mediumfileJ) {
                        MediumFile mf = new MediumFile();
                        mf.setDateOfCreation(LocalDateTime.now());
                        mf.setMovie(m);
                        Element mfNode = (Element)mediumfileList.get(mediumfileJ);
                        try {
                            mf.setHeight(Integer.valueOf(mfNode.getChildText("height")));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            mf.setWidth(Integer.valueOf(mfNode.getChildText("width")));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            mf.setDuration(Integer.valueOf(mfNode.getChildText("duration")));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            mf.setPart(Integer.valueOf(mfNode.getChildText("part")));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                result = m;
                LOG.fine("Imported movie: " + String.valueOf(m));
            }
        }
        catch (IOException io) {
            LOG.severe(io.getMessage());
        }
        catch (JDOMException jdomex) {
            LOG.severe(jdomex.getMessage());
        }
        return result;
    }

    private void readInBookmark(List bookmarksList, int bookmarksI, Scene s) throws NumberFormatException {
        Element bookmarksNode = (Element)bookmarksList.get(bookmarksI);
        List bookmarkList = bookmarksNode.getChildren("bookmark");
        for (int bookmarksJ = 0; bookmarksJ < bookmarkList.size(); ++bookmarksJ) {
            Person findThirdPassivePerson;
            Person findSecondPassivePerson;
            Person findFirstPassivePerson;
            Person findThirdPerson;
            Person findSecondPerson;
            Person findFirstPerson;
            Bookmark bookmark = new Bookmark();
            bookmark.setDateOfCreation(LocalDateTime.now());
            bookmark.setScene(s);
            Element bookmarkNode = (Element)bookmarkList.get(bookmarksJ);
            bookmark.setBookmarkTitle(bookmarkNode.getChildText("bookmarktitle"));
            if (bookmarkNode.getChildText("chapter") != null) {
                bookmark.setChapter(Integer.parseInt(bookmarkNode.getChildText("chapter")));
            }
            if (bookmarkNode.getChildText("title") != null) {
                bookmark.setTitle(Integer.parseInt(bookmarkNode.getChildText("title")));
            }
            if (bookmarkNode.getChildText("starttime") != null) {
                bookmark.setStartTime(Integer.parseInt(bookmarkNode.getChildText("starttime")));
            }
            if (bookmarkNode.getChildText("endtime") != null) {
                bookmark.setEndTime(Integer.parseInt(bookmarkNode.getChildText("endtime")));
            }
            if (bookmarkNode.getChildText("looping") != null && "true".equalsIgnoreCase(bookmarkNode.getChildText("looping"))) {
                bookmark.setLooping(true);
            }
            if (bookmarkNode.getChildText("favorite") != null && "true".equalsIgnoreCase(bookmarkNode.getChildText("favorite"))) {
                bookmark.setFavorite(true);
            }
            if (bookmarkNode.getChildText("position") != null) {
                bookmark.setPosition(Integer.parseInt(bookmarkNode.getChildText("position")));
            }
            if (bookmarkNode.getChildText("publicdescription") != null) {
                bookmark.setPublicDescription(bookmarkNode.getChildText("publicdescription"));
            }
            if (bookmarkNode.getChildText("type") != null) {
                bookmark.setType(BookmarkType.valueOf(bookmarkNode.getChildText("type")));
            }
            if (bookmarkNode.getChildText("primaryPerson") != null && (findFirstPerson = (Person)this.db.getEntityService().find(QPerson.person).filter(f -> f.name.eq((Object)bookmarkNode.getChildText("primaryPerson"))).findFirst()) != null) {
                bookmark.setPrimaryPerson(findFirstPerson);
            }
            if (bookmarkNode.getChildText("primaryPerson2") != null && (findSecondPerson = (Person)this.db.getEntityService().find(QPerson.person).filter(f -> f.name.eq((Object)bookmarkNode.getChildText("primaryPerson2"))).findFirst()) != null) {
                bookmark.setPrimaryPerson2(findSecondPerson);
            }
            if (bookmarkNode.getChildText("primaryPerson3") != null && (findThirdPerson = (Person)this.db.getEntityService().find(QPerson.person).filter(f -> f.name.eq((Object)bookmarkNode.getChildText("primaryPerson3"))).findFirst()) != null) {
                bookmark.setPrimaryPerson3(findThirdPerson);
            }
            if (bookmarkNode.getChildText("passivePerson1") != null && (findFirstPassivePerson = (Person)this.db.getEntityService().find(QPerson.person).filter(f -> f.name.eq((Object)bookmarkNode.getChildText("passivePerson1"))).findFirst()) != null) {
                bookmark.setPassivePerson1(findFirstPassivePerson);
            }
            if (bookmarkNode.getChildText("passivePerson2") != null && (findSecondPassivePerson = (Person)this.db.getEntityService().find(QPerson.person).filter(f -> f.name.eq((Object)bookmarkNode.getChildText("passivePerson2"))).findFirst()) != null) {
                bookmark.setPassivePerson2(findSecondPassivePerson);
            }
            if (bookmarkNode.getChildText("passivePerson3") != null && (findThirdPassivePerson = (Person)this.db.getEntityService().find(QPerson.person).filter(f -> f.name.eq((Object)bookmarkNode.getChildText("passivePerson3"))).findFirst()) != null) {
                bookmark.setPassivePerson3(findThirdPassivePerson);
            }
            if (bookmarkNode.getChildText("roughnessActive1") != null) {
                bookmark.setRoughness(Quantity.valueOf(bookmarkNode.getChildText("roughnessActive1")));
            }
            if (bookmarkNode.getChildText("roughnessActiveDifferentiator1") != null) {
                bookmark.setRoughnessDifferentiator(Differentiator.valueOf(bookmarkNode.getChildText("roughnessActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("roughnessActive2") != null) {
                bookmark.setRoughnessActive2(Quantity.valueOf(bookmarkNode.getChildText("roughnessActive2")));
            }
            if (bookmarkNode.getChildText("roughnessActiveDifferentiator2") != null) {
                bookmark.setRoughnessActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("roughnessActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("roughnessActive3") != null) {
                bookmark.setRoughnessActive2(Quantity.valueOf(bookmarkNode.getChildText("roughnessActive3")));
            }
            if (bookmarkNode.getChildText("roughnessActiveDifferentiator3") != null) {
                bookmark.setRoughnessActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("roughnessActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("roughnessPassive1") != null) {
                bookmark.setRoughness(Quantity.valueOf(bookmarkNode.getChildText("roughnessPassive1")));
            }
            if (bookmarkNode.getChildText("roughnessPassiveDifferentiator1") != null) {
                bookmark.setRoughnessDifferentiator(Differentiator.valueOf(bookmarkNode.getChildText("roughnessPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("roughnessPassive2") != null) {
                bookmark.setRoughnessPassive2(Quantity.valueOf(bookmarkNode.getChildText("roughnessPassive2")));
            }
            if (bookmarkNode.getChildText("roughnessPassiveDifferentiator2") != null) {
                bookmark.setRoughnessPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("roughnessPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("roughnessPassive3") != null) {
                bookmark.setRoughnessPassive2(Quantity.valueOf(bookmarkNode.getChildText("roughnessPassive3")));
            }
            if (bookmarkNode.getChildText("roughnessPassiveDifferentiator3") != null) {
                bookmark.setRoughnessPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("roughnessPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("intensityActive1") != null) {
                bookmark.setIntensity(Intensity.valueOf(bookmarkNode.getChildText("intensityActive1")));
            }
            if (bookmarkNode.getChildText("intensityActiveDifferentiator1") != null) {
                bookmark.setIntensityDifferentiator(Differentiator.valueOf(bookmarkNode.getChildText("intensityActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("intensityActive2") != null) {
                bookmark.setIntensityActive2(Intensity.valueOf(bookmarkNode.getChildText("intensityActive2")));
            }
            if (bookmarkNode.getChildText("intensityActiveDifferentiator2") != null) {
                bookmark.setIntensityActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("intensityActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("intensityActive3") != null) {
                bookmark.setIntensityActive2(Intensity.valueOf(bookmarkNode.getChildText("intensityActive3")));
            }
            if (bookmarkNode.getChildText("intensityActiveDifferentiator3") != null) {
                bookmark.setIntensityActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("intensityActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("intensityPassive1") != null) {
                bookmark.setIntensity(Intensity.valueOf(bookmarkNode.getChildText("intensityPassive1")));
            }
            if (bookmarkNode.getChildText("intensityPassiveDifferentiator1") != null) {
                bookmark.setIntensityDifferentiator(Differentiator.valueOf(bookmarkNode.getChildText("intensityPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("intensityPassive2") != null) {
                bookmark.setIntensityPassive2(Intensity.valueOf(bookmarkNode.getChildText("intensityPassive2")));
            }
            if (bookmarkNode.getChildText("intensityPassiveDifferentiator2") != null) {
                bookmark.setIntensityPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("intensityPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("intensityPassive3") != null) {
                bookmark.setIntensityPassive2(Intensity.valueOf(bookmarkNode.getChildText("intensityPassive3")));
            }
            if (bookmarkNode.getChildText("intensityPassiveDifferentiator3") != null) {
                bookmark.setIntensityPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("intensityPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("speedActive1") != null) {
                bookmark.setSpeed(Speed.valueOf(bookmarkNode.getChildText("speedActive1")));
            }
            if (bookmarkNode.getChildText("speedActiveDifferentiator1") != null) {
                bookmark.setSpeedDifferentiator(Differentiator.valueOf(bookmarkNode.getChildText("speedActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("speedActive2") != null) {
                bookmark.setSpeedActive2(Speed.valueOf(bookmarkNode.getChildText("speedActive2")));
            }
            if (bookmarkNode.getChildText("speedActiveDifferentiator2") != null) {
                bookmark.setSpeedActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("speedActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("speedActive3") != null) {
                bookmark.setSpeedActive2(Speed.valueOf(bookmarkNode.getChildText("speedActive3")));
            }
            if (bookmarkNode.getChildText("speedActiveDifferentiator3") != null) {
                bookmark.setSpeedActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("speedActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("speedPassive1") != null) {
                bookmark.setSpeed(Speed.valueOf(bookmarkNode.getChildText("speedPassive1")));
            }
            if (bookmarkNode.getChildText("speedPassiveDifferentiator1") != null) {
                bookmark.setSpeedDifferentiator(Differentiator.valueOf(bookmarkNode.getChildText("speedPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("speedPassive2") != null) {
                bookmark.setSpeedPassive2(Speed.valueOf(bookmarkNode.getChildText("speedPassive2")));
            }
            if (bookmarkNode.getChildText("speedPassiveDifferentiator2") != null) {
                bookmark.setSpeedPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("speedPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("speedPassive3") != null) {
                bookmark.setSpeedPassive2(Speed.valueOf(bookmarkNode.getChildText("speedPassive3")));
            }
            if (bookmarkNode.getChildText("speedPassiveDifferentiator3") != null) {
                bookmark.setSpeedPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("speedPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("positionActive1") != null) {
                bookmark.setPositionActive1(Position.valueOf(bookmarkNode.getChildText("positionActive1")));
            }
            if (bookmarkNode.getChildText("positionActive2") != null) {
                bookmark.setPositionActive2(Position.valueOf(bookmarkNode.getChildText("positionActive2")));
            }
            if (bookmarkNode.getChildText("positionActive3") != null) {
                bookmark.setPositionActive3(Position.valueOf(bookmarkNode.getChildText("positionActive3")));
            }
            if (bookmarkNode.getChildText("positionPassive1") != null) {
                bookmark.setPositionPassive1(Position.valueOf(bookmarkNode.getChildText("positionPassive1")));
            }
            if (bookmarkNode.getChildText("positionPassive2") != null) {
                bookmark.setPositionPassive2(Position.valueOf(bookmarkNode.getChildText("positionPassive2")));
            }
            if (bookmarkNode.getChildText("positionPassive3") != null) {
                bookmark.setPositionPassive3(Position.valueOf(bookmarkNode.getChildText("positionPassive3")));
            }
            if (bookmarkNode.getChildText("painActive1") != null) {
                bookmark.setPain(Quantity.valueOf(bookmarkNode.getChildText("painActive1")));
            }
            if (bookmarkNode.getChildText("painActiveDifferentiator1") != null) {
                bookmark.setPainDifferentiator(Differentiator.valueOf(bookmarkNode.getChildText("painActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("painActive2") != null) {
                bookmark.setPainActive2(Quantity.valueOf(bookmarkNode.getChildText("painActive2")));
            }
            if (bookmarkNode.getChildText("painActiveDifferentiator2") != null) {
                bookmark.setPainActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("painActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("painActive3") != null) {
                bookmark.setPainActive2(Quantity.valueOf(bookmarkNode.getChildText("painActive3")));
            }
            if (bookmarkNode.getChildText("painActiveDifferentiator3") != null) {
                bookmark.setPainActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("painActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("painPassive1") != null) {
                bookmark.setPain(Quantity.valueOf(bookmarkNode.getChildText("painPassive1")));
            }
            if (bookmarkNode.getChildText("painPassiveDifferentiator1") != null) {
                bookmark.setPainDifferentiator(Differentiator.valueOf(bookmarkNode.getChildText("painPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("painPassive2") != null) {
                bookmark.setPainPassive2(Quantity.valueOf(bookmarkNode.getChildText("painPassive2")));
            }
            if (bookmarkNode.getChildText("painPassiveDifferentiator2") != null) {
                bookmark.setPainPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("painPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("painPassive3") != null) {
                bookmark.setPainPassive2(Quantity.valueOf(bookmarkNode.getChildText("painPassive3")));
            }
            if (bookmarkNode.getChildText("painPassiveDifferentiator3") != null) {
                bookmark.setPainPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("painPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("disgustedActive1") != null) {
                bookmark.setDisgustedActive1(Quantity.valueOf(bookmarkNode.getChildText("disgustedActive1")));
            }
            if (bookmarkNode.getChildText("disgustedActiveDifferentiator1") != null) {
                bookmark.setDisgustedActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("disgustedActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("disgustedActive2") != null) {
                bookmark.setDisgustedActive2(Quantity.valueOf(bookmarkNode.getChildText("disgustedActive2")));
            }
            if (bookmarkNode.getChildText("disgustedActiveDifferentiator2") != null) {
                bookmark.setDisgustedActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("disgustedActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("disgustedActive3") != null) {
                bookmark.setDisgustedActive2(Quantity.valueOf(bookmarkNode.getChildText("disgustedActive3")));
            }
            if (bookmarkNode.getChildText("disgustedActiveDifferentiator3") != null) {
                bookmark.setDisgustedActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("disgustedActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("disgustedPassive1") != null) {
                bookmark.setDisgustedPassive1(Quantity.valueOf(bookmarkNode.getChildText("disgustedPassive1")));
            }
            if (bookmarkNode.getChildText("disgustedPassiveDifferentiator1") != null) {
                bookmark.setDisgustedPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("disgustedPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("disgustedPassive2") != null) {
                bookmark.setDisgustedPassive2(Quantity.valueOf(bookmarkNode.getChildText("disgustedPassive2")));
            }
            if (bookmarkNode.getChildText("disgustedPassiveDifferentiator2") != null) {
                bookmark.setDisgustedPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("disgustedPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("disgustedPassive3") != null) {
                bookmark.setDisgustedPassive2(Quantity.valueOf(bookmarkNode.getChildText("disgustedPassive3")));
            }
            if (bookmarkNode.getChildText("disgustedPassiveDifferentiator3") != null) {
                bookmark.setDisgustedPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("disgustedPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("enjoymentActive1") != null) {
                bookmark.setEnjoymentActive1(Quantity.valueOf(bookmarkNode.getChildText("enjoymentActive1")));
            }
            if (bookmarkNode.getChildText("enjoymentActiveDifferentiator1") != null) {
                bookmark.setEnjoymentActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("enjoymentActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("enjoymentActive2") != null) {
                bookmark.setEnjoymentActive2(Quantity.valueOf(bookmarkNode.getChildText("enjoymentActive2")));
            }
            if (bookmarkNode.getChildText("enjoymentActiveDifferentiator2") != null) {
                bookmark.setEnjoymentActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("enjoymentActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("enjoymentActive3") != null) {
                bookmark.setEnjoymentActive2(Quantity.valueOf(bookmarkNode.getChildText("enjoymentActive3")));
            }
            if (bookmarkNode.getChildText("enjoymentActiveDifferentiator3") != null) {
                bookmark.setEnjoymentActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("enjoymentActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("enjoymentPassive1") != null) {
                bookmark.setEnjoymentPassive1(Quantity.valueOf(bookmarkNode.getChildText("enjoymentPassive1")));
            }
            if (bookmarkNode.getChildText("enjoymentPassiveDifferentiator1") != null) {
                bookmark.setEnjoymentPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("enjoymentPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("enjoymentPassive2") != null) {
                bookmark.setEnjoymentPassive2(Quantity.valueOf(bookmarkNode.getChildText("enjoymentPassive2")));
            }
            if (bookmarkNode.getChildText("enjoymentPassiveDifferentiator2") != null) {
                bookmark.setEnjoymentPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("enjoymentPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("enjoymentPassive3") != null) {
                bookmark.setEnjoymentPassive2(Quantity.valueOf(bookmarkNode.getChildText("enjoymentPassive3")));
            }
            if (bookmarkNode.getChildText("enjoymentPassiveDifferentiator3") != null) {
                bookmark.setEnjoymentPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("enjoymentPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("moaningActive1") != null) {
                bookmark.setMoaningActive1(Quantity.valueOf(bookmarkNode.getChildText("moaningActive1")));
            }
            if (bookmarkNode.getChildText("moaningActiveDifferentiator1") != null) {
                bookmark.setMoaningActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("moaningActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("moaningActive2") != null) {
                bookmark.setMoaningActive2(Quantity.valueOf(bookmarkNode.getChildText("moaningActive2")));
            }
            if (bookmarkNode.getChildText("moaningActiveDifferentiator2") != null) {
                bookmark.setMoaningActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("moaningActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("moaningActive3") != null) {
                bookmark.setMoaningActive2(Quantity.valueOf(bookmarkNode.getChildText("moaningActive3")));
            }
            if (bookmarkNode.getChildText("moaningActiveDifferentiator3") != null) {
                bookmark.setMoaningActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("moaningActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("moaningPassive1") != null) {
                bookmark.setMoaningPassive1(Quantity.valueOf(bookmarkNode.getChildText("moaningPassive1")));
            }
            if (bookmarkNode.getChildText("moaningPassiveDifferentiator1") != null) {
                bookmark.setMoaningPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("moaningPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("moaningPassive2") != null) {
                bookmark.setMoaningPassive2(Quantity.valueOf(bookmarkNode.getChildText("moaningPassive2")));
            }
            if (bookmarkNode.getChildText("moaningPassiveDifferentiator2") != null) {
                bookmark.setMoaningPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("moaningPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("moaningPassive3") != null) {
                bookmark.setMoaningPassive2(Quantity.valueOf(bookmarkNode.getChildText("moaningPassive3")));
            }
            if (bookmarkNode.getChildText("moaningPassiveDifferentiator3") != null) {
                bookmark.setMoaningPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("moaningPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("screamingActive1") != null) {
                bookmark.setScreamingActive1(Quantity.valueOf(bookmarkNode.getChildText("screamingActive1")));
            }
            if (bookmarkNode.getChildText("screamingActiveDifferentiator1") != null) {
                bookmark.setScreamingActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("screamingActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("screamingActive2") != null) {
                bookmark.setScreamingActive2(Quantity.valueOf(bookmarkNode.getChildText("screamingActive2")));
            }
            if (bookmarkNode.getChildText("screamingActiveDifferentiator2") != null) {
                bookmark.setScreamingActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("screamingActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("screamingActive3") != null) {
                bookmark.setScreamingActive2(Quantity.valueOf(bookmarkNode.getChildText("screamingActive3")));
            }
            if (bookmarkNode.getChildText("screamingActiveDifferentiator3") != null) {
                bookmark.setScreamingActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("screamingActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("screamingPassive1") != null) {
                bookmark.setScreamingPassive1(Quantity.valueOf(bookmarkNode.getChildText("screamingPassive1")));
            }
            if (bookmarkNode.getChildText("screamingPassiveDifferentiator1") != null) {
                bookmark.setScreamingPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("screamingPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("screamingPassive2") != null) {
                bookmark.setScreamingPassive2(Quantity.valueOf(bookmarkNode.getChildText("screamingPassive2")));
            }
            if (bookmarkNode.getChildText("screamingPassiveDifferentiator2") != null) {
                bookmark.setScreamingPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("screamingPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("screamingPassive3") != null) {
                bookmark.setScreamingPassive2(Quantity.valueOf(bookmarkNode.getChildText("screamingPassive3")));
            }
            if (bookmarkNode.getChildText("screamingPassiveDifferentiator3") != null) {
                bookmark.setScreamingPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("screamingPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("titsBouncingActive1") != null) {
                bookmark.setTitsBouncingActive1(Quantity.valueOf(bookmarkNode.getChildText("titsBouncingActive1")));
            }
            if (bookmarkNode.getChildText("titsBouncingActiveDifferentiator1") != null) {
                bookmark.setTitsBouncingActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("titsBouncingActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("titsBouncingActive2") != null) {
                bookmark.setTitsBouncingActive2(Quantity.valueOf(bookmarkNode.getChildText("titsBouncingActive2")));
            }
            if (bookmarkNode.getChildText("titsBouncingActiveDifferentiator2") != null) {
                bookmark.setTitsBouncingActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("titsBouncingActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("titsBouncingActive3") != null) {
                bookmark.setTitsBouncingActive2(Quantity.valueOf(bookmarkNode.getChildText("titsBouncingActive3")));
            }
            if (bookmarkNode.getChildText("titsBouncingActiveDifferentiator3") != null) {
                bookmark.setTitsBouncingActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("titsBouncingActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("titsBouncingPassive1") != null) {
                bookmark.setTitsBouncingPassive1(Quantity.valueOf(bookmarkNode.getChildText("titsBouncingPassive1")));
            }
            if (bookmarkNode.getChildText("titsBouncingPassiveDifferentiator1") != null) {
                bookmark.setTitsBouncingPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("titsBouncingPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("titsBouncingPassive2") != null) {
                bookmark.setTitsBouncingPassive2(Quantity.valueOf(bookmarkNode.getChildText("titsBouncingPassive2")));
            }
            if (bookmarkNode.getChildText("titsBouncingPassiveDifferentiator2") != null) {
                bookmark.setTitsBouncingPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("titsBouncingPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("titsBouncingPassive3") != null) {
                bookmark.setTitsBouncingPassive2(Quantity.valueOf(bookmarkNode.getChildText("titsBouncingPassive3")));
            }
            if (bookmarkNode.getChildText("titsBouncingPassiveDifferentiator3") != null) {
                bookmark.setTitsBouncingPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("titsBouncingPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("dirtyTalkActive1") != null) {
                bookmark.setDirtyTalkActive1(Quantity.valueOf(bookmarkNode.getChildText("dirtyTalkActive1")));
            }
            if (bookmarkNode.getChildText("dirtyTalkActiveDifferentiator1") != null) {
                bookmark.setDirtyTalkActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("dirtyTalkActive2") != null) {
                bookmark.setDirtyTalkActive2(Quantity.valueOf(bookmarkNode.getChildText("dirtyTalkActive2")));
            }
            if (bookmarkNode.getChildText("dirtyTalkActiveDifferentiator2") != null) {
                bookmark.setDirtyTalkActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("dirtyTalkActive3") != null) {
                bookmark.setDirtyTalkActive2(Quantity.valueOf(bookmarkNode.getChildText("dirtyTalkActive3")));
            }
            if (bookmarkNode.getChildText("dirtyTalkActiveDifferentiator3") != null) {
                bookmark.setDirtyTalkActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("dirtyTalkPassive1") != null) {
                bookmark.setDirtyTalkPassive1(Quantity.valueOf(bookmarkNode.getChildText("dirtyTalkPassive1")));
            }
            if (bookmarkNode.getChildText("dirtyTalkPassiveDifferentiator1") != null) {
                bookmark.setDirtyTalkPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("dirtyTalkPassive2") != null) {
                bookmark.setDirtyTalkPassive2(Quantity.valueOf(bookmarkNode.getChildText("dirtyTalkPassive2")));
            }
            if (bookmarkNode.getChildText("dirtyTalkPassiveDifferentiator2") != null) {
                bookmark.setDirtyTalkPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("dirtyTalkPassive3") != null) {
                bookmark.setDirtyTalkPassive2(Quantity.valueOf(bookmarkNode.getChildText("dirtyTalkPassive3")));
            }
            if (bookmarkNode.getChildText("dirtyTalkPassiveDifferentiator3") != null) {
                bookmark.setDirtyTalkPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityActive1") != null) {
                bookmark.setDirtyTalkIntensityActive1(Intensity.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityActive1")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityActiveDifferentiator1") != null) {
                bookmark.setDirtyTalkIntensityActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityActive2") != null) {
                bookmark.setDirtyTalkIntensityActive2(Intensity.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityActive2")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityActiveDifferentiator2") != null) {
                bookmark.setDirtyTalkIntensityActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityActive3") != null) {
                bookmark.setDirtyTalkIntensityActive2(Intensity.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityActive3")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityActiveDifferentiator3") != null) {
                bookmark.setDirtyTalkIntensityActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityPassive1") != null) {
                bookmark.setDirtyTalkIntensityPassive1(Intensity.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityPassive1")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityPassiveDifferentiator1") != null) {
                bookmark.setDirtyTalkIntensityPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityPassive2") != null) {
                bookmark.setDirtyTalkIntensityPassive2(Intensity.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityPassive2")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityPassiveDifferentiator2") != null) {
                bookmark.setDirtyTalkIntensityPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityPassive3") != null) {
                bookmark.setDirtyTalkIntensityPassive2(Intensity.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityPassive3")));
            }
            if (bookmarkNode.getChildText("dirtyTalkIntensityPassiveDifferentiator3") != null) {
                bookmark.setDirtyTalkIntensityPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("dirtyTalkIntensityPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("dominatingActive1") != null) {
                bookmark.setDominatingActive1(Quantity.valueOf(bookmarkNode.getChildText("dominatingActive1")));
            }
            if (bookmarkNode.getChildText("dominatingActiveDifferentiator1") != null) {
                bookmark.setDominatingActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("dominatingActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("dominatingActive2") != null) {
                bookmark.setDominatingActive2(Quantity.valueOf(bookmarkNode.getChildText("dominatingActive2")));
            }
            if (bookmarkNode.getChildText("dominatingActiveDifferentiator2") != null) {
                bookmark.setDominatingActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("dominatingActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("dominatingActive3") != null) {
                bookmark.setDominatingActive2(Quantity.valueOf(bookmarkNode.getChildText("dominatingActive3")));
            }
            if (bookmarkNode.getChildText("dominatingActiveDifferentiator3") != null) {
                bookmark.setDominatingActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("dominatingActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("dominatingPassive1") != null) {
                bookmark.setDominatingPassive1(Quantity.valueOf(bookmarkNode.getChildText("dominatingPassive1")));
            }
            if (bookmarkNode.getChildText("dominatingPassiveDifferentiator1") != null) {
                bookmark.setDominatingPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("dominatingPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("dominatingPassive2") != null) {
                bookmark.setDominatingPassive2(Quantity.valueOf(bookmarkNode.getChildText("dominatingPassive2")));
            }
            if (bookmarkNode.getChildText("dominatingPassiveDifferentiator2") != null) {
                bookmark.setDominatingPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("dominatingPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("dominatingPassive3") != null) {
                bookmark.setDominatingPassive2(Quantity.valueOf(bookmarkNode.getChildText("dominatingPassive3")));
            }
            if (bookmarkNode.getChildText("dominatingPassiveDifferentiator3") != null) {
                bookmark.setDominatingPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("dominatingPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("submissiveActive1") != null) {
                bookmark.setSubmissiveActive1(Quantity.valueOf(bookmarkNode.getChildText("submissiveActive1")));
            }
            if (bookmarkNode.getChildText("submissiveActiveDifferentiator1") != null) {
                bookmark.setSubmissiveActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("submissiveActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("submissiveActive2") != null) {
                bookmark.setSubmissiveActive2(Quantity.valueOf(bookmarkNode.getChildText("submissiveActive2")));
            }
            if (bookmarkNode.getChildText("submissiveActiveDifferentiator2") != null) {
                bookmark.setSubmissiveActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("submissiveActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("submissiveActive3") != null) {
                bookmark.setSubmissiveActive2(Quantity.valueOf(bookmarkNode.getChildText("submissiveActive3")));
            }
            if (bookmarkNode.getChildText("submissiveActiveDifferentiator3") != null) {
                bookmark.setSubmissiveActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("submissiveActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("submissivePassive1") != null) {
                bookmark.setSubmissivePassive1(Quantity.valueOf(bookmarkNode.getChildText("submissivePassive1")));
            }
            if (bookmarkNode.getChildText("submissivePassiveDifferentiator1") != null) {
                bookmark.setSubmissivePassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("submissivePassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("submissivePassive2") != null) {
                bookmark.setSubmissivePassive2(Quantity.valueOf(bookmarkNode.getChildText("submissivePassive2")));
            }
            if (bookmarkNode.getChildText("submissivePassiveDifferentiator2") != null) {
                bookmark.setSubmissivePassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("submissivePassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("submissivePassive3") != null) {
                bookmark.setSubmissivePassive2(Quantity.valueOf(bookmarkNode.getChildText("submissivePassive3")));
            }
            if (bookmarkNode.getChildText("submissivePassiveDifferentiator3") != null) {
                bookmark.setSubmissivePassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("submissivePassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("cumCoveredActive1") != null) {
                bookmark.setCumCoveredActive1(Quantity.valueOf(bookmarkNode.getChildText("cumCoveredActive1")));
            }
            if (bookmarkNode.getChildText("cumCoveredActiveDifferentiator1") != null) {
                bookmark.setCumCoveredActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("cumCoveredActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("cumCoveredActive2") != null) {
                bookmark.setCumCoveredActive2(Quantity.valueOf(bookmarkNode.getChildText("cumCoveredActive2")));
            }
            if (bookmarkNode.getChildText("cumCoveredActiveDifferentiator2") != null) {
                bookmark.setCumCoveredActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("cumCoveredActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("cumCoveredActive3") != null) {
                bookmark.setCumCoveredActive2(Quantity.valueOf(bookmarkNode.getChildText("cumCoveredActive3")));
            }
            if (bookmarkNode.getChildText("cumCoveredActiveDifferentiator3") != null) {
                bookmark.setCumCoveredActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("cumCoveredActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("cumCoveredPassive1") != null) {
                bookmark.setCumCoveredPassive1(Quantity.valueOf(bookmarkNode.getChildText("cumCoveredPassive1")));
            }
            if (bookmarkNode.getChildText("cumCoveredPassiveDifferentiator1") != null) {
                bookmark.setCumCoveredPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("cumCoveredPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("cumCoveredPassive2") != null) {
                bookmark.setCumCoveredPassive2(Quantity.valueOf(bookmarkNode.getChildText("cumCoveredPassive2")));
            }
            if (bookmarkNode.getChildText("cumCoveredPassiveDifferentiator2") != null) {
                bookmark.setCumCoveredPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("cumCoveredPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("cumCoveredPassive3") != null) {
                bookmark.setCumCoveredPassive2(Quantity.valueOf(bookmarkNode.getChildText("cumCoveredPassive3")));
            }
            if (bookmarkNode.getChildText("cumCoveredPassiveDifferentiator3") != null) {
                bookmark.setCumCoveredPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("cumCoveredPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraActive1") != null) {
                bookmark.setEyeContactWithCameraActive1(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithCameraActive1")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraActiveDifferentiator1") != null) {
                bookmark.setEyeContactWithCameraActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithCameraActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraActive2") != null) {
                bookmark.setEyeContactWithCameraActive2(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithCameraActive2")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraActiveDifferentiator2") != null) {
                bookmark.setEyeContactWithCameraActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithCameraActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraActive3") != null) {
                bookmark.setEyeContactWithCameraActive2(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithCameraActive3")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraActiveDifferentiator3") != null) {
                bookmark.setEyeContactWithCameraActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithCameraActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraPassive1") != null) {
                bookmark.setEyeContactWithCameraPassive1(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithCameraPassive1")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraPassiveDifferentiator1") != null) {
                bookmark.setEyeContactWithCameraPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithCameraPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraPassive2") != null) {
                bookmark.setEyeContactWithCameraPassive2(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithCameraPassive2")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraPassiveDifferentiator2") != null) {
                bookmark.setEyeContactWithCameraPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithCameraPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraPassive3") != null) {
                bookmark.setEyeContactWithCameraPassive2(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithCameraPassive3")));
            }
            if (bookmarkNode.getChildText("eyeContactWithCameraPassiveDifferentiator3") != null) {
                bookmark.setEyeContactWithCameraPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithCameraPassiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerActive1") != null) {
                bookmark.setEyeContactWithPartnerActive1(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerActive1")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerActiveDifferentiator1") != null) {
                bookmark.setEyeContactWithPartnerActiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerActiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerActive2") != null) {
                bookmark.setEyeContactWithPartnerActive2(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerActive2")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerActiveDifferentiator2") != null) {
                bookmark.setEyeContactWithPartnerActiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerActiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerActive3") != null) {
                bookmark.setEyeContactWithPartnerActive2(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerActive3")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerActiveDifferentiator3") != null) {
                bookmark.setEyeContactWithPartnerActiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerActiveDifferentiator3")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerPassive1") != null) {
                bookmark.setEyeContactWithPartnerPassive1(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerPassive1")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerPassiveDifferentiator1") != null) {
                bookmark.setEyeContactWithPartnerPassiveDifferentiator1(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerPassiveDifferentiator1")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerPassive2") != null) {
                bookmark.setEyeContactWithPartnerPassive2(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerPassive2")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerPassiveDifferentiator2") != null) {
                bookmark.setEyeContactWithPartnerPassiveDifferentiator2(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerPassiveDifferentiator2")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerPassive3") != null) {
                bookmark.setEyeContactWithPartnerPassive2(Quantity.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerPassive3")));
            }
            if (bookmarkNode.getChildText("eyeContactWithPartnerPassiveDifferentiator3") != null) {
                bookmark.setEyeContactWithPartnerPassiveDifferentiator3(Differentiator.valueOf(bookmarkNode.getChildText("eyeContactWithPartnerPassiveDifferentiator3")));
            }
            List toysRoot = bookmarkNode.getChildren("toysRoot");
            for (int toysI = 0; toysI < toysRoot.size(); ++toysI) {
                Element toysNode = (Element)toysRoot.get(toysI);
                List toysList = toysNode.getChildren("toys");
                for (int toysJ = 0; toysJ < toysList.size(); ++toysJ) {
                    List content = ((Element)toysList.get(toysJ)).getContent();
                    if (content.size() != 1) continue;
                    bookmark.getToys().add(Toys.valueOf(((Text)content.get(0)).getText()));
                }
            }
            List goldenshowerChildren = bookmarkNode.getChildren("goldenshower");
            for (int gs = 0; gs < goldenshowerChildren.size(); ++gs) {
                Goldenshower goldenshower = new Goldenshower();
                goldenshower.setBookmark(bookmark);
                Element gsNode = (Element)goldenshowerChildren.get(gs);
                if ("true".equalsIgnoreCase(gsNode.getChildText("dripping"))) {
                    goldenshower.setDripping(true);
                }
                if ("true".equalsIgnoreCase(gsNode.getChildText("gargle"))) {
                    goldenshower.setGargle(true);
                }
                if ("true".equalsIgnoreCase(gsNode.getChildText("recap"))) {
                    goldenshower.setRecap(true);
                }
                if ("true".equalsIgnoreCase(gsNode.getChildText("swallow"))) {
                    goldenshower.setSwallow(true);
                }
                if ("true".equalsIgnoreCase(gsNode.getChildText("swallow"))) {
                    goldenshower.setSwallow(true);
                }
                if ("true".equalsIgnoreCase(gsNode.getChildText("color"))) {
                    goldenshower.setColor(GoldenshowerColor.valueOf(gsNode.getChildText("color")));
                }
                if (!"true".equalsIgnoreCase(gsNode.getChildText("colorDifferentiator"))) continue;
                goldenshower.setColorDifferentiator(Differentiator.valueOf(gsNode.getChildText("colorDifferentiator")));
            }
            List cumshotChildren = bookmarkNode.getChildren("cumshot");
            for (int cs = 0; cs < cumshotChildren.size(); ++cs) {
                Cumshot cumshot = new Cumshot();
                cumshot.setBookmark(bookmark);
                Element csNode = (Element)cumshotChildren.get(cs);
                if ("true".equalsIgnoreCase(csNode.getChildText("cleanup"))) {
                    cumshot.setCleanup(true);
                }
                if ("true".equalsIgnoreCase(csNode.getChildText("swallow"))) {
                    cumshot.setSwallow(true);
                }
                if (csNode.getChildText("disgusted") != null) {
                    cumshot.setDisgusted(Quantity.valueOf(csNode.getChildText("disgusted")));
                }
                if (csNode.getChildText("disgustedDifferentiator") != null) {
                    cumshot.setDisgustedDifferentiator(Differentiator.valueOf(csNode.getChildText("disgustedDifferentiator")));
                }
                if (csNode.getChildText("disgusted2") != null) {
                    cumshot.setDisgusted2(Quantity.valueOf(csNode.getChildText("disgusted2")));
                }
                if (csNode.getChildText("disgustedDifferentiator2") != null) {
                    cumshot.setDisgustedDifferentiator2(Differentiator.valueOf(csNode.getChildText("disgustedDifferentiator2")));
                }
                if (csNode.getChildText("disgusted3") != null) {
                    cumshot.setDisgusted3(Quantity.valueOf(csNode.getChildText("disgusted3")));
                }
                if (csNode.getChildText("disgustedDifferentiator3") != null) {
                    cumshot.setDisgustedDifferentiator3(Differentiator.valueOf(csNode.getChildText("disgustedDifferentiator3")));
                }
                if (csNode.getChildText("enjoyment") != null) {
                    cumshot.setEnjoyment(Quantity.valueOf(csNode.getChildText("enjoyment")));
                }
                if (csNode.getChildText("enjoymentDifferentiator") != null) {
                    cumshot.setEnjoymentDifferentiator(Differentiator.valueOf(csNode.getChildText("enjoymentDifferentiator")));
                }
                if (csNode.getChildText("enjoyment2") != null) {
                    cumshot.setEnjoyment2(Quantity.valueOf(csNode.getChildText("enjoyment2")));
                }
                if (csNode.getChildText("enjoymentDifferentiator2") != null) {
                    cumshot.setEnjoymentDifferentiator2(Differentiator.valueOf(csNode.getChildText("enjoymentDifferentiator2")));
                }
                if (csNode.getChildText("enjoyment3") != null) {
                    cumshot.setEnjoyment3(Quantity.valueOf(csNode.getChildText("enjoyment3")));
                }
                if (csNode.getChildText("enjoymentDifferentiator3") != null) {
                    cumshot.setEnjoymentDifferentiator3(Differentiator.valueOf(csNode.getChildText("enjoymentDifferentiator3")));
                }
                if (csNode.getChildText("quantity") != null) {
                    cumshot.setQuantity(Quantity.valueOf(csNode.getChildText("quantity")));
                }
                if (csNode.getChildText("quantityDifferentiator") != null) {
                    cumshot.setQuantityDifferentiator(Differentiator.valueOf(csNode.getChildText("quantityDifferentiator")));
                }
                if (csNode.getChildText("position") != null) {
                    cumshot.setPosition(Position.valueOf(csNode.getChildText("position")));
                }
                if (csNode.getChildText("position2") != null) {
                    cumshot.setPosition2(Position.valueOf(csNode.getChildText("position2")));
                }
                if (csNode.getChildText("position3") != null) {
                    cumshot.setPosition3(Position.valueOf(csNode.getChildText("position3")));
                }
                bookmark.setCumshot(cumshot);
            }
            List bookmarkStartMediumChildren = bookmarkNode.getChildren("startMedium");
            for (int sm = 0; sm < bookmarkStartMediumChildren.size(); ++sm) {
                Element smNode = (Element)bookmarkStartMediumChildren.get(sm);
                if (smNode.getChild("medium").getChildText("hash") == null) continue;
                MediumFile mediumFromDb = this.db.getMediumFile(smNode.getChild("medium").getChildText("hash"), true);
                bookmark.setMedium(mediumFromDb);
            }
            List bookmarkEndMediumChildren = bookmarkNode.getChildren("endMedium");
            for (int sm = 0; sm < bookmarkEndMediumChildren.size(); ++sm) {
                Element smNode = (Element)bookmarkEndMediumChildren.get(sm);
                if (smNode.getChild("medium").getChildText("hash") == null) continue;
                MediumFile mediumFromDb = this.db.getMediumFile(smNode.getChild("medium").getChildText("hash"), true);
                bookmark.setEndMedium(mediumFromDb);
            }
            s.getBookmarks(true).add(bookmark);
        }
    }

    private SceneDetails readInSceneDetails(List scenedetailList, int scenedetailsJ, Scene s) {
        SceneDetails sd = new SceneDetails();
        sd.setDateOfCreation(LocalDateTime.now());
        Element scenedetailNode = (Element)scenedetailList.get(scenedetailsJ);
        Person findFirstPerson = (Person)this.db.getEntityService().find(QPerson.person).filter(f -> f.name.eq((Object)scenedetailNode.getChildText("person"))).findFirst();
        if (findFirstPerson != null) {
            sd.setScene(s);
            sd.setPerson(findFirstPerson);
        }
        if (scenedetailNode.getChildText("creditedAs") != null) {
            sd.setCreditedAs(scenedetailNode.getChildText("creditedAs"));
        }
        if (scenedetailNode.getChildText("hairColor") != null) {
            sd.setHairColor(HairColor.valueOf(scenedetailNode.getChildText("hairColor")));
        }
        if (scenedetailNode.getChildText("hairLength") != null) {
            sd.setHairLength(HairLength.valueOf(scenedetailNode.getChildText("hairLength")));
        }
        if (scenedetailNode.getChildText("hairType") != null) {
            sd.setHairType(HairType.valueOf(scenedetailNode.getChildText("hairType")));
        }
        if (scenedetailNode.getChildText("hairStyle") != null) {
            sd.setHairStyle(HairStyle.valueOf(scenedetailNode.getChildText("hairStyle")));
        }
        if (scenedetailNode.getChildText("pubicHair") != null) {
            sd.setPubicHairLength(PubicHairLength.valueOf(scenedetailNode.getChildText("pubicHair")));
        }
        if (scenedetailNode.getChildText("makeup") != null) {
            sd.setMakeup(Quantity.valueOf(scenedetailNode.getChildText("makeup")));
        }
        if (scenedetailNode.getChildText("makeupDifferentiator") != null) {
            sd.setMakeupDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("makeupDifferentiator")));
        }
        if (scenedetailNode.getChildText("skinTone") != null) {
            sd.setSkinTone(SkinTone.valueOf(scenedetailNode.getChildText("skinTone")));
        }
        if (scenedetailNode.getChildText("skinToneDifferentiator") != null) {
            sd.setSkinToneDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("skinToneDifferentiator")));
        }
        if (scenedetailNode.getChildText("freckles") != null) {
            sd.setFreckles(Quantity.valueOf(scenedetailNode.getChildText("freckles")));
        }
        if (scenedetailNode.getChildText("frecklesDifferentiator") != null) {
            sd.setFrecklesDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("frecklesDifferentiator")));
        }
        if (scenedetailNode.getChildText("nails") != null) {
            sd.setNails(Quantity.valueOf(scenedetailNode.getChildText("nails")));
        }
        if (scenedetailNode.getChildText("nailsDifferentiator") != null) {
            sd.setNailsDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("nailsDifferentiator")));
        }
        if (scenedetailNode.getChildText("dirtytalk") != null) {
            sd.setDirtyTalk(Quantity.valueOf(scenedetailNode.getChildText("dirtytalk")));
        }
        if (scenedetailNode.getChildText("dirtytalkDifferentiator") != null) {
            sd.setDirtyTalkDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("dirtytalkDifferentiator")));
        }
        if (scenedetailNode.getChildText("dirtytalkIntensity") != null) {
            sd.setDirtyTalkIntensity(DirtyTalkIntensity.valueOf(scenedetailNode.getChildText("dirtytalkIntensity")));
        }
        if (scenedetailNode.getChildText("dirtytalkIntensityDifferentiator") != null) {
            sd.setDirtyTalkIntensityDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("dirtytalkIntensityDifferentiator")));
        }
        if (scenedetailNode.getChildText("dominating") != null) {
            sd.setDominating(Dominating.valueOf(scenedetailNode.getChildText("dominating")));
        }
        if (scenedetailNode.getChildText("dominatingDifferentiator") != null) {
            sd.setDominatingDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("dominatingDifferentiator")));
        }
        if (scenedetailNode.getChildText("disgusted") != null) {
            sd.setDisgusted(Quantity.valueOf(scenedetailNode.getChildText("disgusted")));
        }
        if (scenedetailNode.getChildText("disgustedDifferentiator") != null) {
            sd.setDisgustedDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("disgustedDifferentiator")));
        }
        if (scenedetailNode.getChildText("enjoyment") != null) {
            sd.setEnjoyment(Quantity.valueOf(scenedetailNode.getChildText("enjoyment")));
        }
        if (scenedetailNode.getChildText("enjoymentDifferentiator") != null) {
            sd.setEnjoymentDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("enjoymentDifferentiator")));
        }
        if (scenedetailNode.getChildText("moaning") != null) {
            sd.setMoaning(Quantity.valueOf(scenedetailNode.getChildText("moaning")));
        }
        if (scenedetailNode.getChildText("moaningDifferentiator") != null) {
            sd.setMoaningDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("moaningDifferentiator")));
        }
        if (scenedetailNode.getChildText("screaming") != null) {
            sd.setScreaming(Quantity.valueOf(scenedetailNode.getChildText("screaming")));
        }
        if (scenedetailNode.getChildText("screamingDifferentiator") != null) {
            sd.setScreamingDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("screamingDifferentiator")));
        }
        if (scenedetailNode.getChildText("titsBouncing") != null) {
            sd.setTitsBouncing(Quantity.valueOf(scenedetailNode.getChildText("titsBouncing")));
        }
        if (scenedetailNode.getChildText("titsBouncingDifferentiator") != null) {
            sd.setTitsBouncingDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("titsBouncingDifferentiator")));
        }
        if (scenedetailNode.getChildText("tattoos") != null) {
            sd.setTattoos(Quantity.valueOf(scenedetailNode.getChildText("tattoos")));
        }
        if (scenedetailNode.getChildText("tattoosDifferentiator") != null) {
            sd.setTattoosDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("tattoosDifferentiator")));
        }
        if (scenedetailNode.getChildText("bodytype") != null) {
            sd.setBodyType(BodyType.valueOf(scenedetailNode.getChildText("bodytype")));
        }
        if (scenedetailNode.getChildText("bodytypeDifferentiator") != null) {
            sd.setBodyTypeDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("bodytypeDifferentiator")));
        }
        if (scenedetailNode.getChildText("fakeTits") != null && "true".equalsIgnoreCase(scenedetailNode.getChildText("fakeTits"))) {
            sd.setFakeTits(true);
        }
        if (scenedetailNode.getChildText("fakeTitsObviousness") != null) {
            sd.setFakeTitsObviousness(Quantity.valueOf(scenedetailNode.getChildText("fakeTitsObviousness")));
        }
        if (scenedetailNode.getChildText("fakeTitsObviousnessDifferentiator") != null) {
            sd.setFakeTitsObviousnessDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("fakeTitsObviousnessDifferentiator")));
        }
        if (scenedetailNode.getChildText("faceCensored") != null && "true".equalsIgnoreCase(scenedetailNode.getChildText("faceCensored"))) {
            sd.setFaceCensored(true);
        }
        if (scenedetailNode.getChildText("braces") != null) {
            if ("true".equalsIgnoreCase(scenedetailNode.getChildText("braces"))) {
                sd.setBraces(true);
            } else {
                sd.setBraces(false);
            }
        }
        if (scenedetailNode.getChildText("nonSex") != null) {
            if ("true".equalsIgnoreCase(scenedetailNode.getChildText("nonSex"))) {
                sd.setNonSex(true);
            } else {
                sd.setNonSex(Boolean.FALSE);
            }
        }
        if (scenedetailNode.getChildText("cuck") != null) {
            if ("true".equalsIgnoreCase(scenedetailNode.getChildText("cuck"))) {
                sd.setCuck(true);
            } else {
                sd.setCuck(Boolean.FALSE);
            }
        }
        if (scenedetailNode.getChildText("titsSize") != null) {
            sd.setTitsSize(BodyPartSize.valueOf(scenedetailNode.getChildText("titsSize")));
        }
        if (scenedetailNode.getChildText("titsSizeDifferentiator") != null) {
            sd.setTitsSizeDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("titsSizeDifferentiator")));
        }
        if (scenedetailNode.getChildText("assSize") != null) {
            sd.setAssSize(BodyPartSize.valueOf(scenedetailNode.getChildText("assSize")));
        }
        if (scenedetailNode.getChildText("assSizeDifferentiator") != null) {
            sd.setAssSizeDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("assSizeDifferentiator")));
        }
        if (scenedetailNode.getChildText("dickSize") != null) {
            sd.setDickSize(BodyPartSize.valueOf(scenedetailNode.getChildText("dickSize")));
        }
        if (scenedetailNode.getChildText("dickSizeDifferentiator") != null) {
            sd.setDickSizeDifferentiator(Differentiator.valueOf(scenedetailNode.getChildText("dickSizeDifferentiator")));
        }
        if (scenedetailNode.getChildText("spokenLanguage") != null) {
            sd.setLanguageSpoken(Language.valueOf(scenedetailNode.getChildText("spokenLanguage")));
        }
        List clothes = scenedetailNode.getChildren("clothesRoot");
        for (int clothesI = 0; clothesI < clothes.size(); ++clothesI) {
            Element clothesNode = (Element)clothes.get(clothesI);
            List clothesList = clothesNode.getChildren("clothes");
            for (int clothesJ = 0; clothesJ < clothesList.size(); ++clothesJ) {
                List content = ((Element)clothesList.get(clothesJ)).getContent();
                if (content.size() != 1) continue;
                sd.getClothes().add(Clothes.valueOf(((Text)content.get(0)).getText()));
            }
        }
        List appearances = scenedetailNode.getChildren("appearancesRoot");
        for (int appI = 0; appI < appearances.size(); ++appI) {
            Element appearancesNode = (Element)appearances.get(appI);
            List appearancesList = appearancesNode.getChildren("appearance");
            for (int appJ = 0; appJ < appearancesList.size(); ++appJ) {
                List content = ((Element)appearancesList.get(appJ)).getContent();
                if (content.size() != 1) continue;
                sd.getAppearances().add(Appearance.valueOf(((Text)content.get(0)).getText()));
            }
        }
        List jewelryRoot = scenedetailNode.getChildren("jewelryRoot");
        for (int jewelryI = 0; jewelryI < jewelryRoot.size(); ++jewelryI) {
            Element jewelryNode = (Element)jewelryRoot.get(jewelryI);
            List jewelryList = jewelryNode.getChildren("jewelry");
            for (int jewelryJ = 0; jewelryJ < jewelryList.size(); ++jewelryJ) {
                List content = ((Element)jewelryList.get(jewelryJ)).getContent();
                if (content.size() != 1) continue;
                sd.getJewelry().add(Jewelry.valueOf(((Text)content.get(0)).getText()));
            }
        }
        return sd;
    }

    public Studio importStudioFile(String filepath) throws Exception {
        Studio result = null;
        try {
            Element rootNode = this.initImport(filepath);
            List list = rootNode.getChildren("studio");
            for (int i = 0; i < list.size(); ++i) {
                Element node = (Element)list.get(i);
                result = this.readStudioNode(node);
                LOG.fine("Imported studio: " + String.valueOf(result));
            }
        }
        catch (IOException io) {
            LOG.severe(io.getMessage());
        }
        catch (JDOMException jdomex) {
            LOG.severe(jdomex.getMessage());
        }
        return result;
    }

    private void readOtherNodes(Element personNode, Person p, List<Person> persons) throws NumberFormatException {
        if (personNode.getChildText("dickSize") != null) {
            p.setDickSize(BodyPartSize.valueOf(personNode.getChildText("dickSize")));
        }
        if (personNode.getChildText("dickSizeDifferentiator") != null) {
            p.setDickSizeDifferentiator(Differentiator.valueOf(personNode.getChildText("dickSizeDifferentiator")));
        }
        if (personNode.getChildText("comment") != null) {
            p.setComment(personNode.getChildText("comment"));
        }
        if (personNode.getChildText("remindsMeOf") != null) {
            p.setRemindsMeOf(personNode.getChildText("remindsMeOf"));
        }
        if (personNode.getChildText("rating") != null) {
            p.setRating(Integer.valueOf(personNode.getChildText("rating")));
        }
        if (personNode.getChildText("ratingDifferentiator") != null) {
            p.setRatingDifferentiator(Differentiator.valueOf(personNode.getChildText("ratingDifferentiator")));
        }
        if (personNode.getChildText("ratingAss") != null) {
            p.setRatingAss(Integer.valueOf(personNode.getChildText("ratingAss")));
        }
        if (personNode.getChildText("ratingCharacter") != null) {
            p.setRatingCharacter(Integer.valueOf(personNode.getChildText("ratingCharacter")));
        }
        if (personNode.getChildText("ratingEyes") != null) {
            p.setRatingEyes(Integer.valueOf(personNode.getChildText("ratingEyes")));
        }
        if (personNode.getChildText("ratingFace") != null) {
            p.setRatingFace(Integer.valueOf(personNode.getChildText("ratingFace")));
        }
        if (personNode.getChildText("ratingLaugh") != null) {
            p.setRatingLaugh(Integer.valueOf(personNode.getChildText("ratingLaugh")));
        }
        if (personNode.getChildText("ratingPussy") != null) {
            p.setRatingPussy(Integer.valueOf(personNode.getChildText("ratingPussy")));
        }
        if (personNode.getChildText("ratingSmile") != null) {
            p.setRatingSmile(Integer.valueOf(personNode.getChildText("ratingSmile")));
        }
        if (personNode.getChildText("ratingSympathy") != null) {
            p.setRatingSympathy(Integer.valueOf(personNode.getChildText("ratingSympathy")));
        }
        if (personNode.getChildText("ratingTits") != null) {
            p.setRatingTits(Integer.valueOf(personNode.getChildText("ratingTits")));
        }
        if (personNode.getChildText("ratingVoice") != null) {
            p.setRatingVoice(Integer.valueOf(personNode.getChildText("ratingVoice")));
        }
        if (personNode.getChildText("ratingFeet") != null) {
            p.setRatingFeet(Integer.valueOf(personNode.getChildText("ratingFeet")));
        }
        if (personNode.getChildText("ratingTeeth") != null) {
            p.setRatingTeeth(Integer.valueOf(personNode.getChildText("ratingTeeth")));
        }
        if (personNode.getChildText("picture") != null) {
            MediumFile picture = (MediumFile)this.db.getEntityService().find(QMediumFile.mediumFile).filter(f -> f.hashValue.eq((Object)personNode.getChildText("picture"))).findFirst();
            p.setPicture(picture);
        }
        persons.add(p);
    }

    private Studio readStudioNode(Element node) throws NumberFormatException {
        Studio s = new Studio();
        s.setName(node.getChildText("name"));
        List studioWebsitesRoot = node.getChildren("sutdioWebsitesRoot");
        LOG.finer("studioWebsitesRoot children: " + studioWebsitesRoot.size());
        for (int pbI = 0; pbI < studioWebsitesRoot.size(); ++pbI) {
            Element websites = (Element)studioWebsitesRoot.get(pbI);
            List websitesList = websites.getChildren("studioWebsite");
            LOG.info("studiowebsiteslist children: " + websitesList.size());
            for (int pbJ = 0; pbJ < websitesList.size(); ++pbJ) {
                StudioWebsites studioWebsites = new StudioWebsites();
                if (((Element)websitesList.get(pbJ)).getChildText("site") != null) {
                    if (((Element)websitesList.get(pbJ)).getChildText("site").equalsIgnoreCase("iafd")) {
                        studioWebsites.setSocialWebsite(SocialWebsites.IAFD);
                    } else {
                        studioWebsites.setSocialWebsite(SocialWebsites.valueOf(((Element)websitesList.get(pbJ)).getChildText("site")));
                    }
                }
                if (((Element)websitesList.get(pbJ)).getChildText("url") != null) {
                    studioWebsites.setUrl(((Element)websitesList.get(pbJ)).getChildText("url"));
                }
                studioWebsites.setStudio(s);
            }
        }
        if (node.getChildText("twitter") != null) {
            s.setTwitter(node.getChildText("twitter"));
        }
        if (node.getChildText("twitter2") != null) {
            s.setTwitter2(node.getChildText("twitter2"));
        }
        if (node.getChildText("wikipedia") != null) {
            s.setWikipedia(node.getChildText("wikipedia"));
        }
        if (node.getChildText("homepage") != null) {
            s.setHomepage(node.getChildText("homepage"));
        }
        if (node.getChildText("homepage2") != null) {
            s.setHomepage2(node.getChildText("homepage2"));
        }
        if (node.getChildText("otherUrls") != null) {
            s.setOtherUrls(node.getChildText("otherUrls"));
        }
        if (node.getChildText("yearFounded") != null) {
            s.setYearFounded(Integer.valueOf(node.getChildText("yearFounded")));
        }
        if (node.getChildText("yearDefunct") != null) {
            s.setYearDefunct(Integer.valueOf(node.getChildText("yearDefunct")));
        }
        if (node.getChildText("rating") != null) {
            s.setRating(Integer.valueOf(node.getChildText("rating")));
        }
        if (node.getChildText("ratingDifferentiator") != null) {
            s.setRatingDifferentiator(Differentiator.valueOf(node.getChildText("ratingDifferentiator")));
        }
        if (node.getChildText("description") != null) {
            s.setPublicDescription(node.getChildText("description"));
        }
        if (node.getChildText("type1") != null) {
            s.setType1(MovieType.valueOf(node.getChildText("type1")));
        }
        if (node.getChildText("type2") != null) {
            s.setType2(MovieType.valueOf(node.getChildText("type2")));
        }
        if (node.getChildText("type3") != null) {
            s.setType3(MovieType.valueOf(node.getChildText("type3")));
        }
        if (node.getChildText("type4") != null) {
            s.setType4(MovieType.valueOf(node.getChildText("type4")));
        }
        if (node.getChildText("type5") != null) {
            s.setType5(MovieType.valueOf(node.getChildText("type5")));
        }
        if (node.getChildText("type6") != null) {
            s.setType6(MovieType.valueOf(node.getChildText("type6")));
        }
        if (node.getChildText("parent") != null && !node.getChildren("parent").isEmpty()) {
            LOG.finer("read in parent");
            for (Element e : node.getChildren("parent")) {
                LOG.finer("e: " + String.valueOf(e));
                if (e.getChildText("studio") == null) continue;
                LOG.finer("found parent node");
                s.setParent(this.readStudioNode(e.getChild("studio")));
            }
        }
        return s;
    }

    public Person importPersonFile(String filepath) throws Exception {
        return this.importPersonFile(filepath, false);
    }

    public Person importPersonFile(String filepath, boolean savePersonBodyAlready) throws Exception {
        LOG.finer("importPersonFile: " + filepath + " - " + savePersonBodyAlready);
        SAXBuilder builder = new SAXBuilder();
        File xmlFile = new File(filepath);
        Person result = null;
        try {
            Document document = builder.build(xmlFile);
            Element rootNode = document.getRootElement();
            if (!"scenerixx".equals(rootNode.getName())) {
                throw new Exception("don't know how to handle this");
            }
            List versionList = rootNode.getChildren("version");
            String codename = ((Element)versionList.get(0)).getChildText("codename");
            try {
                PreviousCodenames.valueOf(codename);
            }
            catch (IllegalArgumentException iae) {
                throw new Exception("You are trying to import a file which was created with a newer version of Scenerixx. Upgrade at least to a version with codename '" + codename + "'");
            }
            List list = rootNode.getChildren("person");
            for (int i = 0; i < list.size(); ++i) {
                Person p = new Person();
                Element node = (Element)list.get(i);
                this.readPersonNode(p, node);
                this.readPersonBodyRootNode(node, false, p);
                if (PreviousCodenames.aurora.getTitle().equalsIgnoreCase(codename) || PreviousCodenames.jessa.getTitle().equalsIgnoreCase(codename)) {
                    PersonBody personBody = this.readPersonBodyNodeOldWay(node);
                    this.readAppearanceNodeOldWay(node, personBody);
                    if (savePersonBodyAlready) {
                        personBody = this.db.getEntityService().save(personBody);
                    }
                    p.getPersonBodys().add(personBody);
                }
                if (node.getChildText("dickSize") != null) {
                    p.setDickSize(BodyPartSize.valueOf(node.getChildText("dickSize")));
                }
                if (node.getChildText("dickSizeDifferentiator") != null) {
                    p.setDickSizeDifferentiator(Differentiator.valueOf(node.getChildText("dickSizeDifferentiator")));
                }
                if (!PreviousCodenames.aurora.getTitle().equalsIgnoreCase(codename) && !PreviousCodenames.jessa.getTitle().equalsIgnoreCase(codename)) {
                    LOG.finer("Read person body root");
                    this.readPersonBodyRootNode(node, savePersonBodyAlready, p);
                }
                ArrayList<Person> persons = new ArrayList<Person>();
                persons.add(p);
                this.readOtherNodes(rootNode, p, persons);
                LOG.fine("Imported person: " + String.valueOf(p));
                result = p;
            }
        }
        catch (IOException io) {
            LOG.severe(io.getMessage());
        }
        catch (JDOMException jdomex) {
            LOG.severe(jdomex.getMessage());
        }
        return result;
    }

    private void readPersonBodyRootNode(Element node, boolean savePersonBodyAlready, Person p) {
        List personBodyRoot = node.getChildren("personBodyRoot");
        LOG.finer("personBodyRoot children: " + personBodyRoot.size());
        for (int pbI = 0; pbI < personBodyRoot.size(); ++pbI) {
            Element personBodyNode = (Element)personBodyRoot.get(pbI);
            List personBodyList = personBodyNode.getChildren("personBody");
            LOG.finer("personBodylist children: " + personBodyList.size());
            for (int pbJ = 0; pbJ < personBodyList.size(); ++pbJ) {
                PersonBody personBody = new PersonBody();
                if (((Element)personBodyList.get(pbJ)).getChildText("assSize") != null) {
                    personBody.setAssSize(BodyPartSize.valueOf(((Element)personBodyList.get(pbJ)).getChildText("assSize")));
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("bodytype") != null) {
                    personBody.setBodyType(BodyType.valueOf(((Element)personBodyList.get(pbJ)).getChildText("bodytype")));
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("bodytypeDifferentiator") != null) {
                    personBody.setBodyTypeDifferentiator(Differentiator.valueOf(((Element)personBodyList.get(pbJ)).getChildText("bodytypeDifferentiator")));
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("fakeTits") != null && "true".equalsIgnoreCase(((Element)personBodyList.get(pbJ)).getChildText("fakeTits"))) {
                    personBody.setFakeTits(true);
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("fakeTitsObviousness") != null) {
                    personBody.setFakeTitsObviousness(Quantity.valueOf(((Element)personBodyList.get(pbJ)).getChildText("fakeTitsObviousness")));
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("fakeTitsObviousnessDifferentiator") != null) {
                    personBody.setFakeTitsDifferentiator(Differentiator.valueOf(((Element)personBodyList.get(pbJ)).getChildText("fakeTitsObviousnessDifferentiator")));
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("titsSize") != null) {
                    personBody.setTitsSize(BodyPartSize.valueOf(((Element)personBodyList.get(pbJ)).getChildText("titsSize")));
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("titsSizeDifferentiator") != null) {
                    personBody.setTitsSizeDifferentiator(Differentiator.valueOf(((Element)personBodyList.get(pbJ)).getChildText("titsSizeDifferentiator")));
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("assSize") != null) {
                    personBody.setAssSize(BodyPartSize.valueOf(((Element)personBodyList.get(pbJ)).getChildText("assSize")));
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("assSizeDifferentiator") != null) {
                    personBody.setAssSizeDifferentiator(Differentiator.valueOf(((Element)personBodyList.get(pbJ)).getChildText("assSizeDifferentiator")));
                }
                if (((Element)personBodyList.get(pbJ)).getChildText("defaultPersonBody") != null && "true".equalsIgnoreCase(((Element)personBodyList.get(pbJ)).getChildText("defaultPersonBody"))) {
                    personBody.setDefaultPersonBody(true);
                }
                this.readAppearanceNodeOldWay((Element)personBodyList.get(pbJ), personBody);
                if (savePersonBodyAlready) {
                    personBody = this.db.getEntityService().save(personBody);
                }
                p.getPersonBodys().add(personBody);
            }
        }
    }

    private void readAppearanceNodeOldWay(Element node, PersonBody personBody) {
        List app = node.getChildren("appearanceRoot");
        for (int appI = 0; appI < app.size(); ++appI) {
            Element appNode = (Element)app.get(appI);
            List appList = appNode.getChildren("appearance");
            for (int appJ = 0; appJ < appList.size(); ++appJ) {
                List content = ((Element)appList.get(appJ)).getContent();
                if (content.size() != 1) continue;
                personBody.getAppearance().add(Appearance.valueOf(((Text)content.get(0)).getText()));
            }
        }
    }

    private PersonBody readPersonBodyNodeOldWay(Element node) throws ParseException {
        LOG.finer("readPersonBodyNodeOldWay");
        PersonBody personBody = new PersonBody();
        personBody.setDefaultPersonBody(true);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (node.getChildText("validFrom") != null) {
            personBody.setStartDate(df.parse(node.getChildText("validFrom")).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }
        if (node.getChildText("validTill") != null) {
            personBody.setEndDate(df.parse(node.getChildText("validTill")).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }
        if (node.getChildText("bodytype") != null) {
            personBody.setBodyType(BodyType.valueOf(node.getChildText("bodytype")));
        }
        if (node.getChildText("bodytypeDifferentiator") != null) {
            personBody.setBodyTypeDifferentiator(Differentiator.valueOf(node.getChildText("bodytypeDifferentiator")));
        }
        if (node.getChildText("fakeTits") != null && "true".equalsIgnoreCase(node.getChildText("fakeTits"))) {
            personBody.setFakeTits(true);
        }
        if (node.getChildText("titsSize") != null) {
            personBody.setTitsSize(BodyPartSize.valueOf(node.getChildText("titsSize")));
        }
        if (node.getChildText("titsSizeDifferentiator") != null) {
            personBody.setTitsSizeDifferentiator(Differentiator.valueOf(node.getChildText("titsSizeDifferentiator")));
        }
        if (node.getChildText("assSize") != null) {
            personBody.setAssSize(BodyPartSize.valueOf(node.getChildText("assSize")));
        }
        if (node.getChildText("assSizeDifferentiator") != null) {
            personBody.setAssSizeDifferentiator(Differentiator.valueOf(node.getChildText("assSizeDifferentiator")));
        }
        return personBody;
    }

    private void readPersonNode(Person p, Element node) throws NumberFormatException {
        PersonWebsites personWebsites;
        p.setName(node.getChildText("name"));
        p.setGender(Gender.valueOf(node.getChildText("gender")));
        if (node.getChildText("realName") != null) {
            p.setRealName(node.getChildText("realName"));
        }
        if (node.getChildText("twitter") != null) {
            p.setTwitter(node.getChildText("twitter"));
            personWebsites = new PersonWebsites();
            personWebsites.setPerson(p);
            personWebsites.setSocialWebsite(SocialWebsites.X);
            personWebsites.setUrl(p.getTwitter());
            p.getPersonWebsites().add(personWebsites);
        }
        if (node.getChildText("wikipedia") != null) {
            p.setWikipedia(node.getChildText("wikipedia"));
            personWebsites = new PersonWebsites();
            personWebsites.setPerson(p);
            personWebsites.setSocialWebsite(SocialWebsites.Wikipedia);
            personWebsites.setUrl(p.getWikipedia());
            p.getPersonWebsites().add(personWebsites);
        }
        if (node.getChildText("iafd") != null) {
            p.setIafd(node.getChildText("iafd"));
            personWebsites = new PersonWebsites();
            personWebsites.setPerson(p);
            personWebsites.setSocialWebsite(SocialWebsites.IAFD);
            personWebsites.setUrl(p.getIafd());
            p.getPersonWebsites().add(personWebsites);
        }
        if (node.getChildText("instagram") != null) {
            p.setInstagram(node.getChildText("instagram"));
            personWebsites = new PersonWebsites();
            personWebsites.setPerson(p);
            personWebsites.setSocialWebsite(SocialWebsites.Instagram);
            personWebsites.setUrl(p.getInstagram());
            p.getPersonWebsites().add(personWebsites);
        }
        if (node.getChildText("officialHomepage") != null) {
            p.setOfficialHomepage(node.getChildText("officialHomepage"));
            personWebsites = new PersonWebsites();
            personWebsites.setPerson(p);
            personWebsites.setSocialWebsite(SocialWebsites.Official);
            personWebsites.setUrl(p.getOfficialHomepage());
            p.getPersonWebsites().add(personWebsites);
        }
        if (node.getChildText("otherUrls") != null) {
            p.setOtherUrls(node.getChildText("otherUrls"));
            personWebsites = new PersonWebsites();
            personWebsites.setPerson(p);
            personWebsites.setSocialWebsite(SocialWebsites.Other);
            personWebsites.setUrl(p.getOtherUrls());
            p.getPersonWebsites().add(personWebsites);
        }
        List personWebsitesRoot = node.getChildren("personWebsitesRoot");
        LOG.finer("personWebsitesRoot children: " + personWebsitesRoot.size());
        for (int pbI = 0; pbI < personWebsitesRoot.size(); ++pbI) {
            Element websites = (Element)personWebsitesRoot.get(pbI);
            List websitesList = websites.getChildren("personWebsite");
            LOG.finer("websiteslist children: " + websitesList.size());
            for (int pbJ = 0; pbJ < websitesList.size(); ++pbJ) {
                PersonWebsites personWebsites2 = new PersonWebsites();
                if (((Element)websitesList.get(pbJ)).getChildText("site") != null) {
                    if (((Element)websitesList.get(pbJ)).getChildText("site").equalsIgnoreCase("iafd")) {
                        personWebsites2.setSocialWebsite(SocialWebsites.IAFD);
                    } else {
                        personWebsites2.setSocialWebsite(SocialWebsites.valueOf(((Element)websitesList.get(pbJ)).getChildText("site")));
                    }
                }
                if (((Element)websitesList.get(pbJ)).getChildText("url") != null) {
                    personWebsites2.setUrl(((Element)websitesList.get(pbJ)).getChildText("url"));
                }
                personWebsites2.setPerson(p);
                p.getPersonWebsites().add(personWebsites2);
            }
        }
        if (node.getChildText("birthDay") != null) {
            p.setBirthDay(Integer.valueOf(node.getChildText("birthDay")));
        }
        if (node.getChildText("birthMonth") != null) {
            p.setBirthMonth(Integer.valueOf(node.getChildText("birthMonth")));
        }
        if (node.getChildText("birthYear") != null) {
            p.setBirthYear(Integer.valueOf(node.getChildText("birthYear")));
        }
        if (node.getChildText("deathDay") != null) {
            p.setDeathDay(Integer.valueOf(node.getChildText("deathDay")));
        }
        if (node.getChildText("deathMonth") != null) {
            p.setDeathMonth(Integer.valueOf(node.getChildText("deathMonth")));
        }
        if (node.getChildText("deathYear") != null) {
            p.setDeathYear(Integer.valueOf(node.getChildText("deathYear")));
        }
        if (node.getChildText("causeOfDeathComment") != null) {
            p.setCauseOfDeathComment(node.getChildText("causeOfDeathComment"));
        }
        if (node.getChildText("causeOfDeath") != null) {
            p.setCauseOfDeath(CauseOfDeath.getEnum(node.getChildText("causeOfDeath")));
        }
        if (node.getChildText("nationality") != null) {
            p.setNationality(Nationality.getEnum(node.getChildText("nationality")));
        }
        if (node.getChildText("ethnicity") != null) {
            p.setEthnicity(Ethnicity.valueOf(node.getChildText("ethnicity").replace("/", "").replace(" ", "")));
        }
        if (node.getChildText("heightInCm") != null) {
            p.setHeightInCm(Integer.valueOf(node.getChildText("heightInCm")));
        }
        if (node.getChildText("personHeight") != null) {
            p.setPersonHeight(PersonHeight.valueOf(node.getChildText("personHeight")));
        }
        if (node.getChildText("personHeightDifferentiator") != null) {
            p.setPersonHeightDifferentiator(Differentiator.valueOf(node.getChildText("personHeightDifferentiator")));
        }
        if (node.getChildText("haircolor") != null) {
            p.setHairColor(HairColor.valueOf(node.getChildText("haircolor")));
        }
    }
}

