/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.db;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.RollbackException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;

public class EntityServiceInternal
implements Serializable {
    private final Logger LOGGER = LoggerFactory.getLogger(EntityServiceInternal.class);
    private static AtomicBoolean permanentConnectionFailure = new AtomicBoolean(false);
    private EntityManagerFactory emf;
    public String jdbcUrl = "jdbc:hsqldb:file:" + System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + "data" + File.separator + "scenerixxdb;shutdown=true";
    private boolean useOtherJdbcUrl = false;

    public EntityServiceInternal() {
    }

    public EntityServiceInternal(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        this.useOtherJdbcUrl = true;
    }

    public final EntityManager getEntityManager() {
        return this.getEntityManagerFactory().createEntityManager();
    }

    public final void reset() {
        this.emf = null;
    }

    public final EntityManagerFactory getEntityManagerFactory() {
        if (this.emf == null) {
            Properties props = new Properties();
            String mysqlconf = System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + "mysql.conf";
            this.LOGGER.info("use other jdbc url: " + this.useOtherJdbcUrl + " - " + this.jdbcUrl);
            if (!this.useOtherJdbcUrl && new File(mysqlconf).exists()) {
                this.LOGGER.info(mysqlconf + " exists, read MySql configuration.");
                try {
                    props.load(new FileInputStream(mysqlconf));
                }
                catch (FileNotFoundException ex) {
                    java.util.logging.Logger.getLogger(EntityServiceInternal.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    java.util.logging.Logger.getLogger(EntityServiceInternal.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.LOGGER.info(mysqlconf + " doesn't exists or an explicit url was passed in. Use embedded database HSQLDB with URL: " + this.jdbcUrl);
                props.setProperty("jakarta.persistence.jdbc.url", this.jdbcUrl);
                props.setProperty("jakarta.persistence.jdbc.user", "SA");
                props.setProperty("jakarta.persistence.jdbc.password", "");
                props.setProperty("jakarta.persistence.jdbc.driver", "org.hsqldb.jdbcDriver");
            }
            try {
                this.emf = Persistence.createEntityManagerFactory((String)"xxx.scenerixx_ScenerixxLib_jar_0.1PU", (Map)props);
            }
            catch (Exception e) {
                this.LOGGER.error("Failed to connect to database. Error: " + e.getMessage());
                if (e.getMessage().contains("Database lock acquisition failure")) {
                    this.LOGGER.error("There's still a lock on the database. You can only run one instance at the same time.");
                    permanentConnectionFailure = new AtomicBoolean(true);
                }
                e.printStackTrace();
            }
        }
        return this.emf;
    }

    private <PathType extends EntityPath<EntityType>, EntityType extends AbstractEntity> List<EntityType> getAll(PathType root, long offset, long max, boolean distinct, List<Predicate> predicates, OrderSpecifier ... orderBy) {
        Predicate[] p = new Predicate[predicates.size()];
        JPAQuery query = new JPAQuery(this.getEntityManager());
        ((JPAQuery)query.select(root).from(root)).where(predicates.toArray(p));
        ((JPAQuery)((JPAQuery)query.offset(offset)).limit(max)).orderBy(orderBy);
        if (distinct) {
            query.distinct();
        }
        return query.fetch();
    }

    private <PathType extends EntityPath<EntityType>, EntityType extends AbstractEntity> long getCount(PathType root, boolean distinct, List<Predicate> predicates) {
        Predicate[] p = new Predicate[predicates.size()];
        JPAQuery query = new JPAQuery(this.getEntityManager());
        ((JPAQuery)query.select(root).from(root)).where(predicates.toArray(p));
        if (distinct) {
            query.distinct();
        }
        return query.fetchCount();
    }

    private <PathType extends EntityPath<EntityType>, EntityType extends AbstractEntity> EntityType getFirst(PathType root, List<Predicate> predicates) {
        Predicate[] p = new Predicate[predicates.size()];
        JPAQuery query = new JPAQuery(this.getEntityManager());
        ((JPAQuery)query.select(root).from(root)).where(predicates.toArray(p));
        return (EntityType)((AbstractEntity)query.fetchFirst());
    }

    public <T extends AbstractEntity> T load(Class<T> entity, long id) {
        AbstractEntity find = (AbstractEntity)this.getEntityManager().find(entity, (Object)id);
        return (T)find;
    }

    public <T extends AbstractEntity> boolean delete(T entity) {
        EntityManager entityManager;
        boolean result;
        block7: {
            this.LOGGER.info("Trying to delete: " + String.valueOf(entity.getClass()) + " with ID " + ((AbstractEntity)entity).getId());
            result = true;
            entityManager = this.getEntityManager();
            entityManager.getTransaction().begin();
            try {
                if (!entityManager.contains(entity)) {
                    entity = (AbstractEntity)entityManager.merge(entity);
                }
                entityManager.remove(entity);
                entityManager.getTransaction().commit();
            }
            catch (IllegalArgumentException e) {
                result = false;
                if (!entityManager.getTransaction().isActive()) break block7;
                this.LOGGER.info("Error during delete.");
                entityManager.getTransaction().rollback();
                this.LOGGER.info("Transaction was rolled back.");
            }
        }
        if (entityManager.getTransaction().isActive()) {
            this.LOGGER.warn("Transaction was still active. There seemed to be an internal problem removing the entity.");
            try {
                entityManager.getTransaction().commit();
            }
            catch (RollbackException ex) {
                result = false;
                this.LOGGER.debug("rollback exception");
            }
        }
        if (((AbstractEntity)entity).getId() != null && entityManager.find(entity.getClass(), (Object)((AbstractEntity)entity).getId()) != null) {
            result = false;
        }
        this.LOGGER.info("Deleted: " + result);
        return result;
    }

    public <T extends AbstractEntity> T save(T entity) {
        if (entity != null) {
            Object result = entity;
            EntityManager entityManager = this.getEntityManager();
            entityManager.getTransaction().begin();
            entity.setDateOfLastModification(LocalDateTime.now());
            if (entity.getId() == null) {
                this.LOGGER.debug("id was null... persist");
                try {
                    entity.setDateOfCreation(LocalDateTime.now());
                    entityManager.persist(entity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.LOGGER.debug("id was set... merge");
                result = (AbstractEntity)entityManager.merge(entity);
            }
            entityManager.getTransaction().commit();
            return result;
        }
        this.LOGGER.error("Entity to persist was null");
        return null;
    }

    public <T extends AbstractEntity> void save(List<T> entities) {
        if (entities != null && !entities.isEmpty()) {
            EntityManager entityManager = this.getEntityManager();
            entityManager.getTransaction().begin();
            for (AbstractEntity entity : entities) {
                entity.setDateOfLastModification(LocalDateTime.now());
                if (entity.getId() == null) {
                    this.LOGGER.debug("id was null... persist");
                    try {
                        entity.setDateOfCreation(LocalDateTime.now());
                        entityManager.persist((Object)entity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                this.LOGGER.debug("id was set... merge");
            }
            entityManager.getTransaction().commit();
        } else {
            this.LOGGER.error("Entity to persist was null");
        }
    }

    public <PathType extends EntityPathBase<EntityType>, EntityType extends AbstractEntity> Finder<PathType, EntityType> find(PathType root) {
        return new Finder(this, root);
    }

    public static AtomicBoolean getPermanentConnectionFailure() {
        return permanentConnectionFailure;
    }

    public static class Finder<PathType extends EntityPathBase<EntityType>, EntityType extends AbstractEntity>
    implements Serializable {
        private final List<Function<PathType, Predicate>> predicates = new ArrayList<Function<PathType, Predicate>>();
        private final PathType root;
        private Function<PathType, OrderSpecifier>[] orderBy = new Function[0];
        private boolean distinct = false;
        final /* synthetic */ EntityServiceInternal this$0;

        private Finder(PathType root) {
            this.this$0 = this$0;
            this.root = root;
        }

        public Finder<PathType, EntityType> filter(Function<PathType, Predicate> filter) {
            this.predicates.add(filter);
            return this;
        }

        public Finder<PathType, EntityType> order(Function<PathType, OrderSpecifier> ... orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Finder<PathType, EntityType> distinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        private <Result> Result getResult(BiFunction<List<Predicate>, OrderSpecifier[], Result> function) {
            OrderSpecifier[] orders = (OrderSpecifier[])Stream.of(this.orderBy).map(f -> (OrderSpecifier)f.apply(this.root)).toArray(OrderSpecifier[]::new);
            List pred = this.predicates.stream().map(f -> (Predicate)f.apply(this.root)).collect(Collectors.toList());
            return function.apply(pred, orders);
        }

        public List<EntityType> find() {
            return this.find(0L, Integer.MAX_VALUE);
        }

        public List<EntityType> find(long max) {
            return this.find(0L, max);
        }

        public List<EntityType> find(long offset, long max) {
            return this.getResult((predicates, orderBy) -> this.this$0.getAll(this.root, offset, max, this.distinct, (List<Predicate>)predicates, (OrderSpecifier)orderBy));
        }

        public <Result> EntityType findFirst() {
            List<EntityType> tmp = this.find(1L);
            if (tmp.isEmpty()) {
                return null;
            }
            return (EntityType)((AbstractEntity)tmp.get(0));
        }

        public long count() {
            List<Predicate> pred = this.predicates.stream().map(f -> (Predicate)f.apply(this.root)).collect(Collectors.toList());
            return this.this$0.getCount(this.root, this.distinct, pred);
        }
    }
}

